!= const_provider ⥸塼Υƥȥץ
!
!= Test program for "const_provider"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: const_provider_test.f90,v 1.1 2008-04-22 12:41:12 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! const_provider ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "const_provider" module.
! Confirm compilation and execution of this program.
!
program const_provider_test
  use const_provider, only: ConstGet
  use dc_test, only: AssertEqual
  use dc_types, only: DP, STRING
  use dc_string, only: StoA
  use dc_args, only: ARGS, DCArgsOpen, DCArgsHelpMsg, DCArgsOption, &
    & DCArgsDebug, DCArgsHelp, DCArgsStrict, DCArgsClose
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'const_provider_test $Name: dcpam4-20080427 $ :: ' // &
    & 'Test program of "const_provider" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'


  !---------------------------------------------------------
  !  ʪ
  !  Physical constants
  !---------------------------------------------------------
  real(DP):: PI
                              ! $ \pi $ .
                              ! ߼Ψ.  Circular constant
  real(DP):: RPlanet
                              ! $ a $ [m]. 
                              ! Ⱦ. 
                              ! Radius of planet
  real(DP):: Omega
                              ! $ \Omega $ [s-1]. 
                              ! ž®. 
                              ! Angular velocity
  real(DP):: Grav
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS) :: arg
  logical:: OPT_namelist
  character(STRING):: VAL_namelist
  character(*), parameter:: subname = 'const_provider_test'
continue

  !-------------------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line options handling
  !-------------------------------------------------------------------
  call cmdline_optparse ! ֥롼. This is an internal subroutine

  !---------------------------------------------------------
  !  ConstGet Υƥ
  !  Test of "ConstGet"
  !---------------------------------------------------------
  call ConstGet( PI = PI ) ! (out)

  call AssertEqual( 'ConstGet test 1-1', &
    & answer = 3.1415926535897930_DP, check = PI, &
    & significant_digits = 15, ignore_digits = -15 )

  call ConstGet( planet = 'earth', &                  ! (in)
    & RPlanet = RPlanet, Omega = Omega, Grav = Grav ) ! (out)

  call AssertEqual( 'ConstGet test 2-1', &
    & answer = 6.371e6_DP, check = RPlanet, &
    & significant_digits = 15, ignore_digits = -15 )

  call AssertEqual( 'ConstGet test 2-2', &
    & answer = 7.29210659088065e-05_DP, check = Omega, &
    & significant_digits = 15, ignore_digits = -15 )

  call AssertEqual( 'ConstGet test 2-3', &
    & answer = 9.8_DP, check = Grav, &
    & significant_digits = 15, ignore_digits = -15 )


  call ConstGet( planet = 'jupiter00', &              ! (in)
    & RPlanet = RPlanet, Omega = Omega, Grav = Grav ) ! (out)

  call AssertEqual( 'ConstGet test 3-1', &
    & answer = 7.1492e7_DP, check = RPlanet, &
    & significant_digits = 15, ignore_digits = -15 )

  call AssertEqual( 'ConstGet test 3-2', &
    & answer = 1.75851813802955e-4_DP, check = Omega, &
    & significant_digits = 15, ignore_digits = -15 )

  call AssertEqual( 'ConstGet test 3-3', &
    & answer = 23.1_DP, check = Grav, &
    & significant_digits = 15, ignore_digits = -15 )


contains
  
  subroutine cmdline_optparse
    !
    ! ޥɥ饤νԤޤ
    !
    ! Handle command line options
    !
    call DCArgsOpen( arg = arg )               ! (out)

    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Title', msg = title )      ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Usage', &                  ! (in)
      & msg = './' // trim(subname) // &
      &       ' [Options]' )                   ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Source', msg = source )    ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Institution', &            ! (in)
      & msg = institution )                    ! (in)

    call DCArgsOption( arg = arg, &           ! (inout)
      & options = StoA('-N', '--namelist'), & ! (in)
      & flag = OPT_namelist, &                ! (out)
      & value = VAL_namelist, &               ! (out)
      & help = "Namelist filename")           ! (in)

    call DCArgsDebug( arg = arg )  ! (inout)
    call DCArgsHelp( arg = arg )   ! (inout)
    call DCArgsStrict( arg = arg ) ! (inout)

    call DCArgsClose( arg = arg )  ! (inout)
  end subroutine cmdline_optparse

end program const_provider_test
