dnl $Id: aclocal.m4,v 0.53 1999/06/02 02:30:25 kagimoto Exp $
dnl DCL macros for dcl-5.0.1 configure

dnl Check for C compiler.
dnl
AC_DEFUN(DCL_PROG_CC,
[
    case "${CC-}" in
        '')
            case `uname` in
                ULTRIX)
                    ccs='gcc cc'
                    ;;
                *)
                    ccs='xlc acc cc gcc'
                    ;;
            esac
            for cc in $ccs; do
                AC_CHECK_PROG(CC, $cc, $cc)
                case "$CC" in
                    '') ;;
                    *)  break;;
                esac
            done
            case "${CC-}" in
                '')
                    AC_MSG_ERROR("Could not find C compiler")
                    ;;
            esac
            ;;
        *)
            AC_CHECKING(user-defined C compiler \"$CC\")
            ;;
    esac
    AC_MSG_CHECKING(C compiler)
    AC_TRY_COMPILE(, ,
        AC_MSG_RESULT(works),
        AC_MSG_ERROR($CC failed to compile test program))
    AC_SUBST(CC)
    case "$CC" in
        *gcc*)
            GCC=yes             # Expected by autoconf(1) macros
            ;;
    esac
    case `uname -s` in
        HP-UX*)
            CFLAGS="${CFLAGS-} -D_INCLUDE_POSIX_SOURCE)"
            ;;
        SunOS)
            case `uname -r` in
                4*)
                    CFLAGS="${CFLAGS-} -Dsun4"
                    ;;
                5*)
                    ;;
            esac
            ;;
    esac
    AC_SUBST(CFLAGS)
])

dnl Check for FORTRAN compiler.
dnl
AC_DEFUN(DCL_PROG_FC,
[
    SUNF=no
    case `uname -s` in
        AIX)
            forts="xlf90 f90 xlf f77"
            ;;
        BSD/OS)
            forts="f77 g77"
            fflags=-w
            ;;
        HI-OSF*)
            forts="f90 f77"
            fflags="-i,E,L,EU"
            ;;
        HP-UX)
            forts=fort77
            fflags=-w
            flibs=-lU77
            ;;
        IRIX)
            forts="f90 f77"
            ;;
        IRIX64)
            forts="f90 f77 g77"
            fflags=-w
            ;;
        Linux)
            forts="f90 pgf77 f77 g77"
            fflags=-w
            ;;
        OSF1)
            forts="f90 f77"
            ;;
        SunOS)
            case `uname -r` in
                4*)
                    forts="f77 frt g77"
                    fflags=-w
                    ;;
                5*)
                    forts="f90 f77 frt g77"
                    SUNF=yes
                    ;;
            esac
            ;;
        sn*|UNICOS)
            forts="cf90 f90 cf77 f77 g77"
            ;;
        *)
            forts="xlf90 f90 xlf ghf77 f77 cf77 g77 fort77"
            ;;
    esac
    FFLAGS="${FFLAGS-} ${fflags-}"
    FLIBS="${FLIBS-} ${flibs-}"
    case "${FC+set}" in
        set)
            case "$FC" in
                '')
                    AC_MSG_WARN(no FORTRAN compiler)
                    ;;
                *)
                    AC_MSG_CHECKING(user-defined FORTRAN compiler \"$FC\")
                    cat << EOF > conftest.f
      CALL FOO
      END
EOF
                    doit='$FC -c ${FFLAGS-} conftest.f'
                    if AC_TRY_EVAL(doit); then
                        AC_MSG_RESULT(works)
                    else
                        AC_MSG_WARN($FC failed to compile test program)
                        FC=
                    fi
                    rm -f conftest.*
                    ;;
            esac
            ;;
        *)
            for fc in $forts; do
                AC_CHECK_PROG(FC, $fc, $fc)
                case "${FC-}" in
                    '')
                        ;;
                    *)
                        cat << EOF > conftest.f
      CALL FOO
      END
EOF
                    doit='$FC -c ${FFLAGS-} conftest.f'
                    if AC_TRY_EVAL(doit); then
                        break
                    else
                        AC_MSG_WARN($FC failed to compile test program)
                        unset FC
                        unset ac_cv_prog_FC
                    fi
                    ;;
                esac
            done
            rm -f conftest.*
            case "${FC-}" in
                '')
                    AC_MSG_WARN(Could not find working FORTRAN compiler)
                    FC=
                    ;;
            esac
            ;;
    esac

dnl If Sun Fortran 90 is selected, -R<f90_dir> should be specified
dnl in the compilation process
dnl
    if test ${SUNF} = yes && test "${FC}" = "f90"; then
        AC_PATH_PROG(SUNFC,"f90")
        flibdir=`dirname ${SUNFC}`
        flibdir=`echo $flibdir | sed -e s/bin/lib/`
        FLIBS="${FLIBS-} -R"$flibdir
    fi

    AC_SUBST(FC)
    AC_SUBST(FFLAGS)
    AC_SUBST(FLIBS)
])

dnl Check for awk
dnl
AC_DEFUN(DCL_PROG_AWK,
[
    awk="mawk gawk jgawk nawk awk"
    for prog in $awk
    do
        AC_PATH_PROG(AWK, $prog)
        case "${AWK-}" in
            '')
                ;;
            *)
                break;;
        esac
    done
    case "${AWK-}" in
        '')
            AC_MSG_WARN(Could not find awk program)
            AWK=
            ;;
    esac
    AC_SUBST(AWK)
])

dnl Check for sed
dnl
AC_DEFUN(DCL_PROG_SED,
[
    sed="gsed sed"
    for prog in $sed
    do
        AC_CHECK_PROG(SED, $prog, $prog)
        case "${SED-}" in
            '')
                ;;
            *)
                break;;
        esac
    done
    case "${SED-}" in
        '')
            AC_MSG_WARN(Could not find sed program)
            SED=
            ;;
    esac
    AC_SUBST(SED)
])

dnl Check for jLaTeX program
dnl
AC_DEFUN(DCL_PROG_JLATEX,
[
    jlatex="jlatex platex"
    for jl in $jlatex
    do
        AC_CHECK_PROG(JLATEX, $jl, $jl)
        case "${JLATEX-}" in
            '')
                ;;
            *)
                break
                ;;
        esac
    done
    case "${JLATEX-}" in
        '')
            AC_MSG_WARN(Could not find LaTeX program)
            JLATEX=
            ;;
    esac
    AC_SUBST(JLATEX)
])

dnl Check for DVI->PS filter
dnl
AC_DEFUN(DCL_PROG_DVIPS,
[
    dvips="dvi2ps dvi2jps dvips"
    for dvi in $dvips
    do
        AC_CHECK_PROG(DVI2JPS, $dvi, $dvi)
        case "${DVI2JPS-}" in
            '')
                ;;
            dvips)
                DVI2JPS="dvips -f"
                break
                ;;
            *)
                break
                ;;
        esac
    done
    case "${DVI2JPS-}" in
        '')
            AC_MSG_WARN(Could not find DVI->PS program)
            DVI2JPS=
            ;;
    esac
    AC_SUBST(DVI2JPS)
])

dnl Check options for math1/oslib/{osgarg.F,osqarn.F}
dnl
AC_DEFUN(DCL_CHECK_OSLIB_OPTIONS,
[
    cat << EOF > conftest.f
      PROGRAM MAIN
      CHARACTER ARGV*10
      EXTERNAL GETARG
      CALL GETARG(2, ARGV)
      STOP
      END
EOF
    doit='${FC-} ${FFLAGS-} conftest.f > /dev/null 2>&1'
    AC_MSG_CHECKING(Fortran service routine getarg())
    if AC_TRY_EVAL(doit); then
        AC_MSG_RESULT(works)
        OSGARG_OPT=getarg
    else
        AC_MSG_WARN(getarg() is not available)
        OSGARG_OPT=dummy
    fi
    rm -f conftest.* a.out

    cat << EOF > conftest.f
      PROGRAM MAIN
      EXTERNAL IARGC
      N = IARGC()
      STOP
      END
EOF
    doit='${FC-} ${FFLAGS-} conftest.f > /dev/null 2>&1'
    AC_MSG_CHECKING(Fortran service routine iargc())
    if AC_TRY_EVAL(doit); then
        AC_MSG_RESULT(works)
        OSQARN_OPT=iargc
    else
        AC_MSG_WARN(Service routine iargc() is not available)
        OSQARN_OPT=dummy
    fi
    rm -f conftest.* a.out

    AC_SUBST(OSGARG_OPT)
    AC_SUBST(OSQARN_OPT)
])

dnl Check underscore for C functions' name
dnl
AC_DEFUN(DCL_CHECK_UNDERSCORE,
[
    cat << EOF > conftest.f
      PROGRAM MAIN
      CALL CFUNC
      STOP
      END
EOF
    cat << EOF > conftest1.c
int cfunc()
{
    return 0;
}
EOF
    cat << EOF > conftest2.c
int cfunc_()
{
    return 0;
}
EOF
    ${CC-} -c conftest1.c -o conftest1.o
    ${CC-} -c conftest2.c -o conftest2.o
    doit1='${FC-} ${FFLAGS-} conftest.f conftest1.o'
    doit2='${FC-} ${FFLAGS-} conftest.f conftest2.o'
    if AC_TRY_EVAL(doit1); then
        AC_MSG_RESULT(underscore is unnecessary)
        USCORE="-DUSCORE"
    elif AC_TRY_EVAL(doit2); then
        AC_MSG_RESULT(underscore is necessary)
        USCORE="-DUSCORE=_"
    fi
    rm -f conftest?.? conftest.* a.out
    AC_SUBST(USCORE)
])

dnl Check CSGI package
dnl
AC_DEFUN(DCL_CHECK_CSGI,
[
    cat << EOF > conftest.f
      print*,ichar('a')
      end
EOF
    AC_MSG_CHECKING(Character code set csgi()/isgc())
    ${FC-} -o conftest conftest.f > /dev/null 2>&1
    ia=`./conftest`
    if test $ia -gt 0; then
        CSGI_OPT=general
        AC_MSG_RESULT(general)
    else
        CSGI_OPT=other
        AC_MSG_RESULT(other)
    fi
    rm -f conftest conftest.?
    AC_SUBST(CSGI_OPT)
])

dnl Set DCLDIR (current working directory)
dnl
AC_DEFUN(DCL_SET_DCLDIR,
[
    AC_PATH_PROG(PWD, pwd)
    case "${PWD-}" in
        '')
            AC_MSG_WARN(*** WARN *** Please set environment variable DCLDIR by yourself)
            DCLDIR=
            ;;
        *)
            DCLDIR=${PWD-}
    esac
    AC_SUBST(DCLDIR)
])

dnl Check for the name format of a Fortran-callable C routine.
dnl
dnl DCL_CHECK_FCALLSCSUB
AC_DEFUN([DCL_CHECK_FCALLSCSUB],
[
    AC_REQUIRE([DCL_PROG_FC])
    case "$FC" in
        '') ;;
        *)  AC_BEFORE([DCL_CHECK_CTYPE_FORTRAN])
            AC_MSG_CHECKING(for C-equivalent to Fortran routine \"SUB\")
            cat >conftest.f <<\EOF
              call sub()
              end
EOF
            doit='$FC -c ${FFLAGS} conftest.f'
            if AC_TRY_EVAL(doit); then
                FCALLSCSUB=`nm conftest.o | awk '
                    /SUB_/{print "SUB_";exit}
                    /SUB/ {print "SUB"; exit}
                    /sub_/{print "sub_";exit}
                    /sub/ {print "sub"; exit}'`
                case "$FCALLSCSUB" in
                    '') AC_MSG_ERROR(not found)
                        ;;
                    *)  AC_MSG_RESULT($FCALLSCSUB)
                        ;;
                esac
            else
                AC_MSG_ERROR(Could not compile conftest.f)
            fi
            rm -f conftest*
            ;;
    esac
])

dnl Check for a C type equivalent to a Fortran type.
dnl
dnl DCL_CHECK_CTYPE_FORTRAN(ftype, ctypes, fmacro_root)
dnl
AC_DEFUN(DCL_CHECK_CTYPE_FORTRAN,
[
    cat >conftestf.f <<EOF
           $1 values(4)
           data values /-1, -2, -3, -4/
           call sub(values)
           end
EOF
    for ctype in $2; do
        AC_MSG_CHECKING(if Fortran \"$1\" is C \"$ctype\")
        cat >conftest.c <<EOF
            void $FCALLSCSUB(values)
                $ctype values[[4]];
            {
                exit(values[[1]] != -2 || values[[2]] != -3);
            }
EOF
        doit='$CC -c ${CPPFLAGS} ${CFLAGS} conftest.c'
        if AC_TRY_EVAL(doit); then
            doit='$FC ${FFLAGS} -c conftestf.f'
            if AC_TRY_EVAL(doit); then
                doit='$FC -o conftest ${FFLAGS} ${FLDFLAGS} conftestf.o conftest.o ${LIBS}'
                if AC_TRY_EVAL(doit); then
                    doit=./conftest
                    if AC_TRY_EVAL(doit); then
                        AC_MSG_RESULT(yes)
                        AC_DEFINE_UNQUOTED(DCL_$3[], $ctype)
                        break
                    else
                        AC_MSG_RESULT(no)
                    fi
                else
			AC_MSG_ERROR(Could not link conftestf.o and conftest.o)
                fi
            else
                AC_MSG_ERROR(Could not compile conftestf.f)
            fi
        else
            AC_MSG_ERROR(Could not compile conftest.c)
        fi
    done
    rm -f conftest*
])

dnl Get information about Fortran data types.
dnl
AC_DEFUN([DCL_FORTRAN_TYPES],
[
    AC_REQUIRE([DCL_PROG_FC])
    case "$FC" in
    '')
        ;;
    *)
        AC_REQUIRE([DCL_CHECK_FCALLSCSUB])

        DCL_CHECK_CTYPE_FORTRAN(integer, int long, INT)
        DCL_CHECK_CTYPE_FORTRAN(real, float double, REAL)
        ;;
    esac
])

dnl
dnl check the form of hexadecimal number in FORTRAN
dnl
AC_DEFUN(DCL_CHECK_FORTRAN_HEX_DATA,
[
    cat << EOF > conftest1.f
      INTEGER I
      DATA I /Z'7FFFFFFF'/
      END
EOF
    cat << EOF > conftest2.f
      INTEGER I
      DATA I /Z7FFFFFFF/
      END
EOF
    doit1='$FC -o conftest1 ${FFLAGS-} conftest1.f'
    doit2='$FC -o conftest2 ${FFLAGS-} conftest2.f'

    if AC_TRY_EVAL(doit1); then
        AC_MSG_RESULT(hexadecimal number requires quotation)
        QFLAG=-DQUOTE
    elif AC_TRY_EVAL(doit2); then
        AC_MSG_RESULT(hexadecimal number requires no quotation)
        QFLAG=
    fi
    rm -f conftest? conftest?.?
])

dnl
dnl Get information about maximum and minimum value
dnl
AC_DEFUN(DCL_CHECK_VALUES,
[
    AC_REQUIRE([DCL_CHECK_FORTRAN_HEX_DATA])

cat << EOF > conftest.c
#include <stdio.h>
#include <float.h>
#include <values.h>

#ifdef FLT_MIN
#  define float_min FLT_MIN
#endif
#ifdef FLT_MAX
#  define float_max FLT_MAX
#endif
#ifdef FLT_EPSILON
#  define float_epsilon FLT_EPSILON
#endif
#ifdef MAXINT
#  define int_max MAXINT
#endif

typedef union {
    int          si;
    unsigned int ui;
} INT;
typedef union {
    float        fl;
    unsigned int ui;
} FLT;

main ()
{
    FILE *fd1, *fd2, *fd3, *fd4;
    FLT fmin, fmax, feps;
    INT imax;

    fmin.fl = float_min, fmax.fl = float_max;
    feps.fl = float_epsilon * 10.00001;
    imax.si = int_max;

    if ((fd1 = fopen("fminval", "w")) == NULL) {
        fprintf(stderr, "conftest: cannot open file fminval\n");
        exit(1);
    }
    if ((fd2 = fopen("fmaxval", "w")) == NULL) {
        fprintf(stderr, "conftest: cannot open file fmaxval\n");
        exit(1);
    }
    if ((fd3 = fopen("fepsval", "w")) == NULL) {
        fprintf(stderr, "conftest: cannot open file fepsval\n");
        exit(1);
    }
    if ((fd4 = fopen("imaxval", "w")) == NULL) {
        fprintf(stderr, "conftest: cannot open file imaxval\n");
        exit(1);
    }
#ifdef QUOTE
    fprintf(fd1, "Z'%08X'\n", fmin.ui);
    fprintf(fd2, "Z'%08X'\n", fmax.ui);
    fprintf(fd3, "Z'%08X'\n", feps.ui);
    fprintf(fd4, "Z'%08X'\n", imax.ui);
#else
    fprintf(fd1, "Z%08X\n", fmin.ui);
    fprintf(fd2, "Z%08X\n", fmax.ui);
    fprintf(fd3, "Z%08X\n", feps.ui);
    fprintf(fd4, "Z%08X\n", imax.ui);
#endif
    fclose(fd1);
    fclose(fd2);
    fclose(fd3);
    fclose(fd4);
    exit(0);
}
EOF

    REALMIN=
    REALMAX=
    REPSL=
    INTMAX=
    doit='$CC -o conftest ${CFLAGS-} $QFLAG conftest.c'
    if AC_TRY_EVAL(doit); then
        doit=`./conftest`
        REALMIN=`cat fminval`
        REALMAX=`cat fmaxval`
        REPSL=`cat fepsval`
        INTMAX=`cat imaxval`
        AC_MSG_RESULT(REALMAX is ${REALMAX})
        AC_MSG_RESULT(REALMIN is ${REALMIN})
        AC_MSG_RESULT(EPSILON is ${REPSL})
        AC_MSG_RESULT(INTMAX is ${INTMAX})
    fi
    AC_SUBST(REALMIN)
    AC_SUBST(REALMAX)
    AC_SUBST(REPSL)
    AC_SUBST(INTMAX)

    rm -f conftest conftest.? fminval fmaxval fepsval imaxval
])

dnl
dnl Check the value CLOCKS_PER_SEC and CLK_TCK
dnl
AC_DEFUN(DCL_CHECK_CLOCK_VALUES,
[
    cat << EOF > conftest.c
#include <stdio.h>
#include <time.h>

#ifndef CLOCKS_PER_SEC
#  define CLK_PER_SEC 1000000
#else
#  define CLK_PER_SEC 0
#endif
#ifndef CLK_TCK
#  define CLK_RSL_TCK 60
#else
#  define CLK_RSL_TCK 0
#endif

main ()
{
    FILE *fd1, *fd2;

    if ((fd1 = fopen("confval1", "w")) == NULL) {
        fprintf(stderr, "conftest: cannot open file confval1\n");
        exit(1);
    }
    if ((fd2 = fopen("confval2", "w")) == NULL) {
        fprintf(stderr, "conftest: cannot open file confval2\n");
        exit(1);
    }

    fprintf(fd1, "%d", CLK_PER_SEC);
    fprintf(fd2, "%d", CLK_RSL_TCK);

    fclose(fd1);
    fclose(fd2);
}
EOF

    doit='$CC -o conftest ${CFLAGS-} conftest.c'
    CLK_PER_SEC=
    CLK_RSL_TCK=
    if AC_TRY_EVAL(doit); then
        doit=`./conftest`
        cpsval=`cat confval1`
        crtval=`cat confval2`
        if test ${cpsval} != 0; then
            CLK_PER_SEC=${cpsval}
            AC_MSG_RESULT(CLOCKS_PER_SEC is ${CLK_PER_SEC})
        else
            AC_MSG_RESULT(CLOCKS_PER_SEC is provided by the system)
        fi
        if test ${crtval} != 0; then
            CLK_RSL_TCK=${crtval}
            AC_MSG_RESULT(CLK_TCK is ${CLK_RSL_TCK})
        else
            AC_MSG_RESULT(CLK_TCK is provided by the system)
        fi
    fi
    AC_SUBST(CLK_PER_SEC)
    AC_SUBST(CLK_RSL_TCK)

    rm -f conftest conftest.? confval?
])
