/* Copyright (C) by GFD-Dennou Club, 1999-2000.  All rights reserved. */
/* mpfpst.f -- translated by f2c (version 19990503).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* ----------------------------------------------------------------------- */
/*     MAP PROJECTION (POLAR STEREO)                    93/02/20 S.SAKAI */
/* ----------------------------------------------------------------------- */
/* Subroutine */ int mpfpst_0_(int n__, real *xlon, real *ylat, real *x, real 
	*y)
{
    /* Builtin functions */
    double tan(doublereal), sin(doublereal), cos(doublereal), sqrt(doublereal)
	    , atan(doublereal), atan2(doublereal, doublereal);

    /* Local variables */
    extern doublereal rfpi_(void);
    static real r__, pi, th;

    switch(n__) {
	case 1: goto L_mpipst;
	}

    pi = rfpi_();
    th = pi / 2 - *ylat;
    if (th >= pi - 1e-4f) {
	th = pi - 1e-4f;
    }
    r__ = tan(th / 2) * 2;
    *x = r__ * sin(*xlon);
    *y = -r__ * cos(*xlon);
    return 0;
/* ----------------------------------------------------------------------- */

L_mpipst:
    pi = rfpi_();
    r__ = sqrt(*x * *x + *y * *y);
    *ylat = pi / 2 - atan(r__ / 2) * 2;
    if (r__ == 0.f) {
	*xlon = 0.f;
    } else {
	*xlon = atan2(*x, -(*y));
    }
    return 0;
} /* mpfpst_ */

/* Subroutine */ int mpfpst_(real *xlon, real *ylat, real *x, real *y)
{
    return mpfpst_0_(0, xlon, ylat, x, y);
    }

/* Subroutine */ int mpipst_(real *x, real *y, real *xlon, real *ylat)
{
    return mpfpst_0_(1, xlon, ylat, x, y);
    }

