/* Copyright (C) by GFD-Dennou Club, 1999-2000.  All rights reserved. */
/* mpfaza.f -- translated by f2c (version 19990503).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* ----------------------------------------------------------------------- */
/*     MAP PROJECTION (LANBERT AZIMUTHAL EQUAL-AREA)    93/02/20 S.SAKAI */
/* ----------------------------------------------------------------------- */
/* Subroutine */ int mpfaza_0_(int n__, real *xlon, real *ylat, real *x, real 
	*y)
{
    /* Builtin functions */
    double sin(doublereal), cos(doublereal), sqrt(doublereal), atan2(
	    doublereal, doublereal), asin(doublereal);

    /* Local variables */
    extern doublereal rfpi_(void);
    static real r__, pi, th;
    extern /* Subroutine */ int glrget_(char *, real *, ftnlen);
    static real rna;

    switch(n__) {
	case 1: goto L_mpiaza;
	}

    pi = rfpi_();
    th = pi / 2 - *ylat;
    if (th > pi) {
	th = pi;
    }
    if (th < 0.f) {
	th = 0.f;
    }
    r__ = sin(th / 2) * 2;
    *x = r__ * sin(*xlon);
    *y = -r__ * cos(*xlon);
    return 0;
/* ----------------------------------------------------------------------- */

L_mpiaza:
    pi = rfpi_();
    r__ = sqrt(*x * *x + *y * *y);
    if (r__ == 0.f) {
	*xlon = 0.f;
	*ylat = pi / 2.f;
	return 0;
    } else if (r__ <= 2.f) {
	*xlon = atan2(*x, -(*y));
	*ylat = pi / 2 - asin(r__ / 2) * 2;
	return 0;
    }
    glrget_("RUNDEF", &rna, (ftnlen)6);
    *xlon = rna;
    *ylat = rna;
    return 0;
} /* mpfaza_ */

/* Subroutine */ int mpfaza_(real *xlon, real *ylat, real *x, real *y)
{
    return mpfaza_0_(0, xlon, ylat, x, y);
    }

/* Subroutine */ int mpiaza_(real *x, real *y, real *xlon, real *ylat)
{
    return mpfaza_0_(1, xlon, ylat, x, y);
    }

