/* Copyright (C) by GFD-Dennou Club, 1999-2000.  All rights reserved. */
/* stftrn.f -- translated by f2c (version 19990503).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static doublereal c_b2 = 10.;

/* ----------------------------------------------------------------------- */
/*     NORMALIZATION TRANSFORMATION (INCLUDING MAP PROJECTION) */
/* ----------------------------------------------------------------------- */
/* Subroutine */ int stftrn_0_(int n__, real *ux, real *uy, real *vx, real *
	vy, integer *itr, real *cxa, real *cya, real *vxoff, real *vyoff)
{
    /* System generated locals */
    doublereal d__1;

    /* Builtin functions */
    double r_lg10(real *), pow_dd(doublereal *, doublereal *);

    /* Local variables */
    static integer itrz;
    extern /* Subroutine */ int ct2bc_(real *, real *, real *, real *), 
	    ct2pc_(real *, real *, real *, real *), ct2cp_(real *, real *, 
	    real *, real *), mpfek6_(real *, real *, real *, real *), mpiek6_(
	    real *, real *, real *, real *);
    static real cx, cy;
    extern /* Subroutine */ int mpfcoa_(real *, real *, real *, real *), 
	    mpfcoc_(real *, real *, real *, real *), mpicoa_(real *, real *, 
	    real *, real *), mpicoc_(real *, real *, real *, real *);
    static real xx, yy;
    extern /* Subroutine */ int mpfcon_(real *, real *, real *, real *), 
	    mpfbon_(real *, real *, real *, real *), mpfktd_(real *, real *, 
	    real *, real *), mpfmer_(real *, real *, real *, real *), mpfaza_(
	    real *, real *, real *, real *), msgdmp_(char *, char *, char *, 
	    ftnlen, ftnlen, ftnlen), mpfhmr_(real *, real *, real *, real *), 
	    mpfcyl_(real *, real *, real *, real *), mpfmwd_(real *, real *, 
	    real *, real *), mpfotg_(real *, real *, real *, real *), mpfazm_(
	    real *, real *, real *, real *), mpicyl_(real *, real *, real *, 
	    real *), mpimer_(real *, real *, real *, real *), mpimwd_(real *, 
	    real *, real *, real *), mpihmr_(real *, real *, real *, real *), 
	    mpiktd_(real *, real *, real *, real *), mpicon_(real *, real *, 
	    real *, real *), mpibon_(real *, real *, real *, real *), mpiotg_(
	    real *, real *, real *, real *), mpiazm_(real *, real *, real *, 
	    real *), mpiaza_(real *, real *, real *, real *), glrget_(char *, 
	    real *, ftnlen), mpfpst_(real *, real *, real *, real *), mpipst_(
	    real *, real *, real *, real *), stfusr_(real *, real *, real *, 
	    real *), stiusr_(real *, real *, real *, real *);
    static real vx0, vy0, rna;

    switch(n__) {
	case 1: goto L_stitrn;
	case 2: goto L_ststrn;
	}

    if (itrz == 1) {
	xx = *ux;
	yy = *uy;
    } else if (itrz == 2) {
	xx = *ux;
	yy = r_lg10(uy);
    } else if (itrz == 3) {
	xx = r_lg10(ux);
	yy = *uy;
    } else if (itrz == 4) {
	xx = r_lg10(ux);
	yy = r_lg10(uy);
    } else if (itrz == 5) {
	ct2pc_(ux, uy, &xx, &yy);
    } else if (itrz == 6) {
	ct2bc_(ux, uy, &xx, &yy);
    } else if (itrz == 10) {
	mpfcyl_(ux, uy, &xx, &yy);
    } else if (itrz == 11) {
	mpfmer_(ux, uy, &xx, &yy);
    } else if (itrz == 12) {
	mpfmwd_(ux, uy, &xx, &yy);
    } else if (itrz == 13) {
	mpfhmr_(ux, uy, &xx, &yy);
    } else if (itrz == 14) {
	mpfek6_(ux, uy, &xx, &yy);
    } else if (itrz == 15) {
	mpfktd_(ux, uy, &xx, &yy);
    } else if (itrz == 20) {
	mpfcon_(ux, uy, &xx, &yy);
    } else if (itrz == 21) {
	mpfcoa_(ux, uy, &xx, &yy);
    } else if (itrz == 22) {
	mpfcoc_(ux, uy, &xx, &yy);
    } else if (itrz == 23) {
	mpfbon_(ux, uy, &xx, &yy);
    } else if (itrz == 30) {
	mpfotg_(ux, uy, &xx, &yy);
    } else if (itrz == 31) {
	mpfpst_(ux, uy, &xx, &yy);
    } else if (itrz == 32) {
	mpfazm_(ux, uy, &xx, &yy);
    } else if (itrz == 33) {
	mpfaza_(ux, uy, &xx, &yy);
    } else if (itrz == 99) {
	stfusr_(ux, uy, &xx, &yy);
    }
    if (xx == rna || yy == rna) {
	*vx = rna;
	*vy = rna;
    } else {
	*vx = cx * xx + vx0;
	*vy = cy * yy + vy0;
    }
    return 0;
/* ----------------------------------------------------------------------- */

L_stitrn:
    xx = (*vx - vx0) / cx;
    yy = (*vy - vy0) / cy;
    if (itrz == 1) {
	*ux = xx;
	*uy = yy;
    } else if (itrz == 2) {
	*ux = xx;
	d__1 = (doublereal) yy;
	*uy = pow_dd(&c_b2, &d__1);
    } else if (itrz == 3) {
	d__1 = (doublereal) xx;
	*ux = pow_dd(&c_b2, &d__1);
	*uy = *vy;
    } else if (itrz == 4) {
	d__1 = (doublereal) xx;
	*ux = pow_dd(&c_b2, &d__1);
	d__1 = (doublereal) yy;
	*uy = pow_dd(&c_b2, &d__1);
    } else if (itrz == 5) {
	ct2cp_(&xx, &yy, ux, uy);
    } else if (itrz == 6) {
	msgdmp_("E", "STITRN", "INVERSE TRANSFORMATION IS NOT DEFINED FOR IT"
		"R=6.", (ftnlen)1, (ftnlen)6, (ftnlen)48);
    } else if (itrz == 10) {
	mpicyl_(&xx, &yy, ux, uy);
    } else if (itrz == 11) {
	mpimer_(&xx, &yy, ux, uy);
    } else if (itrz == 12) {
	mpimwd_(&xx, &yy, ux, uy);
    } else if (itrz == 13) {
	mpihmr_(&xx, &yy, ux, uy);
    } else if (itrz == 14) {
	mpiek6_(&xx, &yy, ux, uy);
    } else if (itrz == 15) {
	mpiktd_(&xx, &yy, ux, uy);
    } else if (itrz == 20) {
	mpicon_(&xx, &yy, ux, uy);
    } else if (itrz == 21) {
	mpicoa_(&xx, &yy, ux, uy);
    } else if (itrz == 22) {
	mpicoc_(&xx, &yy, ux, uy);
    } else if (itrz == 23) {
	mpibon_(&xx, &yy, ux, uy);
    } else if (itrz == 30) {
	mpiotg_(&xx, &yy, ux, uy);
    } else if (itrz == 31) {
	mpipst_(&xx, &yy, ux, uy);
    } else if (itrz == 32) {
	mpiazm_(&xx, &yy, ux, uy);
    } else if (itrz == 33) {
	mpiaza_(&xx, &yy, ux, uy);
    } else if (itrz == 99) {
	stiusr_(&xx, &yy, ux, uy);
    }
    return 0;
/* ----------------------------------------------------------------------- */

L_ststrn:
    cx = *cxa;
    cy = *cya;
    vx0 = *vxoff;
    vy0 = *vyoff;
    itrz = *itr;
    glrget_("RUNDEF", &rna, (ftnlen)6);
    return 0;
} /* stftrn_ */

/* Subroutine */ int stftrn_(real *ux, real *uy, real *vx, real *vy)
{
    return stftrn_0_(0, ux, uy, vx, vy, (integer *)0, (real *)0, (real *)0, (
	    real *)0, (real *)0);
    }

/* Subroutine */ int stitrn_(real *vx, real *vy, real *ux, real *uy)
{
    return stftrn_0_(1, ux, uy, vx, vy, (integer *)0, (real *)0, (real *)0, (
	    real *)0, (real *)0);
    }

/* Subroutine */ int ststrn_(integer *itr, real *cxa, real *cya, real *vxoff, 
	real *vyoff)
{
    return stftrn_0_(2, (real *)0, (real *)0, (real *)0, (real *)0, itr, cxa, 
	    cya, vxoff, vyoff);
    }

