*-----------------------------------------------------------------------
*     USPQNP / USPQID / USPQCP / USPQVL / USPSVL
*-----------------------------------------------------------------------
      SUBROUTINE USPQNP(NCP)

      CHARACTER CP*(*)

      PARAMETER (NPARA=47, RUNDEF=-999., IUNDEF=-999)

      INTEGER   IX(NPARA)
      REAL      RX(NPARA)
      LOGICAL   LX(NPARA),LCHREQ,LFIRST
      CHARACTER CPARA(NPARA)*8,CMSG*80

      EQUIVALENCE (IX,RX,LX)

      EXTERNAL  LCHREQ,LENC

      SAVE

*     / CONTROL PARAMETERS /

      DATA      CPARA( 1)/'IRESET  '/, IX( 1)/ 1/

*     / PARAMETERS FOR USDAXS /

      DATA      CPARA( 2)/'LXINV   '/, LX( 2)/ .FALSE./
      DATA      CPARA( 3)/'LYINV   '/, LX( 3)/ .FALSE./
      DATA      CPARA( 4)/'LMATCH  '/, LX( 4)/ .FALSE./
      DATA      CPARA( 5)/'RMRGN   '/, RX( 5)/  9.524/

*     / PARAMETERS FOR USUSCU /

      DATA      CPARA( 6)/'XOFF    '/, RX( 6)/ RUNDEF/
      DATA      CPARA( 7)/'YOFF    '/, RX( 7)/ RUNDEF/
      DATA      CPARA( 8)/'XFAC    '/, RX( 8)/ RUNDEF/
      DATA      CPARA( 9)/'YFAC    '/, RX( 9)/ RUNDEF/
      DATA      CPARA(10)/'DXT     '/, RX(10)/ RUNDEF/
      DATA      CPARA(11)/'DYT     '/, RX(11)/ RUNDEF/
      DATA      CPARA(12)/'DXL     '/, RX(12)/ RUNDEF/
      DATA      CPARA(13)/'DYL     '/, RX(13)/ RUNDEF/
      DATA      CPARA(14)/'TFACT   '/, RX(14)/ 2./
      DATA      CPARA(15)/'MXDGTX  '/, IX(15)/ 4/
      DATA      CPARA(16)/'MXDGTY  '/, IX(16)/ 4/
      DATA      CPARA(17)/'NBLANK1 '/, IX(17)/ 1/
      DATA      CPARA(18)/'NBLANK2 '/, IX(18)/ 2/

*     / PARAMETERS FOR USUSCL /

      DATA      CPARA(19)/'NLBLX   '/, IX(19)/ IUNDEF/
      DATA      CPARA(20)/'NLBLY   '/, IX(20)/ IUNDEF/
      DATA      CPARA(21)/'NTICKSX '/, IX(21)/ IUNDEF/
      DATA      CPARA(22)/'NTICKSY '/, IX(22)/ IUNDEF/
      DATA      CPARA(23)/'ITYPEX  '/, IX(23)/ IUNDEF/
      DATA      CPARA(24)/'ITYPEY  '/, IX(24)/ IUNDEF/

*     / PARAMETERS FOR USXSUB & USYSUB /

      DATA      CPARA(25)/'MXDGTSX '/, IX(25)/  6/
      DATA      CPARA(26)/'MXDGTSY '/, IX(26)/  6/
      DATA      CPARA(27)/'LPRTCT  '/, LX(27)/ .FALSE./

*     / FOLLOWING 20 PARAMETERS ARE RESET BY USINIZ /

      DATA      CPARA(28)/'SOFFXTR '/, RX(28)/  0.018/
      DATA      CPARA(29)/'SOFFXBR '/, RX(29)/  0.018/
      DATA      CPARA(30)/'SOFFXUR '/, RX(30)/  0.018/
      DATA      CPARA(31)/'SOFFXTL '/, RX(31)/ -0.018/
      DATA      CPARA(32)/'SOFFXBL '/, RX(32)/ -0.018/
      DATA      CPARA(33)/'SOFFXUL '/, RX(33)/ -0.018/
      DATA      CPARA(34)/'SOFFYRT '/, RX(34)/  0.018/
      DATA      CPARA(35)/'SOFFYLT '/, RX(35)/  0.018/
      DATA      CPARA(36)/'SOFFYUT '/, RX(36)/  0.018/
      DATA      CPARA(37)/'SOFFYRB '/, RX(37)/ -0.018/
      DATA      CPARA(38)/'SOFFYLB '/, RX(38)/ -0.018/
      DATA      CPARA(39)/'SOFFYUB '/, RX(39)/ -0.018/
      DATA      CPARA(40)/'ROFFXT  '/, RX(40)/  0./
      DATA      CPARA(41)/'ROFFXB  '/, RX(41)/  0./
      DATA      CPARA(42)/'ROFFYR  '/, RX(42)/  0./
      DATA      CPARA(43)/'ROFFYL  '/, RX(43)/  0./

      DATA      CPARA(44)/'XDTMIN  '/, RX(44)/  RUNDEF/
      DATA      CPARA(45)/'XDTMAX  '/, RX(45)/  RUNDEF/
      DATA      CPARA(46)/'YDTMIN  '/, RX(46)/  RUNDEF/
      DATA      CPARA(47)/'YDTMAX  '/, RX(47)/  RUNDEF/

      DATA      LFIRST/.TRUE./

      NCP=NPARA

      RETURN
*-----------------------------------------------------------------------
      ENTRY USPQID(CP,IDX)

      DO 10 N=1,NPARA
        IF (LCHREQ(CP,CPARA(N))) THEN
          IDX=N
          RETURN
        END IF
   10 CONTINUE
      CMSG='PARAMETER '''//CP(1:LENC(CP))//''' IS NOT DEFINED.'
      CALL MSGDMP('E','USPQID',CMSG)

      RETURN
*-----------------------------------------------------------------------
      ENTRY USPQCP(IDX,CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP=CPARA(IDX)
      ELSE
        CALL MSGDMP('E','USPQCP','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY USPQVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('US:',CPARA,IX,NPARA)
        LFIRST=.FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IPARA=IX(IDX)
      ELSE
        CALL MSGDMP('E','USPQVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY USPSVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('US:',CPARA,IX,NPARA)
        LFIRST=.FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IX(IDX)=IPARA
      ELSE
        CALL MSGDMP('E','USPSVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
      END
