program solver
! Holton (2004) non-divergent barotropic vortex model
  use gtool_history
  use Derivation
  use Statistics
  use Math_Const
  use Phys_Const
  use Basis
  use saveval_define
  use val_define
  use read_namelist
  use saveval_alloc
  use val_alloc
  use val_coord
  use time_scheme
  use sub_mod
  use force_solv
  use Ellip_Slv

  implicit none

!-- do loop ѿ
  integer :: i, j, it

!-- namelist ɤ߹

  call read_name()

!-- allocating array

  call saveval_allocate()
  call val_allocate()

!-- ʻκ

  call val_coordinate()

!-- Ͳ (׻ΰ䶭, ä˥ݥ׻ˤĤ)

write(*,*) "starting initialization."

!-- psi, omega Ф, ƶե饰.

  bnd=0.0d0

!-- reading initial data

  call HistoryGet( trim(ininame), trim(adjustl(inix)), xi )
  call HistoryGet( trim(ininame), trim(adjustl(iniy)), yi )
!  call HistoryGet( trim(ininame), trim(adjustl(inif)), fi )
  call HistoryGet( trim(ininame), trim(adjustl(iniz)), zi )

  do i=1,nx
     xd(i)=real(x(i))
  end do
  do j=1,ny
     yd(j)=real(y(j))
  end do

write(*,*) "starting interpolation of initial data."
!  call auto_interpolation_1d( yi, y, fi, coril )
  call auto_interpolation_2d( xi, yi, xd, yd, zi, zd )

!  call grad_1d( y, coril, betaf )

  do j=1,ny
     do i=1,nx
        zo(i,j)=dble(zd(i,j))
     end do
  end do

!-- setting psi

write(*,*) "setting initial data of psi."
  call Ellip_Jacobi_2d( x, y, zo, eps, boundary, psio,  &
  &                     init_flag=.false. )

!-- ͤ.

  write(*,*) "normally pass the initialization."

!-- ϥեν
  call HistoryCreate( file=trim(foname), title='BAROTRO result data', &
  & source='test', institution='test', dims=(/'x', 'y', 't'/),  &
  & dimsizes=(/ nx, ny, 0 /),  & 
  & longnames=(/'X-coordinate','Y-coordinate', 'time        '/),  &
  & units=(/'m', 'm', 's'/), origin=0.0, interval=dmpstp*real(dt) )
  
  call HistoryPut( 'x', xd )
  call HistoryPut( 'y', yd )
  
  call HistoryAddVariable( varname='psi', dims=(/'x','y','t'/), &
    & longname='stream line function', units='m2 s-1', xtype='float')

  call HistoryAddVariable( varname='zeta', dims=(/'x','y','t'/), &
    & longname='vorticity', units='s-1', xtype='float')

  call HistoryAddVariable( varname='u', dims=(/'x','y','t'/), &
    & longname='X wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='v', dims=(/'x','y','t'/), &
    & longname='Y wind', units='m s-1', xtype='float')

  write(*,*) "time integration start."

  !-- ν (ͤν)

  call psi2uv( psio, u, v )

  do j=1,ny
     do i=1,nx
        psid(i,j)=real(psio(i,j))
        zd(i,j)=real(zo(i,j))
        ud(i,j)=real(u(i,j))
        vd(i,j)=real(v(i,j))
        psin(i,j)=psio(i,j)
        zn(i,j)=zo(i,j)
     end do
  end do

  write(*,*) "*******************************************"
  write(*,*) "File damp (time =", 0.0, "[s])."
  write(*,*) "*******************************************"

  call HistoryPut( 'psi', psid )
  call HistoryPut( 'zeta', zd )
  call HistoryPut( 'u', ud )
  call HistoryPut( 'v', vd )

!-- solver 

  do it=1,nt

     select case (time_flag(1:3))
     case ('L-F')
        call time_schematic( it, zo, psio, zn, psin, zopt1 )
     case ('AB2')
        call time_schematic( it, zo, psio, zn, psin, zopt1 )
     case default
        call time_schematic( it, zo, psio, zn, psin )
     end select

     zo=zn
     psio=psin

  !-- ƥåפοʤ߶
     write(*,*) "This step is ", it, "(time =", dble(it)*dt, "[s])."

     !-- ν (2)
     if(mod(it,dmpstp)==0)then  ! ѴԤ¿Ϥ.

        call psi2uv( psin, u, v )

        do j=1,ny
           do i=1,nx
              psid(i,j)=real(psin(i,j))
              zd(i,j)=real(zn(i,j))
              ud(i,j)=real(u(i,j))
              vd(i,j)=real(v(i,j))
           end do
        end do

        write(*,*) "*******************************************"
        write(*,*) "File damp (time =", dble(it)*dt, "[s])."
        write(*,*) "*******************************************"

        call HistoryPut( 'psi', psid )
        call HistoryPut( 'zeta', zd )
        call HistoryPut( 'u', ud )
        call HistoryPut( 'v', vd )

     end if

  end do

!-- solver ȥå

  write(*,*) "solver is normally."

end program
