require "numru/netcdf"
include NumRu

nx = 100
fname = 'init.dat'

inix = NArray.sfloat(nx).indgen(0.0)
inix = inix * nx
iniy = NArray.sfloat(nx)
ini = NArray.sfloat(nx)

iniy[0..nx/2] = 1.0
iniy[nx/2+1..nx-1] = -1.0

f = NetCDF.create(fname)
f.def_dim('x',nx)
require 'date'
f.put_att('history','created by #{$0} #{Date.today}')
x = f.def_var('x','sfloat',['x'])

y = f.def_var('h','sfloat',['x'])
y.put_att('long_name','height')
y.put_att('units','m')
val1 = f.def_var('u','sfloat',['x'])
val1.put_att('long_name','zonal wind')
val1.put_att('units','m s-1')
val2 = f.def_var('v','sfloat',['x'])
val2.put_att('long_name','meridional wind')
val2.put_att('units','m s-1')
f.enddef

x.put(inix)
y.put(iniy)
val1.put(ini)
val2.put(ini)

f.close
