!-----------------------------------------------------------------------
!     Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!-----------------------------------------------------------------------

module typhoon_analy  ! ټ¸ѥڥϥ⥸塼

  use algebra
  use Basis
  use Derivation
  use Geometry
  use Map_Function
  use max_min
  use statistics
  use stdio

  implicit none

  private :: search_region_1d  ! ʿѤǽȾ¤ܺ.

interface tangent_conv_scal

  module procedure tangent_conv_scal_f, tangent_conv_scal_d

end interface tangent_conv_scal

interface tangent_mean_scal

  module procedure tangent_mean_scal_f, tangent_mean_scal_d

end interface tangent_mean_scal

interface tangent_mean_anom_scal

  module procedure tangent_mean_anom_scal_f, tangent_mean_anom_scal_d

end interface tangent_mean_anom_scal

interface tangent_mean_scal_Cart

  module procedure tangent_mean_scal_Cart_f, tangent_mean_scal_Cart_d

end interface tangent_mean_scal_Cart

interface tangent_mean_anom_scal_Cart

  module procedure tangent_mean_anom_scal_Cart_f, tangent_mean_anom_scal_Cart_d

end interface tangent_mean_anom_scal_Cart

interface Cart_conv_scal

  module procedure Cart_conv_scal_f, Cart_conv_scal_d

end interface Cart_conv_scal

interface Cart_mean_scal

  module procedure Cart_mean_scal_f, Cart_mean_scal_d

end interface Cart_mean_scal

interface tangent_mean_vec

  module procedure tangent_mean_vec_f, tangent_mean_vec_d

end interface tangent_mean_vec

interface tangent_mean_anom_vec

  module procedure tangent_mean_anom_vec_f, tangent_mean_anom_vec_d

end interface tangent_mean_anom_vec

interface calc_taufil

  module procedure calc_taufil_f, calc_taufil_d

end interface calc_taufil

interface hydro_grad_eqb

  module procedure hydro_grad_eqb_f, hydro_grad_eqb_d

end interface hydro_grad_eqb

interface grad_wind_pres

  module procedure grad_wind_pres_f, grad_wind_pres_d

end interface grad_wind_pres

interface pres_grad_wind

  module procedure pres_grad_wind_f, pres_grad_wind_d

end interface pres_grad_wind

interface SPLB_Kurihara

  module procedure SPLB_Kurihara_f, SPLB_Kurihara_d

end interface SPLB_Kurihara

interface CPS_Hart

  module procedure CPS_Hart_f, CPS_Hart_d

end interface CPS_Hart

interface DC_Braun

  module procedure DC_Braun_f, DC_Braun_d

end interface DC_Braun

interface DC_Sat_ZNCC

  module procedure DC_Sat_ZNCC_f, DC_Sat_ZNCC_d

end interface DC_Sat_ZNCC

contains

subroutine tangent_conv_scal_f( x, y, xc, yc, u, r, theta, v, undef,  &
  &                             undefg, undefgc, stdopt, axis )
  ! Ǥդʪ̤濴Ѵ롼
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! ܥ롼ʿ̶˺ɸåͤǤк׻Ԥ.
  ! ʿѤԤäΤ, ǥȺɸкȤˤ, 
  ! tangent_mean_anom_scal_r2c .
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  implicit none
  real, intent(in) :: x(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: y(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: u(size(x),size(y))  ! ɸϤǤʿѲ
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ. [m or rad]
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ. [m or rad]
  real, intent(in) :: r(:)  ! (xc, yc) 濴Ȥ˺ɸưºɸ [m].
  real, intent(in) :: theta(:)  ! (xc, yc) 濴Ȥ˺ɸƱ̳Ѻɸ [rad].
  real, intent(inout) :: v(size(r),size(theta))  ! ʿѲ u ΥΥޥ꡼.
  real, intent(in), optional :: undef  ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: i, j, nx, ny, nr, nt, i_undef
  real :: r_undef, r_undefg
  real :: work(size(r),size(theta))
  real :: point(size(r),size(theta),2)
  integer :: ip(size(r),size(theta),2)
  real :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)
  double precision :: tmppointd1, tmppointd2
  character(1) :: undefgcflag
  character(2) :: ax_flag
  logical, dimension(size(r)) :: undefgc_check
  logical :: ucf, stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "tangent_conv_scal" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nt, v ),  &
  &                                     "tangent_conv_scal" )
  end if

  undefgc_check(:)=.true.
  i_undef=0

  if(present(undef))then
    r_undef=undef
  else
    r_undef=-999.0
  end if

  if(present(undefg))then
    r_undefg=undefg
  else
    r_undefg=-999.0
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:1)
     else
        undefgcflag="i"
     end if
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(axis))then
     ax_flag=axis(1:2)
  else
     ax_flag='xy'
  end if

!-- ΰ򥯥ꥢƤ뤫ǧ ---
!-- ϹԤʤ.

!  call search_region_1d( (/x(1),x(nx)/), (/y(1),y(ny)/), (/xc,yc/), r, nr,  &
!  &                      stdopt=stderr, axis=ax_flag(1:2) )

!--  v  undef ͤƤ.
!  do j=1,nt
!     do i=1,nrr
!        v(i,j)=r_undef
!     end do
!  end do

!-- (1) ---
  if(ax_flag(1:2)=='xy')then
     do j=1,nt
        do i=1,nr
           call rt_2_xy( r(i), theta(j), point(i,j,1), point(i,j,2) )
           point(i,j,1)=xc+point(i,j,1)
           point(i,j,2)=yc+point(i,j,2)
        end do
     end do
  else
     do j=1,nt
        do i=1,nr
           if(r(i)/=0.0)then
              call rt2ll( dble(r(i)), dble(theta(j)), dble(xc), dble(yc),  &
  &                       tmppointd1, tmppointd2 )
              point(i,j,1)=real(tmppointd1)
              point(i,j,2)=real(tmppointd2)
           else
              point(i,j,1)=xc
              point(i,j,2)=yc
           end if
        end do
     end do
  end if

!-- (2) ---
  do j=1,nt
     do i=1,nr
        call interpo_search_2d( x, y, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2), undeff=i_undef,  &
  &                             stdopt=stderr )
     end do
  end do

!-- (3) ---
  do j=1,nt
     do i=1,nr
        if(ip(i,j,1)/=i_undef.and.ip(i,j,2)/=i_undef.and.  &
  &        ip(i,j,1)/=nx.and.ip(i,j,2)/=ny)then
           tmpx(1)=x(ip(i,j,1))
           tmpx(2)=x(ip(i,j,1)+1)
           tmpy(1)=y(ip(i,j,2))
           tmpy(2)=y(ip(i,j,2)+1)
           tmpz(1,1)=u(ip(i,j,1),ip(i,j,2))
           tmpz(2,1)=u(ip(i,j,1)+1,ip(i,j,2))
           tmpz(1,2)=u(ip(i,j,1),ip(i,j,2)+1)
           tmpz(2,2)=u(ip(i,j,1)+1,ip(i,j,2)+1)
           inter(1)=point(i,j,1)
           inter(2)=point(i,j,2)

           if(present(undefg))then
              ucf=undef_checker_2df( tmpz, undefg )
              if(ucf.eqv..false.)then
                 call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
              else
                 work(i,j)=r_undefg
                 undefgc_check(i)=.false.
              end if
           else
              call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
           end if
        else
           work(i,j)=r_undef
        end if
     end do
  end do

  do j=1,nt
     do i=1,nr
        v(i,j)=work(i,j)
     end do
  end do

end subroutine tangent_conv_scal_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_conv_scal_d( x, y, xc, yc, u, r, theta, v, undef,  &
  &                             undefg, undefgc, stdopt, axis )
  ! Ǥդʪ̤濴Ѵ롼
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! ܥ롼ʿ̶˺ɸåͤǤк׻Ԥ.
  ! ʿѤԤäΤ, ǥȺɸкȤˤ, 
  ! tangent_mean_anom_scal_r2c .
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  implicit none
  double precision, intent(in) :: x(:)  ! ɸϤǤʬ [m or rad]
  double precision, intent(in) :: y(:)  ! ɸϤǤʬ [m or rad]
  double precision, intent(in) :: u(size(x),size(y))  ! ɸϤǤʿѲ
  double precision, intent(in) :: xc  ! ʿѤݤ濴 x ʬ. [m or rad]
  double precision, intent(in) :: yc  ! ʿѤݤ濴 y ʬ. [m or rad]
  double precision, intent(in) :: r(:)  ! (xc, yc) 濴Ȥ˺ɸưºɸ [m].
  double precision, intent(in) :: theta(:)  ! (xc, yc) 濴Ȥ˺ɸƱ̳Ѻɸ [rad].
  double precision, intent(inout) :: v(size(r),size(theta))  ! ʿѲ u ΥΥޥ꡼.
  double precision, intent(in), optional :: undef  ! ΰ賰
  double precision, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: i, j, nx, ny, nr, nt, i_undef
  double precision :: r_undef, r_undefg
  double precision :: work(size(r),size(theta))
  double precision :: point(size(r),size(theta),2)
  integer :: ip(size(r),size(theta),2)
  double precision :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)
  double precision :: tmppointd1, tmppointd2
  character(1) :: undefgcflag
  character(2) :: ax_flag
  logical, dimension(size(r)) :: undefgc_check
  logical :: ucf, stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "tangent_conv_scal" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nt, v ),  &
  &                                     "tangent_conv_scal" )
  end if

  undefgc_check(:)=.true.
  i_undef=0

  if(present(undef))then
    r_undef=undef
  else
    r_undef=-999.0d0
  end if

  if(present(undefg))then
    r_undefg=undefg
  else
    r_undefg=-999.0d0
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:1)
     else
        undefgcflag="i"
     end if
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(axis))then
     ax_flag=axis(1:2)
  else
     ax_flag='xy'
  end if

!-- ΰ򥯥ꥢƤ뤫ǧ ---
!-- ϹԤʤ.

!  call search_region_1d( (/x(1),x(nx)/), (/y(1),y(ny)/), (/xc,yc/), r, nr,  &
!  &                      stdopt=stderr, axis=ax_flag(1:2) )

!--  v  undef ͤƤ.
!  do j=1,nt
!     do i=1,nrr
!        v(i,j)=r_undef
!     end do
!  end do

!-- (1) ---
  if(ax_flag(1:2)=='xy')then
     do j=1,nt
        do i=1,nr
           call rt_2_xy( r(i), theta(j), point(i,j,1), point(i,j,2) )
           point(i,j,1)=xc+point(i,j,1)
           point(i,j,2)=yc+point(i,j,2)
        end do
     end do
  else
     do j=1,nt
        do i=1,nr
           if(r(i)/=0.0d0)then
              call rt2ll( r(i), theta(j), xc, yc,  &
  &                       tmppointd1, tmppointd2 )
              point(i,j,1)=tmppointd1
              point(i,j,2)=tmppointd2
           else
              point(i,j,1)=xc
              point(i,j,2)=yc
           end if
        end do
     end do
  end if

!-- (2) ---
  do j=1,nt
     do i=1,nr
        call interpo_search_2d( x, y, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2), undeff=i_undef,  &
  &                             stdopt=stderr )
     end do
  end do

!-- (3) ---
  do j=1,nt
     do i=1,nr
        if(ip(i,j,1)/=i_undef.and.ip(i,j,2)/=i_undef.and.  &
  &        ip(i,j,1)/=nx.and.ip(i,j,2)/=ny)then
           tmpx(1)=x(ip(i,j,1))
           tmpx(2)=x(ip(i,j,1)+1)
           tmpy(1)=y(ip(i,j,2))
           tmpy(2)=y(ip(i,j,2)+1)
           tmpz(1,1)=u(ip(i,j,1),ip(i,j,2))
           tmpz(2,1)=u(ip(i,j,1)+1,ip(i,j,2))
           tmpz(1,2)=u(ip(i,j,1),ip(i,j,2)+1)
           tmpz(2,2)=u(ip(i,j,1)+1,ip(i,j,2)+1)
           inter(1)=point(i,j,1)
           inter(2)=point(i,j,2)

           if(present(undefg))then
              ucf=undef_checker_2dd( tmpz, undefg )
              if(ucf.eqv..false.)then
                 call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
              else
                 work(i,j)=r_undefg
                 undefgc_check(i)=.false.
              end if
           else
              call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
           end if
        else
           work(i,j)=r_undef
        end if
     end do
  end do

  do j=1,nt
     do i=1,nr
        v(i,j)=work(i,j)
     end do
  end do

end subroutine tangent_conv_scal_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_scal_f( x, y, xc, yc, u, r, theta, v, undef,  &
  &                             undefg, undefgc, stdopt, axis )
  ! Ǥդʪ̤濴ʿѤ롼
  ! Υ롼®ʿѤˤѤ뤳ȤϤǤʤ.
  ! ʿѤԤݤˤ, ̤Υ롼, tangent_mean_vec λѤɬ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! (4) nr x nt Ĥޥ顼ͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  implicit none
  real, intent(in) :: x(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: y(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: u(size(x),size(y))  ! ɸϤǤʿѲ
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ. [m or rad]
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ. [m or rad]
  real, intent(in) :: r(:)  ! (xc, yc) 濴Ȥ˺ɸưºɸ [m].
  real, intent(in) :: theta(:)  ! (xc, yc) 濴Ȥ˺ɸƱ̳Ѻɸ [rad].
  real, intent(inout) :: v(size(r))  ! ʿѲ u .
  real, intent(in), optional :: undef   ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: i, nx, ny, nr, nt
  real :: r_undef, r_undefg
  real :: work(size(r),size(theta))
  character(3) :: undefgcflag
  character(2) :: ax_flag
  logical, dimension(size(r)) :: undefgc_check
  logical :: stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "tangent_mean_scal" )
     call check_array_size_dmp_message( check_array_size_1d( nr, v ),  &
  &                                     "tangent_mean_scal" )
  end if

  undefgc_check(:)=.true.

  if(present(undef))then
    r_undef=undef
  else
    r_undef=-999.0
  end if

  if(present(undefg))then
    r_undefg=undefg
  else
    r_undefg=-999.0
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:3)
     else
        undefgcflag="inc"
     end if
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(axis))then
     ax_flag=axis(1:2)
  else
     ax_flag='xy'
  end if

!-- (1) - (3)

  call tangent_conv_scal_f( x, y, xc, yc, u, r, theta, work, undef=r_undef,  &
  &                         undefg=r_undefg, undefgc=undefgcflag(1:3),  &
  &                         stdopt=stderr, axis=ax_flag(1:2) )

!-- (4) ---
  if(present(undefg))then
     if(undefgcflag(1:1)=='i')then
        do i=1,nr
           call Mean_1d( work(i,:), v(i), error=undefg )
        end do
     else
        do i=1,nr
           if(undefgc_check(i).eqv..true.)then
              call Mean_1d( work(i,:), v(i) )
           else
              v(i)=undefg
           end if
        end do
     end if
  else
     do i=1,nr
        call Mean_1d( work(i,:), v(i) )
     end do
  end if

end subroutine tangent_mean_scal_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_scal_d( x, y, xc, yc, u, r, theta, v, undef,  &
  &                             undefg, undefgc, stdopt, axis )
  ! Ǥդʪ̤濴ʿѤ롼
  ! Υ롼®ʿѤˤѤ뤳ȤϤǤʤ.
  ! ʿѤԤݤˤ, ̤Υ롼, tangent_mean_vec λѤɬ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! (4) nr x nt Ĥޥ顼ͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  implicit none
  double precision, intent(in) :: x(:)  ! ɸϤǤʬ [m or rad]
  double precision, intent(in) :: y(:)  ! ɸϤǤʬ [m or rad]
  double precision, intent(in) :: u(size(x),size(y))  ! ɸϤǤʿѲ
  double precision, intent(in) :: xc  ! ʿѤݤ濴 x ʬ. [m or rad]
  double precision, intent(in) :: yc  ! ʿѤݤ濴 y ʬ. [m or rad]
  double precision, intent(in) :: r(:)  ! (xc, yc) 濴Ȥ˺ɸưºɸ [m].
  double precision, intent(in) :: theta(:)  ! (xc, yc) 濴Ȥ˺ɸƱ̳Ѻɸ [rad].
  double precision, intent(inout) :: v(size(r))  ! ʿѲ u .
  double precision, intent(in), optional :: undef   ! ΰ賰
  double precision, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: i, nx, ny, nr, nt
  double precision :: r_undef, r_undefg
  double precision :: work(size(r),size(theta))
  character(3) :: undefgcflag
  character(2) :: ax_flag
  logical, dimension(size(r)) :: undefgc_check
  logical :: stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "tangent_mean_scal" )
     call check_array_size_dmp_message( check_array_size_1d( nr, v ),  &
  &                                     "tangent_mean_scal" )
  end if

  undefgc_check(:)=.true.

  if(present(undef))then
    r_undef=undef
  else
    r_undef=-999.0d0
  end if

  if(present(undefg))then
    r_undefg=undefg
  else
    r_undefg=-999.0d0
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:3)
     else
        undefgcflag="inc"
     end if
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(axis))then
     ax_flag=axis(1:2)
  else
     ax_flag='xy'
  end if

!-- (1) - (3)

  call tangent_conv_scal_d( x, y, xc, yc, u, r, theta, work, undef=r_undef,  &
  &                         undefg=r_undefg, undefgc=undefgcflag(1:3),  &
  &                         stdopt=stderr, axis=ax_flag(1:2) )

!-- (4) ---
  if(present(undefg))then
     if(undefgcflag(1:1)=='i')then
        do i=1,nr
           call Mean_1d( work(i,:), v(i), error=undefg )
        end do
     else
        do i=1,nr
           if(undefgc_check(i).eqv..true.)then
              call Mean_1d( work(i,:), v(i) )
           else
              v(i)=undefg
           end if
        end do
     end if
  else
     do i=1,nr
        call Mean_1d( work(i,:), v(i) )
     end do
  end if

end subroutine tangent_mean_scal_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_anom_scal_f( x, y, xc, yc, u, r, theta, v, undef,  &
  &                                  undefg, undefgc, stdopt, axis )
  ! Ǥդʪ̤濴ʿѤ, ΥΥޥ꡼׻롼
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! (4) nr x nt Ĥޥ顼ͤޤä, nt к׻ Anomaly_1d .
  ! ʾǳ nr ˤĤкͤ.
  ! ܥ롼ʿ̶˺ɸåͤǤк׻Ԥ.
  ! ʿѤԤäΤ, ǥȺɸкȤˤ, 
  ! tangent_mean_anom_scal_r2c .
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  implicit none
  real, intent(in) :: x(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: y(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: u(size(x),size(y))  ! ɸϤǤʿѲ
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ. [m or rad]
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ. [m or rad]
  real, intent(in) :: r(:)  ! (xc, yc) 濴Ȥ˺ɸưºɸ [m].
  real, intent(in) :: theta(:)  ! (xc, yc) 濴Ȥ˺ɸƱ̳Ѻɸ [rad].
  real, intent(inout) :: v(size(r),size(theta))  ! ʿѲ u ΥΥޥ꡼.
  real, intent(in), optional :: undef  ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: i, j, nx, ny, nr, nt
  real :: r_undef, r_undefg
  real :: work(size(r),size(theta))
  character(3) :: undefgcflag
  character(2) :: ax_flag
  logical, dimension(size(r)) :: undefgc_check
  logical :: stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "tangent_mean_anom_scal" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nt, v ),  &
  &                                     "tangent_mean_anom_scal" )
  end if

  undefgc_check(:)=.true.

  if(present(undef))then
    r_undef=undef
  else
    r_undef=-999.0
  end if

  if(present(undefg))then
    r_undefg=undefg
  else
    r_undefg=-999.0
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:3)
     else
        undefgcflag="inc"
     end if
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(axis))then
     ax_flag=axis(1:2)
  else
     ax_flag='xy'
  end if

!-- (1) - (3) ---

  call tangent_conv_scal_f( x, y, xc, yc, u, r, theta, work, undef=r_undef,  &
  &                         undefg=r_undefg, undefgc=undefgcflag(1:3),  &
  &                         stdopt=stderr, axis=ax_flag(1:2) )

!-- (4) ---
  if(present(undefg))then
     if(undefgcflag(1:1)=='i')then
        do i=1,nr
           call Anomaly_1d( work(i,:), v(i,:), error=undefg )
        end do
     else
        do i=1,nr
           if(undefgc_check(i).eqv..true.)then
              call Anomaly_1d( work(i,:), v(i,:) )
           else
              do j=1,nt
                 v(i,j)=undefg
              end do
           end if
        end do
     end if
  else
     do i=1,nr
        call Anomaly_1d( work(i,:), v(i,:) )
     end do
  end if

end subroutine tangent_mean_anom_scal_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_anom_scal_d( x, y, xc, yc, u, r, theta, v, undef,  &
  &                                  undefg, undefgc, stdopt, axis )
  ! Ǥդʪ̤濴ʿѤ, ΥΥޥ꡼׻롼
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! (4) nr x nt Ĥޥ顼ͤޤä, nt к׻ Anomaly_1d .
  ! ʾǳ nr ˤĤкͤ.
  ! ܥ롼ʿ̶˺ɸåͤǤк׻Ԥ.
  ! ʿѤԤäΤ, ǥȺɸкȤˤ, 
  ! tangent_mean_anom_scal_r2c .
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  implicit none
  double precision, intent(in) :: x(:)  ! ɸϤǤʬ [m or rad]
  double precision, intent(in) :: y(:)  ! ɸϤǤʬ [m or rad]
  double precision, intent(in) :: u(size(x),size(y))  ! ɸϤǤʿѲ
  double precision, intent(in) :: xc  ! ʿѤݤ濴 x ʬ. [m or rad]
  double precision, intent(in) :: yc  ! ʿѤݤ濴 y ʬ. [m or rad]
  double precision, intent(in) :: r(:)  ! (xc, yc) 濴Ȥ˺ɸưºɸ [m].
  double precision, intent(in) :: theta(:)  ! (xc, yc) 濴Ȥ˺ɸƱ̳Ѻɸ [rad].
  double precision, intent(inout) :: v(size(r),size(theta))  ! ʿѲ u ΥΥޥ꡼.
  double precision, intent(in), optional :: undef  ! ΰ賰
  double precision, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: i, j, nx, ny, nr, nt
  double precision :: r_undef, r_undefg
  double precision :: work(size(r),size(theta))
  character(3) :: undefgcflag
  character(2) :: ax_flag
  logical, dimension(size(r)) :: undefgc_check
  logical :: stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "tangent_mean_anom_scal" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nt, v ),  &
  &                                     "tangent_mean_anom_scal" )
  end if

  undefgc_check(:)=.true.

  if(present(undef))then
    r_undef=undef
  else
    r_undef=-999.0d0
  end if

  if(present(undefg))then
    r_undefg=undefg
  else
    r_undefg=-999.0d0
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:3)
     else
        undefgcflag="inc"
     end if
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(axis))then
     ax_flag=axis(1:2)
  else
     ax_flag='xy'
  end if

!-- (1) - (3) ---

  call tangent_conv_scal_d( x, y, xc, yc, u, r, theta, work, undef=r_undef,  &
  &                         undefg=r_undefg, undefgc=undefgcflag(1:3),  &
  &                         stdopt=stderr, axis=ax_flag(1:2) )

!-- (4) ---
  if(present(undefg))then
     if(undefgcflag(1:1)=='i')then
        do i=1,nr
           call Anomaly_1d( work(i,:), v(i,:), error=undefg )
        end do
     else
        do i=1,nr
           if(undefgc_check(i).eqv..true.)then
              call Anomaly_1d( work(i,:), v(i,:) )
           else
              do j=1,nt
                 v(i,j)=undefg
              end do
           end if
        end do
     end if
  else
     do i=1,nr
        call Anomaly_1d( work(i,:), v(i,:) )
     end do
  end if

end subroutine tangent_mean_anom_scal_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_scal_Cart_f( x, y, xc, yc, scal, r, theta,  &
  &                                  scal_mean, undef, undefg, undefgc,  &
  &                                  stdopt, axis )
  ! 濴ʿѤ׻, ǥȺɸϤ᤹.
  ! ʿѥ롼Ѥʪ̤ʿѤ,  1 ǡݤƤ.
  ! Ʊ, ǥȷϤǤʪ̤αɸϤǤ radial ֤.
  !  radial ΰ֤ˤʿͤ 1 ǡޤǵ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  implicit none
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ [m] or lon [rad]
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ [m] or lat [rad]
  real, intent(in) :: scal(size(x),size(y))  ! ǥȺɸϤǤʿѲ.
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ [m] or [rad].
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ [m] or [rad].
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: scal_mean(size(x),size(y))  ! ǥȷϤǤʿ.
  real, optional :: undef  ! ͤĤʤȤ̤.
                           ! ǥեȤǤ dcl ̤
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: j, k, nx, ny, nr, nt, itmpr
  real :: tmp(size(r))
  real :: tmpr, tmp_anom, undeff
  character(2) :: ax
  character(3) :: undefgcflag
  logical :: stderr

  if(present(undef))then
     undeff=undef
  else
     undeff=999.0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, scal ),  &
  &                                     "tangent_mean_scal_Cart" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, scal_mean ),  &
  &                                     "tangent_mean_scal_Cart" )
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:3)
     else
        undefgcflag="inc"
     end if
  end if

  if(present(axis))then
     ax(1:2)=axis(1:2)
  else
     ax='xy'
  end if

  if(present(undefg))then
     call tangent_mean_scal_f( x, y, xc, yc, scal, r, theta, tmp,  &
  &                    undef=undeff, undefg=undefg, undefgc=undefgcflag(1:3),  &
  &                    stdopt=stderr, axis=ax )
  else
     call tangent_mean_scal_f( x, y, xc, yc, scal, r, theta, tmp, undef=undeff,  &
  &                            stdopt=stderr, axis=ax )
  end if

!-- ʿͤޤ, ǥȷϤǤʿͤ.
  if(present(undefg))then
     if(undefgcflag(1:3)=='err')then
        do k=1,ny
           do j=1,nx
              if(ax(1:2)=='xy')then  ! Cart.
                 tmpr=sqrt((x(j)-xc)**2+(y(k)-yc)**2)
              else  ! lon-lat
                 tmpr=real(ll2radi( dble(xc), dble(yc), dble(x(j)), dble(y(k))))
              end if
              call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
              if(nr>itmpr)then
                 if(tmp(itmpr)/=undefg.and.tmp(itmpr+1)/=undefg)then
                    call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                       (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
                    scal_mean(j,k)=tmp_anom
                 else
                    scal_mean(j,k)=undefg
                 end if
              else
                 scal_mean(j,k)=undeff
              end if
           end do
        end do
     else
        do k=1,ny
           do j=1,nx
              if(ax(1:2)=='xy')then  ! Cart.
                 tmpr=sqrt((x(j)-xc)**2+(y(k)-yc)**2)
              else  ! lon-lat
                 tmpr=real(ll2radi( dble(xc), dble(yc), dble(x(j)), dble(y(k))))
              end if
              call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
              if(nr>itmpr)then
                 if(tmp(itmpr)/=undefg.and.tmp(itmpr+1)/=undefg.and.  &
  &                 scal(j,k)/=undefg)then
                    call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                       (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
                    scal_mean(j,k)=tmp_anom
                 else
                    scal_mean(j,k)=undefg
                 end if
              else
                 scal_mean(j,k)=undeff
              end if
           end do
        end do
     end if
  else
     do k=1,ny
        do j=1,nx
           if(ax(1:2)=='xy')then  ! Cart.
              tmpr=sqrt((x(j)-xc)**2+(y(k)-yc)**2)
           else  ! lon-lat
              tmpr=real(ll2radi( dble(xc), dble(yc), dble(x(j)), dble(y(k)) ))
           end if
           call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
           if(nr>itmpr)then
              call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                               (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
              scal_mean(j,k)=tmp_anom
           else
              scal_mean(j,k)=undeff
           end if
        end do
     end do
  end if

end subroutine tangent_mean_scal_Cart_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_scal_Cart_d( x, y, xc, yc, scal, r, theta,  &
  &                                  scal_mean, undef, undefg, undefgc,  &
  &                                  stdopt, axis )
  ! 濴ʿѤ׻, ǥȺɸϤ᤹.
  ! ʿѥ롼Ѥʪ̤ʿѤ,  1 ǡݤƤ.
  ! Ʊ, ǥȷϤǤʪ̤αɸϤǤ radial ֤.
  !  radial ΰ֤ˤʿͤ 1 ǡޤǵ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  implicit none
  double precision, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ [m] or lon [rad]
  double precision, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ [m] or lat [rad]
  double precision, intent(in) :: scal(size(x),size(y))  ! ǥȺɸϤǤʿѲ.
  double precision, intent(in) :: xc  ! ʿѤݤ濴 x ʬ [m] or [rad].
  double precision, intent(in) :: yc  ! ʿѤݤ濴 y ʬ [m] or [rad].
  double precision, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  double precision, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  double precision, intent(inout) :: scal_mean(size(x),size(y))  ! ǥȷϤǤʿ.
  double precision, optional :: undef  ! ͤĤʤȤ̤.
                           ! ǥեȤǤ dcl ̤
  double precision, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: j, k, nx, ny, nr, nt, itmpr
  double precision :: tmp(size(r))
  double precision :: tmpr, tmp_anom, undeff
  character(2) :: ax
  character(3) :: undefgcflag
  logical :: stderr

  if(present(undef))then
     undeff=undef
  else
     undeff=999.0d0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, scal ),  &
  &                                     "tangent_mean_scal_Cart" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, scal_mean ),  &
  &                                     "tangent_mean_scal_Cart" )
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:3)
     else
        undefgcflag="inc"
     end if
  end if

  if(present(axis))then
     ax(1:2)=axis(1:2)
  else
     ax='xy'
  end if

  if(present(undefg))then
     call tangent_mean_scal_d( x, y, xc, yc, scal, r, theta, tmp,  &
  &                    undef=undeff, undefg=undefg, undefgc=undefgcflag(1:3),  &
  &                    stdopt=stderr, axis=ax )
  else
     call tangent_mean_scal_d( x, y, xc, yc, scal, r, theta, tmp, undef=undeff,  &
  &                            stdopt=stderr, axis=ax )
  end if

!-- ʿͤޤ, ǥȷϤǤʿͤ.
  if(present(undefg))then
     if(undefgcflag(1:3)=='err')then
        do k=1,ny
           do j=1,nx
              if(ax(1:2)=='xy')then  ! Cart.
                 tmpr=dsqrt((x(j)-xc)**2+(y(k)-yc)**2)
              else  ! lon-lat
                 tmpr=ll2radi( xc, yc, x(j), y(k) )
              end if
              call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
              if(nr>itmpr)then
                 if(tmp(itmpr)/=undefg.and.tmp(itmpr+1)/=undefg)then
                    call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                       (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
                    scal_mean(j,k)=tmp_anom
                 else
                    scal_mean(j,k)=undefg
                 end if
              else
                 scal_mean(j,k)=undeff
              end if
           end do
        end do
     else
        do k=1,ny
           do j=1,nx
              if(ax(1:2)=='xy')then  ! Cart.
                 tmpr=dsqrt((x(j)-xc)**2+(y(k)-yc)**2)
              else  ! lon-lat
                 tmpr=ll2radi( xc, yc, x(j), y(k) )
              end if
              call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
              if(nr>itmpr)then
                 if(tmp(itmpr)/=undefg.and.tmp(itmpr+1)/=undefg.and.  &
  &                 scal(j,k)/=undefg)then
                    call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                       (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
                    scal_mean(j,k)=tmp_anom
                 else
                    scal_mean(j,k)=undefg
                 end if
              else
                 scal_mean(j,k)=undeff
              end if
           end do
        end do
     end if
  else
     do k=1,ny
        do j=1,nx
           if(ax(1:2)=='xy')then  ! Cart.
              tmpr=dsqrt((x(j)-xc)**2+(y(k)-yc)**2)
           else  ! lon-lat
              tmpr=ll2radi( xc, yc, x(j), y(k) )
           end if
           call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
           if(nr>itmpr)then
              call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                               (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
              scal_mean(j,k)=tmp_anom
           else
              scal_mean(j,k)=undeff
           end if
        end do
     end do
  end if

end subroutine tangent_mean_scal_Cart_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_anom_scal_Cart_f( x, y, xc, yc, scal, r, theta,  &
  &                                       scal_anom, undef, undefg, undefgc,  &
  &                                       stdopt, axis )
  ! 濴Υޥ׻, ǥȺɸϤ᤹.
  ! ʿѥ롼Ѥʪ̤ʿѤ,  1 ǡݤƤ.
  ! Ʊ, ǥȷϤǤʪ̤αɸϤǤ radial ֤.
  !  radial ΰ֤ˤʿͤ 1 ǡޤǵ.
  ! ε᤿ͤ򸵤ΥǥȥǡȤǥΥޥȤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  implicit none
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ [m] or lon [rad]
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ [m] or lat [rad]
  real, intent(in) :: scal(size(x),size(y))  ! ǥȺɸϤǤʿѲ.
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ [m] or [rad].
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ [m] or [rad].
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: scal_anom(size(x),size(y))  ! ǥȷϤǤΥΥޥ.
  real, optional :: undef  ! ͤĤʤȤ̤.
                           ! ǥեȤǤ dcl ̤
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: j, k, nx, ny, nr, nt, itmpr
  real :: tmp(size(r))
  real :: tmpr, tmp_anom, undeff
  character(2) :: ax
  character(3) :: undefgcflag
  logical :: stderr

  if(present(undef))then
     undeff=undef
  else
     undeff=999.0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, scal ),  &
  &                                     "tangent_mean_scal_anom_Cart" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, scal_anom ),  &
  &                                     "tangent_mean_scal_anom_Cart" )
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:3)
     else
        undefgcflag="inc"
     end if
  end if

  if(present(axis))then
     ax(1:2)=axis(1:2)
  else
     ax='xy'
  end if

  if(present(undefg))then
     call tangent_mean_scal_f( x, y, xc, yc, scal, r, theta, tmp,  &
  &                    undef=undeff, undefg=undefg, undefgc=undefgcflag(1:3),  &
  &                    stdopt=stderr, axis=ax )
  else
     call tangent_mean_scal_f( x, y, xc, yc, scal, r, theta, tmp, undef=undeff,  &
  &                            stdopt=stderr, axis=ax )
  end if

!-- ʿͤޤ, ͤƥΥޥ.
  if(present(undefg))then
     if(undefgcflag(1:3)=='err')then
        do k=1,ny
           do j=1,nx
              if(ax(1:2)=='xy')then  ! Cart.
                 tmpr=sqrt((x(j)-xc)**2+(y(k)-yc)**2)
              else  ! lon-lat
                 tmpr=ll2radi( dble(xc), dble(yc), dble(x(j)), dble(y(k)) )
              end if
              call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
              if(nr>itmpr)then
                 if(tmp(itmpr)/=undefg.and.tmp(itmpr+1)/=undefg)then
                    call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                       (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
                    scal_anom(j,k)=scal(j,k)-tmp_anom
                 else
                    scal_anom(j,k)=undefg
                 end if
              else
                 scal_anom(j,k)=undeff
              end if
           end do
        end do
     else
        do k=1,ny
           do j=1,nx
              if(ax(1:2)=='xy')then  ! Cart.
                 tmpr=sqrt((x(j)-xc)**2+(y(k)-yc)**2)
              else  ! lon-lat
                 tmpr=ll2radi( dble(xc), dble(yc), dble(x(j)), dble(y(k)) )
              end if
              call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
              if(nr>itmpr)then
                 if(tmp(itmpr)/=undefg.and.tmp(itmpr+1)/=undefg.and.  &
  &                 scal(j,k)/=undefg)then
                    call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                       (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
                    scal_anom(j,k)=scal(j,k)-tmp_anom
                 else
                    scal_anom(j,k)=undefg
                 end if
              else
                 scal_anom(j,k)=undeff
              end if
           end do
        end do
     end if
  else
     do k=1,ny
        do j=1,nx
           if(ax(1:2)=='xy')then  ! Cart.
              tmpr=sqrt((x(j)-xc)**2+(y(k)-yc)**2)
           else  ! lon-lat
              tmpr=ll2radi( dble(xc), dble(yc), dble(x(j)), dble(y(k)) )
           end if
           call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
           if(nr>itmpr)then
              call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                               (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
              scal_anom(j,k)=scal(j,k)-tmp_anom
           else
              scal_anom(j,k)=undeff
           end if
        end do
     end do
  end if

end subroutine tangent_mean_anom_scal_Cart_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_anom_scal_Cart_d( x, y, xc, yc, scal, r, theta,  &
  &                                       scal_anom, undef, undefg, undefgc,  &
  &                                       stdopt, axis )
  ! 濴Υޥ׻, ǥȺɸϤ᤹.
  ! ʿѥ롼Ѥʪ̤ʿѤ,  1 ǡݤƤ.
  ! Ʊ, ǥȷϤǤʪ̤αɸϤǤ radial ֤.
  !  radial ΰ֤ˤʿͤ 1 ǡޤǵ.
  ! ε᤿ͤ򸵤ΥǥȥǡȤǥΥޥȤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  implicit none
  double precision, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ [m] or lon [rad]
  double precision, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ [m] or lat [rad]
  double precision, intent(in) :: scal(size(x),size(y))  ! ǥȺɸϤǤʿѲ.
  double precision, intent(in) :: xc  ! ʿѤݤ濴 x ʬ [m] or [rad].
  double precision, intent(in) :: yc  ! ʿѤݤ濴 y ʬ [m] or [rad].
  double precision, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  double precision, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  double precision, intent(inout) :: scal_anom(size(x),size(y))  ! ǥȷϤǤΥΥޥ.
  double precision, optional :: undef  ! ͤĤʤȤ̤.
                           ! ǥեȤǤ dcl ̤
  double precision, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: j, k, nx, ny, nr, nt, itmpr
  double precision :: tmp(size(r))
  double precision :: tmpr, tmp_anom, undeff
  character(2) :: ax
  character(3) :: undefgcflag
  logical :: stderr

  if(present(undef))then
     undeff=undef
  else
     undeff=999.0d0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, scal ),  &
  &                                     "tangent_mean_scal_anom_Cart" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, scal_anom ),  &
  &                                     "tangent_mean_scal_anom_Cart" )
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:3)
     else
        undefgcflag="inc"
     end if
  end if

  if(present(axis))then
     ax(1:2)=axis(1:2)
  else
     ax='xy'
  end if

  if(present(undefg))then
     call tangent_mean_scal_d( x, y, xc, yc, scal, r, theta, tmp,  &
  &                    undef=undeff, undefg=undefg, undefgc=undefgcflag(1:3),  &
  &                    stdopt=stderr, axis=ax )
  else
     call tangent_mean_scal_d( x, y, xc, yc, scal, r, theta, tmp, undef=undeff,  &
  &                            stdopt=stderr, axis=ax )
  end if

!-- ʿͤޤ, ͤƥΥޥ.
  if(present(undefg))then
     if(undefgcflag(1:3)=='err')then
        do k=1,ny
           do j=1,nx
              if(ax(1:2)=='xy')then  ! Cart.
                 tmpr=dsqrt((x(j)-xc)**2+(y(k)-yc)**2)
              else  ! lon-lat
                 tmpr=ll2radi( xc, yc, x(j), y(k) )
              end if
              call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
              if(nr>itmpr)then
                 if(tmp(itmpr)/=undefg.and.tmp(itmpr+1)/=undefg)then
                    call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                       (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
                    scal_anom(j,k)=scal(j,k)-tmp_anom
                 else
                    scal_anom(j,k)=undefg
                 end if
              else
                 scal_anom(j,k)=undeff
              end if
           end do
        end do
     else
        do k=1,ny
           do j=1,nx
              if(ax(1:2)=='xy')then  ! Cart.
                 tmpr=dsqrt((x(j)-xc)**2+(y(k)-yc)**2)
              else  ! lon-lat
                 tmpr=ll2radi( xc, yc, x(j), y(k) )
              end if
              call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
              if(nr>itmpr)then
                 if(tmp(itmpr)/=undefg.and.tmp(itmpr+1)/=undefg.and.  &
  &                 scal(j,k)/=undefg)then
                    call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                       (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
                    scal_anom(j,k)=scal(j,k)-tmp_anom
                 else
                    scal_anom(j,k)=undefg
                 end if
              else
                 scal_anom(j,k)=undeff
              end if
           end do
        end do
     end if
  else
     do k=1,ny
        do j=1,nx
           if(ax(1:2)=='xy')then  ! Cart.
              tmpr=dsqrt((x(j)-xc)**2+(y(k)-yc)**2)
           else  ! lon-lat
              tmpr=ll2radi( xc, yc, x(j), y(k) )
           end if
           call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
           if(nr>itmpr)then
              call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                               (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
              scal_anom(j,k)=scal(j,k)-tmp_anom
           else
              scal_anom(j,k)=undeff
           end if
        end do
     end do
  end if

end subroutine tangent_mean_anom_scal_Cart_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine Cart_conv_scal_f( r, theta, v, x, y, xc, yc, u, undef,  &
  &                          undefg, undefgc, stdopt, axis )
  ! Ǥդʪ̤濴Ȥʿ̶˺ɸǥȺɸѴ롼
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nx, ny Τ٤ƤˤĤƤб r, t ɸͤ xy_2_rt Ƿ׻.
  ! (2) ޤ r,t åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! ܥ롼ʿ̶˺ɸåͤǤк׻Ԥ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  use Math_Const
  implicit none
  real, intent(in) :: r(:)  ! (xc, yc) 濴Ȥ˺ɸưºɸ [m].
  real, intent(in) :: theta(:)  ! (xc, yc) 濴Ȥ˺ɸƱ̳Ѻɸ [rad].
  real, intent(in) :: v(size(r),size(theta))  ! ʿ̶˺ɸ줿ѿ.
  real, intent(in) :: x(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: y(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ. [m or rad]
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ. [m or rad]
  real, intent(inout) :: u(size(x),size(y))  ! ǥȺɸѿ.
  real, intent(in), optional :: undef  ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: i, j, nx, ny, nr, nt, i_undef
  real :: r_undef, r_undefg
  real :: work(size(x),size(y))
  real :: point(size(x),size(y),2)
  integer :: ip(size(x),size(y),2)
  real :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)
  double precision :: tmppoint1, tmppoint2
  character(1) :: undefgcflag
  character(2) :: ax_flag
  logical, dimension(size(r)) :: undefgc_check
  logical :: ucf, stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "tangent_conv_scal" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nt, v ),  &
  &                                     "tangent_conv_scal" )
  end if

  undefgc_check(:)=.true.
  i_undef=0

  if(present(undef))then
    r_undef=undef
  else
    r_undef=-999.0
  end if

  if(present(undefg))then
    r_undefg=undefg
  else
    r_undefg=-999.0
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:1)
     else
        undefgcflag="i"
     end if
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(axis))then
     ax_flag=axis(1:2)
  else
     ax_flag='xy'
  end if

!-- ΰ򥯥ꥢƤ뤫ǧ ---
!-- ϹԤʤ.

!  call search_region_1d( (/x(1),x(nx)/), (/y(1),y(ny)/), (/xc,yc/), r, nr,  &
!  &                      stdopt=stderr, axis=ax_flag(1:2) )

!--  v  undef ͤƤ.
!  do j=1,nt
!     do i=1,nrr
!        v(i,j)=r_undef
!     end do
!  end do

!-- (1) ---
  if(ax_flag(1:2)=='xy')then
     do j=1,ny
        do i=1,nx
           call xy_2_rt( x(i), y(j), xc, yc, point(i,j,1), point(i,j,2) )
           if(point(i,j,2)<0.0)then
              point(i,j,2)=point(i,j,2)+2.0*pi
           end if
        end do
     end do
  else if(ax_flag(1:2)=='ll')then
     do j=1,ny
        do i=1,nx
           call ll2rt( dble(xc), dble(yc), dble(x(i)), dble(y(j)),  &
  &                    tmppoint1, tmppoint2 )
           point(i,j,1)=real(tmppoint1)
           point(i,j,2)=real(tmppoint2)
           if(point(i,j,2)<0.0)then
              point(i,j,2)=point(i,j,2)+2.0*pi
           end if
        end do
     end do
  end if

!-- (2) ---
  do j=1,ny
     do i=1,nx
        call interpo_search_2d( r, theta, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2), undeff=i_undef,  &
  &                             stdopt=stderr )
     end do
  end do

!-- (3) ---
  do j=1,ny
     do i=1,nx
        if(ip(i,j,1)/=i_undef.and.ip(i,j,2)/=i_undef.and.  &
  &        ip(i,j,1)/=nr.and.ip(i,j,2)/=nt)then
           tmpx(1)=r(ip(i,j,1))
           tmpx(2)=r(ip(i,j,1)+1)
           tmpy(1)=theta(ip(i,j,2))
           tmpy(2)=theta(ip(i,j,2)+1)
           tmpz(1,1)=v(ip(i,j,1),ip(i,j,2))
           tmpz(2,1)=v(ip(i,j,1)+1,ip(i,j,2))
           tmpz(1,2)=v(ip(i,j,1),ip(i,j,2)+1)
           tmpz(2,2)=v(ip(i,j,1)+1,ip(i,j,2)+1)
           inter(1)=point(i,j,1)
           inter(2)=point(i,j,2)

           if(present(undefg))then
              ucf=undef_checker_2df( tmpz, undefg )
              if(ucf.eqv..false.)then
                 call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
              else
                 work(i,j)=r_undefg
                 undefgc_check(i)=.false.
              end if
           else
              call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
           end if
        else
           work(i,j)=r_undef
        end if
     end do
  end do

  do j=1,ny
     do i=1,nx
        u(i,j)=work(i,j)
     end do
  end do

end subroutine Cart_conv_scal_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine Cart_conv_scal_d( r, theta, v, x, y, xc, yc, u, undef,  &
  &                          undefg, undefgc, stdopt, axis )
  ! Ǥդʪ̤濴Ȥʿ̶˺ɸǥȺɸѴ롼
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nx, ny Τ٤ƤˤĤƤб r, t ɸͤ xy_2_rt Ƿ׻.
  ! (2) ޤ r,t åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! ܥ롼ʿ̶˺ɸåͤǤк׻Ԥ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  use Math_Const
  implicit none
  double precision, intent(in) :: r(:)  ! (xc, yc) 濴Ȥ˺ɸưºɸ [m].
  double precision, intent(in) :: theta(:)  ! (xc, yc) 濴Ȥ˺ɸƱ̳Ѻɸ [rad].
  double precision, intent(in) :: v(size(r),size(theta))  ! ʿ̶˺ɸ줿ѿ.
  double precision, intent(in) :: x(:)  ! ɸϤǤʬ [m or rad]
  double precision, intent(in) :: y(:)  ! ɸϤǤʬ [m or rad]
  double precision, intent(in) :: xc  ! ʿѤݤ濴 x ʬ. [m or rad]
  double precision, intent(in) :: yc  ! ʿѤݤ濴 y ʬ. [m or rad]
  double precision, intent(inout) :: u(size(x),size(y))  ! ǥȺɸѿ.
  double precision, intent(in), optional :: undef  ! ΰ賰
  double precision, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: i, j, nx, ny, nr, nt, i_undef
  double precision :: r_undef, r_undefg
  double precision :: work(size(x),size(y))
  double precision :: point(size(x),size(y),2)
  integer :: ip(size(x),size(y),2)
  double precision :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)
  double precision :: tmppoint1, tmppoint2
  character(1) :: undefgcflag
  character(2) :: ax_flag
  logical, dimension(size(r)) :: undefgc_check
  logical :: ucf, stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "tangent_conv_scal" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nt, v ),  &
  &                                     "tangent_conv_scal" )
  end if

  undefgc_check(:)=.true.
  i_undef=0

  if(present(undef))then
    r_undef=undef
  else
    r_undef=-999.0d0
  end if

  if(present(undefg))then
    r_undefg=undefg
  else
    r_undefg=-999.0d0
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:1)
     else
        undefgcflag="i"
     end if
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(axis))then
     ax_flag=axis(1:2)
  else
     ax_flag='xy'
  end if

!-- ΰ򥯥ꥢƤ뤫ǧ ---
!-- ϹԤʤ.

!  call search_region_1d( (/x(1),x(nx)/), (/y(1),y(ny)/), (/xc,yc/), r, nr,  &
!  &                      stdopt=stderr, axis=ax_flag(1:2) )

!--  v  undef ͤƤ.
!  do j=1,nt
!     do i=1,nrr
!        v(i,j)=r_undef
!     end do
!  end do

!-- (1) ---
  if(ax_flag(1:2)=='xy')then
     do j=1,ny
        do i=1,nx
           call xy_2_rt( x(i), y(j), xc, yc, point(i,j,1), point(i,j,2) )
           if(point(i,j,2)<0.0d0)then
              point(i,j,2)=point(i,j,2)+2.0d0*pi_dp
           end if
        end do
     end do
  else if(ax_flag(1:2)=='ll')then
     do j=1,ny
        do i=1,nx
           call ll2rt( xc, yc, x(i), y(j),  &
  &                    tmppoint1, tmppoint2 )
           point(i,j,1)=tmppoint1
           point(i,j,2)=tmppoint2
           if(point(i,j,2)<0.0d0)then
              point(i,j,2)=point(i,j,2)+2.0d0*pi_dp
           end if
        end do
     end do
  end if

!-- (2) ---
  do j=1,ny
     do i=1,nx
        call interpo_search_2d( r, theta, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2), undeff=i_undef,  &
  &                             stdopt=stderr )
     end do
  end do

!-- (3) ---
  do j=1,ny
     do i=1,nx
        if(ip(i,j,1)/=i_undef.and.ip(i,j,2)/=i_undef.and.  &
  &        ip(i,j,1)/=nr.and.ip(i,j,2)/=nt)then
           tmpx(1)=r(ip(i,j,1))
           tmpx(2)=r(ip(i,j,1)+1)
           tmpy(1)=theta(ip(i,j,2))
           tmpy(2)=theta(ip(i,j,2)+1)
           tmpz(1,1)=v(ip(i,j,1),ip(i,j,2))
           tmpz(2,1)=v(ip(i,j,1)+1,ip(i,j,2))
           tmpz(1,2)=v(ip(i,j,1),ip(i,j,2)+1)
           tmpz(2,2)=v(ip(i,j,1)+1,ip(i,j,2)+1)
           inter(1)=point(i,j,1)
           inter(2)=point(i,j,2)

           if(present(undefg))then
              ucf=undef_checker_2dd( tmpz, undefg )
              if(ucf.eqv..false.)then
                 call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
              else
                 work(i,j)=r_undefg
                 undefgc_check(i)=.false.
              end if
           else
              call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
           end if
        else
           work(i,j)=r_undef
        end if
     end do
  end do

  do j=1,ny
     do i=1,nx
        u(i,j)=work(i,j)
     end do
  end do

end subroutine Cart_conv_scal_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine Cart_mean_scal_f( r, v, x, y, xc, yc, u, undef,  &
  &                          undefg, undefgc, stdopt, axis )
  ! Ǥդʪ̤濴Ȥʿ̶˺ɸưʬۤǥȺɸ
  ! Ѵ롼.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nx, ny Τ٤ƤˤĤƤб r ɸͤ׻.
  ! (2) ޤ r åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 2 Ф, ǤΥ顼ͤ 2 Υ顼
  !     ,  interpolation_1d Ƿ׻.
  ! ܥ롼ʿ̶˺ɸåͤǤк׻Ԥ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  use Math_Const
  implicit none
  real, intent(in) :: r(:)  ! (xc, yc) 濴Ȥ˺ɸưºɸ [m].
  real, intent(in) :: v(size(r))  ! ʿѲǤդʪ.
  real, intent(in) :: x(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: y(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ. [m or rad]
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ. [m or rad]
  real, intent(inout) :: u(size(x),size(y))  ! ɸϤǤʿѲ
  real, intent(in), optional :: undef  ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: i, j, nx, ny, nr, i_undef
  real :: r_undef, r_undefg
  real :: work(size(x),size(y))
  real :: point(size(x),size(y))
  integer :: ip(size(x),size(y))
  character(1) :: undefgcflag
  character(2) :: ax_flag
  logical, dimension(size(r)) :: undefgc_check
  logical :: ucf, stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "tangent_conv_scal" )
     call check_array_size_dmp_message( check_array_size_1d( nr, v ),  &
  &                                     "tangent_conv_scal" )
  end if

  undefgc_check(:)=.true.
  i_undef=0

  if(present(undef))then
    r_undef=undef
  else
    r_undef=-999.0
  end if

  if(present(undefg))then
    r_undefg=undefg
  else
    r_undefg=-999.0
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:1)
     else
        undefgcflag="i"
     end if
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(axis))then
     ax_flag=axis(1:2)
  else
     ax_flag='xy'
  end if

!-- ΰ򥯥ꥢƤ뤫ǧ ---
!-- ϹԤʤ.

!  call search_region_1d( (/x(1),x(nx)/), (/y(1),y(ny)/), (/xc,yc/), r, nr,  &
!  &                      stdopt=stderr, axis=ax_flag(1:2) )

!--  v  undef ͤƤ.
!  do j=1,nt
!     do i=1,nrr
!        v(i,j)=r_undef
!     end do
!  end do

!-- (1) ---
  if(ax_flag(1:2)=='xy')then
     do j=1,ny
        do i=1,nx
           point(i,j)=sqrt((x(i)-xc)**2+(y(j)-yc)**2)
        end do
     end do
  else if(ax_flag(1:2)=='ll')then
     do j=1,ny
        do i=1,nx
           point(i,j)=ll2radi( dble(xc), dble(yc), dble(x(i)), dble(y(j)) )
        end do
     end do
  end if

!-- (2) ---
  do j=1,ny
     do i=1,nx
        call interpo_search_1d( r, point(i,j), ip(i,j), undeff=i_undef,  &
  &                             stdopt=stderr )
     end do
  end do

!-- (3) ---
  do j=1,ny
     do i=1,nx
        if(ip(i,j)/=i_undef.and.ip(i,j)/=nr)then
           if(present(undefg))then
              ucf=undef_checker_1df( v(ip(i,j):ip(i,j)+1), undefg )
              if(ucf.eqv..false.)then
                 call interpolation_1d( r(ip(i,j):ip(i,j)+1),  &
  &                                     v(ip(i,j):ip(i,j)+1),  &
  &                                     point(i,j), work(i,j) )
              else
                 work(i,j)=r_undefg
                 undefgc_check(i)=.false.
              end if
           else
              call interpolation_1df( r(ip(i,j):ip(i,j)+1),  &
  &                                  v(ip(i,j):ip(i,j)+1),  &
  &                                  point(i,j), work(i,j) )
           end if
        else
           work(i,j)=r_undef
        end if
     end do
  end do

  do j=1,ny
     do i=1,nx
        u(i,j)=work(i,j)
     end do
  end do

end subroutine Cart_mean_scal_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine Cart_mean_scal_d( r, v, x, y, xc, yc, u, undef,  &
  &                          undefg, undefgc, stdopt, axis )
  ! Ǥդʪ̤濴Ȥʿ̶˺ɸưʬۤǥȺɸ
  ! Ѵ롼.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nx, ny Τ٤ƤˤĤƤб r ɸͤ׻.
  ! (2) ޤ r åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 2 Ф, ǤΥ顼ͤ 2 Υ顼
  !     ,  interpolation_1d Ƿ׻.
  ! ܥ롼ʿ̶˺ɸåͤǤк׻Ԥ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  use Math_Const
  implicit none
  double precision, intent(in) :: r(:)  ! (xc, yc) 濴Ȥ˺ɸưºɸ [m].
  double precision, intent(in) :: v(size(r))  ! ʿѲǤդʪ.
  double precision, intent(in) :: x(:)  ! ɸϤǤʬ [m or rad]
  double precision, intent(in) :: y(:)  ! ɸϤǤʬ [m or rad]
  double precision, intent(in) :: xc  ! ʿѤݤ濴 x ʬ. [m or rad]
  double precision, intent(in) :: yc  ! ʿѤݤ濴 y ʬ. [m or rad]
  double precision, intent(inout) :: u(size(x),size(y))  ! ɸϤǤʿѲ
  double precision, intent(in), optional :: undef  ! ΰ賰
  double precision, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: i, j, nx, ny, nr, i_undef
  double precision :: r_undef, r_undefg
  double precision :: work(size(x),size(y))
  double precision :: point(size(x),size(y))
  integer :: ip(size(x),size(y))
  character(1) :: undefgcflag
  character(2) :: ax_flag
  logical, dimension(size(r)) :: undefgc_check
  logical :: ucf, stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "tangent_conv_scal" )
     call check_array_size_dmp_message( check_array_size_1d( nr, v ),  &
  &                                     "tangent_conv_scal" )
  end if

  undefgc_check(:)=.true.
  i_undef=0

  if(present(undef))then
    r_undef=undef
  else
    r_undef=-999.0d0
  end if

  if(present(undefg))then
    r_undefg=undefg
  else
    r_undefg=-999.0d0
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:1)
     else
        undefgcflag="i"
     end if
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(axis))then
     ax_flag=axis(1:2)
  else
     ax_flag='xy'
  end if

!-- ΰ򥯥ꥢƤ뤫ǧ ---
!-- ϹԤʤ.

!  call search_region_1d( (/x(1),x(nx)/), (/y(1),y(ny)/), (/xc,yc/), r, nr,  &
!  &                      stdopt=stderr, axis=ax_flag(1:2) )

!--  v  undef ͤƤ.
!  do j=1,nt
!     do i=1,nrr
!        v(i,j)=r_undef
!     end do
!  end do

!-- (1) ---
  if(ax_flag(1:2)=='xy')then
     do j=1,ny
        do i=1,nx
           point(i,j)=dsqrt((x(i)-xc)**2+(y(j)-yc)**2)
        end do
     end do
  else if(ax_flag(1:2)=='ll')then
     do j=1,ny
        do i=1,nx
           point(i,j)=ll2radi( xc, yc, x(i), y(j) )
        end do
     end do
  end if

!-- (2) ---
  do j=1,ny
     do i=1,nx
        call interpo_search_1d( r, point(i,j), ip(i,j), undeff=i_undef,  &
  &                             stdopt=stderr )
     end do
  end do

!-- (3) ---
  do j=1,ny
     do i=1,nx
        if(ip(i,j)/=i_undef.and.ip(i,j)/=nr)then
           if(present(undefg))then
              ucf=undef_checker_1dd( v(ip(i,j):ip(i,j)+1), undefg )
              if(ucf.eqv..false.)then
                 call interpolation_1d( r(ip(i,j):ip(i,j)+1),  &
  &                                     v(ip(i,j):ip(i,j)+1),  &
  &                                     point(i,j), work(i,j) )
              else
                 work(i,j)=r_undefg
                 undefgc_check(i)=.false.
              end if
           else
              call interpolation_1dd( r(ip(i,j):ip(i,j)+1),  &
  &                                  v(ip(i,j):ip(i,j)+1),  &
  &                                  point(i,j), work(i,j) )
           end if
        else
           work(i,j)=r_undef
        end if
     end do
  end do

  do j=1,ny
     do i=1,nx
        u(i,j)=work(i,j)
     end do
  end do

end subroutine Cart_mean_scal_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_vec_f( charc, x, y, xc, yc, u1, u2, r, theta, v,  &
  &                            undef, undefg, undefgc, stdopt )
  ! Ǥդʪ̤濴ʿѤ롼
  ! ®ʿ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r.
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  !     Ʊ롼, 2 ĤΥ٥ȥʬʿͤΤ,
  !     Ѥ vec_prod_2d ˤä濴ΰ֥٥ȥȤγѤ׻
  !     . Ʊ롼濴εΥǳä v ʬΤ.
  ! (4) nr x nt Ĥʬͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  ! ʤ, ܥ롼ϲΤ, β tangent_mean_scal 롼
  ! ꤲƤ. ܥ롼ǹԤΤ, charc ˹碌,
  ! ƥǥȺɸˤ濴Ф, ư׻ΤߤǤ.
  implicit none
  character(6), intent(in) :: charc  ! ưʬʬȽ, vector = , scalar = ưʬ.
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: u1(size(x),size(y))  ! ǥȺɸϤǤʿѲ 1
  real, intent(in) :: u2(size(x),size(y))  ! ǥȺɸϤǤʿѲ 2
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: v(size(r))  ! ʿѲ u .
  real, intent(in), optional :: undef  ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  integer :: i, j, nx, ny, nr, z_count
  real, dimension(size(x),size(y)) :: posx, posy, abpos, vecz
  logical :: stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u1 ),  &
  &                                     "tangent_mean_vec" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u2 ),  &
  &                                     "tangent_mean_vec" )
     call check_array_size_dmp_message( check_array_size_1d( nr, v ),  &
  &                                     "tangent_mean_vec" )
  end if

  z_count=0

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

!-- ޤ, charc ˹碌, ʿ٥ȥư¡Ѵ.
!-- Ѵ, ͤϥ顼ͤȤɾΤ,
!-- tangent_mean_scal ꤲ.

!-- 濴ФƥǥȺɸοʿ֥٥ȥ׻.

  do j=1,ny
     do i=1,nx
        posx(i,j)=x(i)-xc
        posy(i,j)=y(j)-yc
     end do
  end do

  select case (trim(charc))
  case ('vector')
     if(present(undefg))then
        call vec_prod_2d( posx, posy, u1, u2, vecz, undeff=undefg )
     else
        call vec_prod_2d( posx, posy, u1, u2, vecz )
     end if
  case ('scalar')
     if(present(undefg))then
        call dot_prod_2d( posx, posy, u1, u2, vecz, undeff=undefg )
     else
        call dot_prod_2d( posx, posy, u1, u2, vecz )
     end if
  case default
     write(*,*) "error : bad character. select 'vector', or 'scalar'."
     stop
  end select

  call abst_2d( posx, posy, abpos )

  if(present(undefg))then
     do j=1,ny
        do i=1,nx   
           if(vecz(i,j)/=undefg.and.abpos(i,j)/=0.0)then
              vecz(i,j)=vecz(i,j)/abpos(i,j)
           else if(abpos(i,j)==0.0)then
              z_count=z_count+1
              vecz(i,j)=0.0
           end if
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           if(abpos(i,j)/=0.0)then
              vecz(i,j)=vecz(i,j)/abpos(i,j)
           else
              z_count=z_count+1
              vecz(i,j)=0.0
           end if
        end do
     end do
  end if

  if(present(undef))then
     if(present(undefg))then
        call tangent_mean_scal_f( x, y, xc, yc, vecz, r, theta, v,  &
  &                               undef=undef, undefg=undefg,  &
  &                               undefgc=trim(undefgc), stdopt=stderr )
     else
        call tangent_mean_scal_f( x, y, xc, yc, vecz, r, theta, v,  &
  &                               undef=undef, stdopt=stderr )
     end if
  else if(present(undefg))then
     call tangent_mean_scal_f( x, y, xc, yc, vecz, r, theta, v,  &
  &                            undefg=undefg, undefgc=trim(undefgc),  &
  &                            stdopt=stderr )
  else
     call tangent_mean_scal_f( x, y, xc, yc, vecz, r, theta, v, stdopt=stderr )
  end if

end subroutine tangent_mean_vec_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_vec_d( charc, x, y, xc, yc, u1, u2, r, theta, v,  &
  &                            undef, undefg, undefgc, stdopt )
  ! Ǥդʪ̤濴ʿѤ롼
  ! ®ʿ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r.
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  !     Ʊ롼, 2 ĤΥ٥ȥʬʿͤΤ,
  !     Ѥ vec_prod_2d ˤä濴ΰ֥٥ȥȤγѤ׻
  !     . Ʊ롼濴εΥǳä v ʬΤ.
  ! (4) nr x nt Ĥʬͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  ! ʤ, ܥ롼ϲΤ, β tangent_mean_scal 롼
  ! ꤲƤ. ܥ롼ǹԤΤ, charc ˹碌,
  ! ƥǥȺɸˤ濴Ф, ư׻ΤߤǤ.
  implicit none
  character(6), intent(in) :: charc  ! ưʬʬȽ, vector = , scalar = ưʬ.
  double precision, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  double precision, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  double precision, intent(in) :: u1(size(x),size(y))  ! ǥȺɸϤǤʿѲ 1
  double precision, intent(in) :: u2(size(x),size(y))  ! ǥȺɸϤǤʿѲ 2
  double precision, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  double precision, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  double precision, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  double precision, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  double precision, intent(inout) :: v(size(r))  ! ʿѲ u .
  double precision, intent(in), optional :: undef  ! ΰ賰
  double precision, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  integer :: i, j, nx, ny, nr, z_count
  double precision, dimension(size(x),size(y)) :: posx, posy, abpos, vecz
  logical :: stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u1 ),  &
  &                                     "tangent_mean_vec" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u2 ),  &
  &                                     "tangent_mean_vec" )
     call check_array_size_dmp_message( check_array_size_1d( nr, v ),  &
  &                                     "tangent_mean_vec" )
  end if

  z_count=0

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

!-- ޤ, charc ˹碌, ʿ٥ȥư¡Ѵ.
!-- Ѵ, ͤϥ顼ͤȤɾΤ,
!-- tangent_mean_scal ꤲ.

!-- 濴ФƥǥȺɸοʿ֥٥ȥ׻.

  do j=1,ny
     do i=1,nx
        posx(i,j)=x(i)-xc
        posy(i,j)=y(j)-yc
     end do
  end do

  select case (trim(charc))
  case ('vector')
     if(present(undefg))then
        call vec_prod_2d( posx, posy, u1, u2, vecz, undeff=undefg )
     else
        call vec_prod_2d( posx, posy, u1, u2, vecz )
     end if
  case ('scalar')
     if(present(undefg))then
        call dot_prod_2d( posx, posy, u1, u2, vecz, undeff=undefg )
     else
        call dot_prod_2d( posx, posy, u1, u2, vecz )
     end if
  case default
     write(*,*) "error : bad character. select 'vector', or 'scalar'."
     stop
  end select

  call abst_2d( posx, posy, abpos )

  if(present(undefg))then
     do j=1,ny
        do i=1,nx   
           if(vecz(i,j)/=undefg.and.abpos(i,j)/=0.0d0)then
              vecz(i,j)=vecz(i,j)/abpos(i,j)
           else if(abpos(i,j)==0.0d0)then
              z_count=z_count+1
              vecz(i,j)=0.0d0
           end if
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           if(abpos(i,j)/=0.0d0)then
              vecz(i,j)=vecz(i,j)/abpos(i,j)
           else
              z_count=z_count+1
              vecz(i,j)=0.0d0
           end if
        end do
     end do
  end if

  if(present(undef))then
     if(present(undefg))then
        call tangent_mean_scal_d( x, y, xc, yc, vecz, r, theta, v,  &
  &                               undef=undef, undefg=undefg,  &
  &                               undefgc=trim(undefgc), stdopt=stderr )
     else
        call tangent_mean_scal_d( x, y, xc, yc, vecz, r, theta, v,  &
  &                               undef=undef, stdopt=stderr )
     end if
  else if(present(undefg))then
     call tangent_mean_scal_d( x, y, xc, yc, vecz, r, theta, v,  &
  &                            undefg=undefg, undefgc=trim(undefgc),  &
  &                            stdopt=stderr )
  else
     call tangent_mean_scal_d( x, y, xc, yc, vecz, r, theta, v, stdopt=stderr )
  end if

end subroutine tangent_mean_vec_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_anom_vec_f( charc, x, y, xc, yc, u1, u2, r, theta, v,  &
  &                                 undef, undefg, undefgc, stdopt )
  ! Ǥդʪ̤濴ʿѥΥޥ׻롼
  ! ®ʿ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  !     Ʊ롼, 2 ĤΥ٥ȥʬʿͤΤ,
  !     Ѥ vec_prod_2d ˤä濴ΰ֥٥ȥȤγѤ׻
  !     . Ʊ롼濴εΥǳä v ʬΤ.
  ! (4) nr x nt Ĥʬͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  ! ʤ, ܥ롼ϲΤ, β tangent_mean_scal 롼
  ! ꤲƤ. ܥ롼ǹԤΤ, charc ˹碌,
  ! ƥǥȺɸˤ濴Ф, ư׻ΤߤǤ.
  implicit none
  character(6), intent(in) :: charc  ! ưʬʬȽ, vector = , scalar = ưʬ.
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: u1(size(x),size(y))  ! ǥȺɸϤǤʿѲ 1
  real, intent(in) :: u2(size(x),size(y))  ! ǥȺɸϤǤʿѲ 2
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: v(size(r),size(theta))  ! Υޥ u .
  real, intent(in), optional :: undef  ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  integer :: i, j, nx, ny, nr, nt, z_count
  real, dimension(size(x),size(y)) :: posx, posy, abpos, vecz
  logical :: stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u1 ),  &
  &                                     "tangent_mean_anom_vec" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u2 ),  &
  &                                     "tangent_mean_anom_vec" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nt, v ),  &
  &                                     "tangent_mean_anom_vec" )
  end if

  z_count=0

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

!-- ޤ, charc ˹碌, ʿ٥ȥư¡Ѵ.
!-- Ѵ, ͤϥ顼ͤȤɾΤ,
!-- tangent_mean_scal ꤲ.

!-- 濴ФƥǥȺɸοʿ֥٥ȥ׻.

  do j=1,ny
     do i=1,nx
        posx(i,j)=x(i)-xc
        posy(i,j)=y(j)-yc
     end do
  end do

  select case (trim(charc))
  case ('vector')
     if(present(undefg))then
        call vec_prod_2d( posx, posy, u1, u2, vecz, undeff=undefg )
     else
        call vec_prod_2d( posx, posy, u1, u2, vecz )
     end if
  case ('scalar')
     if(present(undefg))then
        call dot_prod_2d( posx, posy, u1, u2, vecz, undeff=undefg )
     else
        call dot_prod_2d( posx, posy, u1, u2, vecz )
     end if
  case default
     write(*,*) "error : bad character. select 'vector', or 'scalar'."
     stop
  end select

  call abst_2d( posx, posy, abpos )

  if(present(undefg))then
     do j=1,ny
        do i=1,nx   
           if(vecz(i,j)/=undefg.and.abpos(i,j)/=0.0)then
              vecz(i,j)=vecz(i,j)/abpos(i,j)
           else if(abpos(i,j)==0.0)then
              z_count=z_count+1
              vecz(i,j)=0.0
           end if
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           if(abpos(i,j)/=0.0)then
              vecz(i,j)=vecz(i,j)/abpos(i,j)
           else
              z_count=z_count+1
              vecz(i,j)=0.0
           end if
        end do
     end do
  end if

  if(present(undef))then
     if(present(undefg))then
        call tangent_mean_anom_scal_f( x, y, xc, yc, vecz, r, theta, v,  &
  &                                    undef=undef, undefg=undefg,  &
  &                                    undefgc=trim(undefgc), stdopt=stderr )
     else
        call tangent_mean_anom_scal_f( x, y, xc, yc, vecz, r, theta, v,  &
  &                                    undef=undef, stdopt=stderr )
     end if
  else if(present(undefg))then
     call tangent_mean_anom_scal_f( x, y, xc, yc, vecz, r, theta, v,  &
  &                                 undefg=undefg, undefgc=trim(undefgc),  &
  &                                 stdopt=stderr )
  else
     call tangent_mean_anom_scal_f( x, y, xc, yc, vecz, r, theta, v,  &
  &                                 stdopt=stderr )
  end if

end subroutine tangent_mean_anom_vec_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_anom_vec_d( charc, x, y, xc, yc, u1, u2, r, theta, v,  &
  &                                 undef, undefg, undefgc, stdopt )
  ! Ǥդʪ̤濴ʿѥΥޥ׻롼
  ! ®ʿ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  !     Ʊ롼, 2 ĤΥ٥ȥʬʿͤΤ,
  !     Ѥ vec_prod_2d ˤä濴ΰ֥٥ȥȤγѤ׻
  !     . Ʊ롼濴εΥǳä v ʬΤ.
  ! (4) nr x nt Ĥʬͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  ! ʤ, ܥ롼ϲΤ, β tangent_mean_scal 롼
  ! ꤲƤ. ܥ롼ǹԤΤ, charc ˹碌,
  ! ƥǥȺɸˤ濴Ф, ư׻ΤߤǤ.
  implicit none
  character(6), intent(in) :: charc  ! ưʬʬȽ, vector = , scalar = ưʬ.
  double precision, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  double precision, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  double precision, intent(in) :: u1(size(x),size(y))  ! ǥȺɸϤǤʿѲ 1
  double precision, intent(in) :: u2(size(x),size(y))  ! ǥȺɸϤǤʿѲ 2
  double precision, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  double precision, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  double precision, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  double precision, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  double precision, intent(inout) :: v(size(r),size(theta))  ! Υޥ u .
  double precision, intent(in), optional :: undef  ! ΰ賰
  double precision, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  integer :: i, j, nx, ny, nr, nt, z_count
  double precision, dimension(size(x),size(y)) :: posx, posy, abpos, vecz
  logical :: stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u1 ),  &
  &                                     "tangent_mean_anom_vec" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u2 ),  &
  &                                     "tangent_mean_anom_vec" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nt, v ),  &
  &                                     "tangent_mean_anom_vec" )
  end if

  z_count=0

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

!-- ޤ, charc ˹碌, ʿ٥ȥư¡Ѵ.
!-- Ѵ, ͤϥ顼ͤȤɾΤ,
!-- tangent_mean_scal ꤲ.

!-- 濴ФƥǥȺɸοʿ֥٥ȥ׻.

  do j=1,ny
     do i=1,nx
        posx(i,j)=x(i)-xc
        posy(i,j)=y(j)-yc
     end do
  end do

  select case (trim(charc))
  case ('vector')
     if(present(undefg))then
        call vec_prod_2d( posx, posy, u1, u2, vecz, undeff=undefg )
     else
        call vec_prod_2d( posx, posy, u1, u2, vecz )
     end if
  case ('scalar')
     if(present(undefg))then
        call dot_prod_2d( posx, posy, u1, u2, vecz, undeff=undefg )
     else
        call dot_prod_2d( posx, posy, u1, u2, vecz )
     end if
  case default
     write(*,*) "error : bad character. select 'vector', or 'scalar'."
     stop
  end select

  call abst_2d( posx, posy, abpos )

  if(present(undefg))then
     do j=1,ny
        do i=1,nx   
           if(vecz(i,j)/=undefg.and.abpos(i,j)/=0.0d0)then
              vecz(i,j)=vecz(i,j)/abpos(i,j)
           else if(abpos(i,j)==0.0d0)then
              z_count=z_count+1
              vecz(i,j)=0.0d0
           end if
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           if(abpos(i,j)/=0.0d0)then
              vecz(i,j)=vecz(i,j)/abpos(i,j)
           else
              z_count=z_count+1
              vecz(i,j)=0.0d0
           end if
        end do
     end do
  end if

  if(present(undef))then
     if(present(undefg))then
        call tangent_mean_anom_scal_d( x, y, xc, yc, vecz, r, theta, v,  &
  &                                    undef=undef, undefg=undefg,  &
  &                                    undefgc=trim(undefgc), stdopt=stderr )
     else
        call tangent_mean_anom_scal_d( x, y, xc, yc, vecz, r, theta, v,  &
  &                                    undef=undef, stdopt=stderr )
     end if
  else if(present(undefg))then
     call tangent_mean_anom_scal_d( x, y, xc, yc, vecz, r, theta, v,  &
  &                                 undefg=undefg, undefgc=trim(undefgc),  &
  &                                 stdopt=stderr )
  else
     call tangent_mean_anom_scal_d( x, y, xc, yc, vecz, r, theta, v,  &
  &                                 stdopt=stderr )
  end if

end subroutine tangent_mean_anom_vec_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_turb( signal, r, z, u, v, w, rho, nuh, nuv, val, undef, sfctau )
!  ʿѤήեå׻.
!  ʿѤƤΤ, tau_{*2} ʬ (\theta ʬʬ) ϴޤޤʤ.
  implicit none
  character(1) :: signal  ! ɸϤβܤήʬȽꤹ.
                  ! [1] = ɸˤ radial ɸʬ ( vr ʬ)
                  ! [2] = ɸˤ tangential ɸʬ ( vt ʬ)
                  ! [3] = ɸˤ vertical ɸʬ ( w ʬ)
  real, intent(in) :: r(:)  ! ưΰֺɸ [m]
  real, intent(in) :: z(:)  ! ľΰֺɸ [m]
  real, intent(in) :: u(size(r),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(r),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(r),size(z))  ! y б 2 >ȥʬ
  real, intent(in) :: rho(size(z))  ! ʿ̤ʿѤܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(r),size(z))  ! ʿǴ
  real, intent(in) :: nuv(size(r),size(z))  ! ľǴ
  real, intent(inout) :: val(size(r),size(z))  ! ήեå
  real, intent(in), optional :: undef
  real, intent(in), optional :: sfctau(size(r))  ! ɽ̤Υեå
                 ! 줬Ϳ, ǲؤαϤϤ֤.
  integer :: i   ! 졼ź
!  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: id   ! 졼ź
  integer :: nr  ! ǿ 1 
  integer :: nz  ! ǿ 2 
  real :: dr  ! 1 ܤʬʻҴֳ [m]
  real :: dz  ! 2 ܤʬʻҴֳ [m]
  character(1) :: signaltau(3)
  real, dimension(size(r),size(z),3) :: tau  ! signal 
              ! Ѥ 1,2,3 ̤˿ľʱ
  real, dimension(size(r),size(z)) :: tmp
  real, dimension(size(r)) :: stau

  signaltau=(/ '1', '2', '3' /)

  dr=r(2)-r(1)
  dz=z(2)-z(1)
  nr=size(r)
  nz=size(z) 

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, u ),  &
  &                                     "tangent_mean_turb" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, v ),  &
  &                                     "tangent_mean_turb" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, w ),  &
  &                                     "tangent_mean_turb" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, nuh ),  &
  &                                     "tangent_mean_turb" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, nuv ),  &
  &                                     "tangent_mean_turb" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, val ),  &
  &                                     "tangent_mean_turb" )
     call check_array_size_dmp_message( check_array_size_1d( nz, rho ),  &
  &                                     "tangent_mean_turb" )
     call check_array_size_dmp_message( check_array_size_1d( nr, sfctau ),  &
  &                                     "tangent_mean_turb" )
  end if

  val=0.0

  do id=1,3
     if(id/=2)then  ! tau_{*2} ʬϥʤΤ, ׻ʤ.
        if(present(sfctau))then
           stau(:)=sfctau(:)
           call tangent_mean_Reynolds( signal//signaltau(id),  &
  &             r, z, u, v, w, rho, nuh, nuv, tau(:,:,id), sfctau=stau )
        else
           call tangent_mean_Reynolds( signal//signaltau(id),  &
  &             r, z, u, v, w, rho, nuh, nuv, tau(:,:,id) )
        end if
     end if
  end do

!-- (signal, 1) ʬη׻
  do k=1,nz
     call grad_1d( r, tau(:,k,1), tmp(:,k))
     do i=1,nr
        if(r(i)/=0.0)then
           val(i,k)=tmp(i,k)+val(i,k)+tau(i,k,1)/r(i)
        else
           val(i,k)=tmp(i,k)+val(i,k)
        end if
     end do
  end do

!-- (signal, 3) ʬη׻
  do i=1,nr
     call grad_1d( z, tau(i,:,3), tmp(i,:))
     do k=1,nz
        val(i,k)=tmp(i,k)+val(i,k)
     end do
  end do



end subroutine

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_Reynolds( signal, r, z, u, v, w, rho, nuh, nuv, val, undef, sfctau )
! ɸϤˤ쥤Υ륺ϥƥ󥽥׻.
  implicit none
  character(2) :: signal  ! ׻ƥ󥽥ʬ.
                  ! ['11', '22', '33'] = 줾гѥƥ󥽥ʬ
                  ! ['12', '13', '21', '23', '31', '32'] = 줾г
                  ! ƥ󥽥ʬ. , оΥƥ󥽥Ǥ뤿, '12'='21' 
                  ! ׻Ƥ뤳Ȥ.
  real, intent(in) :: r(:)  ! radial ζֺɸ [m]
  real, intent(in) :: z(:)  ! vertical ζֺɸ [m]
  real, intent(in) :: u(size(r),size(z))  ! radial б 3 ٥ȥʬ
  real, intent(in) :: v(size(r),size(z))  ! tangential б 3 ٥ȥʬ
  real, intent(in) :: w(size(r),size(z))  ! vertical б 3 ٥ȥʬ
  real, intent(in) :: rho(size(z))  ! ʿ̤ʿѤܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(r),size(z))  ! ʿǴ
  real, intent(in) :: nuv(size(r),size(z))  ! ľǴ
  real, intent(inout) :: val(size(r),size(z))  ! ׻줿ƥ󥽥ʬ
! , ʲΥץϻѤƤʤ.
  real, intent(in), optional :: undef
  real, intent(in), optional :: sfctau(size(r))  ! ɽ̤Υեå
                 ! 줬Ϳ, ǲؤαϤϤ֤.
  integer :: i   ! 졼ź
!  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nr  ! ǿ 1 
  integer :: nz  ! ǿ 3 
  real :: dr  ! 1 ܤʬʻҴֳ [m]
  real :: dz  ! 3 ܤʬʻҴֳ [m]
  real :: sxx(size(r),size(z)), nu(size(r),size(z))
  real :: stau(size(r))

  dr=r(2)-r(1)
  dz=z(2)-z(1)
  nr=size(r)
  nz=size(z)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, u ),  &
  &                                     "tangent_mean_Reynolds" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, v ),  &
  &                                     "tangent_mean_Reynolds" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, w ),  &
  &                                     "tangent_mean_Reynolds" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, nuh ),  &
  &                                     "tangent_mean_Reynolds" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, nuv ),  &
  &                                     "tangent_mean_Reynolds" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, val ),  &
  &                                     "tangent_mean_Reynolds" )
     call check_array_size_dmp_message( check_array_size_1d( nz, rho ),  &
  &                                     "tangent_mean_Reynolds" )
     call check_array_size_dmp_message( check_array_size_1d( nr, sfctau ),  &
  &                                     "tangent_mean_Reynolds" )
  end if

  val=0.0
  stau=0.0

  if(present(sfctau))then
     if(signal(2:2)=='3'.and.signal(1:1)/='3')then
        stau(:)=sfctau(:)
     end if
  end if

!-- [NOTE]
!-- ʲ, ʸ case  or Ǥʤ, 
!-- if ʸҤǤϤʤ, if ʸɽ case Ʊ褦˸.
!-- Ϥ, 夫 if 򤿤ɤ뤬, ɤξ 2 ʾ if 
!-- פʤȤΤǤ뤿˲ǽȤʤǤ,
!-- ɽ if  2 ѥʾ˹פƤޤ褦ʾʸǤ,
!-- case ѤˤѤ뤳ȤǤʤȤ.
!-- ܥ饤֥ǤΤ褦ʶ路ɽ򤷤Ƥɬ NOTE .

  if(signal(1:2)=='12'.or.signal(1:2)=='21')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do
  end if

  if(signal(1:2)=='23'.or.signal(1:2)=='32')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )

     if(signal(2:2)=='3')then
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuv(i,k)
           end do
        end do
     else
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuh(i,k)
           end do
        end do
     end if
  end if

  if(signal(1:2)=='13'.or.signal(1:2)=='31')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )

     if(signal(2:2)=='3')then
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuv(i,k)
           end do
        end do
     else
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuh(i,k)
           end do
        end do
     end if
  end if

  if(signal(1:2)=='11')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )
     call div( r, z, u, w, val )
     do k=1,nz
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)+u(i,k)/r(i)
           end if
        end do
     end do

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do
  end if

  if(signal(1:2)=='22')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )
     call div( r, z, u, w, val )
     do k=1,nz
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)+u(i,k)/r(i)
           end if
        end do
     end do

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do

  end if

  if(signal(1:2)=='33')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )
     call div( r, z, u, w, val )
     do k=1,nz
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)+u(i,k)/r(i)
           end if
        end do
     end do

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do

  end if

!-- ʲμ, ǽ val = 0  if ʸǷ׻ƤΤȤƤʤ
!-- ΤʬΤ, μɾǤ.
!-- ׻ƤʤΤˤĤƤϤ⤽⥼Ǥ.

!-- ʲ, ǲؤɽ̥եå뤫ɤΥץΤ, ̥롼

  if(present(sfctau))then
     do i=1,nr
        val(i,1)=stau(i)
     end do
  else
     do i=1,nr
        val(i,1)=rho(1)*nu(i,1)*(sxx(i,1)-(2.0/3.0)*val(i,1))
     end do
  end if

  do k=2,nz
     do i=1,nr
        val(i,k)=rho(k)*nu(i,k)*(sxx(i,k)-(2.0/3.0)*val(i,k))
     end do
  end do

end subroutine


!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine calc_taufil_f( x, y, u, v, val, undef, sx, sy )
! Rozoff et al. (2006)  filamentation time ׻.
  implicit none
  real, intent(in) :: x(:)  ! ֺɸʬ [Ǥ]
  real, intent(in) :: y(:)  ! ֺɸʬ [Ǥ]
  real, intent(in) :: u(size(x),size(y))  ! x  2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y))  ! x  2 ٥ȥʬ
  real, intent(inout) :: val(size(x),size(y))  ! ׻줿 tau_fil
  real, intent(in), optional :: undef
  real, intent(in), optional :: sx(size(x),size(y))  !  x ʬ
  real, intent(in), optional :: sy(size(x),size(y))  !  y ʬ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  real, dimension(size(x),size(y)) :: hx, hy  ! sx, sy
  real, dimension(size(x),size(y)) :: s1, s2, s3  ! S1, S2, zeta
  real, dimension(size(x),size(y)) :: dudx, dudy, dvdx, dvdy
  real, dimension(size(x),size(y)) :: ds1dx, ds1dy, ds2dx, ds2dy
  logical :: sx_flag, sy_flag

  nx=size(x)
  ny=size(y)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "calc_taufil" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, v ),  &
  &                                     "calc_taufil" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, val ),  &
  &                                     "calc_taufil" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, sx ),  &
  &                                     "calc_taufil" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, sy ),  &
  &                                     "calc_taufil" )
  end if

  if(present(sx))then
     sx_flag=.true.
     hx=sx
  else
     sx_flag=.false.
     ds1dx=0.0
     ds1dy=0.0
     hx=1.0
  end if
  if(present(sy))then
     sy_flag=.true.
     hy=sy
  else
     sy_flag=.false.
     ds2dx=0.0
     ds2dy=0.0
     hy=1.0
  end if

  if(present(undef))then

  !-- calculating essential variables
     call grad_2d( x, y, u, dudx, dudy, undeff=undef )
     call grad_2d( x, y, v, dvdx, dvdy, undeff=undef )
  !-- calculating scale factor variables
     if(sx_flag.eqv..true.)then
        call grad_2d( x, y, hx, ds1dx, ds1dy, undeff=undef )
     end if
     if(sy_flag.eqv..true.)then
        call grad_2d( x, y, hy, ds2dx, ds2dy, undeff=undef )
     end if
  !-- calculating each value
     do j=1,ny
        do i=1,nx
           if(dudx(i,j)/=undef.and.dudy(i,j)/=undef.and.  &
  &           dvdx(i,j)/=undef.and.dvdy(i,j)/=undef)then
              s1(i,j)=dudx(i,j)/hx(i,j)-dvdy(i,j)/hy(i,j)  &
  &                   +(v(i,j)*ds1dy(i,j)-u(i,j)*ds2dx(i,j))/(hx(i,j)*hy(i,j))
              s2(i,j)=dvdx(i,j)/hx(i,j)+dudy(i,j)/hy(i,j)  &
  &                   -(u(i,j)*ds2dx(i,j)+v(i,j)*ds1dy(i,j))/(hx(i,j)*hy(i,j))
              s3(i,j)=dvdx(i,j)/hx(i,j)-dudy(i,j)/hy(i,j)  &
  &                   +(v(i,j)*ds2dx(i,j)-u(i,j)*ds1dy(i,j))/(hx(i,j)*hy(i,j))
              val(i,j)=s1(i,j)**2+s2(i,j)**2-s3(i,j)**2
              if(val(i,j)>0.0)then
                 val(i,j)=2.0/sqrt(val(i,j))
              else
                 val(i,j)=undef
              end if
           else
              val(i,j)=undef
           end if
        end do
     end do

  else
     
  !-- calculating essential variables
     call grad_2d( x, y, u, dudx, dudy )
     call grad_2d( x, y, v, dvdx, dvdy )
  !-- calculating scale factor variables
     if(sx_flag.eqv..true.)then
        call grad_2d( x, y, hx, ds1dx, ds1dy )
     end if
     if(sy_flag.eqv..true.)then
        call grad_2d( x, y, hy, ds2dx, ds2dy )
     end if
  !-- calculating each value
     do j=1,ny
        do i=1,nx
           s1(i,j)=dudx(i,j)/hx(i,j)-dvdy(i,j)/hy(i,j)  &
  &                +(v(i,j)*ds1dy(i,j)-u(i,j)*ds2dx(i,j))/(hx(i,j)*hy(i,j))
           s2(i,j)=dvdx(i,j)/hx(i,j)+dudy(i,j)/hy(i,j)  &
  &                -(u(i,j)*ds2dx(i,j)+v(i,j)*ds1dy(i,j))/(hx(i,j)*hy(i,j))
           s3(i,j)=dvdx(i,j)/hx(i,j)-dudy(i,j)/hy(i,j)  &
  &                +(v(i,j)*ds2dx(i,j)-u(i,j)*ds1dy(i,j))/(hx(i,j)*hy(i,j))
           val(i,j)=s1(i,j)**2+s2(i,j)**2-s3(i,j)**2
           if(val(i,j)>0.0)then
              val(i,j)=2.0/sqrt(val(i,j))
           else
              val(i,j)=0.0
           end if
        end do
     end do

  end if

end subroutine calc_taufil_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine calc_taufil_d( x, y, u, v, val, undef, sx, sy )
! Rozoff et al. (2006)  filamentation time ׻.
  implicit none
  double precision, intent(in) :: x(:)  ! ֺɸʬ [Ǥ]
  double precision, intent(in) :: y(:)  ! ֺɸʬ [Ǥ]
  double precision, intent(in) :: u(size(x),size(y))  ! x  2 ٥ȥʬ
  double precision, intent(in) :: v(size(x),size(y))  ! x  2 ٥ȥʬ
  double precision, intent(inout) :: val(size(x),size(y))  ! ׻줿 tau_fil
  double precision, intent(in), optional :: undef
  double precision, intent(in), optional :: sx(size(x),size(y))  !  x ʬ
  double precision, intent(in), optional :: sy(size(x),size(y))  !  y ʬ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  double precision, dimension(size(x),size(y)) :: hx, hy  ! sx, sy
  double precision, dimension(size(x),size(y)) :: s1, s2, s3  ! S1, S2, zeta
  double precision, dimension(size(x),size(y)) :: dudx, dudy, dvdx, dvdy
  double precision, dimension(size(x),size(y)) :: ds1dx, ds1dy, ds2dx, ds2dy
  logical :: sx_flag, sy_flag

  nx=size(x)
  ny=size(y)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "calc_taufil" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, v ),  &
  &                                     "calc_taufil" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, val ),  &
  &                                     "calc_taufil" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, sx ),  &
  &                                     "calc_taufil" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, sy ),  &
  &                                     "calc_taufil" )
  end if

  if(present(sx))then
     sx_flag=.true.
     hx=sx
  else
     sx_flag=.false.
     ds1dx=0.0d0
     ds1dy=0.0d0
     hx=1.0d0
  end if
  if(present(sy))then
     sy_flag=.true.
     hy=sy
  else
     sy_flag=.false.
     ds2dx=0.0d0
     ds2dy=0.0d0
     hy=1.0d0
  end if

  if(present(undef))then

  !-- calculating essential variables
     call grad_2d( x, y, u, dudx, dudy, undeff=undef )
     call grad_2d( x, y, v, dvdx, dvdy, undeff=undef )
  !-- calculating scale factor variables
     if(sx_flag.eqv..true.)then
        call grad_2d( x, y, hx, ds1dx, ds1dy, undeff=undef )
     end if
     if(sy_flag.eqv..true.)then
        call grad_2d( x, y, hy, ds2dx, ds2dy, undeff=undef )
     end if
  !-- calculating each value
     do j=1,ny
        do i=1,nx
           if(dudx(i,j)/=undef.and.dudy(i,j)/=undef.and.  &
  &           dvdx(i,j)/=undef.and.dvdy(i,j)/=undef)then
              s1(i,j)=dudx(i,j)/hx(i,j)-dvdy(i,j)/hy(i,j)  &
  &                   +(v(i,j)*ds1dy(i,j)-u(i,j)*ds2dx(i,j))/(hx(i,j)*hy(i,j))
              s2(i,j)=dvdx(i,j)/hx(i,j)+dudy(i,j)/hy(i,j)  &
  &                   -(u(i,j)*ds2dx(i,j)+v(i,j)*ds1dy(i,j))/(hx(i,j)*hy(i,j))
              s3(i,j)=dvdx(i,j)/hx(i,j)-dudy(i,j)/hy(i,j)  &
  &                   +(v(i,j)*ds2dx(i,j)-u(i,j)*ds1dy(i,j))/(hx(i,j)*hy(i,j))
              val(i,j)=s1(i,j)**2+s2(i,j)**2-s3(i,j)**2
              if(val(i,j)>0.0d0)then
                 val(i,j)=2.0d0/sqrt(val(i,j))
              else
                 val(i,j)=undef
              end if
           else
              val(i,j)=undef
           end if
        end do
     end do

  else
     
  !-- calculating essential variables
     call grad_2d( x, y, u, dudx, dudy )
     call grad_2d( x, y, v, dvdx, dvdy )
  !-- calculating scale factor variables
     if(sx_flag.eqv..true.)then
        call grad_2d( x, y, hx, ds1dx, ds1dy )
     end if
     if(sy_flag.eqv..true.)then
        call grad_2d( x, y, hy, ds2dx, ds2dy )
     end if
  !-- calculating each value
     do j=1,ny
        do i=1,nx
           s1(i,j)=dudx(i,j)/hx(i,j)-dvdy(i,j)/hy(i,j)  &
  &                +(v(i,j)*ds1dy(i,j)-u(i,j)*ds2dx(i,j))/(hx(i,j)*hy(i,j))
           s2(i,j)=dvdx(i,j)/hx(i,j)+dudy(i,j)/hy(i,j)  &
  &                -(u(i,j)*ds2dx(i,j)+v(i,j)*ds1dy(i,j))/(hx(i,j)*hy(i,j))
           s3(i,j)=dvdx(i,j)/hx(i,j)-dudy(i,j)/hy(i,j)  &
  &                +(v(i,j)*ds2dx(i,j)-u(i,j)*ds1dy(i,j))/(hx(i,j)*hy(i,j))
           val(i,j)=s1(i,j)**2+s2(i,j)**2-s3(i,j)**2
           if(val(i,j)>0.0d0)then
              val(i,j)=2.0d0/dsqrt(val(i,j))
           else
              val(i,j)=0.0d0
           end if
        end do
     end do

  end if

end subroutine calc_taufil_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_deform( signal, r, z, u, v, w, val, undef )
! ǥȺɸϤˤѷ®٥ƥ󥽥׻.
  implicit none
  character(2) :: signal  ! ׻ƥ󥽥ʬ.
                  ! ['11', '22', '33'] = 줾гѥƥ󥽥ʬ
                  ! ['12', '13', '21', '23', '31', '32'] = 줾г
                  ! ƥ󥽥ʬ. , оΥƥ󥽥Ǥ뤿, '12'='21' 
                  ! ׻Ƥ뤳Ȥ.
  real, intent(in) :: r(:)  ! radial ζֺɸ [m]
  real, intent(in) :: z(:)  ! vertical ζֺɸ [m]
  real, intent(in) :: u(size(r),size(z))  ! radial б 3 ٥ȥʬ
  real, intent(in) :: v(size(r),size(z))  ! tangential б 3 ٥ȥʬ
  real, intent(in) :: w(size(r),size(z))  ! vertical б 3 ٥ȥʬ
  real, intent(inout) :: val(size(r),size(z))  ! ׻줿ƥ󥽥ʬ
! , ʲΥץϻѤƤʤ.
  real, intent(in), optional :: undef
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nr  ! ǿ 1 
  integer :: nz  ! ǿ 2 
  real :: dr  ! 1 ܤʬʻҴֳ [m]
  real :: dz  ! 2 ܤʬʻҴֳ [m]

  dr=r(2)-r(1)
  dz=z(2)-z(1)
  nr=size(r)
  nz=size(z)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, u ),  &
  &                                     "tangent_mean_deform" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, v ),  &
  &                                     "tangent_mean_deform" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, w ),  &
  &                                     "tangent_mean_deform" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, val ),  &
  &                                     "tangent_mean_deform" )
  end if

!-- [NOTE]
!-- ʲ, ʸ case  or Ǥʤ, 
!-- if ʸҤǤϤʤ, if ʸɽ case Ʊ褦˸.
!-- Ϥ, 夫 if 򤿤ɤ뤬, ɤξ 2 ʾ if 
!-- פʤȤΤǤ뤿˲ǽȤʤǤ,
!-- ɽ if  2 ѥʾ˹פƤޤ褦ʾʸǤ,
!-- case ѤˤѤ뤳ȤǤʤȤ.
!-- ܥ饤֥ǤΤ褦ʶ路ɽ򤷤Ƥɬ NOTE .

  if(signal(1:2)=='12'.or.signal(1:2)=='21')then
     do k=1,nz
        call grad_1d( r, v(:,k), val(:,k) )
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)-v(i,k)/r(i)
           end if
        end do
     end do
  end if

  if(signal(1:2)=='23'.or.signal(1:2)=='32')then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(k)
     do k=1,nr
        call grad_1d( z, v(k,:), val(k,:) )
     end do
!$omp end do
!$omp end parallel
  end if

  if(signal(1:2)=='13'.or.signal(1:2)=='31')then
     call div( r, z, w, u, val )
  end if

  if(signal(1:2)=='11')then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(k)
     do k=1,nz
        call grad_1d( r, u(:,k), val(:,k) )
        val(:,k)=2.0*val(:,k)
     end do
!$omp end do
!$omp end parallel
  end if

  if(signal(1:2)=='22')then
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
     do k=1,nz
        do j=1,nr
           if(r(j)/=0.0)then
              val(j,k)=2.0*u(j,k)/r(j)
           else
              val(j,k)=0.0
           end if
        end do
     end do
!$omp end do
!$omp end parallel
  end if

  if(signal(1:2)=='33')then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(j)
     do j=1,nr
        call grad_1d( z, w(j,:), val(j,:) )
        val(j,:)=2.0*val(j,:)
     end do
!$omp end do
!$omp end parallel
  end if

end subroutine

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine hydro_grad_eqb_f( r, z, coril, v, pres_s, rho_s, pres, rho, error, dl )
!  ǥ󥰤ȼоήϳءʿվη׻.
  use Thermo_Const
  use Phys_Const
  implicit none
  real, intent(in) :: r(:)  ! ưºɸ [m]
  real, intent(in) :: z(:)  ! ľɸ [m]
  real, intent(in) :: coril(size(r),size(z))  ! ꥪѥ᡼ [/s]
  real, intent(in) :: v(size(r),size(z))  ! оή [m/s]
  real, intent(in) :: pres_s(size(z))  ! ǥ󥰤ε [Pa]
  real, intent(in) :: rho_s(size(z))  ! ǥ󥰤̩ [kg/m^3]
  real, intent(in), optional :: error  ! 졼μ«
                    ! default = 1.0e-5
  real, intent(inout) :: pres(size(r),size(z))  ! ʿվε [Pa]
  real, intent(inout) :: rho(size(r),size(z))  ! ʿվ̩ [kg/m^3]
  integer, intent(in), optional :: dl  ! ǥХå٥
  real :: dr(size(r)), dz(size(z))
  real :: old_pres(size(r),size(z)), old_rho(size(r),size(z))
  real :: N2(size(r),size(z)), tmprho(size(r),size(z)), force(size(r),size(z))
  integer :: nr, nz
  integer :: i, j
  real :: err, err_tmp, err_max, tmpp, tmpc, tmpr

  nr=size(r)
  nz=size(z)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, coril ),  &
  &                                     "hydro_grad_eqb" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, v ),  &
  &                                     "hydro_grad_eqb" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, pres ),  &
  &                                     "hydro_grad_eqb" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, rho ),  &
  &                                     "hydro_grad_eqb" )
     call check_array_size_dmp_message( check_array_size_1d( nz, pres_s ),  &
  &                                     "hydro_grad_eqb" )
     call check_array_size_dmp_message( check_array_size_1d( nz, rho_s ),  &
  &                                     "hydro_grad_eqb" )
  end if

  if(present(error))then
     err_max=error
  else
     err_max=1.0e-5
  end if

!-- ʲǳƹ٤ˤ, ̩٤ϰǤȤƷʿդ鵤׻,
!-- ͤѤϳʿդ̩٤. eps ʲˤʤޤǷ֤.
!--  2 ȥǥ󥰤.
  do j=1,nz
     do i=1,nr
        old_pres(i,j)=pres_s(j)
     end do
  end do
!-- ̩٤ˤĤƤ, ʿ̰ͤ
  do j=1,nz
     do i=1,nr
        old_rho(i,j)=log(rho_s(j))
     end do
  end do

  do i=1,nr-1
     dr(i)=r(i+1)-r(i)
  end do
  do j=1,nz-1
     dz(j)=z(j+1)-z(j)
  end do

!-- ʲǥ졼󳫻.
  err=err_max

  do while(err>=err_max)
     err=0.0

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)

     do j=1,nz
        do i=1,nr
           if(r(i)/=0.0)then
              force(i,j)=coril(i,j)*v(i,j)+v(i,j)*v(i,j)/r(i)
           else
              force(i,j)=0.0
           end if
        end do
     end do

!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,tmpp,tmpc,tmpr)

     do j=1,nz-1
        do i=1,nr-1
           tmpp=old_pres(i+1,j)*dz(j)+force(i,j)*dr(i)*old_pres(i,j+1)/g
           tmpc=dz(j)+dr(i)*force(i,j)/g
           tmpr=old_rho(i+1,j)*dz(j)+force(i,j)*dr(i)*old_rho(i,j+1)/g  &
  &             +(force(i,j+1)-force(i,j))*dr(i)/g
           pres(i,j)=tmpp/tmpc
           tmprho(i,j)=tmpr/tmpc
        end do
     end do

!$omp end do
!$omp end parallel

!-- ͤ
     do i=1,nr
        pres(i,nz)=pres_s(nz)
        tmprho(i,nz)=log(rho_s(nz))
     end do
     do j=1,nz
        pres(nr,j)=pres_s(j)
        tmprho(nr,j)=log(rho_s(j))
     end do

!-- ̩پμ«׻
     do j=1,nz
        do i=1,nr
           if(tmprho(i,j)==0.0)then
              err_tmp=abs(exp(old_rho(i,j))-exp(tmprho(i,j)))/abs(exp(old_rho(i,j)))
           else
              err_tmp=abs(exp(old_rho(i,j))-exp(tmprho(i,j)))/abs(exp(tmprho(i,j)))
           end if

!-- ι
           if(err<=err_tmp)then
              err=err_tmp
           end if

           old_rho(i,j)=tmprho(i,j)
           old_pres(i,j)=pres(i,j)

        end do
     end do

  end do

  do j=1,nz
     do i=1,nr
        rho(i,j)=exp(tmprho(i,j))
     end do
  end do

  if(present(dl))then
     do j=1,nz
        call debug_flag_r( dl, 'typhoon_analy', 'hydro_grad_eqb (pres)',  &
  &                        pres(1,j), 'Pa' )
     end do
  end if

end subroutine hydro_grad_eqb_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine hydro_grad_eqb_d( r, z, coril, v, pres_s, rho_s, pres, rho, error, dl )
!  ǥ󥰤ȼоήϳءʿվη׻.
  use Thermo_Const
  use Phys_Const
  implicit none
  double precision, intent(in) :: r(:)  ! ưºɸ [m]
  double precision, intent(in) :: z(:)  ! ľɸ [m]
  double precision, intent(in) :: coril(size(r),size(z))  ! ꥪѥ᡼ [/s]
  double precision, intent(in) :: v(size(r),size(z))  ! оή [m/s]
  double precision, intent(in) :: pres_s(size(z))  ! ǥ󥰤ε [Pa]
  double precision, intent(in) :: rho_s(size(z))  ! ǥ󥰤̩ [kg/m^3]
  double precision, intent(in), optional :: error  ! 졼μ«
                    ! default = 1.0e-5
  double precision, intent(inout) :: pres(size(r),size(z))  ! ʿվε [Pa]
  double precision, intent(inout) :: rho(size(r),size(z))  ! ʿվ̩ [kg/m^3]
  integer, intent(in), optional :: dl  ! ǥХå٥
  double precision :: dr(size(r)), dz(size(z))
  double precision :: old_pres(size(r),size(z)), old_rho(size(r),size(z))
  double precision :: N2(size(r),size(z)), tmprho(size(r),size(z)), force(size(r),size(z))
  integer :: nr, nz
  integer :: i, j
  double precision :: err, err_tmp, err_max, tmpp, tmpc, tmpr

  nr=size(r)
  nz=size(z)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, coril ),  &
  &                                     "hydro_grad_eqb" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, v ),  &
  &                                     "hydro_grad_eqb" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, pres ),  &
  &                                     "hydro_grad_eqb" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nz, rho ),  &
  &                                     "hydro_grad_eqb" )
     call check_array_size_dmp_message( check_array_size_1d( nz, pres_s ),  &
  &                                     "hydro_grad_eqb" )
     call check_array_size_dmp_message( check_array_size_1d( nz, rho_s ),  &
  &                                     "hydro_grad_eqb" )
  end if

  if(present(error))then
     err_max=error
  else
     err_max=1.0d-5
  end if

!-- ʲǳƹ٤ˤ, ̩٤ϰǤȤƷʿդ鵤׻,
!-- ͤѤϳʿդ̩٤. eps ʲˤʤޤǷ֤.
!--  2 ȥǥ󥰤.
  do j=1,nz
     do i=1,nr
        old_pres(i,j)=pres_s(j)
     end do
  end do
!-- ̩٤ˤĤƤ, ʿ̰ͤ
  do j=1,nz
     do i=1,nr
        old_rho(i,j)=dlog(rho_s(j))
     end do
  end do

  do i=1,nr-1
     dr(i)=r(i+1)-r(i)
  end do
  do j=1,nz-1
     dz(j)=z(j+1)-z(j)
  end do

!-- ʲǥ졼󳫻.
  err=err_max

  do while(err>=err_max)
     err=0.0d0

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)

     do j=1,nz
        do i=1,nr
           if(r(i)/=0.0d0)then
              force(i,j)=coril(i,j)*v(i,j)+v(i,j)*v(i,j)/r(i)
           else
              force(i,j)=0.0d0
           end if
        end do
     end do

!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,tmpp,tmpc,tmpr)

     do j=1,nz-1
        do i=1,nr-1
           tmpp=old_pres(i+1,j)*dz(j)+force(i,j)*dr(i)*old_pres(i,j+1)/g_dp
           tmpc=dz(j)+dr(i)*force(i,j)/g_dp
           tmpr=old_rho(i+1,j)*dz(j)+force(i,j)*dr(i)*old_rho(i,j+1)/g_dp  &
  &             +(force(i,j+1)-force(i,j))*dr(i)/g_dp
           pres(i,j)=tmpp/tmpc
           tmprho(i,j)=tmpr/tmpc
        end do
     end do

!$omp end do
!$omp end parallel

!-- ͤ
     do i=1,nr
        pres(i,nz)=pres_s(nz)
        tmprho(i,nz)=dlog(rho_s(nz))
     end do
     do j=1,nz
        pres(nr,j)=pres_s(j)
        tmprho(nr,j)=dlog(rho_s(j))
     end do

!-- ̩پμ«׻
     do j=1,nz
        do i=1,nr
           if(tmprho(i,j)==0.0d0)then
              err_tmp=dabs(dexp(old_rho(i,j))-dexp(tmprho(i,j)))/dabs(dexp(old_rho(i,j)))
           else
              err_tmp=dabs(dexp(old_rho(i,j))-dexp(tmprho(i,j)))/dabs(dexp(tmprho(i,j)))
           end if

!-- ι
           if(err<=err_tmp)then
              err=err_tmp
           end if

           old_rho(i,j)=tmprho(i,j)
           old_pres(i,j)=pres(i,j)

        end do
     end do

  end do

  do j=1,nz
     do i=1,nr
        rho(i,j)=dexp(tmprho(i,j))
     end do
  end do

  if(present(dl))then
     do j=1,nz
        call debug_flag_d( dl, 'typhoon_analy', 'hydro_grad_eqb (pres)',  &
  &                        pres(1,j), 'Pa' )
     end do
  end if

end subroutine hydro_grad_eqb_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine grad_wind_pres_f( r, coril, v, rho, r_ref, p_ref, pres )
!  ʿվ׻.
  implicit none
  real, intent(in) :: r(:)  ! r ΰֺɸ [m]
  real, intent(in) :: coril(size(r))  ! ꥪѥ᡼ [/s]
  real, intent(in) :: v(size(r))  ! r ΰֺɸ [m]
  real, intent(in) :: rho(size(r))  ! ̩ [kg/m^3]
  real, intent(in) :: r_ref  ! ʬȤʤֺɸ [m]
  real, intent(in) :: p_ref  ! r_ref Ǥε (ʬ) [Pa]
  real, intent(inout) :: pres(size(r))  ! ʿդǤε [Pa]
  integer :: i, nr
  real :: grad(size(r))

  nr=size(r)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nr, coril ),  &
  &                                     "grad_wind_pres" )
     call check_array_size_dmp_message( check_array_size_1d( nr, v ),  &
  &                                     "grad_wind_pres" )
     call check_array_size_dmp_message( check_array_size_1d( nr, rho ),  &
  &                                     "grad_wind_pres" )
     call check_array_size_dmp_message( check_array_size_1d( nr, pres ),  &
  &                                     "grad_wind_pres" )
  end if

  do i=1,nr
     if(r(i)/=0.0)then
        grad(i)=rho(i)*(v(i)*v(i)/r(i)+coril(i)*v(i))
     else
        grad(i)=0.0
     end if
  end do

  do i=1,nr
     if(r(i)<r_ref)then
        call rectangle_int( r, grad, r(i), r_ref, pres(i) )
        pres(i)=p_ref-pres(i)
     else if(r(i)>r_ref)then
        call rectangle_int( r, grad, r_ref, r(i), pres(i) )
        pres(i)=p_ref+pres(i)
     else
        pres(i)=p_ref
     end if
  end do

end subroutine grad_wind_pres_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine grad_wind_pres_d( r, coril, v, rho, r_ref, p_ref, pres )
!  ʿվ׻.
  implicit none
  double precision, intent(in) :: r(:)  ! r ΰֺɸ [m]
  double precision, intent(in) :: coril(size(r))  ! ꥪѥ᡼ [/s]
  double precision, intent(in) :: v(size(r))  ! r ΰֺɸ [m]
  double precision, intent(in) :: rho(size(r))  ! ̩ [kg/m^3]
  double precision, intent(in) :: r_ref  ! ʬȤʤֺɸ [m]
  double precision, intent(in) :: p_ref  ! r_ref Ǥε (ʬ) [Pa]
  double precision, intent(inout) :: pres(size(r))  ! ʿդǤε [Pa]
  integer :: i, nr
  double precision :: grad(size(r))

  nr=size(r)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nr, coril ),  &
  &                                     "grad_wind_pres" )
     call check_array_size_dmp_message( check_array_size_1d( nr, v ),  &
  &                                     "grad_wind_pres" )
     call check_array_size_dmp_message( check_array_size_1d( nr, rho ),  &
  &                                     "grad_wind_pres" )
     call check_array_size_dmp_message( check_array_size_1d( nr, pres ),  &
  &                                     "grad_wind_pres" )
  end if

  do i=1,nr
     if(r(i)/=0.0d0)then
        grad(i)=rho(i)*(v(i)*v(i)/r(i)+coril(i)*v(i))
     else
        grad(i)=0.0d0
     end if
  end do

  do i=1,nr
     if(r(i)<r_ref)then
        call rectangle_int( r, grad, r(i), r_ref, pres(i) )
        pres(i)=p_ref-pres(i)
     else if(r(i)>r_ref)then
        call rectangle_int( r, grad, r_ref, r(i), pres(i) )
        pres(i)=p_ref+pres(i)
     else
        pres(i)=p_ref
     end if
  end do

end subroutine grad_wind_pres_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine pres_grad_wind_f( r, coril, pres, rho, v )
!  ׻.
  implicit none
  real, intent(in) :: r(:)  ! r ΰֺɸ [m]
  real, intent(in) :: coril(size(r))  ! ꥪѥ᡼ [/s]
  real, intent(in) :: pres(size(r))  ! ʿդǤε [Pa]
  real, intent(in) :: rho(size(r))  ! ̩ [kg/m^3]
  real, intent(inout) :: v(size(r))  ! r ΰֺɸ [m]
  integer :: i, nr
  real :: grad(size(r)), tmp(size(r))

  nr=size(r)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nr, coril ),  &
  &                                     "pres_grad_wind" )
     call check_array_size_dmp_message( check_array_size_1d( nr, v ),  &
  &                                     "pres_grad_wind" )
     call check_array_size_dmp_message( check_array_size_1d( nr, rho ),  &
  &                                     "pres_grad_wind" )
     call check_array_size_dmp_message( check_array_size_1d( nr, pres ),  &
  &                                     "pres_grad_wind" )
  end if

  call grad_1d( r, pres, grad )

  do i=1,nr
     if(r(i)/=0.0)then
        tmp(i)=4.0*grad(i)/(rho(i)*coril(i)*coril(i)*r(i))
        v(i)=0.5*coril(i)*r(i)*(-1.0+sqrt(1.0+tmp(i)))
     else
        v(i)=0.0
     end if
  end do

end subroutine pres_grad_wind_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine pres_grad_wind_d( r, coril, pres, rho, v )
!  ׻.
  implicit none
  double precision, intent(in) :: r(:)  ! r ΰֺɸ [m]
  double precision, intent(in) :: coril(size(r))  ! ꥪѥ᡼ [/s]
  double precision, intent(in) :: pres(size(r))  ! ʿդǤε [Pa]
  double precision, intent(in) :: rho(size(r))  ! ̩ [kg/m^3]
  double precision, intent(inout) :: v(size(r))  ! r ΰֺɸ [m]
  integer :: i, nr
  double precision :: grad(size(r)), tmp(size(r))

  nr=size(r)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nr, coril ),  &
  &                                     "pres_grad_wind" )
     call check_array_size_dmp_message( check_array_size_1d( nr, v ),  &
  &                                     "pres_grad_wind" )
     call check_array_size_dmp_message( check_array_size_1d( nr, rho ),  &
  &                                     "pres_grad_wind" )
     call check_array_size_dmp_message( check_array_size_1d( nr, pres ),  &
  &                                     "pres_grad_wind" )
  end if

  call grad_1d( r, pres, grad )

  do i=1,nr
     if(r(i)/=0.0d0)then
        tmp(i)=4.0d0*grad(i)/(rho(i)*coril(i)*coril(i)*r(i))
        v(i)=0.5d0*coril(i)*r(i)*(-1.0d0+dsqrt(1.0d0+tmp(i)))
     else
        v(i)=0.0d0
     end if
  end do

end subroutine pres_grad_wind_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine SPLB_Kurihara_f( axopt, phi0, x, y, Lx, Ly, ival, oval,  &
  &                         optm, optnx, optny )
! Kurihara etal. (1990) ˤʪ̤˴ޤޤǤդȿʬ
! ե륿Ȥ롼.
! , optn Ϳ, Nguyen and Chen (2011) ˤ
! ǡбνǤǽ.
! Ѥ뼰 Nguyen and Chen (2011)  (3), (4), (5) .
! n=1 ξ, Kurihara etal. (1990) μˡ˰פ.

  use Math_Const
  use Phys_Const

  implicit none

  character(2), intent(in) :: axopt     ! ׻ɸ 'xy' or 'll'
                                        ! dx, dy ñ̤˱ƶ.
  real, intent(in) :: phi0     !  [rad]
  real, intent(in) :: x(:)     ! ival Ǥγʻ [m] or [rad]
  real, intent(in) :: y(:)     ! ival Ǥγʻ [m] or [rad]
  real, intent(in) :: Lx(2)    ! ե륿 x ΰ [m] or [rad]
  real, intent(in) :: Ly(2)    ! ե륿 y ΰ [m] or [rad]
  real, intent(in) :: ival(size(x),size(y))    ! ե륿Ȥѿ
  real, intent(inout) :: oval(size(x),size(y)) ! ե륿Ȥ줿ѿ
  integer, intent(in), optional :: optm(:)  ! ե륿Ȥȿ
                                  ! ǥեȤ 8 ȿ, 11 
                                  ! 2,3,4,2,5,6,7,2,8,9,2
  integer, intent(in), optional :: optnx(:)  ! Ǥγʻ
  integer, intent(in), optional :: optny(:)  ! Ǥγʻ

  integer :: nx, ny, m, n, nnx, nny
  integer :: i, j, k, l
  integer, dimension(2) :: ilx, ily
  integer, allocatable, dimension(:) :: qnx, qny
  real :: dx, dy
  real, allocatable, dimension(:) :: Km
  real :: tmpval(size(x),size(y))

  nx=size(x)
  ny=size(y)

!-- dx, dy  m ñ̤

  if(axopt(1:2)=='xy')then
     dx=x(2)-x(1)
     dy=y(2)-y(1)
  else if(axopt(1:2)=='ll')then
     dx=radius*cos(phi0)*(x(2)-x(1))
     dy=radius*(y(2)-y(1))
  else
     write(*,*) "*** ERROR (SPLB_Kurihara) *** : axopt is invalid."
     stop
  end if

write(*,*) "dx", dx, dy
!-- ե륿η׻

  if(present(optm))then
     m=size(optm)
     allocate(Km(m))
     do i=1,m
        Km(i)=0.5/(1.0-cos(2.0*pi/real(optm(i))))
     end do
  else
     allocate(Km(11))
     Km=(/0.25,                        &  ! m=2
  &       1.0/3.0,                     &  ! m=3
  &       0.5,                         &  ! m=4
  &       0.25,                        &  ! m=2
  &       0.5/(1.0-cos(0.4*pi)),       &  ! m=5
  &       1.0,                         &  ! m=6
  &       0.5/(1.0-cos(2.0*pi/7.0)),   &  ! m=7
  &       0.25,                        &  ! m=2
  &       0.5/(1.0-cos(0.25*pi)),      &  ! m=8
  &       0.5/(1.0-cos(2.0*pi/9.0)),   &  ! m=9
  &       0.25/)                          ! m=2
     m=11
  end if

write(*,*) "Km", Km
!-- ǤǤ 3 ʻҤΰ֤׻.

  if(present(optnx))then
     nnx=size(optnx)
  else   ! Original filterring according to Kurihara et al. (1990)
     nnx=1
  end if

  if(present(optny))then
     nny=size(optny)
  else   ! Original filterring according to Kurihara et al. (1990)
     nny=1
  end if

  allocate(qnx(nnx))
  allocate(qny(nny))


  if(nnx>1)then
     do i=1,nnx
        qnx(i)=int(radius*(pi/180.0)*cos(phi0)/(real(optnx(i))*dx))
     end do
  else
     qnx(1)=int(radius*(pi/180.0)*cos(phi0)/dx)
  end if

  if(qnx(1)<1)then
     qnx(1)=1
  end if

  if(nny>1)then
     do i=1,nny
        qny(i)=int(radius*(pi/180.0)/(real(optny(i))*dy))
     end do
  else
     qny(1)=int(radius*(pi/180.0)/dy)
  end if

  if(qny(1)<1)then
     qny(1)=1
  end if

write(*,*) "nnx", nnx, nny, qnx, qny
!-- ե륿ΰγʻֹ򸡺

  call interpo_search_1d( x, Lx(1), ilx(1), stdopt=.true. )
  call interpo_search_1d( x, Lx(2), ilx(2), stdopt=.true. )
  call interpo_search_1d( y, Ly(1), ily(1), stdopt=.true. )
  call interpo_search_1d( y, Ly(2), ily(2), stdopt=.true. )

  if(ilx(1)-qnx(1)<1)then
     write(*,*) "*** ERROR (SPLB_Kurihara) *** : Lx(1) is out of range."
     write(*,*) "Over number = ", ilx(1)-qnx(1)
     stop
  end if
  if(ilx(2)+qnx(1)>nx)then
     write(*,*) "*** ERROR (SPLB_Kurihara) *** : Lx(2) is out of range."
     write(*,*) "Over number = ", ilx(2)+qnx(1)
     stop
  end if
  if(ily(1)-qny(1)<1)then
     write(*,*) "*** ERROR (SPLB_Kurihara) *** : Ly(1) is out of range."
     write(*,*) "Over number = ", ily(1)-qny(1)
     stop
  end if
  if(ily(2)+qny(1)>ny)then
     write(*,*) "*** ERROR (SPLB_Kurihara) *** : Ly(2) is out of range."
     write(*,*) "Over number = ", ily(2)+qny(1)
     stop
  end if

write(*,*) "ilx", ilx, ily, Lx, Ly, x(ilx(1)), x(ilx(2)), y(ily(1)), y(ily(2))
  tmpval=ival
  oval=ival

!-- ʬե륿

  do l=1,nnx
     do k=1,m

        do j=ily(1),ily(2)
           do i=ilx(1),ilx(2)
              oval(i,j)=tmpval(i,j)  &
  &                    +Km(k)*(tmpval(i-qnx(l),j)+tmpval(i+qnx(l),j)  &
  &                            -2.0*tmpval(i,j))
           end do
        end do

        tmpval=oval

     end do
  end do

!-- ʬե륿

  do l=1,nny
     do k=1,m

        do j=ily(1),ily(2)
           do i=ilx(1),ilx(2)
              oval(i,j)=tmpval(i,j)  &
  &                    +Km(k)*(tmpval(i,j-qny(l))+tmpval(i,j+qny(l))  &
  &                            -2.0*tmpval(i,j))
           end do
        end do

        tmpval=oval

     end do
  end do

end subroutine SPLB_Kurihara_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine SPLB_Kurihara_d( axopt, phi0, x, y, Lx, Ly, ival, oval,  &
  &                         optm, optnx, optny )
! Kurihara etal. (1990) ˤʪ̤˴ޤޤǤդȿʬ
! ե륿Ȥ롼.
! , optn Ϳ, Nguyen and Chen (2011) ˤ
! ǡбνǤǽ.
! Ѥ뼰 Nguyen and Chen (2011)  (3), (4), (5) .
! n=1 ξ, Kurihara etal. (1990) μˡ˰פ.

  use Math_Const
  use Phys_Const

  implicit none

  character(2), intent(in) :: axopt     ! ׻ɸ 'xy' or 'll'
                                        ! dx, dy ñ̤˱ƶ.
  double precision, intent(in) :: phi0     !  [rad]
  double precision, intent(in) :: x(:)     ! ival Ǥγʻ [m] or [rad]
  double precision, intent(in) :: y(:)     ! ival Ǥγʻ [m] or [rad]
  double precision, intent(in) :: Lx(2)    ! ե륿 x ΰ [m] or [rad]
  double precision, intent(in) :: Ly(2)    ! ե륿 y ΰ [m] or [rad]
  double precision, intent(in) :: ival(size(x),size(y))    ! ե륿Ȥѿ
  double precision, intent(inout) :: oval(size(x),size(y)) ! ե륿Ȥ줿ѿ
  integer, intent(in), optional :: optm(:)  ! ե륿Ȥȿ
                                  ! ǥեȤ 8 ȿ, 11 
                                  ! 2,3,4,2,5,6,7,2,8,9,2
  integer, intent(in), optional :: optnx(:)  ! Ǥγʻ
  integer, intent(in), optional :: optny(:)  ! Ǥγʻ

  integer :: nx, ny, m, n, nnx, nny
  integer :: i, j, k, l
  integer, dimension(2) :: ilx, ily
  integer, allocatable, dimension(:) :: qnx, qny
  double precision :: dx, dy
  double precision, allocatable, dimension(:) :: Km
  double precision :: tmpval(size(x),size(y))

  nx=size(x)
  ny=size(y)

!-- dx, dy  m ñ̤

  if(axopt(1:2)=='xy')then
     dx=x(2)-x(1)
     dy=y(2)-y(1)
  else if(axopt(1:2)=='ll')then
     dx=radius_dp*dcos(phi0)*(x(2)-x(1))
     dy=radius_dp*(y(2)-y(1))
  else
     write(*,*) "*** ERROR (SPLB_Kurihara) *** : axopt is invalid."
     stop
  end if

write(*,*) "dx", dx, dy
!-- ե륿η׻

  if(present(optm))then
     m=size(optm)
     allocate(Km(m))
     do i=1,m
        Km(i)=0.5d0/(1.0d0-dcos(2.0d0*pi_dp/dble(optm(i))))
     end do
  else
     allocate(Km(11))
     Km=(/0.25d0,                           &  ! m=2
  &       1.0d0/3.0d0,                      &  ! m=3
  &       0.5d0,                            &  ! m=4
  &       0.25d0,                           &  ! m=2
  &       0.5d0/(1.0d0-dcos(0.4d0*pi_dp)),  &  ! m=5
  &       1.0d0,                            &  ! m=6
  &       0.5d0/(1.0d0-dcos(2.0d0*pi_dp/7.0d0)),  &  ! m=7
  &       0.25d0,                           &  ! m=2
  &       0.5d0/(1.0d0-dcos(0.25d0*pi_dp)), &  ! m=8
  &       0.5d0/(1.0d0-dcos(2.0d0*pi_dp/9.0d0)),  &  ! m=9
  &       0.25d0/)                             ! m=2
     m=11
  end if

write(*,*) "Km", Km
!-- ǤǤ 3 ʻҤΰ֤׻.

  if(present(optnx))then
     nnx=size(optnx)
  else   ! Original filterring according to Kurihara et al. (1990)
     nnx=1
  end if

  if(present(optny))then
     nny=size(optny)
  else   ! Original filterring according to Kurihara et al. (1990)
     nny=1
  end if

  allocate(qnx(nnx))
  allocate(qny(nny))


  if(nnx>1)then
     do i=1,nnx
        qnx(i)=int(radius_dp*(pi_dp/180.0d0)*dcos(phi0)/(dble(optnx(i))*dx))
     end do
  else
     qnx(1)=int(radius_dp*(pi_dp/180.0d0)*dcos(phi0)/dx)
  end if

  if(qnx(1)<1)then
     qnx(1)=1
  end if

  if(nny>1)then
     do i=1,nny
        qny(i)=int(radius_dp*(pi/180.0d0)/(dble(optny(i))*dy))
     end do
  else
     qny(1)=int(radius_dp*(pi_dp/180.0d0)/dy)
  end if

  if(qny(1)<1)then
     qny(1)=1
  end if

write(*,*) "nnx", nnx, nny, qnx, qny
!-- ե륿ΰγʻֹ򸡺

  call interpo_search_1d( x, Lx(1), ilx(1), stdopt=.true. )
  call interpo_search_1d( x, Lx(2), ilx(2), stdopt=.true. )
  call interpo_search_1d( y, Ly(1), ily(1), stdopt=.true. )
  call interpo_search_1d( y, Ly(2), ily(2), stdopt=.true. )

  if(ilx(1)-qnx(1)<1)then
     write(*,*) "*** ERROR (SPLB_Kurihara) *** : Lx(1) is out of range."
     write(*,*) "Over number = ", ilx(1)-qnx(1)
     stop
  end if
  if(ilx(2)+qnx(1)>nx)then
     write(*,*) "*** ERROR (SPLB_Kurihara) *** : Lx(2) is out of range."
     write(*,*) "Over number = ", ilx(2)+qnx(1)
     stop
  end if
  if(ily(1)-qny(1)<1)then
     write(*,*) "*** ERROR (SPLB_Kurihara) *** : Ly(1) is out of range."
     write(*,*) "Over number = ", ily(1)-qny(1)
     stop
  end if
  if(ily(2)+qny(1)>ny)then
     write(*,*) "*** ERROR (SPLB_Kurihara) *** : Ly(2) is out of range."
     write(*,*) "Over number = ", ily(2)+qny(1)
     stop
  end if

write(*,*) "ilx", ilx, ily, Lx, Ly, x(ilx(1)), x(ilx(2)), y(ily(1)), y(ily(2))
  tmpval=ival
  oval=ival

!-- ʬե륿

  do l=1,nnx
     do k=1,m

        do j=ily(1),ily(2)
           do i=ilx(1),ilx(2)
              oval(i,j)=tmpval(i,j)  &
  &                    +Km(k)*(tmpval(i-qnx(l),j)+tmpval(i+qnx(l),j)  &
  &                            -2.0d0*tmpval(i,j))
           end do
        end do

        tmpval=oval

     end do
  end do

!-- ʬե륿

  do l=1,nny
     do k=1,m

        do j=ily(1),ily(2)
           do i=ilx(1),ilx(2)
              oval(i,j)=tmpval(i,j)  &
  &                    +Km(k)*(tmpval(i,j-qny(l))+tmpval(i,j+qny(l))  &
  &                            -2.0d0*tmpval(i,j))
           end do
        end do

        tmpval=oval

     end do
  end do

end subroutine SPLB_Kurihara_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine CPS_Hart_f( x, y, center, z300, z600, z900, mv, B, VTL, VTU )
! ȫ (2011; ŷ) ˴Ť, Hart (2003a) 㵤֥ѥ᡼
! γʬ׻.
! ׻ϰʲ.
! (1) ư () η : atan(mv(2)/mv(1))
! (2) 500 km ϰǤʿѲ.
!     ư (1)  rad ѴƤΤ, tangen_mean 롼
!     Ǥճ rad ΤߤʿѲԤ.
! (3) 500 km ϰǤκǾͤη׻.
!     (1) Ƥ rad 󤫤, 500 km ʱγʻҤ˴ؤƤ
!     undef ͿƤ, max_min ⥸塼Ѥ.
! [] : ͤȾꤷƷ׻ƤΤ,
!          ȾŬѤݤ,  B ͿФ褤.
!          ޤ, ܥ롼Ѥݤ p ɸϤǹԤ뤳ȤꤷƤ.

  use Math_Const

  implicit none

  real, intent(in) :: x(:)  ! x κɸ [m]
  real, intent(in) :: y(:)  ! y κɸ [m]
  real, intent(in) :: center(2)
                         ! 㵤濴ɸ [m].
                         ! 줾 x, y ʬκɸб.
  real, intent(in) :: z300(size(x),size(y))
                      ! 300 hPa ̤ǤΥݥƥ󥷥 [m]
  real, intent(in) :: z600(size(x),size(y))
                      ! 600 hPa ̤ǤΥݥƥ󥷥 [m]
  real, intent(in) :: z900(size(x),size(y))
                      ! 900 hPa ̤ǤΥݥƥ󥷥 [m]
  real, intent(in) :: mv(2)   ! ư®٤ x, y ʬ [m/s].
  real, intent(inout) :: B    ! ѥ᡼
  real, intent(inout) :: VTL  ! زٳ˹¤
  real, intent(inout) :: VTU  ! زٳ˹¤
  integer :: nx, ny, i, j, nr, nt
  integer :: irad, itmp
  real, parameter :: rcalc=500.0e3   ! ׻ϰ [m].
  real, parameter :: undef=-1.0e6
  real :: radt, dzmax3, dzmax6, dzmax9, dzmin3, dzmin6, dzmin9, rb, lb
  real, dimension(size(x),size(y)) :: thick, tmpz3, tmpz6, tmpz9
  real, allocatable, dimension(:) :: theta   !  [rad].
  real, allocatable, dimension(:) :: r       ! 濴εΥ [m].
  real, allocatable, dimension(:) :: tmpr, tmpl

  nx=size(x)
  ny=size(y)
  nr=nx

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, z300 ),  &
  &                                     "CPS_Hart" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, z600 ),  &
  &                                     "CPS_Hart" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, z900 ),  &
  &                                     "CPS_Hart" )
  end if

  allocate(r(nr))
  allocate(tmpr(nr))
  allocate(tmpl(nr))
  r=(/(((x(2)-x(1))*real(i-1)),i=1,nr)/)
  nt=int(2.0*pi*rcalc/(x(2)-x(1)))
  write(*,*) "*** MESSAGE (CPS_Hart:typhoon_analy) ***"
  write(*,*) "theta number is set of ", nt
  allocate(theta(nt))

  !-- (1) ưη׻
  if(mv(1)>=0.0.and.mv(2)>=0.0)then        ! ݸ
     if(mv(1)==0.0.and.mv(2)==0.0)then
        radt=0.0
     else if(mv(1)==0.0)then
        radt=0.5*pi
     else if(mv(2)==0.0)then
        radt=0.0
     else
        radt=atan(mv(2)/mv(1))
     end if
  else if(mv(1)<0.0.and.mv(2)>=0.0)then    ! ݸ
     radt=acos(mv(1)/sqrt(mv(1)**2+mv(2)**2))
  else if(mv(1)<0.0.and.mv(2)<0.0)then     ! 軰ݸ
     radt=pi+atan(abs(mv(2))/abs(mv(1)))
  else if(mv(1)>=0.0.and.mv(2)<0.0)then    ! ;ݸ
     radt=asin(mv(2)/sqrt(mv(1)**2+mv(2)**2))
  end if

  if(0.0>radt)then
     radt=radt+2.0*pi
  else if(2.0*pi<radt)then
     radt=radt-2.0*pi
  end if

  theta=(/((radt+2.0*pi*real(i-1)/real(nt)),i=1,nt)/)

  call interpo_search_1d( r, rcalc, irad )

  !-- 500 km ʱ undef .
  thick=undef
  tmpz3=undef
  tmpz6=undef
  tmpz9=undef

  do j=1,ny
     do i=1,nx
        if(sqrt((x(i)-center(1))**2+(y(j)-center(2))**2)<=rcalc)then
           thick(i,j)=z600(i,j)-z900(i,j)
           tmpz3(i,j)=z300(i,j)
           tmpz6(i,j)=z600(i,j)
           tmpz9(i,j)=z900(i,j)
        end if
     end do
  end do

  !-- (2) 500 km Ǥʿ
  call tangent_mean_scal_f( x, y, center(1), center(2), thick,  &
  &                         r(1:irad), theta(1:nt/2), tmpl(1:irad),  &
  &                         undef=undef, undefg=undef, undefgc='inc' )
  call tangent_mean_scal_f( x, y, center(1), center(2), thick,  &
  &                         r(1:irad), theta(nt/2+1:nt), tmpr(1:irad),  &
  &                         undef=undef, undefg=undef, undefgc='inc' )

  do i=1,irad
     tmpr(i)=tmpr(i)*r(i)
     tmpl(i)=tmpl(i)*r(i)
  end do

  call rectangle_int( r, tmpr, r(1), r(irad), rb )
  call rectangle_int( r, tmpl, r(1), r(irad), lb )

  rb=rb/(r(irad)**2-r(1)**2)
  lb=lb/(r(irad)**2-r(1)**2)

  !-- (3) 500 km Ǥκ, Ǿ
  call max_val_2d( tmpz3, itmp, itmp, dzmax3, undef=undef )
  call max_val_2d( tmpz6, itmp, itmp, dzmax6, undef=undef )
  call max_val_2d( tmpz9, itmp, itmp, dzmax9, undef=undef )
  call min_val_2d( tmpz3, itmp, itmp, dzmin3, undef=undef )
  call min_val_2d( tmpz6, itmp, itmp, dzmin6, undef=undef )
  call min_val_2d( tmpz9, itmp, itmp, dzmin9, undef=undef )

  B=(rb-lb)
  VTL=((dzmax6-dzmin6)-(dzmax9-dzmin9))/(log(2.0/3.0))
  VTU=((dzmax3-dzmin3)-(dzmax6-dzmin6))/(log(0.5))

end subroutine CPS_Hart_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine CPS_Hart_d( x, y, center, z300, z600, z900, mv, B, VTL, VTU )
! ȫ (2011; ŷ) ˴Ť, Hart (2003a) 㵤֥ѥ᡼
! γʬ׻.
! ׻ϰʲ.
! (1) ư () η : atan(mv(2)/mv(1))
! (2) 500 km ϰǤʿѲ.
!     ư (1)  rad ѴƤΤ, tangen_mean 롼
!     Ǥճ rad ΤߤʿѲԤ.
! (3) 500 km ϰǤκǾͤη׻.
!     (1) Ƥ rad 󤫤, 500 km ʱγʻҤ˴ؤƤ
!     undef ͿƤ, max_min ⥸塼Ѥ.
! [] : ͤȾꤷƷ׻ƤΤ,
!          ȾŬѤݤ,  B ͿФ褤.
!          ޤ, ܥ롼Ѥݤ p ɸϤǹԤ뤳ȤꤷƤ.

  use Math_Const

  implicit none

  double precision, intent(in) :: x(:)  ! x κɸ [m]
  double precision, intent(in) :: y(:)  ! y κɸ [m]
  double precision, intent(in) :: center(2)
                         ! 㵤濴ɸ [m].
                         ! 줾 x, y ʬκɸб.
  double precision, intent(in) :: z300(size(x),size(y))
                      ! 300 hPa ̤ǤΥݥƥ󥷥 [m]
  double precision, intent(in) :: z600(size(x),size(y))
                      ! 600 hPa ̤ǤΥݥƥ󥷥 [m]
  double precision, intent(in) :: z900(size(x),size(y))
                      ! 900 hPa ̤ǤΥݥƥ󥷥 [m]
  double precision, intent(in) :: mv(2)   ! ư®٤ x, y ʬ [m/s].
  double precision, intent(inout) :: B    ! ѥ᡼
  double precision, intent(inout) :: VTL  ! زٳ˹¤
  double precision, intent(inout) :: VTU  ! زٳ˹¤
  integer :: nx, ny, i, j, nr, nt
  integer :: irad, itmp
  double precision, parameter :: rcalc=500.0e3   ! ׻ϰ [m].
  double precision, parameter :: undef=-1.0e6
  double precision :: radt, dzmax3, dzmax6, dzmax9, dzmin3, dzmin6, dzmin9, rb, lb
  double precision, dimension(size(x),size(y)) :: thick, tmpz3, tmpz6, tmpz9
  double precision, allocatable, dimension(:) :: theta   !  [rad].
  double precision, allocatable, dimension(:) :: r       ! 濴εΥ [m].
  double precision, allocatable, dimension(:) :: tmpr, tmpl

  nx=size(x)
  ny=size(y)
  nr=nx

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, z300 ),  &
  &                                     "CPS_Hart" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, z600 ),  &
  &                                     "CPS_Hart" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, z900 ),  &
  &                                     "CPS_Hart" )
  end if

  allocate(r(nr))
  allocate(tmpr(nr))
  allocate(tmpl(nr))
  r=(/(((x(2)-x(1))*dble(i-1)),i=1,nr)/)
  nt=int(2.0d0*pi_dp*rcalc/(x(2)-x(1)))
  write(*,*) "*** MESSAGE (CPS_Hart:typhoon_analy) ***"
  write(*,*) "theta number is set of ", nt
  allocate(theta(nt))

  !-- (1) ưη׻
  if(mv(1)>=0.0d0.and.mv(2)>=0.0d0)then        ! ݸ
     if(mv(1)==0.0d0.and.mv(2)==0.0d0)then
        radt=0.0d0
     else if(mv(1)==0.0d0)then
        radt=0.5d0*pi_dp
     else if(mv(2)==0.0d0)then
        radt=0.0d0
     else
        radt=datan(mv(2)/mv(1))
     end if
  else if(mv(1)<0.0d0.and.mv(2)>=0.0d0)then    ! ݸ
     radt=dacos(mv(1)/dsqrt(mv(1)**2+mv(2)**2))
  else if(mv(1)<0.0d0.and.mv(2)<0.0d0)then     ! 軰ݸ
     radt=pi_dp+datan(dabs(mv(2))/dabs(mv(1)))
  else if(mv(1)>=0.0d0.and.mv(2)<0.0d0)then    ! ;ݸ
     radt=dasin(mv(2)/dsqrt(mv(1)**2+mv(2)**2))
  end if

  if(0.0d0>radt)then
     radt=radt+2.0d0*pi_dp
  else if(2.0d0*pi_dp<radt)then
     radt=radt-2.0d0*pi_dp
  end if

  theta=(/((radt+2.0d0*pi_dp*dble(i-1)/dble(nt)),i=1,nt)/)

  call interpo_search_1d( r, rcalc, irad )

  !-- 500 km ʱ undef .
  thick=undef
  tmpz3=undef
  tmpz6=undef
  tmpz9=undef

  do j=1,ny
     do i=1,nx
        if(dsqrt((x(i)-center(1))**2+(y(j)-center(2))**2)<=rcalc)then
           thick(i,j)=z600(i,j)-z900(i,j)
           tmpz3(i,j)=z300(i,j)
           tmpz6(i,j)=z600(i,j)
           tmpz9(i,j)=z900(i,j)
        end if
     end do
  end do

  !-- (2) 500 km Ǥʿ
  call tangent_mean_scal_d( x, y, center(1), center(2), thick,  &
  &                         r(1:irad), theta(1:nt/2), tmpl(1:irad),  &
  &                         undef=undef, undefg=undef, undefgc='inc' )
  call tangent_mean_scal_d( x, y, center(1), center(2), thick,  &
  &                         r(1:irad), theta(nt/2+1:nt), tmpr(1:irad),  &
  &                         undef=undef, undefg=undef, undefgc='inc' )

  do i=1,irad
     tmpr(i)=tmpr(i)*r(i)
     tmpl(i)=tmpl(i)*r(i)
  end do

  call rectangle_int( r, tmpr, r(1), r(irad), rb )
  call rectangle_int( r, tmpl, r(1), r(irad), lb )

  rb=rb/(r(irad)**2-r(1)**2)
  lb=lb/(r(irad)**2-r(1)**2)

  !-- (3) 500 km Ǥκ, Ǿ
  call max_val_2d( tmpz3, itmp, itmp, dzmax3, undef=undef )
  call max_val_2d( tmpz6, itmp, itmp, dzmax6, undef=undef )
  call max_val_2d( tmpz9, itmp, itmp, dzmax9, undef=undef )
  call min_val_2d( tmpz3, itmp, itmp, dzmin3, undef=undef )
  call min_val_2d( tmpz6, itmp, itmp, dzmin6, undef=undef )
  call min_val_2d( tmpz9, itmp, itmp, dzmin9, undef=undef )

  B=(rb-lb)
  VTL=((dzmax6-dzmin6)-(dzmax9-dzmin9))/(dlog(2.0d0/3.0d0))
  VTU=((dzmax3-dzmin3)-(dzmax6-dzmin6))/(dlog(0.5d0))

end subroutine CPS_Hart_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine DC_Braun_f( x, y, fg, pres, search_dis, var_dis, center, undef,  &
  &                    stdopt )
! Braun (2002) ˡ濴ꤹ.
  use Math_Const
  implicit none
  real, intent(in) :: x(:)  ! x κɸ [m]
  real, intent(in) :: y(:)  ! y κɸ [m]
  integer, intent(in) :: fg(2)
                         ! 濴 (̾ﵤκ)
                         ! fg(1) = x ֹ, fg(2) = y ֹ
  real, intent(in) :: pres(size(x),size(y))
                         ! ٤Ǥε (ɽ̵Ǥ褤.)
                         ! , ɽ̵ξ, ̹Ƥ.
  real, intent(in) :: search_dis  ! ΰ (fg ΰ֤濴)
                         ! 㤨, 100000.0 ʤ, fg 濴˽Ĳ 100 km 
  real, intent(in) :: var_dis  ! 濴֤к׻Ⱦ [m]
  integer, intent(inout) :: center(2)  ! ᤿濴γǿ
  real, intent(in), optional :: undef  ! ̤ͤ, ̤.
                             ! ܥ롼Ǥ, ̤ͤ, 
                             ! γʻΤк׻˻Ѥʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)

  integer :: i, j, ix, jy, nx, ny, nr, nt, nxgmin, nxgmax, nygmin, nygmax
  integer :: ompnum, tmp_o_num
  real :: dr, dtheta, undeff, tmpmin, tmp_anom, tmp_counter
  real, allocatable, dimension(:) :: rad, theta
  real, allocatable, dimension(:,:) :: anom_check
  real, allocatable, dimension(:,:,:) :: apres
  logical :: stderr

!-- OpenMP ؿ
!$ integer :: OMP_GET_THREAD_NUM, OMP_GET_MAX_THREADS

  nx=size(x)
  ny=size(y)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, pres ),  &
  &                                     "DC_Braun" )
  end if

  if(present(undef))then
     undeff=undef
  else
     undeff=-999.0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

!-- ʻϰϤ

  call interpo_search_2d( x, y, x(fg(1))-0.5*search_dis,  &
  &                             y(fg(2))-0.5*search_dis,  &
  &                       nxgmin, nygmin, undeff=int(undeff),  &
  &                       stdopt=stderr )

  call interpo_search_2d( x, y, x(fg(1))+0.5*search_dis,  &
  &                             y(fg(2))+0.5*search_dis,  &
  &                       nxgmax, nygmax, undeff=int(undeff),  &
  &                       stdopt=stderr )

  if(nxgmin==int(undeff))then  ! ΰ賰Ȥξν
     nxgmin=1
  end if
  if(nygmin==int(undeff))then  ! ΰ賰Ȥξν
     nygmin=1
  end if
  if(nxgmax==int(undeff))then  ! ΰ賰Ȥξν
     nxgmax=1
  end if
  if(nygmax==int(undeff))then  ! ΰ賰Ȥξν
     nygmax=1
  end if

!  nxgmin=fg(1)-(search_dis-1)/2
!  nxgmax=fg(1)+(search_dis-1)/2
!  nygmin=fg(2)-(search_dis-1)/2
!  nygmax=fg(2)+(search_dis-1)/2

  allocate(anom_check(nx,ny))

!-- openmp Ǥξդѥ
!-- ʿѥΥޥβս openmp 󤷤,
!-- apres  inout °ʤΤ, private °ꤷʤ
!-- thread Ȥ apres ͤ񤭤Ƥޤ.
!-- , threads number 򻲾Ȥ 3 ˤ,
!-- thread Ȥ̤Ȥ褦ѹ.

   ompnum=1
!$   ompnum=OMP_GET_MAX_THREADS()  ! OpenMP ͭξϤͭ.

  allocate(apres(nx,ny,ompnum))

!-- ϤؤѴκݤˤ, var_dis Ǥ٤ x, y ʤ褦
!-- ꤹ.

  nr=int(var_dis/(x(2)-x(1)))+1
  nt=int(2.0*pi*var_dis/(x(2)-x(1)))+1
!  nt=4
  dr=x(2)-x(1)
  dtheta=2.0*pi/real(nt-1)

  allocate(rad(nr))
  allocate(theta(nt))

  rad=(/((dr*real(i-1)),i=1,nr)/)
  theta=(/((dtheta*real(i-1)),i=1,nt)/)

!-- õʻˤĤ, ʿкȤ,
!-- Ƴʻˤкιפ׻.

  anom_check=undeff  ! õϰϳγʻˤϤ٤ undeff .
                     ! õϰγʻҤˤϤȤǥ.

  tmp_o_num=1  ! OpenMP ͭǤʤ, ͤ apres  3 ܤ

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,tmp_anom,tmp_o_num,tmp_counter)

  do j=nygmin,nygmax
     do i=nxgmin,nxgmax

        if(pres(i,j)/=undeff)then
!$         tmp_o_num=OMP_GET_THREAD_NUM()+1  ! OpenMP ͭξ, ͤ apres  3 ܤ

           apres(:,:,tmp_o_num)=0.0
           tmp_counter=0

           call tangent_mean_anom_scal_Cart_f( x, y, x(i), y(j), pres, rad, theta,  &
  &                                            apres(:,:,tmp_o_num), undef=undeff,  &
  &                                            undefg=undeff, undefgc='inc',  &
  &                                            stdopt=stderr )

           tmp_anom=0.0

           do jy=1,ny
              do ix=1,nx
                 if(apres(ix,jy,tmp_o_num)/=undeff)then
                    tmp_counter=tmp_counter+1
                    tmp_anom=tmp_anom+apres(ix,jy,tmp_o_num)*apres(ix,jy,tmp_o_num)
                 end if
              end do
           end do

           if(tmp_counter>0)then  ! ʿѤ undef ʤȤϹʤ.
              anom_check(i,j)=tmp_anom
           end if
        end if
     end do
  end do

!$omp end do
!$omp end parallel

!-- ׻кιͤΤ, ǾȤʤʻ.

  call min_val_2d( anom_check, center(1), center(2), tmpmin, undef=undeff )

  if(stderr.eqv..false.)then
     if(center(1)==nx+1.or.center(2)==ny+1)then
        write(*,*) "*** WARNING *** : DC_Braun (typhoon_analy)"
        write(*,*) "Setting the undef only point."
     end if
  end if

  deallocate(rad)
  deallocate(theta)
  deallocate(anom_check)
  deallocate(apres)

end subroutine DC_Braun_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine DC_Braun_d( x, y, fg, pres, search_dis, var_dis, center, undef,  &
  &                    stdopt )
! Braun (2002) ˡ濴ꤹ.
  use Math_Const
  implicit none
  double precision, intent(in) :: x(:)  ! x κɸ [m]
  double precision, intent(in) :: y(:)  ! y κɸ [m]
  integer, intent(in) :: fg(2)
                         ! 濴 (̾ﵤκ)
                         ! fg(1) = x ֹ, fg(2) = y ֹ
  double precision, intent(in) :: pres(size(x),size(y))
                         ! ٤Ǥε (ɽ̵Ǥ褤.)
                         ! , ɽ̵ξ, ̹Ƥ.
  double precision, intent(in) :: search_dis  ! ΰ (fg ΰ֤濴)
                         ! 㤨, 100000.0 ʤ, fg 濴˽Ĳ 100 km 
  double precision, intent(in) :: var_dis  ! 濴֤к׻Ⱦ [m]
  integer, intent(inout) :: center(2)  ! ᤿濴γǿ
  double precision, intent(in), optional :: undef  ! ̤ͤ, ̤.
                             ! ܥ롼Ǥ, ̤ͤ, 
                             ! γʻΤк׻˻Ѥʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)

  integer :: i, j, ix, jy, nx, ny, nr, nt, nxgmin, nxgmax, nygmin, nygmax
  integer :: ompnum, tmp_o_num
  double precision :: dr, dtheta, undeff, tmpmin, tmp_anom, tmp_counter
  double precision, allocatable, dimension(:) :: rad, theta
  double precision, allocatable, dimension(:,:) :: anom_check
  double precision, allocatable, dimension(:,:,:) :: apres
  logical :: stderr

!-- OpenMP ؿ
!$ integer :: OMP_GET_THREAD_NUM, OMP_GET_MAX_THREADS

  nx=size(x)
  ny=size(y)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, pres ),  &
  &                                     "DC_Braun" )
  end if

  if(present(undef))then
     undeff=undef
  else
     undeff=-999.0d0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

!-- ʻϰϤ

  call interpo_search_2d( x, y, x(fg(1))-0.5d0*search_dis,  &
  &                             y(fg(2))-0.5d0*search_dis,  &
  &                       nxgmin, nygmin, undeff=int(undeff),  &
  &                       stdopt=stderr )

  call interpo_search_2d( x, y, x(fg(1))+0.5d0*search_dis,  &
  &                             y(fg(2))+0.5d0*search_dis,  &
  &                       nxgmax, nygmax, undeff=int(undeff),  &
  &                       stdopt=stderr )

  if(nxgmin==int(undeff))then  ! ΰ賰Ȥξν
     nxgmin=1
  end if
  if(nygmin==int(undeff))then  ! ΰ賰Ȥξν
     nygmin=1
  end if
  if(nxgmax==int(undeff))then  ! ΰ賰Ȥξν
     nxgmax=1
  end if
  if(nygmax==int(undeff))then  ! ΰ賰Ȥξν
     nygmax=1
  end if

!  nxgmin=fg(1)-(search_dis-1)/2
!  nxgmax=fg(1)+(search_dis-1)/2
!  nygmin=fg(2)-(search_dis-1)/2
!  nygmax=fg(2)+(search_dis-1)/2

  allocate(anom_check(nx,ny))

!-- openmp Ǥξդѥ
!-- ʿѥΥޥβս openmp 󤷤,
!-- apres  inout °ʤΤ, private °ꤷʤ
!-- thread Ȥ apres ͤ񤭤Ƥޤ.
!-- , threads number 򻲾Ȥ 3 ˤ,
!-- thread Ȥ̤Ȥ褦ѹ.

   ompnum=1
!$   ompnum=OMP_GET_MAX_THREADS()  ! OpenMP ͭξϤͭ.

  allocate(apres(nx,ny,ompnum))

!-- ϤؤѴκݤˤ, var_dis Ǥ٤ x, y ʤ褦
!-- ꤹ.

  nr=int(var_dis/(x(2)-x(1)))+1
  nt=int(2.0d0*pi_dp*var_dis/(x(2)-x(1)))+1
!  nt=4
  dr=x(2)-x(1)
  dtheta=2.0d0*pi_dp/dble(nt-1)

  allocate(rad(nr))
  allocate(theta(nt))

  rad=(/((dr*dble(i-1)),i=1,nr)/)
  theta=(/((dtheta*dble(i-1)),i=1,nt)/)

!-- õʻˤĤ, ʿкȤ,
!-- Ƴʻˤкιפ׻.

  anom_check=undeff  ! õϰϳγʻˤϤ٤ undeff .
                     ! õϰγʻҤˤϤȤǥ.

  tmp_o_num=1  ! OpenMP ͭǤʤ, ͤ apres  3 ܤ

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,tmp_anom,tmp_o_num,tmp_counter)

  do j=nygmin,nygmax
     do i=nxgmin,nxgmax

        if(pres(i,j)/=undeff)then
!$         tmp_o_num=OMP_GET_THREAD_NUM()+1  ! OpenMP ͭξ, ͤ apres  3 ܤ

           apres(:,:,tmp_o_num)=0.0
           tmp_counter=0

           call tangent_mean_anom_scal_Cart_d( x, y, x(i), y(j), pres, rad, theta,  &
  &                                            apres(:,:,tmp_o_num), undef=undeff,  &
  &                                            undefg=undeff, undefgc='inc',  &
  &                                            stdopt=stderr )

           tmp_anom=0.0d0

           do jy=1,ny
              do ix=1,nx
                 if(apres(ix,jy,tmp_o_num)/=undeff)then
                    tmp_counter=tmp_counter+1
                    tmp_anom=tmp_anom+apres(ix,jy,tmp_o_num)*apres(ix,jy,tmp_o_num)
                 end if
              end do
           end do

           if(tmp_counter>0)then  ! ʿѤ undef ʤȤϹʤ.
              anom_check(i,j)=tmp_anom
           end if
        end if
     end do
  end do

!$omp end do
!$omp end parallel

!-- ׻кιͤΤ, ǾȤʤʻ.

  call min_val_2d( anom_check, center(1), center(2), tmpmin, undef=undeff )

  if(stderr.eqv..false.)then
     if(center(1)==nx+1.or.center(2)==ny+1)then
        write(*,*) "*** WARNING *** : DC_Braun (typhoon_analy)"
        write(*,*) "Setting the undef only point."
     end if
  end if

  deallocate(rad)
  deallocate(theta)
  deallocate(anom_check)
  deallocate(apres)

end subroutine DC_Braun_d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine DC_Satellite( x, y, fg, temp, search_dis, center, undef,  &
  &                      smon, sig, stdopt )
! Jaiswal and Kishtawal (2011,IEEE) ˴Ť, ֳ͵ٲ٤οʿʬ
! Ȥ, 濴롼.
  use Math_Const
  implicit none
  real, intent(in) :: x(:)  ! x κɸ [m,deg]
  real, intent(in) :: y(:)  ! y κɸ [m,deg]
  integer, intent(in) :: fg(2)
                         ! 濴 (̾ﵤκ)
                         ! fg(1) = x ֹ, fg(2) = y ֹ
  real, intent(in) :: temp(size(x),size(y))
                         ! ¬줿ֳ͵ٲ [K]
  real, intent(in) :: search_dis  ! ΰ (fg ΰ֤濴) [m,deg]
                         ! 㤨, 100000.0 ʤ, fg 濴˽Ĳ 100 km 
                         ! Ϳͤñ̤ x,y ñ̤Ȱפ뤳.
  integer, intent(inout) :: center(2)  ! ᤿濴γǿ
  real, intent(in), optional :: undef  ! ٤̤ͤ, ̤.
                             ! ܥ롼Ǥ, ̤ͤ, 
                             ! γʻΤк׻˻Ѥʤ.
  integer, intent(in), optional :: smon  ! кȤʿѤ
                                         ! Ȥΰʻҿ ().
                         ! default ϥꥸʥ 20 x 20 km^2 γʻҿ.
  integer, intent(in), optional :: sig(2)  ! ʸǤ濴ѥե륿 sigma1, 2.
                             ! ͤꤵ, ʸǤκǽ
                             ! ܤ. ǥեȤǤϻܤʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)

  integer :: i, j, k, nx, ny, nxgmin, nxgmax, nygmin, nygmax
  integer :: ompnum, tmp_o_num, smnum, hsmnum, hsig, tmpi
  real, allocatable, dimension(:,:) :: dval, ddval
  integer, allocatable, dimension(:,:,:) :: dm
  real :: undeff, tmpa, tmpmin, tbmean, tbgaumean, tb2mean, gaut2mean
  real :: coe1, coe2, tempmin, tempmax
  real, allocatable, dimension(:,:) :: dtdx, dtdy, anom_temp
  real, allocatable, dimension(:,:) :: temp2, gaut, tbgau, gaut2
  logical :: stderr

!-- OpenMP ؿ
!$ integer :: OMP_GET_THREAD_NUM, OMP_GET_MAX_THREADS

  nx=size(x)
  ny=size(y)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, temp ),  &
  &                                     "DC_Satellite" )
  end if

  if(present(undef))then
     undeff=undef
  else
     undeff=-999.0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(smon))then
     smnum=smon
  else
     smnum=int(20.0e3/(x(2)-x(1)))
  end if
  if(mod(smnum,2)==0)then
     smnum=smnum+1
  end if
  hsmnum=(smnum-1)/2

!-- ʻϰϤ

  call interpo_search_2d( x, y, x(fg(1))-0.5*search_dis,  &
  &                             y(fg(2))-0.5*search_dis,  &
  &                       nxgmin, nygmin, undeff=int(undeff),  &
  &                       stdopt=stderr )

  call interpo_search_2d( x, y, x(fg(1))+0.5*search_dis,  &
  &                             y(fg(2))+0.5*search_dis,  &
  &                       nxgmax, nygmax, undeff=int(undeff),  &
  &                       stdopt=stderr )

  if(nxgmin==int(undeff).or.nxgmin<hsmnum+1)then  ! ΰ賰Ȥξν
     nxgmin=hsmnum+1
  end if
  if(nygmin==int(undeff).or.nygmin<hsmnum+1)then  ! ΰ賰Ȥξν
     nygmin=hsmnum+1
  end if
  if(nxgmax==int(undeff).or.nxgmax>nx-hsmnum-1)then  ! ΰ賰Ȥξν
     nxgmax=nx-hsmnum-1
  end if
  if(nygmax==int(undeff).or.nygmax>ny-hsmnum-1)then  ! ΰ賰Ȥξν
     nygmax=ny-hsmnum-1
  end if

  allocate(dtdx(nx,ny))
  allocate(dtdy(nx,ny))
  allocate(anom_temp(nx,ny))

  dtdx=0.0
  dtdy=0.0
  anom_temp=0.0

!-- openmp Ǥξդѥ
!-- ʿѥΥޥβս openmp 󤷤,
!-- apres  inout °ʤΤ, private °ꤷʤ
!-- thread Ȥ apres ͤ񤭤Ƥޤ.
!-- , threads number 򻲾Ȥ 3 ˤ,
!-- thread Ȥ̤Ȥ褦ѹ.

   ompnum=1
!$   ompnum=OMP_GET_MAX_THREADS()  ! OpenMP ͭξϤͭ.

  allocate(dval(nx,ny))
  allocate(ddval(nx,ny))
  allocate(dm(nx,ny,ompnum))

  dval=0.0
  dm=0

  tmp_o_num=1  ! OpenMP ͭǤʤ, ͤ apres  3 ܤ

!-- [1] ٤к.
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,tmpa)

  do j=nygmin-hsmnum,nygmax+hsmnum
     do i=hsmnum+1,nx-hsmnum
        call Mean_2d( temp(i-hsmnum:i+hsmnum,j-hsmnum:j+hsmnum), tmpa,  &
  &                   error=undeff )
        anom_temp(i,j)=abs(temp(i,j)-tmpa)
     end do
  end do

!$omp end do

!$omp barrier

!-- [2] кָۤ.

!$omp do schedule(runtime) private(i,j)

  do j=nygmin,nygmax
     do i=nxgmin,nxgmax
        dtdx(i,j)=anom_temp(i+hsmnum,j)-anom_temp(i-hsmnum,j)
        dtdy(i,j)=anom_temp(i,j+hsmnum)-anom_temp(i,j-hsmnum)
     end do
  end do

!$omp end do

!$omp barrier

!-- [3] ̩٥ޥȥꥯ.

!$omp do schedule(runtime) private(i,j,tmp_o_num)

  do j=nygmin,nygmax
     do i=nxgmin,nxgmax
!$      tmp_o_num=OMP_GET_THREAD_NUM()+1
        ! OpenMP ͭξ, ͤ apres  3 ܤ
        call cross_line( x, y, dtdx(i,j), dtdy(i,j), x(i), y(j),  &
  &                      dm(:,:,tmp_o_num), stdopt=stderr )
     end do
  end do

!$omp end do
!$omp end parallel

  do j=nygmin,nygmax
     do i=nxgmin,nxgmax
        do k=1,ompnum
           dval(i,j)=dval(i,j)+real(dm(i,j,k))
        end do
     end do
  end do

!-- neighboring mean

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)

  do j=nygmin+hsmnum,nygmax-hsmnum
     do i=nxgmin+hsmnum,nxgmax-hsmnum
        call Mean_2d( dval(i-hsmnum:i+hsmnum,j-hsmnum:j+hsmnum), ddval(i,j) )
     end do
  end do

!$omp end do
!$omp end parallel

!-- ׻Τ, Ȥʤʻ.
  call max_val_2d( ddval, center(1), center(2), tmpmin, undef=undeff )
  ddval=0.0

  if(present(sig))then
     hsig=(sig(1)+sig(2))/2
     coe1=(1.0/real(sig(1)))**2
     coe2=(1.0/real(sig(2)))**2

     allocate(gaut(2*hsig+1,2*hsig+1))
     allocate(temp2(nx,ny))
     allocate(tbgau(nx,ny))

     call max_val_2d( temp(center(1)-hsig:center(1)+hsig,center(2)-hsig:center(2)+hsig),  &
  &                   tmpi, tmpi, tempmax, undef=undeff )
     call min_val_2d( temp(center(1)-hsig:center(1)+hsig,center(2)-hsig:center(2)+hsig),  &
  &                   tmpi, tmpi, tempmin, undef=undeff )

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)

     do j=1,ny
        do i=1,nx
           if(temp(i,j)/=undeff)then
              temp2(i,j)=temp(i,j)**2
           else
              temp2(i,j)=undeff
           end if
        end do
     end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j)

     do j=1,2*hsig+1
        do i=1,2*hsig+1
           gaut(i,j)=tempmin+(tempmax-tempmin)  &
  &                 *exp(-real((i-hsig)**2+(j-hsig)**2)*coe1)  &
  &                  -(sig(1)**2)*coe2*exp(-0.5*real((i-hsig)**2+(j-hsig)**2)*coe2)
        end do
     end do

!$omp end do
!$omp end parallel

     ddval=undeff

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,tbmean,tb2mean,tbgaumean)

     do j=center(2)-hsig,center(2)+hsig
        do i=center(1)-hsig,center(1)+hsig
           call prod_priv_2d( temp(i-hsig:i+hsig,j-hsig:j+hsig),  &
  &                           gaut(1:2*hsig+1,1:2*hsig+1),  &
  &                           tbgau(i-hsig:i+hsig,j-hsig:j+hsig),  &
  &                           undef=undeff )
           call Mean_2d( temp(i-hsig:i+hsig,j-hsig:j+hsig), tbmean,  &
  &                      error=undeff )
           call Mean_2d( temp2(i-hsig:i+hsig,j-hsig:j+hsig), tb2mean,  &
  &                      error=undeff )
           call Mean_2d( tbgau(i-hsig:i+hsig,j-hsig:j+hsig), tbgaumean,  &
  &                      error=undeff )
           ddval(i,j)=1.0-tbgaumean/(tb2mean-tbmean**2)
if(ddval(i,j)>1.0)then
write(*,*) "Detect over 1.", tb2mean, tbgaumean
end if
        end do
     end do

!$omp end do
!$omp end parallel

write(*,*) "check center before", center(1:2), ddval(center(1),center(2))
!-- ׻Τ, Ȥʤʻ.
     call max_val_2d( ddval, center(1), center(2), tmpmin, undef=undeff )
write(*,*) "check center after", center(1:2), ddval(center(1),center(2))
  end if

  if(stderr.eqv..false.)then
     if(center(1)==nx+1.or.center(2)==ny+1)then
        write(*,*) "*** WARNING *** : DC_Braun (typhoon_analy)"
        write(*,*) "Setting the undef only point."
     end if
  end if

  deallocate(dtdx)
  deallocate(dtdy)
  deallocate(anom_temp)
  deallocate(dm)

end subroutine DC_Satellite

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine DC_Sat_ZNCC_f( ref_img, img, swx, swy, undef_ref, undef_img )
! ʿؤȤƥץ졼ȥޥåˡѤ,
! ˤ濴.
! ͽ濴֤ȽƤ (A) Ȥ龯֤Ѳ (B) Ǥ
! οʿ¤ϤۤƱǤȲꤹ. ,  A Ȳ B Ȥΰ㤤
! Ѳˤäư֤ưȰʳϤʤ. ä,  A 
! ȲȤƥץ졼ȥޥåˡˤ,  B  A 
! ǤʬФǤ. Ф줿üȲ A 
! üΰٷ٤κ A, B ֤λ֤ưΥȹͤ.
! [] μˡ,  A, B ֤Ǥοʿ¤ѲʤȲꤷƤ
!        , Ϳ 2 ֤λѲ̤ǽʸ¤꾮Ȥ˾ޤ.
!        Ҥޤ 8 εư¬ (2.5 ʬ) Ѥ뤳ȤꤷƤ. 
! Ūˤ, 
! 1. 濴֤ͿƤ ref_img ȤͿ.
!    ǡ͵ٲ٤Ǥ⥢٥ͤǤ⹽ʤ.
! 2. ref_img Ϳ줿 2 ʬۤȺǤ img üʻֹ
!    swx, swy ȤƽϤ.
! 3. ref_img ̳ʻ nrx, nry Ȥ, 
!    img ˤ (swx, swy)  (swx+nrx-1,swy+nry-1) ޤǤ,
!    ref_img ȺǤ٤ι⤤ʬȤʤ.
! 4. ref_img üٷ٤ img  swx, swy ΰٷ٤κ
!    ref_img  img δ֤Ǥΰư٥ȥȤʤΤ, ref_img 
!    濴ΰٷ٤ˤΰư٥ȥʬ­碌, 
!    img Ǥ濴ٷ٤Ȥʤ. 

  implicit none
  real, intent(in) :: ref_img(:,:)  ! ȲǤտ (K, 1, etc.)
  real, intent(in) :: img(:,:)      ! õǤտ (K, 1, etc.)
  integer, intent(inout) :: swx     ! ref_img ȺǤ img üʻ
  integer, intent(inout) :: swy     ! ref_img ȺǤ img üʻ
  real, intent(in), optional :: undef_ref  ! ref_img Ǥ̤
  real, intent(in), optional :: undef_img  ! img Ǥ̤

  integer :: i, j, k, nrx, nry, nix, niy, nx, ny
  real :: RCC(size(img,1)-size(ref_img,1)+1,size(img,2)-size(ref_img,2)+1)
  real :: iref_img(size(ref_img,1),size(ref_img,2))
  real :: tmpv, undef
  logical :: undeflag

  nrx=size(ref_img,1)
  nry=size(ref_img,2)
  nix=size(img,1)
  niy=size(img,2)
  nx=nix-nrx+1
  ny=niy-nry+1
  undef=-999.0

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nrx, nry, ref_img ),  &
  &                                     "DC_Sat_ZNCC" )
     call check_array_size_dmp_message( check_array_size_2d( nix, niy, img ),  &
  &                                     "DC_Sat_ZNCC" )
  end if

  if(nix<=nrx.or.niy<=nry)then
     write(*,*) "*** ERROR (DC_Sat_ZNCC) *** : img must be larger than ref_img."
     write(*,*) "Stop."
     stop
  end if

  do j=1,nry
     do i=1,nrx
        iref_img(i,j)=ref_img(i,j)
     end do
  end do

!-- ξԤ̤ͤ 1 Ĥ줹.
  undeflag=.true.
  if(present(undef_img))then
     undef=undef_img
     if(present(undef_ref))then
        do j=1,nry
           do i=1,nrx
              if(iref_img(i,j)==undef_ref)then
                 iref_img(i,j)=undef
              end if
           end do
        end do
     end if
  else
     if(present(undef_ref))then
        undef=undef_ref
     else
        undeflag=.false.   ! ̤äƤʤ.
     end if
  end if

!-- ܷ׻

!$omp parallel default(shared)

  if(undeflag.eqv..true.)then

!$omp do schedule(runtime) private(i,j)

     do j=1,ny
        do i=1,nx
           call Cor_Coe_2d( iref_img(1:nrx,1:nry), img(i:nrx+i-1,j:nry+j-1),  &
  &                         RCC(i,j), error=undef )
        end do
     end do

!$omp end do

  else

!$omp do schedule(runtime) private(i,j)

     do j=1,ny
        do i=1,nx
           call Cor_Coe_2d( iref_img(1:nrx,1:nry), img(i:nrx+i-1,j:nry+j-1),  &
  &                         RCC(i,j) )
        end do
     end do

!$omp end do

  end if

!$omp end parallel

  if(undeflag.eqv..true.)then
     call max_val_2d( RCC, swx, swy, tmpv, undef=undef )
  else
     call max_val_2d( RCC, swx, swy, tmpv )
  end if

end subroutine DC_Sat_ZNCC_f

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine DC_Sat_ZNCC_d( ref_img, img, swx, swy, undef_ref, undef_img )
! ʿؤȤƥץ졼ȥޥåˡѤ,
! ˤ濴.
! ͽ濴֤ȽƤ (A) Ȥ龯֤Ѳ (B) Ǥ
! οʿ¤ϤۤƱǤȲꤹ. ,  A Ȳ B Ȥΰ㤤
! Ѳˤäư֤ưȰʳϤʤ. ä,  A 
! ȲȤƥץ졼ȥޥåˡˤ,  B  A 
! ǤʬФǤ. Ф줿üȲ A 
! üΰٷ٤κ A, B ֤λ֤ưΥȹͤ.
! [] μˡ,  A, B ֤Ǥοʿ¤ѲʤȲꤷƤ
!        , Ϳ 2 ֤λѲ̤ǽʸ¤꾮Ȥ˾ޤ.
!        Ҥޤ 8 εư¬ (2.5 ʬ) Ѥ뤳ȤꤷƤ. 
! Ūˤ, 
! 1. 濴֤ͿƤ ref_img ȤͿ.
!    ǡ͵ٲ٤Ǥ⥢٥ͤǤ⹽ʤ.
! 2. ref_img Ϳ줿 2 ʬۤȺǤ img üʻֹ
!    swx, swy ȤƽϤ.
! 3. ref_img ̳ʻ nrx, nry Ȥ, 
!    img ˤ (swx, swy)  (swx+nrx-1,swy+nry-1) ޤǤ,
!    ref_img ȺǤ٤ι⤤ʬȤʤ.
! 4. ref_img üٷ٤ img  swx, swy ΰٷ٤κ
!    ref_img  img δ֤Ǥΰư٥ȥȤʤΤ, ref_img 
!    濴ΰٷ٤ˤΰư٥ȥʬ­碌, 
!    img Ǥ濴ٷ٤Ȥʤ. 

  implicit none
  double precision, intent(in) :: ref_img(:,:)  ! ȲǤտ (K, 1, etc.)
  double precision, intent(in) :: img(:,:)      ! õǤտ (K, 1, etc.)
  integer, intent(inout) :: swx     ! ref_img ȺǤ img üʻ
  integer, intent(inout) :: swy     ! ref_img ȺǤ img üʻ
  double precision, intent(in), optional :: undef_ref  ! ref_img Ǥ̤
  double precision, intent(in), optional :: undef_img  ! img Ǥ̤

  integer :: i, j, k, nrx, nry, nix, niy, nx, ny
  double precision :: RCC(size(img,1)-size(ref_img,1)+1,size(img,2)-size(ref_img,2)+1)
  double precision :: iref_img(size(ref_img,1),size(ref_img,2))
  double precision :: tmpv, undef
  logical :: undeflag

  nrx=size(ref_img,1)
  nry=size(ref_img,2)
  nix=size(img,1)
  niy=size(img,2)
  nx=nix-nrx+1
  ny=niy-nry+1
  undef=-999.0d0

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nrx, nry, ref_img ),  &
  &                                     "DC_Sat_ZNCC" )
     call check_array_size_dmp_message( check_array_size_2d( nix, niy, img ),  &
  &                                     "DC_Sat_ZNCC" )
  end if

  if(nix<=nrx.or.niy<=nry)then
     write(*,*) "*** ERROR (DC_Sat_ZNCC) *** : img must be larger than ref_img."
     write(*,*) "Stop."
     stop
  end if

  iref_img=ref_img

!-- ξԤ̤ͤ 1 Ĥ줹.
  undeflag=.true.
  if(present(undef_img))then
     undef=undef_img
     if(present(undef_ref))then
        do j=1,nry
           do i=1,nrx
              if(iref_img(i,j)==undef_ref)then
                 iref_img(i,j)=undef
              end if
           end do
        end do
     end if
  else
     if(present(undef_ref))then
        undef=undef_ref
     else
        undeflag=.false.   ! ̤äƤʤ.
     end if
  end if

!-- ܷ׻

!$omp parallel default(shared)

  if(undeflag.eqv..true.)then

!$omp do schedule(runtime) private(i,j)

     do j=1,ny
        do i=1,nx
           call Cor_Coe_2d( iref_img(1:nrx,1:nry), img(i:nrx+i-1,j:nry+j-1),  &
  &                         RCC(i,j), error=undef )
        end do
     end do

!$omp end do

  else

!$omp do schedule(runtime) private(i,j)

     do j=1,ny
        do i=1,nx
           call Cor_Coe_2d( iref_img(1:nrx,1:nry), img(i:nrx+i-1,j:nry+j-1),  &
  &                         RCC(i,j) )
        end do
     end do

!$omp end do

  end if

!$omp end parallel

  if(undeflag.eqv..true.)then
     call max_val_2d( RCC, swx, swy, tmpv, undef=undef )
  else
     call max_val_2d( RCC, swx, swy, tmpv )
  end if

end subroutine DC_Sat_ZNCC_d

!--------------------------------------------------------------
!  ʲ, private 롼
!--------------------------------------------------------------

subroutine search_region_1d( x, y, c, r, nr, stdopt )
! ʿѲǽȾ¤׻롼
  implicit none
  real, intent(in) :: x(2)  ! x ξüɸ [m]
  real, intent(in) :: y(2)  ! y ξüɸ [m]
  real, intent(in) :: c(2)  ! 濴ΰֺɸ (x,y) [m]
  real, intent(in) :: r(:)  ! ưΰֺɸ [m]
  integer, intent(inout) :: nr  ! ʿѲǽȾ¤ֹ (r(nr) ǽȾ)
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  integer :: nrr, tmp_nr
  real :: xc, yc
  logical :: stderr

  nrr=size(r)
  xc=c(1)
  yc=c(2)
  nr=nrr

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(abs(x(1)-xc) < r(nrr))then
     if(stderr.eqv..false.)then
        write(*,*) "typhoon_analy WARNING :"
        write(*,*) "|x(1)-xc| >= rmax. "
        write(*,*) "undef value is substituted out of region."
     end if
     call interpo_search_1d( r, abs(x(1)-xc), tmp_nr, stdopt=stderr )
     nr=tmp_nr+1  ! interpo_search  abs ͤ꾮 r ֹ椬뤿.
                  ! ʲƱͳ
  else
     if(abs(x(2)-xc) < r(nrr))then
        if(stderr.eqv..false.)then
           write(*,*) "typhoon_analy WARNING :"
           write(*,*) "|x(nx)-xc| >= rmax. "
           write(*,*) "undef value is substituted out of region."
        end if
        call interpo_search_1d( r, abs(x(2)-xc), tmp_nr, stdopt=stderr )
        if(tmp_nr+1<nr)then
           nr=tmp_nr+1
        end if
     else
        if(abs(y(1)-yc) < r(nrr))then
           if(stderr.eqv..false.)then
              write(*,*) "typhoon_analy WARNING :"
              write(*,*) "|y(1)-yc| >= rmax. "
              write(*,*) "undef value is substituted out of region."
           end if
           call interpo_search_1d( r, abs(y(1)-yc), tmp_nr, stdopt=stderr )
           if(tmp_nr+1<nr)then
              nr=tmp_nr+1
           end if
        else
           if(abs(y(2)-yc) < r(nrr))then
              if(stderr.eqv..false.)then
                 write(*,*) "typhoon_analy WARNING :"
                 write(*,*) "|y(ny)-yc| >= rmax. "
                 write(*,*) "undef value is substituted out of region."
              end if
              call interpo_search_1d( r, abs(y(2)-yc), tmp_nr, stdopt=stderr )
              if(tmp_nr+1<nr)then
                 nr=tmp_nr+1
              end if
           end if
        end if
     end if
  end if

end subroutine search_region_1d

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine cross_line( x, y, dx, dy, x0, y0, counter, stdopt )
! ǤդΥ٥ȥʿԤľɤγʻ̲ᤷƤ뤫򥫥Ȥ.
  implicit none
  real, dimension(:), intent(in) :: x  ! x ɸ
  real, dimension(:), intent(in) :: y  ! y ɸ
  real, intent(in) :: dx  ! x η
  real, intent(in) :: dy  ! y η
  real, intent(in) :: x0  ! ľγ x ɸ
  real, intent(in) :: y0  ! ľγ y ɸ
  integer, dimension(size(x),size(y)), intent(inout) :: counter
                    ! ׻ˤ dy/dx ȤͤѤΤ,
                    ! dx, dy ñ̤ϵˤʤƤ褤.
                    ! x0, y0 ξüľ򿭤Ф.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  integer :: i, j, nx, ny, itmp, jtmp, ix, iy
  integer, dimension(size(x),size(y)) :: dummy
  real :: dt, tmpx, tmpy
  logical :: stderr

  nx=size(x)
  ny=size(y)
  dummy=0

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  call nearest_search_2d( x, y, x0, y0, ix, iy )

  if(dx/=0.0.or.dy/=0.0)then
     if(dx==0.0)then
        counter(ix,1:ny)=1
     else if(dy==0.0)then
        counter(1:nx,iy)=1
     else
        dt=dy/dx
     !-- ޤ, x  1 ʻľ򿭤Ф, γ x ΤȤ y 
     !-- б򥫥ȤƤ.
        do i=1,nx
           tmpy=y0+dt*(x(i)-x0)
           call interpo_search_1d( y, tmpy, jtmp, stdopt=stderr )
           if(jtmp>0)then
              if(tmpy/=y(jtmp).and.jtmp<ny)then  ! 2 ʻ֤¸ߤȤ
                 !  2 ʻξȤ.
                 dummy(i,jtmp)=1
                 dummy(i,jtmp+1)=1
                 counter(i,jtmp)=counter(i,jtmp)+1
                 counter(i,jtmp+1)=counter(i,jtmp+1)+1
              else
                 counter(i,jtmp)=counter(i,jtmp)+1
              end if
           end if
        end do
        dt=dx/dy
     !-- , y  1 ʻľ򿭤Ф, γ y ΤȤ x 
     !-- б򥫥ȤƤ.
     !-- ֥륫Ȥ򤷤ʤ, counter = 1 ξϥȤʤ.
        do j=1,ny
           tmpx=x0+dt*(y(j)-y0)
           call interpo_search_1d( x, tmpx, itmp, stdopt=stderr )
           if(itmp>0)then
              if(dummy(itmp,j)==0)then
                 if(tmpx/=x(itmp).and.itmp<nx)then
                    counter(itmp,j)=counter(itmp,j)+1
                    if(dummy(itmp+1,j)==0)then
                       counter(itmp+1,j)=counter(itmp+1,j)+1
                    end if
                 else
                    counter(itmp,j)=counter(itmp,j)+1
                 end if
              end if
           end if
        end do
     end if
  end if

end subroutine cross_line

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine prod_priv_2d( ival1, ival2, oval, undef )
! 2 γʬˤĤ,  2 ֤.
  implicit none
  real, dimension(:,:), intent(in) :: ival1  ! ѿ 1
  real, dimension(size(ival1,1),size(ival1,2)), intent(in) :: ival2  ! ѿ 2
  real, dimension(size(ival1,1),size(ival1,2)), intent(inout) :: oval   ! Ϸ
  real, intent(in), optional :: undef
  integer :: nx, ny, i, j

  nx=size(ival1,1)
  ny=size(ival1,2)

  if(present(undef))then
     do j=1,ny
        do i=1,nx
           if(ival1(i,j)/=undef.and.ival2(i,j)/=undef)then
              oval(i,j)=(ival1(i,j)-ival2(i,j))**2
           else
              oval(i,j)=undef
           end if
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           oval(i,j)=(ival1(i,j)-ival2(i,j))**2
        end do
     end do
  end if

end subroutine prod_priv_2d

!--------------------------------------------------------------
!--------------------------------------------------------------

logical function undef_checker_1df( val, undef )
! Ǥ val ˤĤ, ٤ƤǤˤĤ undef ȤͤäƤ뤫
! ɤå. 1 ĤǤ undef äƤ .true. ֤.
  implicit none
  real, dimension(:), intent(in) :: val  ! å
  real, intent(in) :: undef  ! åѿ
  integer :: i, nx
  logical :: checker

  nx=size(val)
  checker=.false.

  do i=1,nx
     if(val(i)==undef)then
        checker=.true.
        exit
     end if
  end do

  undef_checker_1df=checker

  return
end function undef_checker_1df

!--------------------------------------------------------------
!--------------------------------------------------------------

logical function undef_checker_1dd( val, undef )
! Ǥ val ˤĤ, ٤ƤǤˤĤ undef ȤͤäƤ뤫
! ɤå. 1 ĤǤ undef äƤ .true. ֤.
  implicit none
  double precision, dimension(:), intent(in) :: val  ! å
  double precision, intent(in) :: undef  ! åѿ
  integer :: i, nx
  logical :: checker

  nx=size(val)
  checker=.false.

  do i=1,nx
     if(val(i)==undef)then
        checker=.true.
        exit
     end if
  end do

  undef_checker_1dd=checker

  return
end function undef_checker_1dd

!--------------------------------------------------------------
!--------------------------------------------------------------

logical function undef_checker_2df( val, undef )
! Ǥ val ˤĤ, ٤ƤǤˤĤ undef ȤͤäƤ뤫
! ɤå. 1 ĤǤ undef äƤ .true. ֤.
  implicit none
  real, dimension(:,:), intent(in) :: val  ! å
  real, intent(in) :: undef  ! åѿ
  integer :: i, nx
  logical :: checker

  nx=size(val,2)
  checker=.false.

  do i=1,nx
     checker=undef_checker_1df( val(:,i), undef )
     if(checker.eqv..true.)then
        exit
     end if
  end do

  undef_checker_2df=checker

  return
end function undef_checker_2df

!--------------------------------------------------------------
!--------------------------------------------------------------

logical function undef_checker_2dd( val, undef )
! Ǥ val ˤĤ, ٤ƤǤˤĤ undef ȤͤäƤ뤫
! ɤå. 1 ĤǤ undef äƤ .true. ֤.
  implicit none
  double precision, dimension(:,:), intent(in) :: val  ! å
  double precision, intent(in) :: undef  ! åѿ
  integer :: i, nx
  logical :: checker

  nx=size(val,2)
  checker=.false.

  do i=1,nx
     checker=undef_checker_1dd( val(:,i), undef )
     if(checker.eqv..true.)then
        exit
     end if
  end do

  undef_checker_2dd=checker

  return
end function undef_checker_2dd

!--------------------------------------------------------------
!--------------------------------------------------------------

logical function undef_checker_3df( val, undef )
! Ǥ val ˤĤ, ٤ƤǤˤĤ undef ȤͤäƤ뤫
! ɤå. 1 ĤǤ undef äƤ .true. ֤.
  implicit none
  real, dimension(:,:,:), intent(in) :: val  ! å
  real, intent(in) :: undef  ! åѿ
  integer :: i, nx
  logical :: checker

  nx=size(val,3)
  checker=.false.

  do i=1,nx
     checker=undef_checker_2df( val(:,:,i), undef )
     if(checker.eqv..true.)then
        exit
     end if
  end do

  undef_checker_3df=checker

  return
end function undef_checker_3df

!--------------------------------------------------------------
!--------------------------------------------------------------

logical function undef_checker_3dd( val, undef )
! Ǥ val ˤĤ, ٤ƤǤˤĤ undef ȤͤäƤ뤫
! ɤå. 1 ĤǤ undef äƤ .true. ֤.
  implicit none
  double precision, dimension(:,:,:), intent(in) :: val  ! å
  double precision, intent(in) :: undef  ! åѿ
  integer :: i, nx
  logical :: checker

  nx=size(val,3)
  checker=.false.

  do i=1,nx
     checker=undef_checker_2dd( val(:,:,i), undef )
     if(checker.eqv..true.)then
        exit
     end if
  end do

  undef_checker_3dd=checker

  return
end function undef_checker_3dd

!--------------------------------------------------------------
!--------------------------------------------------------------

!subroutine Rangular_moment(xp,yp,x,y,u,v,mome)
! Ǥդޤгѱư̤׻롼
!
!  3 ٥ȥǷ׻뤬, ݳؤǤ 3 ̤Ϥޤפʤ
! ǤȤȽǤ, žޤγѱưʬΤߤ
! ׻뤳ȤˤƤ.
!
! Ū濴濴˱ľޤγѱư̤׻뤳ȤŪȤ.
!
! $$M=rv,\quad r=濴εΥ, \quad v=®Ʊ̳ʬ$$
!
! ֤®˰٤ѴͿ, Ǥμžޤγѱư̤
! ׻뤳Ȥǽ.
! ٥ȥγѷ׻롼 vec_prod_2d Ѥ뤳ȤǶ˺ɸǤ׻ǽ.
!  use algebra
!  implicit none
!  real, intent(in) :: x(:)  ! x ΰֺɸ
!  real, intent(in) :: y(:)  ! y ΰֺɸ
!  real, intent(in) :: xp  ! ž x ֺɸ
!  real, intent(in) :: yp  ! ž y ֺɸ
!  real, intent(in) :: u(size(x),size(y))  !  i,j Ǥ® 1 ʬ
!  real, intent(in) :: v(size(x),size(y))  !  i,j Ǥ® 1 ʬ
!  real, intent(inout) :: mome(size(x),size(y))  ! žޤгѱư
!  real :: xxp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ x ʬ
!  real :: yyp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ y ʬ
!  integer :: i, j, nx, ny
!  real :: tmp(size(x),size(y),1)
! ׻뤳Ȥǽ.
! ٥ȥγѷ׻롼 vec_prod_2d Ѥ뤳ȤǶ˺ɸǤ׻ǽ.
!  use algebra
!  implicit none
!  real, intent(in) :: x(:)  ! x ΰֺɸ
!  real, intent(in) :: y(:)  ! y ΰֺɸ
!  real, intent(in) :: xp  ! ž x ֺɸ
!  real, intent(in) :: yp  ! ž y ֺɸ
!  real, intent(in) :: u(size(x),size(y))  !  i,j Ǥ® 1 ʬ
!  real, intent(in) :: v(size(x),size(y))  !  i,j Ǥ® 1 ʬ
!  real, intent(inout) :: mome(size(x),size(y))  ! žޤгѱư
!  real :: xxp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ x ʬ
!  real :: yyp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ y ʬ
!  integer :: i, j, nx, ny
!  real :: tmp(size(x),size(y),1)
!
!  nx=size(x)
!  ny=size(y)
!
!!$omp parallel do shared(xxp,yyp,x,y,xp,yp) private(i,j)
!  do j=1,ny
!     do i=1,nx
!        xxp(i,j,1)=x(i)-xp
!        yyp(i,j,1)=y(j)-yp
!     end do
!  end do
!!$omp end parallel do
!
!  tmp=0.0
!  call vec_prod_2d(xxp,yyp,tmp,u,v,tmp,tmp,tmp,mome)
!
!end subroutine Rangular_moment
!
!
!subroutine Aangular_moment(xp,yp,x,y,u,v,f,mome)
!! Ǥդޤгѱư̤׻롼
!!
!! Ū濴濴˱ľޤγѱư̤׻뤳ȤŪȤ.
!!
!! $$M=rv+\dfrac{fr^2}{2} ,\quad r=濴εΥ, \quad v=®Ʊ̳ʬ$$
!!
!! ֤®˰٤ѴͿ, Ǥμžޤγѱư̤
!! ׻뤳Ȥǽ.
!!
!! ٥ȥγѷ׻롼 vec_prod_2d Ѥ뤳ȤǶ˺ɸǤ׻ǽ.
!  use algebra
!  implicit none
!  real, intent(in) :: x(:)  ! x ΰֺɸ
!  real, intent(in) :: y(:)  ! y ΰֺɸ
!  real, intent(in) :: xp  ! ž x ֺɸ
!  real, intent(in) :: yp  ! ž y ֺɸ
!  real, intent(in) :: u(size(x),size(y))  !  i,j Ǥ® 1 ʬ
!  real, intent(in) :: v(size(x),size(y))  !  i,j Ǥ® 1 ʬ
!  real, intent(in) :: f(size(x),size(y))  !  i,j ǤΥꥪѥ᡼
!  real, intent(inout) :: mome(size(x),size(y))  ! žޤгѱư
!  real :: xxp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ x ʬ
!  real :: yyp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ y ʬ
!  integer :: i, j, nx, ny
!  real :: tmp(size(x),size(y),1), rp(size(x),size(y)), tmp1(1)
!
!  nx=size(x)
!  ny=size(y)
!
!!$omp parallel do shared(xxp,yyp,x,y,xp,yp) private(i,j)
!  do j=1,ny
!     do i=1,nx
!        xxp(i,j,1)=x(i)-xp
!        yyp(i,j,1)=y(j)-yp
!     end do
!  end do
!!$omp end parallel do
!
!  tmp=0.0
!  call vec_prod_2d(xxp,yyp,tmp,u,v,tmp,tmp,tmp,mome)
!  call radius(xp,yp,0.0,x,y,tmp1,rp)
!
!!$omp parallel do shared(mome,f,rp) private(i,j)
!  do j=1,ny
!     do i=1,nx
!        mome(i,j)=mome(i,j)+0.5*f(i,j)*rp(i,j)**2
!     end do
!  end do
!!$omp end parallel do
!
!end subroutine Aangular_moment

!-----------------------------------------
!-----------------------------------------

!-----------------------------------------
!-----------------------------------------

end module typhoon_analy
