program make_init
!-- producing initial data of zeta

  use gtool_history

  implicit none

  integer, parameter :: nc=10

!-- namelist variables

  integer :: nx, ny, ntc
  double precision :: xmin, ymin, dx, dy, betac
  character(1000) :: fname

  integer :: i, j, k
  real, allocatable, dimension(:) :: xr, yr
  double precision, dimension(nc) :: zetam, rmw, tcx, tcy, sig
  double precision, allocatable, dimension(:) :: x, y
  double precision, allocatable, dimension(:,:) :: zeta

  namelist /init /nx, ny, xmin, ymin, dx, dy, fname, betac, zetam,  &
  &               sig, rmw, tcx, tcy, ntc
  read(5,nml=init)

  if(ntc>nc)then
     write(*,*) "*** ERROR (main) *** : namelist variable 'ntc' is <=", ntc, '.'
     write(*,*) "STOP."
     stop
  end if

  allocate(x(nx))
  allocate(y(ny))
  allocate(xr(nx))
  allocate(yr(ny))
  allocate(zeta(nx,ny))

  x=(/((xmin+dx*dble(i-1)),i=1,nx)/)
  y=(/((ymin+dy*dble(j-1)),j=1,ny)/)

  xr=(/((xmin+dx*real(i-1)),i=1,nx)/)
  yr=(/((ymin+dy*real(j-1)),j=1,ny)/)

  zeta=0.0d0

  do k=1,ntc
     do j=1,ny
        do i=1,nx
           if(dsqrt((x(i)-tcx(k))**2+(y(j)-tcy(k))**2)<=rmw(k))then
              zeta(i,j)=zeta(i,j)+zetam(k)
           end if
        end do
     end do
  end do

  call HistoryCreate( file=trim(adjustl(fname)), title='BAROTRO initial data', &
  & source='test', institution='test', dims=(/'x', 'y'/),  &
  & dimsizes=(/ nx, ny /),  &
  & longnames=(/'X-coordinate','Y-coordinate'/),  &
  & units=(/'m', 'm'/) )

  call HistoryPut( 'x', xr )
  call HistoryPut( 'y', yr )

  call HistoryAddVariable( varname='zeta', dims=(/'x','y'/), &
  &    longname='vorticity', units='s-1', xtype='double' )

  call HistoryAddVariable( varname='xd', dims=(/'x'/), &
  &    longname='X-coord double', units='m', xtype='double' )

  call HistoryAddVariable( varname='yd', dims=(/'y'/), &
  &    longname='Y-coord double', units='m', xtype='double' )

  call HistoryPut( 'zeta', zeta )
  call HistoryPut( 'xd', x )
  call HistoryPut( 'yd', y )

  call HistoryClose()

end program
