program make_init
  use gtool_history
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use file_operate
  use Basis
  use val_define
  use read_namelist
  use val_alloc
  use val_coord
  use Thermo_Function
  use typhoon_analy
  use sub_calc

  implicit none

!-- do loop ѿ
  integer :: i, j, k, nl

!-- 
  integer :: i_undef
  real :: coer, coez
  real, dimension(:), allocatable :: ht, pr, tm, rho, qv
  real, dimension(:), allocatable :: tmpp, tmpt, tmpq
  real, dimension(:,:), allocatable :: rhoi, tmpc
  character(50), dimension(:,:), allocatable :: cval

  i_undef=int(undef)

  write(*,*) "starting program."

!-- namelist ɤ߹

  call read_name()

!-- allocating array

  call val_allocate()

!-- ǡκɸϤϤʤФʤʤ.

  r_i=(/((rimin+dri*(i-1)),i=1,nri)/)
  z_i(1)=0.0

!-- ¾ѿ
  allocate(tmpp(nzi))
  allocate(tmpt(nzi))
  allocate(tmpq(nzi))
  allocate(rhoi(nri,nzi))
  allocate(tmpc(nri,nzi))

!-- ˥ͤѿΤ, Ƥθ岿⤷ʤ.
  u_i=0.0
  w_i=0.0
  qt_i=0.0
  tmpc=coril

!-- ǥ󥰥ǡǮϳѿɤ߹.

  nl=line_number_counter( trim(sname) )-2
  allocate(cval(4,nl))
  call read_file_text( trim(sname), 4, nl, cval, skip=2)

  allocate(ht(nl))
  allocate(pr(nl))
  allocate(tm(nl))
  allocate(qv(nl))
  allocate(rho(nl))

  do i=1,nl
     ht(i)=c2r_convert( trim(adjustl(cval(1,i))) )
     pr(i)=c2r_convert( trim(adjustl(cval(2,i))) )
     tm(i)=c2r_convert( trim(adjustl(cval(3,i))) )
     qv(i)=c2r_convert( trim(adjustl(cval(4,i))) )
     if(pr(i)/=undef.and.tm(i)/=undef)then
        rho(i)=TP_2_rho( tm(i), pr(i) )
     else
        rho(i)=undef
        write(*,*) "WARNING : detected undefined value."
        write(*,*) "undef height is ", ht(i)
     end if
     if(qv(i)==undef)then
        qv(i)=0.0
     end if
  end do

  z_i(2)=ht(1)
  z_i(3:nzi)=(/((ht(1)+dzi*(i-2)),i=3,nzi)/)
!write(*,*) "zi check", z_i
!-- ǥ󥰥ǡǡ줿ľ٤ޤ.
  call auto_interpolation_1d( ht, z_i, pr, tmpp, undef=i_undef, undefr=undef )
  call auto_interpolation_1d( ht, z_i, tm, tmpt, undef=i_undef, undefr=undef )
  call auto_interpolation_1d( ht, z_i, qv, tmpq, undef=i_undef, undefr=undef )

!-- ̥ǡʤΤ,  2 ʬ鳰ޤԤ.
  if(z_i(1)<ht(1))then
     tmpp(1)=hypsometric_form( tmpp(2), z_i(2), tmpt(2), 0.0 )
     tmpt(1)=tmpt(2)-6.5e-3*(z_i(2)-z_i(1))
     rho(1)=TP_2_rho( tmpt(1), tmpp(1) )
write(*,*) "sho check", rho(1), tmpt(1), tmpp(1)
!write(*,*) "ehcck", tmpt(1), tmpp(1), rho(1)
     tmpq(1)=TP_2_qvs( tmpt(1), tmpp(1) )
  end if

!-- ®η׻.

  do k=1,nzi
     do j=1,nri
        if(z_i(k)<=zlim)then
           coer=r_i(j)/rvmax
           coez=(zlim-z_i(k))/zlim
           v_i(j,k)=coez*2.0*vvmax*coer/(1.0+coer**3)
        else
           v_i(j,k)=0.0
        end if
     end do
  end do

!-- ϳإХ󥹤褦Ĵ.
  call hydro_grad_eqb( r_i, z_i, tmpc, v_i, tmpp, rho, p_i, rhoi, dl=2 )

  do k=1,nzi
     do j=1,nri
        t_i(j,k)=theta_dry( rhoP_2_T( rhoi(j,k), p_i(j,k) ), p_i(j,k) )
!if(k<3)then
!        write(*,*) t_i(j,k), rhoP_2_T( rhoi(j,k), p_i(j,k) ), p_i(j,k), rhoi(j,k)
!end if
        qv_i(j,k)=tmpq(k)
     end do
  end do

!-- ϥեν
  call HistoryCreate( file=trim(finame), title='RE87 result data', &
  & source='test', institution='test', dims=(/'r', 'z'/),  &
  & dimsizes=(/nri, nzi/),  & 
  & longnames=(/'R-coordinate','Z-coordinate'/),  &
  & units=(/'m', 'm'/) )
  
  call HistoryPut( 'r', r_i(1:nri) )
  call HistoryPut( 'z', z_i(1:nzi) )
  
  call HistoryAddVariable( varname='u', dims=(/'r','z'/), &
    & longname='R wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='v', dims=(/'r','z'/), &
    & longname='T wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='w', dims=(/'r','z'/), &
    & longname='Z wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='p', dims=(/'r','z'/), &
    & longname='Pressure', units='1', xtype='float')

  call HistoryAddVariable( varname='t', dims=(/'r','z'/), &
    & longname='Potential Temperature', units='K', xtype='float')

  call HistoryAddVariable( varname='qv', dims=(/'r','z'/), &
    & longname='Vapor Mixing Ratio', units='kg kg-1', xtype='float')

  call HistoryAddVariable( varname='qt', dims=(/'r','z'/), &
    & longname='Condensation Mixing Ratio', units='kg kg-1', xtype='float')

!-- ͥեؤ

  call HistoryPut( 'u', u_i(1:nri,1:nzi) )
  call HistoryPut( 'v', v_i(1:nri,1:nzi) )
  call HistoryPut( 'w', w_i(1:nri,1:nzi) )
  call HistoryPut( 'p', p_i(1:nri,1:nzi) )
  call HistoryPut( 't', t_i(1:nri,1:nzi) )
  call HistoryPut( 'qv', qv_i(1:nri,1:nzi) )
  call HistoryPut( 'qt', qt_i(1:nri,1:nzi) )

!-- ȥå

  write(*,*) "program normally stops."

end program
