!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2006. All rights reserved.
!---------------------------------------------------------------------
!
!= 2  (xy ) ֳָ߳ʻ ͭºʬǥ ܥ⥸塼
!
!* 
!  * 2007/07/15 () : 3D deepconv ذܿ, dc_types  Use.
!  * 2006/12/26 () : ʿѴؿ̾򸵤᤹
!  * 2006/06/17 () : ʬ, ʿѴؿɲ
!  * 2006/06/02 () : 
!
module xy_base_module
  != 2  (xy ) ֳָ߳ʻ ͭºʬǥ ܥ⥸塼
  !
  !== 
  !
  ! xy_base_module , 2  (xy ) ֳָ߳ʻҤѤͭºʬ
  ! ˡ˴ŤͥǥΤ, Ū Fortran90 ץप
  ! ؿ󶡤. 
  !
  ! Υ⥸塼 xy_module β̥⥸塼Ǥ. ⥸塼
  ! Ȥ data_type, x_base_module, y_base_module ⥸塼ѤƤ. 
  ! 
  !
  !== 
  !
  ! * 㳰ʤ
  ! * ξΥåɽʤ
  ! * ͤϥޥ󥤥ץͤȤƤ٤
  !

  use dc_types,      only : DBKIND => DP
  use x_base_module, only : im, imin, imax, xmargin, x_axis_init,   &
    &                       x_X, p_X, x_dx, p_dx, x_avr_p, p_avr_x, &
    &                       IntX_p, IntX_x, AvrX_p, AvrX_x
  use y_base_module, only : jm, jmin, jmax, ymargin, y_axis_init,   &
    &                       y_Y, q_Y, y_dy, q_dy, y_avr_q, q_avr_y, &
    &                       IntY_q, IntY_y, AvrY_q, AvrY_y
  implicit none

  private
  public :: im, imin, imax, xmargin, x_X, p_X, x_dx, p_dx     ! Cascaded
  public :: jm, jmin, jmax, ymargin, y_Y, q_Y, y_dy, q_dy     ! Cascaded
  public :: x_avr_p, p_avr_x, IntX_p, IntX_x, AvrX_p, AvrX_x  ! Cascaded
  public :: y_avr_q, q_avr_y, IntY_q, IntY_y, AvrY_q, AvrY_y  ! Cascaded
  public :: xy_X, xy_Y, xy_dx, py_dx, xy_dy, xq_dy
  public :: xy_axis_init
  public :: xy_avr_py, xq_avr_pq, py_avr_xy, pq_avr_xq
  public :: xy_avr_xq, py_avr_pq, xq_avr_xy, pq_avr_py
  public :: y_IntX_xy, q_IntX_xq, y_IntX_py, x_IntY_xy, p_IntY_py, x_IntY_xq
  public :: y_AvrX_xy, q_AvrX_xq, y_AvrX_py, x_AvrY_xy, p_AvrY_py, x_AvrY_xq
  public :: IntXY_xy, IntXY_xq, IntXY_py, AvrXY_xy, AvrXY_py, AvrXY_xq


  real(DBKIND),allocatable :: xy_X(:,:)   ! x ɸ(Ⱦʻ)
  real(DBKIND),allocatable :: xy_Y(:,:)   ! y ɸ(Ⱦʻ)
  real(DBKIND),allocatable :: xy_dx(:,:)  ! x ʻҴֳ(Ⱦʻ)
  real(DBKIND),allocatable :: py_dx(:,:)  ! x ʻҴֳ(ʻ)
  real(DBKIND),allocatable :: xy_dy(:,:)  ! y ʻҴֳ(Ⱦʻ)
  real(DBKIND),allocatable :: xq_dy(:,:)  ! y ʻҴֳ(ʻ)

  save xy_X, xy_Y, xy_dx, py_dx, xy_dy, xq_dy

  interface xy_avr_py
    module procedure xa_avr_pa
  end interface 

  interface xq_avr_pq
    module procedure xa_avr_pa
  end interface 

  interface py_avr_xy
    module procedure pa_avr_xa
  end interface 

  interface pq_avr_xq
    module procedure pa_avr_xa
  end interface 

  interface xy_avr_xq
    module procedure ay_avr_aq
  end interface 

  interface py_avr_pq
    module procedure ay_avr_aq
  end interface 

  interface xq_avr_xy
    module procedure aq_avr_ay
  end interface 

  interface pq_avr_py
    module procedure aq_avr_ay
  end interface 

  interface y_IntX_xy
    module procedure a_IntX_xa
  end interface 

  interface q_IntX_xq
    module procedure a_IntX_xa
  end interface 

  interface x_IntY_xy
    module procedure a_IntY_ay
  end interface 

  interface p_IntY_py
    module procedure a_IntY_ay
  end interface 

  interface y_AvrX_xy
    module procedure a_AvrX_xa
  end interface 

  interface q_AvrX_xq
    module procedure a_AvrX_xa
  end interface 

  interface x_AvrY_xy
    module procedure a_AvrY_ay
  end interface 

  interface p_AvrY_py
    module procedure a_AvrY_ay
  end interface 

  contains
!--------------------------------------------------------------------
    subroutine xy_axis_init(i, j, xmg, ymg, xmin, xmax, ymin, ymax)
      ! xy κɸͤȳʻֳ֤ꤹ

      integer,intent(in) :: i     ! x ʻ
      integer,intent(in) :: j     ! y ʻ
      integer,intent(in) :: xmg   ! x ʻ
      integer,intent(in) :: ymg   ! y ʻ
      real(DBKIND),intent(in)     :: xmin  ! x ɸǾ     
      real(DBKIND),intent(in)     :: xmax  ! x ɸ  
      real(DBKIND),intent(in)     :: ymin  ! y ɸǾ     
      real(DBKIND),intent(in)     :: ymax  ! y ɸ  

      ! ξ岼¤, ɸͤȳʻֳ֤
      ! * 1 ѤΥ֥롼Ѥ
      !
      call x_axis_init(i, xmg, xmin, xmax)
      call y_axis_init(j, ymg, ymin, ymax)

      ! 2 ɸ
      ! * Ȥ߹ߴؿ spread Ѥ 1  2 ˳ĥ.
      ! 
      allocate(xy_X(imin:imax,jmin:jmax))
      allocate(xy_Y(imin:imax,jmin:jmax))
      allocate(xy_dx(imin:imax,jmin:jmax))
      allocate(py_dx(imin:imax,jmin:jmax))
      allocate(xy_dy(imin:imax,jmin:jmax))
      allocate(xq_dy(imin:imax,jmin:jmax))

      xy_X  = spread(x_X,2,size(y_Y))
      xy_Y  = spread(y_Y,1,size(x_X))
      xy_dx = spread(x_dx,2,size(y_Y))
      py_dx = spread(p_dx,2,size(y_Y))
      xy_dy = spread(y_dy,1,size(x_X))
      xq_dy = spread(q_dy,1,size(x_X))

    end subroutine xy_axis_init  
!--------------------------------------------------------------------
    function xa_avr_pa(pa_Var)
      ! ʿԤʻͤȾʻ֤
  
      real(DBKIND),intent(in) :: pa_Var(imin:imax,jmin:jmax)   ! 
      real(DBKIND)            :: xa_avr_pa(imin:imax,jmin:jmax) ! 
      integer                 :: jy                            ! 롼ź

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xa_avr_pa = 0.0d0

      ! ʿ
      ! * ؿ x_avr_p ѤƷ׻
      !
      do jy = jmin, jmax
        xa_avr_pa(:,jy) = x_avr_p(pa_Var(:,jy))
      end do

    end function xa_avr_pa
!--------------------------------------------------------------------
    function pa_avr_xa(xa_Var)
      ! ʿԤȾʻͤʻ֤
  
      real(DBKIND),intent(in) :: xa_Var(imin:imax,jmin:jmax)   ! 
      real(DBKIND)            :: pa_avr_xa(imin:imax,jmin:jmax) ! 
      integer                 :: jy                            ! 롼ź

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      pa_avr_xa = 0.0d0

      ! ʿ
      ! * ؿ p_x ѤƷ׻
      !
      do jy = jmin, jmax
        pa_avr_xa(:,jy) = p_avr_x(xa_Var(:,jy))
      end do

    end function pa_avr_xa
!--------------------------------------------------------------------
    function ay_avr_aq(aq_Var)
      ! ʿԤʻͤȾʻ֤
  
      real(DBKIND),intent(in) :: aq_Var(imin:imax,jmin:jmax)   ! 
      real(DBKIND)            :: ay_avr_aq(imin:imax,jmin:jmax) ! 
      integer                 :: ix                            ! 롼ź

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      ay_avr_aq = 0.0d0

      ! ʿ
      ! * ؿ y_q ѤƷ׻
      !
      do ix = imin, imax
        ay_avr_aq(ix,:) = y_avr_q(aq_Var(ix,:))
      end do

    end function ay_avr_aq
!--------------------------------------------------------------------
    function aq_avr_ay(ay_Var)
      ! ʿԤȾʻͤʻ֤
  
      real(DBKIND),intent(in) :: ay_Var(imin:imax,jmin:jmax)   ! 
      real(DBKIND)            :: aq_avr_ay(imin:imax,jmin:jmax) ! 
      integer                 :: ix                            ! 롼ź

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      aq_avr_ay = 0.0d0

      ! ʿ
      ! * ؿ q_y ѤƷ׻.
      ! 
      do ix = imin, imax
        aq_avr_ay(ix,:) = q_avr_y(ay_Var(ix,:))
      end do

    end function aq_avr_ay
!--------------------------------------------------------------------
    function a_IntX_xa(xa_Var)
      ! xa ʻҾФ x ˽ŤդʬԤ

      real(DBKIND), intent(in) :: xa_Var(imin:imax,jmin:jmax) ! 
      real(DBKIND)             :: a_IntX_xa(jmin:jmax)        ! 
      integer                  :: jy                          ! 롼ź

      ! 
      a_IntX_xa = 0.0d0

      ! ʬ
      do jy = jmin, jmax
        a_IntX_xa(jy) = IntX_x(xa_Var(:,jy))
      end do
      
    end function a_IntX_xa
!--------------------------------------------------------------------
    function y_IntX_py(py_Var)
      ! py ʻҾФ x ˽ŤդʬԤ

      real(DBKIND), intent(in) :: py_Var(imin:imax,jmin:jmax) ! 
      real(DBKIND)             :: y_IntX_py(jmin:jmax)        ! 
      integer                  :: jy                          ! 롼ź

      ! 
      y_IntX_py = 0.0d0

      ! ʬ
      do jy = jmin, jmax
        y_IntX_py(jy) = IntX_p(py_Var(:,jy))
      end do
      
    end function y_IntX_py
!--------------------------------------------------------------------
    function a_IntY_ay(ay_Var)
      ! ay ʻҾФ y ˽ŤդʬԤ

      real(DBKIND), intent(in) :: ay_Var(imin:imax,jmin:jmax) ! 
      real(DBKIND)             :: a_IntY_ay(imin:imax)        ! 
      integer                  :: ix                          ! 롼ź

      ! 
      a_IntY_ay = 0.0d0

      ! ʬ
      do ix = imin, imax
        a_IntY_ay(ix) = IntY_y(ay_Var(ix,:))
      end do
      
    end function a_IntY_ay
!--------------------------------------------------------------------
    function x_IntY_xq(xq_Var)
      ! ay ʻҾФ y ˽ŤդʬԤ

      real(DBKIND), intent(in) :: xq_Var(imin:imax,jmin:jmax) ! 
      real(DBKIND)             :: x_IntY_xq(imin:imax)        ! 
      integer                  :: ix                          ! 롼ź

      ! 
      x_IntY_xq = 0.0d0

      ! ʬ
      do ix = imin, imax
        x_IntY_xq(ix) = IntY_q(xq_Var(ix,:))
      end do
      
    end function x_IntY_xq
!--------------------------------------------------------------------
    function a_AvrX_xa(xa_Var)
      ! xa ʻҾФ x ʿѤԤ

      real(DBKIND), intent(in) :: xa_Var(imin:imax,jmin:jmax) ! 
      real(DBKIND)             :: a_AvrX_xa(jmin:jmax)        ! 


      a_AvrX_xa = a_IntX_xa(xa_Var)/sum(x_dx(1:im))
      
    end function a_AvrX_xa
!--------------------------------------------------------------------
    function y_AvrX_py(py_Var)
      ! py ʻҾФ x ʿѤԤ

      real(DBKIND), intent(in) :: py_Var(imin:imax,jmin:jmax) ! 
      real(DBKIND)             :: y_AvrX_py(jmin:jmax)        ! 


      y_AvrX_py = y_IntX_py(py_Var)/sum(p_dx(1:im))
      
    end function y_AvrX_py
!--------------------------------------------------------------------
    function a_AvrY_ay(ay_Var)
      ! ay ʻҾФ y ʿѤԤ

      real(DBKIND), intent(in) :: ay_Var(imin:imax,jmin:jmax) ! 
      real(DBKIND)             :: a_AvrY_ay(imin:imax)        ! 


      a_AvrY_ay = a_IntY_ay(ay_Var)/sum(y_dy(1:jm))
      
    end function a_AvrY_ay
!--------------------------------------------------------------------
    function x_AvrY_xq(xq_Var)
      ! xq ʻҾФ y ʿѤԤ

      real(DBKIND), intent(in) :: xq_Var(imin:imax,jmin:jmax) ! 
      real(DBKIND)             :: x_AvrY_xq(imin:imax)        ! 


      x_AvrY_xq = x_IntY_xq(xq_Var)/sum(q_dy(1:jm))
      
    end function x_AvrY_xq
!--------------------------------------------------------------------
    function IntXY_xy(xy_Var)
      ! xy ʻҾФΰʬԤ

      real(DBKIND), intent(in) :: xy_Var(imin:imax,jmin:jmax) ! 
      real(DBKIND)             :: IntXY_xy                    ! 


      IntXY_xy = IntY_y(a_IntX_xa(xy_Var))

    end function IntXY_xy
!--------------------------------------------------------------------
    function IntXY_xq(xq_Var)
      ! xq ʻҾФΰʬԤ

      real(DBKIND), intent(in) :: xq_Var(imin:imax,jmin:jmax) ! 
      real(DBKIND)             :: IntXY_xq                    ! 


      IntXY_xq = IntY_q(a_IntX_xa(xq_Var))

    end function IntXY_xq
!--------------------------------------------------------------------
    function IntXY_py(py_Var)
      ! py ʻҾФΰʬԤ

      real(DBKIND), intent(in) :: py_Var(imin:imax,jmin:jmax) ! 
      real(DBKIND)             :: IntXY_py                    ! 


      IntXY_py = IntY_y(y_IntX_py(py_Var))

    end function IntXY_py
!--------------------------------------------------------------------
    function AvrXY_xy(xy_Var)
      ! xy ʻҾФΰʿѤԤ

      real(DBKIND), intent(in) :: xy_Var(imin:imax,jmin:jmax) ! 
      real(DBKIND)             :: AvrXY_xy                    ! 


      AvrXY_xy = IntXY_xy(xy_Var)/(sum(x_dx(1:im))*sum(y_dy(1:jm)))

    end function AvrXY_xy
!--------------------------------------------------------------------
    function AvrXY_xq(xq_Var)
      ! xq ʻҾФΰʿѤԤ

      real(DBKIND), intent(in) :: xq_Var(imin:imax,jmin:jmax) ! 
      real(DBKIND)             :: AvrXY_xq                    ! 


      AvrXY_xq = IntXY_xq(xq_Var)/(sum(x_dx(1:im))*sum(q_dy(1:jm)))

    end function AvrXY_xq
!--------------------------------------------------------------------
    function AvrXY_py(py_Var)
      ! py ʻҾФΰʿѤԤ

      real(DBKIND), intent(in) :: py_Var(imin:imax,jmin:jmax) ! 
      real(DBKIND)             :: AvrXY_py                    ! 


      AvrXY_py = IntXY_py(py_Var)/(sum(p_dx(1:im))*sum(y_dy(1:jm)))

    end function AvrXY_py
!--------------------------------------------------------------------
end module xy_base_module
