!= Module StoreStab_3d
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: storestab_3d.f90,v 1.1 2008-06-19 16:47:53 odakker Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϥ˴ؤѻͤݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module StoreStab_3d
  !
  !Ϥѻͤݴɤ뤿ѿ⥸塼.
  !
  use dc_types,  only : DP
  use dc_message,only : MessageNotify

  !⥸塼ɤ߹
  use gridset_3d, only:DimXMin,     & ! x β
    &                  DimXMax,     & ! x ξ
    &                  DimYMin,     & ! y β
    &                  DimYMax,     & ! y ξ
    &                  DimZMin,     & ! z β
    &                  DimZMax,     & ! z ξ
    &                  RegXMin,     & ! x ʪΰβ
    &                  RegXMax,     & ! x ʪΰξ
    &                  RegYMin,     & ! y ʪΰβ
    &                  RegYMax        ! y ʪΰξ
  use TimeSet, only:   TimeDisp,    & ! ϻֳִ
    &                  DelTimeLong    ! Ĺ֥ƥå

  !ۤηػ
  implicit none

  !°λ
  private

  !
  public StoreStab_Init, StoreStabMeanXY, StoreStabClean
  public z_StabTemp, z_StabMolWt
  public StoreStabTemp, StoreStabMolWt

  !ѿ
  real(DP), allocatable :: z_StabTemp(:)
  real(DP), allocatable :: z_StabMolWt(:)
  real(DP), allocatable :: xyz_StabTemp(:,:,:)
  real(DP), allocatable :: xyz_StabMolWt(:,:,:)

  save z_StabTemp,  z_StabMolWt
  save xyz_StabTemp, xyz_StabMolWt

contains

  subroutine StoreStab_Init( )
    !롼

    call MessageNotify( "M", "StoreStab_Init", "Initialize" )

    allocate(     &
      & z_StabTemp (DimZMin:DimZMax),  & 
      & z_StabMolWt(DimZMin:DimZMax),  &
      & xyz_StabTemp (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),  & 
      & xyz_StabMolWt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)  &
      &  )
    
    call StoreStabClean()

  end subroutine StoreStab_Init


  subroutine StoreStabClean( )
    !ݴɤͤΥꥢ
    
    z_StabTemp   = 0.0d0
    z_StabMolWt  = 0.0d0
    xyz_StabTemp  = 0.0d0
    xyz_StabMolWt = 0.0d0
    
  end subroutine StoreStabClean


  subroutine StoreStabMeanXY( )
    !ݴɤͤοʿʿ
 
    real(DP) :: CalNum

    CalNum = TimeDisp / DelTimeLong
   
    z_StabTemp  = a_MeanXY_aaa( xyz_StabTemp  ) / CalNum
    z_StabMolWt = a_MeanXY_aaa( xyz_StabMolWt ) / CalNum

  end subroutine StoreStabMeanXY
  

  subroutine StoreStabTemp( xyz_Work )
    !٤δͿݴ

    implicit none

    real(DP), intent(in)  :: xyz_Work (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)              :: xyz_Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    
    xyz_Work2    = xyz_StabTemp + xyz_Work
    xyz_StabTemp = xyz_Work2

  end subroutine StoreStabTemp


  subroutine StoreStabMolWt( xyz_Work )
    !ʬ̤δͿݴ

    implicit none

    real(DP), intent(in)  :: xyz_Work (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)              :: xyz_Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    xyz_Work2     = xyz_StabMolWt + xyz_Work
    xyz_StabMolWt = xyz_Work2
    
  end subroutine StoreStabMolWt

  function a_MeanXY_aaa( var ) 
    !
    ! ʿʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(DP)             :: a_MeanXY_aaa(DimZMin:DimZMax)
                                     !ʿʿ
    real(DP)             :: aa_work(DimYMin:DimYMax,DimZMin:DimZMax)
                                     !ʿʿ

    aa_work = aa_MeanX_aaa(var)

    a_MeanXY_aaa = sum( aa_work(RegYMin:RegYMax, :), 1 ) &
      &           / real(RegYMax - RegYMin + 1, 8) 

  end function a_MeanXY_aaa
  
  function aa_MeanX_aaa( var ) 
    !
    ! ʿʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(DP)             :: aa_MeanX_aaa(DimYMin:DimYMax,DimZMin:DimZMax)
                                     !ʿʿ

    aa_MeanX_aaa = sum( var(RegXMin:RegXMax, :, :), 1 ) &
      &           / real(RegXMax - RegXMin + 1 , 8) 

  end function aa_MeanX_aaa
  
end module StoreStab_3d
