!= Module GridSet
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: gridset.f90,v 1.6 2009-03-10 16:17:25 sugiyama Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϳ줿 NAMELIST ե뤫, ʻ, 
!ݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module gridset
  !
  !Ϳ줿 NAMELIST ե뤫, ʻ, 
  !ݴɤ뤿ѿ⥸塼
  !

  !⥸塼ɤ߹
  use dc_message, only: MessageNotify

  !ۤηػ
  implicit none

  !save °
  save

  !ѿ
  real(8)               :: Xmin, Xmax    ! x ɸλ
  real(8)               :: Zmin, Zmax    ! z ɸλ
  real(8)               :: DelX, DelZ    !ʻҴֳ
  integer               :: NX, NZ        !ʻ
!  integer, parameter    :: MarginX = 5   !Υåɿ
!  integer, parameter    :: MarginZ = 5   !Υåɿ
  integer               :: MarginX       !Υåɿ
  integer               :: MarginZ       !Υåɿ
  integer               :: SpcNum        !ؼο
  integer               :: DimXMin       ! x β
  integer               :: DimXMax       ! x ξ
  integer               :: DimZMin       ! z β
  integer               :: DimZMax       ! z ξ
  integer               :: RegXMin       ! x ʪΰβ
  integer               :: RegXMax       ! x ʪΰξ
  integer               :: RegZMin       ! z ʪΰβ
  integer               :: RegZMax       ! z ʪΰξ
  integer               :: FileNX        !ե
  integer               :: FileNZ        !ե
  integer               :: FileXMin      !ե
  integer               :: FileXMax      !ե
  integer               :: FileZMin      !ե
  integer               :: FileZMax      !ե
  real(8), allocatable  :: s_X(:)        !X ɸ(顼ʻ)
  real(8), allocatable  :: f_X(:)        !X ɸ(٥ȥʻ)
  real(8), allocatable  :: s_Z(:)        !Z ɸ(顼ʻ)
  real(8), allocatable  :: f_Z(:)        !Z ɸ(٥ȥʻ)
  real(8), allocatable  :: x_X(:)        !X ɸ(顼ʻ)
  real(8), allocatable  :: p_X(:)        !X ɸ(٥ȥʻ)
  real(8), allocatable  :: z_Z(:)        !Z ɸ(顼ʻ)
  real(8), allocatable  :: r_Z(:)        !Z ɸ(٥ȥʻ)

contains

  subroutine gridset_init2( im, km, X1, X2, Z1, Z2, mgn, sNum )
    !
    !ʻ׻
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: X1, X2, Z1, Z2
    integer, intent(in) :: im, km, sNum, mgn
    logical             :: flag

    !ѿ
    integer            :: i, k
    integer, parameter :: kind = 8      !٤ɽ

    !-----------------------------------------------------------------
    ! 
    !-----------------------------------------------------------------
    NX = im
    NZ = km
    SpcNum = sNum
    XMin = X1
    XMax = X2
    ZMin = Z1
    ZMax = Z2
    MarginX = mgn
    MarginZ = mgn

    flag = .false.
    call gridset_set( flag )
    
  end subroutine gridset_init2


  subroutine gridset_init(cfgfile)
    !
    !NAMELIST , ʻ׻
    !

    !⥸塼ɤ߹
    use DebugSet, only: DebugOn
    
    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(in) :: cfgfile

    !ѿ
    logical            :: flag

    !-----------------------------------------------------------------
    ! NAMELIST 
    !-----------------------------------------------------------------
    NAMELIST /gridset/ NX, NZ, Xmin, Xmax, Zmin, Zmax, SpcNum
    open (10, FILE=cfgfile)
    read(10, NML=gridset)
    close(10)

    MarginX = 5
    MarginZ = 5

    flag = DebugOn
    call gridset_set(flag)

  end subroutine gridset_init


  subroutine gridset_set(flag)

    implicit none

    !ѿ
    logical, intent(in) :: flag
    integer, parameter :: kind = 8      !٤ɽ
    integer            :: i,k
    
    !-----------------------------------------------------------------
    ! ʻֳַ׻
    !-----------------------------------------------------------------
    DelX = (Xmax - Xmin) / real(NX, kind)
    DelZ = (Zmax - Zmin) / real(NZ, kind)

    !-----------------------------------------------------------------
    ! ʪŪ˰̣Τΰξ¡¤
    !-----------------------------------------------------------------;
    RegXMin = 0
    RegXMax = NX
    RegZMin = 0
    RegZMax = NZ

!    !-----------------------------------------------------------------
!    ! ʪŪ˰̣Τΰξ¡¤
!    !-----------------------------------------------------------------;
!    RegXMin = 1
!    RegXMax = NX
!    RegZMin = 1
!    RegZMax = NZ
!
!    !-----------------------------------------------------------------
!    ! ɤбΰźݴ
!    !-----------------------------------------------------------------;
!    WallXMin = 0
!    WallXMax = NX
!    WallZMin = 0
!    WallZMax = NZ

    !-----------------------------------------------------------------
    ! ξ¡¤
    !-----------------------------------------------------------------
    DimXMin = RegXMin - MarginX
    DimXMax = RegXMax + MarginX
    DimZMin = RegZMin - MarginZ
    DimZMax = RegZMax + MarginZ

    !-----------------------------------------------------------------
    ! åɤ
    !-----------------------------------------------------------------
    allocate( f_X(DimXMin:DimXMax), f_Z(DimZMin:DimZMax) )
    allocate( p_X(DimXMin:DimXMax), r_Z(DimZMin:DimZMax) )
    do i = DimXMin, DimXMax
      f_X(i) = Xmin + DelX * ( real(i, kind) - RegXMin )
    end do
    do k = DimZMin, DimZMax
      f_Z(k) = Zmin + DelZ * ( real(k, kind) - RegZMin )
    end do
    
    p_X = f_X
    r_Z = f_Z
    
    !-----------------------------------------------------------------
    ! ȾʻҤ줿åɤ. ֳ֤ˤƤ.
    !-----------------------------------------------------------------
    allocate( s_X(DimXMin: DimXMax), s_Z(DimZMin: DimZMax) )
    allocate( x_X(DimXMin: DimXMax), z_Z(DimZMin: DimZMax) )
    s_X(DimXMin+1:DimXMax) =           &
      &  (                             &
      &     f_X(DimXMin+1:DimXMax)     &
      &   + f_X(DimXMin:DimXMax-1)     &
      &  ) * 5.0d-1
    s_X(DimXMin) = s_X(DimXMin+1) - DelX
    
    s_Z(DimZMin+1:DimZMax) =           &
      &  (                             &
      &     f_Z(DimZMin+1:DimZMax)     &
      &   + f_Z(DimZMin:DimZMax-1)     &
      &  ) * 5.0d-1
    s_Z(DimZMin) = s_Z(DimZMin+1) - DelZ

    x_X = s_X
    z_Z = f_Z
    !-----------------------------------------------------------------
    ! ǥХå⡼ɤݤ, եϤѤѿ礭Ѥ
    !-----------------------------------------------------------------
!    if (DebugOn) then
    if (flag) then
      FileNX   = size(f_X, 1)
      FileNZ   = size(f_Z, 1)
      FileXMin = DimXMin
      FileXMax = DimXMax
      FileZMin = DimZMin
      FileZMax = DimZMax
    else
      FileNX   = NX
      FileNZ   = NZ
      FileXMin = RegXMin + 1
      FileXMax = RegXMax
      FileZMin = RegZMin + 1
      FileZMax = RegZMax
    end if

    !-----------------------------------------------------------------    
    ! ǧ
    !-----------------------------------------------------------------
    call MessageNotify( "M", "gridset_init", "XMin = %f", d=(/XMin/)    )
    call MessageNotify( "M", "gridset_init", "XMax = %f", d=(/XMax/)    )
    call MessageNotify( "M", "gridset_init", "ZMin = %f", d=(/ZMin/)    )
    call MessageNotify( "M", "gridset_init", "ZMax = %f", d=(/ZMax/)    )
    call MessageNotify( "M", "gridset_init", "DelX = %f", d=(/DelX/)    )
    call MessageNotify( "M", "gridset_init", "DelZ = %f", d=(/DelZ/)    )
    call MessageNotify( "M", "gridset_init", "NX = %d",   i=(/NX/)      )
    call MessageNotify( "M", "gridset_init", "NZ = %d",   i=(/NZ/)      )
    call MessageNotify( "M", "gridset_init", "SpcNum = %d", i=(/SpcNum/) )
    call MessageNotify( "M", "gridset_init", "MarginX = %d", i=(/MarginX/) )
    call MessageNotify( "M", "gridset_init", "MarginZ = %d", i=(/MarginZ/) )
    call MessageNotify( "M", "gridset_init", "DimXMin = %d", i=(/DimXMin/) )
    call MessageNotify( "M", "gridset_init", "DimXMax = %d", i=(/DimXMax/) )
    call MessageNotify( "M", "gridset_init", "DimZMin = %d", i=(/DimZMin/) )
    call MessageNotify( "M", "gridset_init", "DimZMax = %d", i=(/DimZMax/) )
    call MessageNotify( "M", "gridset_init", "RegXMin = %d", i=(/RegXMin/) )
    call MessageNotify( "M", "gridset_init", "RegXMax = %d", i=(/RegXMax/) )
    call MessageNotify( "M", "gridset_init", "RegZMin = %d", i=(/RegZMin/) )
    call MessageNotify( "M", "gridset_init", "RegZMax = %d", i=(/RegZMax/) )
    call MessageNotify( "M", "gridset_init", "FileNX = %d",  i=(/FileNX/))
    call MessageNotify( "M", "gridset_init", "FileNZ = %d",  i=(/FileNZ/))
    call MessageNotify( "M", "gridset_init", "FileXMin = %d", i=(/FileXMin/))
    call MessageNotify( "M", "gridset_init", "FileXMax = %d", i=(/FileXMax/))
    call MessageNotify( "M", "gridset_init", "FileZMin = %d", i=(/FileZMin/))
    call MessageNotify( "M", "gridset_init", "FileZMax = %d", i=(/FileZMax/))

  end subroutine gridset_set
  
end module gridset
