!= Module MoistAdjust
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: moistadjust_3d.f90,v 1.1 2008-06-19 16:53:24 odakker Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!˰Ĵˡ
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

Module MoistAdjust_3d
  !
  !˰ĴˡԤΥѥå⥸塼
  !  * ˰¾Ȥؼ, 층Ū˼¹Ԥ
  !  * ȿˤĤƤ, 줾βȿ˼¹Ԥ. 

  !⥸塼ɤ߹
  use dc_types,   only : DP

  use dc_message, only : MessageNotify

  use gridset_3d, only : SpcNum,            &!ؼο
    &                    DimXMin, DimXMax,  &!x ξ¤Ȳ
    &                    DimYMin, DimYMax,  &!y ξ
    &                    DimZMin, DimZMax    !z β
  use basicset_3d,only : MolWtWet,          &!ʬʬ  
    &                    SpcWetID,          &!ʬβؼID
    &                    xyz_ExnerBasicZ,   &!̵(ܾ)
    &                    xyz_PotTempBasicZ, &!(ܾ)
    &                    xyz_EffMolWtBasicZ,&!ʬ̸
    &                    xyza_MixRtBasicZ,  &!Žʬ(ܾ)
    &                    PressBasis,        &!̤δవ         [Pa]
    &                    CpDry,             &!ʬʿ갵Ǯ [J/K kg]
    &                    MolWtDry,          &!ʬʿʬ   [kg/mol]
    &                    GasRDry             !ʬε     [J/K kg]
  use moistset,   only : CondNum,           &!ŷο
    &                    IdxCG,             &!ŷ()ź
    &                    IdxCC,             &!ŷ()ź
    &                    IdxNH3,            &!NH3()ź
    &                    IdxH2S,            &!H2S()ź
    &                    IdxNH4SHc           !NH4SH()ź
  use ChemCalc_3d, only : xyz_SvapPress, xyz_LatentHeat, ReactHeatNH4SH
  use MoistFunc_3d,only : xyz_DMixRtSatDPotTemp, xyz_DelMixRtNH4SH

  !ۤηػ
  implicit none
  
  !°λ
  private

  !ؿ° public ѹ
  public MoistAdjustSvapPress    !˰¾Ѥ˰¼Ĵ(ʰ)
  public MoistAdjustNH4SH        !ȿΰʿѤ˰¼Ĵ

contains

!!!------------------------------------------------------------------!!!
  subroutine MoistAdjustSvapPress(xyz_Exner, xyz_PotTemp, xyza_MixRt)
    !
    ! ˰¾Ѥ˰Ĵˡμ¹
    ! ץǤ, ͽ᤿ȿɤԤ. 
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8),intent(in)   :: xyz_Exner(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
                                                          !ʡؿ
    real(8),intent(inout):: xyz_PotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
                                                          !
    real(8),intent(inout):: xyza_MixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                                          !
    integer, parameter   :: ItrNum = 4                    !ȿɤβ

    real(DP):: xyz_MixRtV_pre(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_MixRtV_nxt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_MixRtC_pre(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_MixRtC_nxt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_PotTemp_pre(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_PotTemp_nxt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_ExnerAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_TempAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_DelMixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_MixRtSat(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_Cond(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)  
    real(DP):: xyz_Evap(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)  
    real(DP):: xyz_Gamma(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    integer :: i, s                                       ! ź  

    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    xyz_MixRtV_pre  = 0.0d0
    xyz_MixRtV_nxt  = 0.0d0
    xyz_MixRtC_pre  = 0.0d0
    xyz_MixRtC_nxt  = 0.0d0
    xyz_PotTemp_pre = 0.0d0
    xyz_PotTemp_nxt = 0.0d0
    
    xyz_ExnerAll    = 0.0d0
    xyz_TempAll     = 0.0d0
    xyz_DelMixRt    = 0.0d0
    xyz_MixRtSat    = 0.0d0 
    xyz_Gamma       = 0.0d0
    
    !---------------------------------------------------------------------
    ! ˰Ĵˡμ¹
    !   롼פ󤹤Τ, ˤĤƤ.  
    !---------------------------------------------------------------------
    LoopSvapPress: do s = 1, CondNum
      
      !˰ˡǤϰϤѲʤ. 
      xyz_ExnerAll = xyz_Exner + xyz_ExnerBasicZ
          
      !ޤǤ줿ʬ̤ͤȤߤʤ. źɲ
      xyz_MixRtV_pre  = xyza_MixRt(:,:,:,IdxCG(s)) + xyza_MixRtBasicZ(:,:,:,IdxCG(s))
      xyz_MixRtC_pre  = xyza_MixRt(:,:,:,IdxCC(s)) + xyza_MixRtBasicZ(:,:,:,IdxCC(s))
      xyz_PotTemp_pre = xyz_PotTemp
          
      Adjusting: do i = 1, ItrNum
        !---------------------------------------------------------------
        ! ˰¾˰º
        !---------------------------------------------------------------
        !
        xyz_TempAll = ( xyz_PotTemp_pre + xyz_PotTempBasicZ ) * xyz_ExnerAll

        !˰¾˰º׻(ܾ줫κ). 
        xyz_MixRtSat =                                                    &
          & xyz_SvapPress(SpcWetID(IdxCC(s)), xyz_TempAll)              &
          &  * MolWtWet(IdxCC(s))                                     &
          &  / (MolWtDry * PressBasis * (xyz_ExnerAll ** (CpDry / GasRDry)) )

        !ʲ줿Ǯ
        xyz_Gamma = xyz_LatentHeat(SpcWetID(IdxCC(s)), xyz_TempAll) &
          &        * xyz_EffMolWtBasicZ                              &
          &        / (xyz_ExnerAll * CpDry)
        
        !ŷ̤. 
        !  ŷ뤬ˤ, xz_MixRtV_pre - xz_MixRtSat ɬͤȤʤ.
        !  ȯˤ, ȯ̤ - MixRtC Ķ뤳ȤϤʤ. 
        xyz_DelMixRt = &
          & ( xyz_MixRtV_pre - xyz_MixRtSat ) &
          &   / (1.0d0 + xyz_Gamma * xyz_DMixRtSatDPotTemp( &
          &        SpcWetID(IdxCC(s)), MolWtWet(IdxCC(s)), xyz_TempAll, xyz_ExnerAll & 
          &        ) )

        xyz_Cond = max( 0.0d0, min( xyz_MixRtV_pre,   xyz_DelMixRt ) )
        xyz_Evap = max( 0.0d0, min( xyz_MixRtC_pre, - xyz_DelMixRt ) )

        !꿿˶ᤤͤ׻
        xyz_PotTemp_nxt = xyz_PotTemp_pre + xyz_Gamma * ( xyz_Cond - xyz_Evap )
        xyz_MixRtV_nxt  = xyz_MixRtV_pre  - xyz_Cond + xyz_Evap
        xyz_MixRtC_nxt  = xyz_MixRtC_pre  + xyz_Cond - xyz_Evap
        
        !֤Τѿ
        xyz_PotTemp_pre = xyz_PotTemp_nxt
        xyz_MixRtV_pre  = xyz_MixRtV_nxt
        xyz_MixRtC_pre  = xyz_MixRtC_nxt

      end do Adjusting
      
      xyz_PotTemp              = xyz_PotTemp_nxt                 
      xyza_MixRt(:,:,:,IdxCG(s)) = xyz_MixRtV_nxt - xyza_MixRtBasicZ(:,:,:,IdxCG(s))
      xyza_MixRt(:,:,:,IdxCC(s)) = xyz_MixRtC_nxt - xyza_MixRtBasicZ(:,:,:,IdxCC(s))
      
    end do LoopSvapPress
    
  end subroutine MoistAdjustSvapPress


!!!--------------------------------------------------------------------------!!!
  subroutine MoistAdjustNH4SH(xyz_Exner, xyz_PotTemp, xyza_MixRt ) 
    !
    ! NH3 + H2S --> NH4SH ȿΰʿ Kp Ѥ˰¼Ĵˡ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8),intent(in)   :: xyz_Exner(DimXMin:DimXMax,DimXMin:DimXMax,DimZMin:DimZMax) 
                                                          !ʡؿ
    real(8),intent(inout):: xyz_PotTemp(DimXMin:DimXMax,DimXMin:DimXMax,DimZMin:DimZMax) 
                                                          !
    real(8),intent(inout):: xyza_MixRt(DimXMin:DimXMax,DimXMin:DimXMax,DimZMin:DimZMax, SpcNum)
                                                          !Žʬκ
    real(DP):: xyz_PotTemp_pre(DimXMin:DimXMax,DimXMin:DimXMax,DimZMin:DimZMax) 
    real(DP):: xyz_PotTemp_nxt(DimXMin:DimXMax,DimXMin:DimXMax,DimZMin:DimZMax) 
    real(DP):: xyz_MixRtNH3_pre(DimXMin:DimXMax,DimXMin:DimXMax,DimZMin:DimZMax) 
    real(DP):: xyz_MixRtNH3_nxt(DimXMin:DimXMax,DimXMin:DimXMax,DimZMin:DimZMax) 
    real(DP):: xyz_MixRtH2S_pre(DimXMin:DimXMax,DimXMin:DimXMax,DimZMin:DimZMax) 
    real(DP):: xyz_MixRtH2S_nxt(DimXMin:DimXMax,DimXMin:DimXMax,DimZMin:DimZMax) 
    real(DP):: xyz_MixRtNH4SH_pre(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_MixRtNH4SH_nxt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    
    real(DP):: xyz_ExnerAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_PressAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_TempAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_Gamma(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_DelMixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP):: xyz_Cond(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)  
    real(DP)::xyz_Evap(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)  
    
    integer            :: i
    integer, parameter :: ItrNum = 2
            
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    xyz_PotTemp_nxt = 0.0d0
    xyz_MixRtNH3_nxt   = 0.0d0
    xyz_MixRtH2S_nxt   = 0.0d0
    xyz_MixRtNH4SH_nxt = 0.0d0
    
    xyz_Gamma     = 0.0d0
    xyz_DelMixRt  = 0.0d0

    !˰ˡǤϰϤѲʤ. 
    xyz_ExnerAll = xyz_Exner + xyz_ExnerBasicZ
    xyz_PressAll = PressBasis * (xyz_ExnerAll ** (CpDry / GasRDry))
        
    !ޤǤ줿ʬ̤ͤȤߤʤ. źɲ
    xyz_MixRtNH3_pre(:,:,:)   = xyza_MixRt(:,:,:,IdxNH3) &
      &                           + xyza_MixRtBasicZ(:,:,:,IdxNH3)
    xyz_MixRtH2S_pre(:,:,:)   = xyza_MixRt(:,:,:,IdxH2S) &
      &                           + xyza_MixRtBasicZ(:,:,:,IdxH2S)
    xyz_MixRtNH4SH_pre(:,:,:) = xyza_MixRt(:,:,:,IdxNH4SHc) &
      &                           + xyza_MixRtBasicZ(:,:,:,IdxNH4SHc)
    xyz_PotTemp_pre          = xyz_PotTemp
    
    AdjustNH4SH: do i = 1, ItrNum
      !---------------------------------------------------------------
      ! ѿν
      !---------------------------------------------------------------
      !
      xyz_TempAll = ( xyz_PotTemp_pre + xyz_PotTempBasicZ ) * xyz_ExnerAll
      
      !ʲ줿ȿǮ (NH4SH kg ФǮ)
      xyz_Gamma = ReactHeatNH4SH * xyz_EffMolWtBasicZ / ( xyz_ExnerAll * CpDry )

      !NH4SH 
      xyz_DelMixRt =                                                           &
        &    xyz_DelMixRtNH4SH(                                                &
        &          xyz_TempAll, xyz_PressAll, xyz_MixRtNH3_pre, xyz_MixRtH2S_pre, &
        &          MolWtWet(IdxNH3), MolWtWet(IdxH2S)                         &
        &      )

      xyz_Cond = max( 0.0d0, xyz_DelMixRt )
      xyz_Evap = max( 0.0d0, min( - xyz_DelMixRt, xyz_MixRtNH4SH_pre ) )

      !---------------------------------------------------------------
      ! 꿿˶ᤤͤ˰¾˰º
      !---------------------------------------------------------------
      ! NH4SH κ
      xyz_MixRtNH4SH_nxt  = xyz_MixRtNH4SH_pre + xyz_Cond - xyz_Evap
      
      ! DelPress 򸵤, NH3  H2S κ
      xyz_MixRtNH3_nxt = xyz_MixRtNH3_pre - ( xyz_Cond - xyz_Evap )      &
        &                 * MolWtWet(IdxNH3) / MolWtWet(IdxNH4SHc)
      xyz_MixRtH2S_nxt = xyz_MixRtH2S_pre - ( xyz_Cond - xyz_Evap )      &
        &                 * MolWtWet(IdxH2S) / MolWtWet(IdxNH4SHc)
          
      !̤
      xyz_PotTemp_nxt = xyz_PotTemp_pre + xyz_Gamma * ( xyz_Cond - xyz_Evap )
      
      !롼פ󤹤ѿѲ
      xyz_PotTemp_pre    = xyz_PotTemp_nxt
      xyz_MixRtNH3_pre   = xyz_MixRtNH3_nxt 
      xyz_MixRtH2S_pre   = xyz_MixRtH2S_nxt 
      xyz_MixRtNH4SH_pre = xyz_MixRtNH4SH_nxt 

    end do AdjustNH4SH

    xyz_PotTemp              = xyz_PotTemp_nxt                 
    xyza_MixRt(:,:,:,IdxNH3)   = xyz_MixRtNH3_nxt   - xyza_MixRtBasicZ(:,:,:,IdxNH3)
    xyza_MixRt(:,:,:,IdxH2S)   = xyz_MixRtH2S_nxt   - xyza_MixRtBasicZ(:,:,:,IdxH2S)
    xyza_MixRt(:,:,:,IdxNH4SHc) = xyz_MixRtNH4SH_nxt - xyza_MixRtBasicZ(:,:,:,IdxNH4SHc)
    
  end subroutine MoistAdjustNH4SH

  
end Module MoistAdjust_3d
