!= Module ECCM_3d
!
! Authors::   SUGIYAMA Koichiro, ODAKA Masatsugu
! Version::   $Id: eccm_3d.f90,v 1.3 2008-06-19 17:05:40 odakker Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ǮŪ˾徺뵤βٸΨ׻, ſ尵ʿդ鰵Ϥ
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!  * Ǯ, ʿʬ̤
!  * 顼٤­ʤΤ, 󥲥å. 
!
!== Future Plans
!

module ECCM_3d

  !⥸塼ɤ߹
  use dc_types, only : DP
  use dc_trace, only : DbgMessage
  use dc_message, only: MessageNotify

  use gridset_3d,only: DimZMin,       &!  Z β
    &                 DimZMax,       &!  Z ξ 
    &                 RegZMin,       &!
    &                 SpcNum,        &!
    &                 z_dz, r_dz      !
  use basicset_3d,only:  MolWtDry,      &!
    &                 MolWtWet,      &!
    &                 CpDryMol,      &!
    &                 SpcWetID,      &!
    &                 TempSfc,       &!
    &                 PressSfc,      &!
    &                 Grav            !
  use chemcalc_3d, only: SvapPress,        &!
    &                 LatentHeatPerMol, &!
    &                 ReactHeatNH4SHPerMol
  use moistset, only: CondNum,          &!ŷο
    &                 IdxCG,            &!ŷ()ź
    &                 IdxCC,            &!ŷ()ź
    &                 GasNum,           &!Το
    &                 IdxNH3,           &!NH3()ź
    &                 IdxH2S             !H2S()ź
  use ChemData, only: GasRUniv        
  use MoistFunc_3d,only: DelMolFrNH4SH 
  use StoreStab_3d,only: StoreStabTemp, StoreStabMolWt

  !ۤηػ
  implicit none

  !°λ
  private

  !ؿθ
  public ECCM_MolFr
  public ECCM_Stab
  public ECCM_Dry
  public ECCM_Wet

contains

!!!------------------------------------------------------------------------------!!!
  subroutine ECCM_Dry( a_MolFrIni, Humidity, z_Temp, z_Press, z_MolWtMean, za_MolFr )
    !
    !== 
    !  * ǮٸΨ˱ä١ϤᡢФƻꤵ줿м٤Ȥʤ褦˶ŷʬΥ
    !  * Ǯϴ絤ΤΤɽ
    !    * ήΤˤǮϴʬΤΤɽƤ뤿
    !  * 絤ʿʬ̤ˤϼʬʬ̤
    !    * ήΤˤ, ʬʬ̤ϹθƤ뤿
    !
    
    !ۤηػ
    implicit none
    
    real(DP), intent(in) :: a_MolFrIni(1:SpcNum)    !ǤΥ
    real(DP), intent(in) :: Humidity                !м ( Humidity <= 1.0 )
    real(DP), intent(out):: z_Temp(DimZMin:DimZMax) !
    real(DP), intent(out):: z_Press(DimZMin:DimZMax)!
    real(DP), intent(out):: z_MolWtMean(DimZMin:DimZMax) 
                                                   !ʿʬ
    real(DP), intent(out):: za_MolFr(DimZMin:DimZMax, 1:SpcNum) 
                                                   !ʬΨ
    real(DP)             :: MolWtMeanDry            !絤ʬ̤κѿ
    real(DP)             :: MolWtMeanWet            !ᵤʬ̤κѿ
    real(DP)             :: SatPress                !˰¾
    real(DP)             :: VapPress                !
    real(DP)             :: DelMolFr
    integer             :: k, s

    !-------------------------------------------------------------
    ! ν
    !-------------------------------------------------------------
    !ɽ̤ʬ̤
    za_MolFr(RegZMin, 1:SpcNum)   = a_MolFrIni(1:SpcNum) 

    !ɽ̤Ǥʿʬ̤
    MolWtMeanDry = MolWtDry * (1.0d0 - sum(a_MolFrIni))
    MolWtMeanWet = dot_product(MolWtWet, a_MolFrIni) 
    z_MolWtMean(RegZMin) = MolWtMeanDry + MolWtMeanWet
  
    !ɽ̤Ǥβ(RegZMin ,  DelZ / 2 )
    z_Temp          = 1.0d-60
    z_Temp(RegZMin) = TempSfc - Grav * z_MolWtMean(RegZMin) &
      &               / CpDryMol * ( z_dz(RegZMin) * 5.0d-1 )
    
    !ɽ̤Ǥΰ(RegZMin ,  DelZ / 2 )
    z_Press           = 1.0d-60
    z_Press(RegZMin)  = &
      & PressSfc *((TempSfc / z_Temp(RegZMin)) ** (- CpDryMol /  GasRUniv))
    
    !-----------------------------------------------------------
    ! (1) Ǯ˱ä٤
    ! (2) ſ尵ʿդ鰵Ϥ
    ! (3) (1),(2) βٰϤФ, Ȥм٤Ȥʤ
    !-----------------------------------------------------------    
    DtDz: do k = RegZMin, DimZMax-1

      !(1)Ǯ˱ä k+1 Ǥβ٤׻
      z_Temp(k+1) = z_Temp(k) - Grav * z_MolWtMean(k) / CpDryMol * r_dz(k)
      
      !ǰ
      if (z_Temp(k+1) <= 0.0d0 ) z_Temp(k+1) = z_Temp(k) 
      
      !(2)Ϥſ尵ʿդ׻
      z_Press(k+1) =                                                  &
        &  z_Press(k) * ((z_Temp(k) / z_Temp(k+1)) ** (- CpDryMol / GasRUniv)) 

      !(3)η׻
      !  ޤϥѲʤΤȤƥͿ
      !  ˰¾ʿȤʿվŬѤƤ
      za_MolFr(k+1,:) = za_MolFr(k,:)
      
      do s = 1, CondNum      
        !˰¾
        SatPress = SvapPress( SpcWetID(IdxCC(s)), z_Temp(k+1) )        
        
        !ΥʬΨѤƸߤξ׻
        VapPress = za_MolFr(k,IdxCG(s)) * z_Press(k+1)
        
        !˰¾ȰϤ鸽ߤΥ׻
        if ( VapPress > SatPress ) then         
          za_MolFr(k+1,IdxCG(s)) = max(SatPress * Humidity / z_Press(k+1), 1.0d-16)
        end if
      end do
      
      !NH4SH ʿվ
      if ( IdxNH3 /= 0 ) then 
        DelMolFr =                                              &
          & max (                                               &
          &    DelMolFrNH4SH(                                   &
          &         z_Temp(k+1), z_Press(k+1),                  &
          &         za_MolFr(k+1,IdxNH3), za_MolFr(k+1,IdxH2S),       &
          &         Humidity                                    &
          &      ),                                             &
          &    0.0d0                                            &
          &  )
        za_MolFr(k+1,IdxNH3) = za_MolFr(k+1,IdxNH3) - DelMolFr
        za_MolFr(k+1,IdxH2S) = za_MolFr(k+1,IdxH2S) - DelMolFr
      end if
      
      !------------------------------------------------------------
      !ٸۤ׻
      !------------------------------------------------------------
      !ɽ̤Ǥʿʬ̤
      MolWtMeanDry = MolWtDry * (1.0d0 - sum(za_MolFr(k+1, 1:SpcNum)))
      MolWtMeanWet = dot_product(MolWtWet(1:SpcNum), za_MolFr(k+1, 1:SpcNum))
      z_MolWtMean(k+1) = MolWtMeanDry + MolWtMeanWet

    end do DtDz
    
  end subroutine ECCM_Dry


!!------------------------------------------------------------------------------!!!
  subroutine ECCM_Wet( a_MolFrIni, Humidity, z_Temp, z_Press, z_MolWtMean, za_MolFr )
    !
    !== 
    !  * ǮٸΨ˱ä١ϤᡢФƻꤵ줿м٤Ȥʤ褦˶ŷʬΥ
    !  * Ǯϴ絤ΤΤɽ
    !    * ήΤˤǮϴʬΤΤɽƤ뤿
    !  * 絤ʿʬ̤ˤϼʬʬ̤
    !    * ήΤˤ, ʬʬ̤ϹθƤ뤿
    !
    
    !ۤηػ
    implicit none
    
    real(DP), intent(in) :: a_MolFrIni(1:SpcNum)    !ǤΥ
    real(DP), intent(in) :: Humidity                !м ( Humidity <= 1.0 )
    real(DP), intent(out):: z_Temp(DimZMin:DimZMax) !
    real(DP), intent(out):: z_Press(DimZMin:DimZMax)!
    real(DP), intent(out):: z_MolWtMean(DimZMin:DimZMax) 
                                                   !ʿʬ
    real(DP), intent(out):: za_MolFr(DimZMin:DimZMax, 1:SpcNum) 
                                                   !ʬΨ
    real(DP)             :: MolWtMeanDry            !絤ʬ̤κѿ
    real(DP)             :: MolWtMeanWet            !ᵤʬ̤κѿ
    real(DP)             :: SatPress                !˰¾
    real(DP)             :: VapPress                !
    real(DP)             :: DelMolFr
    real(DP)             :: a_MolFr(SpcNum)         !κ
    integer             :: k, s

    real(DP)             :: Temp1, Press1, DTempDZ1
    real(DP)             :: Temp2, Press2, DTempDZ2
    real(DP)             :: Temp3, Press3, DTempDZ3
    real(DP)             :: Temp4, Press4, DTempDZ4
    real(DP)             :: DTempDZ
    
    !-------------------------------------------------------------
    ! ν
    !-------------------------------------------------------------
    !ɽ̤ʬ̤
    za_MolFr(RegZMin, 1:SpcNum)   = a_MolFrIni(1:SpcNum) 
    
    !ɽ̤Ǥʿʬ̤
    MolWtMeanDry = MolWtDry * (1.0d0 - sum(a_MolFrIni))
    MolWtMeanWet = dot_product(MolWtWet, a_MolFrIni) 
    z_MolWtMean(RegZMin) = MolWtMeanDry + MolWtMeanWet
  
    !ɽ̤Ǥβ(RegZMin ,  DelZ / 2 )
    z_Temp          = 1.0d-60
    z_Temp(RegZMin) = TempSfc - Grav * z_MolWtMean(RegZMin) &
      &               / CpDryMol * ( z_dz(RegZMin) * 5.0d-1 )
    
    !ɽ̤Ǥΰ(RegZMin ,  DelZ / 2 )
    z_Press           = 1.0d-60
    z_Press(RegZMin)  = &
      & PressSfc *((TempSfc / z_Temp(RegZMin)) ** (- CpDryMol /  GasRUniv))
    
    !-----------------------------------------------------------
    ! ǮΨ dT/dz η׻. 
    !-----------------------------------------------------------    
    DtDz: do k = RegZMin, DimZMax-1
      
      !
      za_MolFr(k+1,:) = za_MolFr(k,:)
      
      !----------------------------------------------------
      !ǮΨ󥲥åˡѤƷ׻
      !----------------------------------------------------
      ! (0)  k Ǥͤݴ
      Temp1  = z_Temp(k)
      Press1 = z_Press(k)
      a_MolFr  = za_MolFr(k,:)

      ! (1)  k ǤͤѤƲѲ׻
      call ECCM_DTempDZ( Temp1, Press1, r_dz(k), a_MolFr, DTempDZ1 )

      ! (2) (1) ǵ᤿ͤѤ,  k + k/2 ǤͤѤƲѲ׻
      !     ΤȤ, ʬ̤ѲʤΤȤ.
      Temp2  = Temp1 + DTempDZ1 * r_dz(k) * 5.0d-1
      Press2 =                                     &
        & Press1 * ((Temp1 / Temp3) ** (Grav * MolWtDry / (GasRUniv * DTempDZ2))) 
      call ECCM_DTempDZ( Temp2, Press2, r_dz(k), a_MolFr, DTempDZ2 )

      ! (3) (2) ǵ᤿ͤѤ,  k + k/2 ǤͤѤƲѲ׻
      !     ΤȤ, ʬ̤ѲʤΤȤ.
      Temp3  = Temp1 + DTempDZ2 * r_dz(k) * 5.0d-1
      Press3 =                                                                   &
        & Press1 * ((Temp1 / Temp3) ** (Grav * MolWtDry / (GasRUniv * DTempDZ2)))
      call ECCM_DTempDZ( Temp3, Press3, r_dz(k), a_MolFr, DTempDZ3 )
      
      ! (4) (3) ǵ᤿ͤѤ,  k + k ǤͤѤƲѲ׻
      !     ΤȤ, ʬ̤ѲʤΤȤ.
      Temp4  = Temp1 + DTempDZ3 * r_dz(k)
      Press4 =                                               &
        & Press1 * ((Temp1 / Temp4) ** (Grav * MolWtDry / (GasRUniv * DTempDZ3)))
      call ECCM_DTempDZ( Temp4, Press4, r_dz(k), a_MolFr, DTempDZ4 )
      
      ! (5) ǽŪʷ
      DTempDZ = (DTempDZ1 + DTempDZ2 * 2.0d0 + DTempDZ3 * 2.0d0 + DTempDZ4) / 6.0d0

      !----------------------------------------------------
      !줿ٸΨ겹٤ȰϤ
      !----------------------------------------------------
      !٤׻
      z_Temp(k+1) = z_Temp(k) + DTempDz * r_dz(k)

      !ǰ
      if(z_Temp(k+1) < 0.0d0) z_Temp(k+1) = z_Temp(k) 
      
      !Ϥſ尵ʿդ׻
      z_Press(k+1) =                                                  &
        &  z_Press(k) * ( ( z_Temp(k) / z_Temp(k+1))                  &
        &    ** (Grav * MolWtDry / ( DTempDZ * GasRUniv ) ) )
      
      !----------------------------------------------------
      !η׻
      !----------------------------------------------------
      do s = 1, CondNum      
        !˰¾
        SatPress = SvapPress( SpcWetID(IdxCC(s)), z_Temp(k+1) )
        
        !ΥʬΨѤƸߤξ׻
        VapPress = za_MolFr(k,IdxCG(s)) * z_Press(k+1)
        
        !˰¾ȰϤ鸽ߤΥ׻
        if ( VapPress > SatPress ) then         
          za_MolFr(k+1,IdxCG(s)) = max(SatPress * Humidity / z_Press(k+1), 1.0d-16)
        end if
      end do
      
      !NH4SH ʿվ
      if ( IdxNH3 /= 0 ) then 
        DelMolFr =                                              &
          & max (                                               &
          &    DelMolFrNH4SH(                                   &
          &         z_Temp(k+1), z_Press(k+1),                  &
          &         za_MolFr(k+1,IdxNH3), za_MolFr(k+1,IdxH2S),       &
          &         Humidity                                    &
          &      ),                                             &
          &    0.0d0                                            &
          &  )
        za_MolFr(k+1,IdxNH3) = za_MolFr(k+1,IdxNH3) - DelMolFr
        za_MolFr(k+1,IdxH2S) = za_MolFr(k+1,IdxH2S) - DelMolFr
      end if
      
      !------------------------------------------------------------
      !ɽ̤Ǥʿʬ̤
      !------------------------------------------------------------
      MolWtMeanDry = MolWtDry * (1.0d0 - sum(za_MolFr(k+1, 1:SpcNum)))
      MolWtMeanWet = dot_product(MolWtWet(1:SpcNum), za_MolFr(k+1, 1:SpcNum))
      z_MolWtMean(k+1) = MolWtMeanDry + MolWtMeanWet

    end do DtDz
    
  end subroutine ECCM_Wet

!!!------------------------------------------------------------------------------!!!
  subroutine ECCM_MolFr( a_MolFrIni, Humidity, z_Temp, z_Press, za_MolFr )
    !
    ! Ϳ줿٤Ф, ǮŪ˾徺˼¸
    ! Υץե
    !

    
    !ۤηػ
    implicit none
    
    real(DP), intent(in) :: a_MolFrIni(1:SpcNum)
    real(DP), intent(in) :: Humidity
    real(DP), intent(in) :: z_Temp(DimZMin:DimZMax)
    real(DP), intent(in) :: z_Press(DimZMin:DimZMax)
    real(DP), intent(out):: za_MolFr(DimZMin:DimZMax, 1:SpcNum)
    
    real(DP)             :: DelMolFr
    integer             :: k, s
    

    !-----------------------------------------------------------
    ! ν
    !-----------------------------------------------------------
    do s = 1, SpcNum
      za_MolFr(:,s) = a_MolFrIni(s) 
    end do

    !-----------------------------------------------------------
    ! ǮΨ dT/dz η׻. 
    !-----------------------------------------------------------
    do k = RegZMin, DimZMax

      za_MolFr(k,:) = za_MolFr(k-1,:)
      
      !------------------------------------------------------------
      !NH4SH ʳβؼʿվ
      !------------------------------------------------------------
      do s = 1, CondNum

        !
        !ΥƥåפǤΥĶ뤳ȤϤʤ
        za_MolFr(k,IdxCG(s)) =                                 &
          & min(                                                &
          &       za_MolFr(k-1,IdxCG(s)),                      &
          &       SvapPress( SpcWetID(IdxCC(s)), z_Temp(k) ) &
          &        * Humidity / z_Press(k)                      &
          &      )
        
      end do

      !------------------------------------------------------------
      !NH4SH ʿվ
      !------------------------------------------------------------
      if ( IdxNH3 /= 0 ) then 
        
        !Ѳ. 
        !Ȥꤢ NH4SH Ф˰ 1.0 Ȥ(ȴ...).
        DelMolFr =                                            &
          & max (                                             &
          &    DelMolFrNH4SH(                                 &
          &      z_Temp(k), z_Press(k),                       &
          &      za_MolFr(k,IdxNH3), za_MolFr(k,IdxH2S), Humidity   &
          &     ),                                            &
          &    0.0d0                                          &
          &  )
        
        za_MolFr(k,IdxNH3) = za_MolFr(k,IdxNH3) - DelMolFr 
        za_MolFr(k,IdxH2S) = za_MolFr(k,IdxH2S) - DelMolFr
      end if
      
    end do
  end subroutine ECCM_MolFr

!!!------------------------------------------------------------------------------!!!
  subroutine ECCM_DTempDZ( Temp, Press, DelZ, MolFr, DTempDZ )
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: Temp
    real(DP), intent(in) :: Press
    real(DP), intent(in) :: DelZ
    real(DP), intent(inout) :: MolFr(0:SpcNum)    !ʬΨ
    real(DP), intent(out):: DTempDZ
    real(DP)            :: ReactHeat
    real(DP)            :: Heat(SpcNum)
    real(DP)            :: DelMolFr
    real(DP)            :: SatPress
    real(DP)            :: VapPress
    real(DP)            :: Humidity
    real(DP)            :: A, B
    integer             :: s

    !
    DTempDZ      = 0.0d0
    ReactHeat    = 0.0d0
    Heat         = 0.0d0
    DelMolFr     = 0.0d0
    SatPress     = 0.0d0
    VapPress     = 0.0d0

    !------------------------------------------------------------
    !NH4SH ʳβؼʿվ
    !------------------------------------------------------------
    do s = 1, CondNum      
      
      !˰¾
      SatPress = SvapPress( SpcWetID(IdxCC(s)), Temp )
      
      !Ǯ. 
      Heat(IdxCG(s)) = LatentHeatPerMol( SpcWetID(IdxCC(s)), Temp )
      
      !ΥʬΨѤƸߤξ׻
      VapPress = MolFr(IdxCG(s)) * Press
      
      !˰¾ŷ̵ͭ
      if ( VapPress < SatPress ) then         
        !ŷ뤷ƤʤΤǮʤ.
        Heat(IdxCG(s)) = 0.0d0          

      else      

        !˰¾ȰϤ鸽ߤΥ׻
        MolFr(IdxCG(s)) = max(SatPress / Press, 1.0d-16)

      end if
    end do
    
    !------------------------------------------------------------
    !NH4SH ʿվ
    !------------------------------------------------------------
    if ( IdxNH3 /= 0 ) then 
      
      Humidity = 1.0d0
      DelMolFr =                                            &
        & max (                                             &
        &    DelMolFrNH4SH(                                 &
        &         Temp, Press, MolFr(IdxNH3), MolFr(IdxH2S),&
        &         Humidity                                  &
        &      ),                                           &
        &    0.0d0                                          &
        &  )
      MolFr(IdxNH3) = MolFr(IdxNH3) - DelMolFr
      MolFr(IdxH2S) = MolFr(IdxH2S) - DelMolFr

      ReactHeat = ReactHeatNH4SHPerMol * DelMolFr
    end if
    
    !------------------------------------------------------------
    !ٸۤ׻
    !------------------------------------------------------------
    !.  Temp(i) ɾ
    A = dot_product( Heat(1:SpcNum), MolFr(1:SpcNum)) &
      &  / ( GasRUniv * Temp )
    B = dot_product(( Heat(1:SpcNum) ** 2.0d0), MolFr(1:SpcNum)) &
      &  / ( CpDryMol * GasRUniv * ( Temp ** 2.0d0 ) )
    
    !ǮٸΨ
    DTempDZ = - Grav * MolWtDry * (1.0d0 + A) / (CpDryMol * (1.0d0 + B))  &
      &       + ReactHeat / (CpDryMol * DelZ)
    
  end subroutine ECCM_DTempDZ

!!!------------------------------------------------------------------------------!!!
  subroutine ECCM_Stab( xyz_PotTemp, xyz_Exner, xyza_MixRt )

    use gridset_3d,only: DimXMin,       &!  X β
      &                 DimXMax,       &!  X ξ 
      &                 DimYMin,       &!  Y β
      &                 DimYMax,       &!  Y ξ 
      &                 DimZMin,       &!  Z β
      &                 DimZMax,       &!  Z ξ 
      &                 SpcNum          !
    use basicset_3d,only:  MolWtDry,      &!
      &                 MolWtWet,      &!
      &                 CpDry,         &!
      &                 Grav,          &!
      &                 xyz_ExnerBasicZ,   &!
      &                 xyz_PotTempBasicZ, &! 
      &                 xyz_EffMolWtBasicZ, &!
      &                 xyza_MixRtBasicZ

    use xyz_base_module, only : xyz_avr_xyr
    use xyz_deriv_module,only : xyr_dz_xyz
    
    implicit none

    real(DP), intent(in)  :: xyz_PotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)  :: xyz_Exner(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)  :: xyza_MixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)

    real(DP) :: xyz_Stab(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP) :: xyz_StabTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP) :: xyz_StabMolWt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    real(DP)   :: xyza_MolFrAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum)
    real(DP)   :: xyz_TempAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)   :: xyz_MolWtWet(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    integer    :: i, j, k, s

    xyz_TempAll = (xyz_PotTemp + xyz_PotTempBasicZ) * (xyz_Exner + xyz_ExnerBasicZ)
    do s = 1, SpcNum
      xyza_MolFrAll(:,:,:,s) =                             &
        &   (xyza_MixRt(:,:,:,s) + xyza_MixRtBasicZ(:,:,:,s)) &
        &   * MolWtDry / MolWtWet(s) 
    end do
    
    do k = DimZMin, DimZMax
    do j = DimYMin, DimYMax
    do i = DimXMin, DimXMax
      xyz_MolWtWet(i,j,k) = &
        &     dot_product( MolWtWet(1:GasNum), xyza_MolFrAll(i,j,k,1:GasNum) )
    end do
    end do
    end do
    
    xyz_StabTemp =                                               &
      &         Grav / xyz_TempAll                               &
      &           * (   xyz_avr_xyr( xyr_dz_xyz( xyz_TempAll ) ) &
      &               + Grav * xyz_EffMolWtBasicZ / CpDry ) 
    xyz_StabMolWt =                                              &
      &       - Grav * xyz_avr_xyr( xyr_dz_xyz( xyz_MolWtWet ) ) &
      &         / ( MolWtDry * xyz_EffMolWtBasicZ )   
    xyz_Stab = xyz_StabTemp + xyz_StabMolWt

    call StoreStabTemp( xyz_StabTemp ) 
    call StoreStabMolWt( xyz_StabMolWt ) 

    where (xyz_Stab < 1.0d-7) 
      xyz_Stab = 1.0d-7
    end where

  end subroutine ECCM_Stab

end module ECCM_3d
