!= Module DynFunc_3D
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu 
! Version::   $Id: dynfunc_3d.f90,v 1.5 2008-06-26 09:24:27 odakker2 Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ǥϳز׻뤿ɬפȤʤؿ«ͤ⥸塼
!Ūˤϰʲι׻뤿δؿǼ.  
!  * ή
!  * Ϲ
!  * Ϲ
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!  * ʡؿζΥˤ, 2 ٤ΥۤѤƤ뤿, Ϲη׻ץˤ differentiate_center4 ⥸塼ꤹ뤳ȤϤǤʤΤ.
!
!== Future Plans
!

module DynFunc_3d
  !
  !۳Ѥϳزγƹη׻⥸塼. 
  !Ūˤϰʲι׻뤿δؿǼ.  
  !  * ή
  !  * Ϲ
  !  * Ϲ
  !

  !⥸塼ɤ߹
  use dc_types, only: DP

  use gridset_3d, only:  DimXMin,           &! x β
    &                 DimXMax,           &! x ξ
    &                 DimYMin,           &! y β
    &                 DimYMax,           &! y ξ
    &                 DimZMin,           &! z β
    &                 DimZMax,           &! z ξ
    &                 SpcNum              !
  use damping_3d,  only: DampSound           !Ȥθ그
  use basicset_3d, only: xyz_PotTempBasicZ,  &!ܾβ
    &                 CpDry,             &!ʬǮ
    &                 Grav                !ϲ®
  use xyz_module, only: &
    &                xyz_avr_pyz, xyr_avr_pyr, xqz_avr_pqz, &
    &                pyz_avr_xyz, pyr_avr_xyr, pqz_avr_xqz, &
    &                xyz_avr_xqz, pyz_avr_pqz, xyr_avr_xqr, &
    &                xqz_avr_xyz, pqz_avr_pyz, xqr_avr_xyr, &
    &                xyz_avr_xyr, pyz_avr_pyr, xqz_avr_xqr, &
    &                xyr_avr_xyz, pyr_avr_pyz, xqr_avr_xqz 
  use StorePotTemp_3d,  only: StorePotTempAdv
  use StoreMixRt_3d,    only: StoreMixRtAdv

  !ۤηػ
  implicit none

  !°λ
  private

  !ή׻Τδؿ public ˤ
  public xyz_AdvScalar
  public xyz_AdvKm
  public xyza_AdvScalar
  public pyz_AdvVelX
  public xqz_AdvVelY
  public xyr_AdvVelZ

  !Ϲ׻Τδؿ public ˤ
  public xyr_Buoy

  !Ϥη׻Τδؿ public ˤ
  public pyz_GradPi
  public xqz_GradPi


contains


!!!------------------------------------------------------------------------!!!
  function xyz_AdvScalar(xyz_Var, pyz_VelX, xqz_VelY, xyr_VelZ)
    !
    ! x, z ȾʻҤ줿ˤή׻
    !
    
    !⥸塼ɤ߹
    use xyz_deriv_c4_module, only: pyz_dx_xyz, xqz_dy_xyz, xyr_dz_xyz

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: pyz_VelX &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿ®
    real(DP), intent(in) :: xqz_VelY &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿ®
    real(DP), intent(in) :: xyr_VelZ &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ľ®
    real(DP), intent(in) :: xyz_Var &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !顼
    real(DP)             :: xyz_AdvScalar &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !顼̤οʿή
    
    xyz_AdvScalar =                               &
      & - xyz_avr_pyz(pyz_VelX * pyz_dx_xyz(xyz_Var))  &
      & - xyz_avr_xqz(xqz_VelY * xqz_dy_xyz(xyz_Var))  &
      & - xyz_avr_xyr(xyr_VelZ * xyr_dz_xyz(xyz_Var))    

    call StorePotTempAdv( xyz_AdvScalar )   

  end function xyz_AdvScalar


!!!------------------------------------------------------------------------!!!
  function xyz_AdvKm(xyz_Var, pyz_VelX, xqz_VelY, xyr_VelZ)
    !
    ! x, z ȾʻҤ줿ˤή׻
    !
    
    !⥸塼ɤ߹
    use xyz_deriv_c4_module, only: pyz_dx_xyz, xqz_dy_xyz, xyr_dz_xyz

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: pyz_VelX &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿ®
    real(DP), intent(in) :: xqz_VelY &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿ®
    real(DP), intent(in) :: xyr_VelZ &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ľ®
    real(DP), intent(in) :: xyz_Var &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !顼
    real(DP)             :: xyz_AdvKm &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !顼̤οʿή
    
    xyz_AdvKm =                               &
      & - xyz_avr_pyz(pyz_VelX * pyz_dx_xyz(xyz_Var))  &
      & - xyz_avr_xqz(xqz_VelY * xqz_dy_xyz(xyz_Var))  &
      & - xyz_avr_xyr(xyr_VelZ * xyr_dz_xyz(xyz_Var))    

  end function xyz_AdvKm

!!!------------------------------------------------------------------------!!!
  function xyza_AdvScalar(xyza_Var, pyz_VelX, xqz_VelY, xyr_VelZ)
    !
    ! x, z ȾʻҤ줿ˤή׻
    !
    
    !⥸塼ɤ߹
    use xyz_deriv_c4_module, only: pyz_dx_xyz, xqz_dy_xyz, xyr_dz_xyz
!    use xyz_deriv_module, only: pyz_dx_xyz, xqz_dy_xyz, xyr_dz_xyz

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: pyz_VelX &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿ®
    real(DP), intent(in) :: xqz_VelY &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿ®
    real(DP), intent(in) :: xyr_VelZ &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ľ®
    real(DP), intent(in) :: xyza_Var &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum)
                                                        !顼
    real(DP)             :: xyza_AdvScalar &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum)
                                                        !顼̤οʿή
    integer :: s ! 롼ѿ

    do s = 1, SpcNum        
      xyza_AdvScalar(:,:,:,s) =                                  &
        & - xyz_avr_pyz(pyz_VelX * pyz_dx_xyz(xyza_Var(:,:,:,s))) &
        & - xyz_avr_xqz(xqz_VelY * xqz_dy_xyz(xyza_Var(:,:,:,s))) &
        & - xyz_avr_xyr(xyr_VelZ * xyr_dz_xyz(xyza_Var(:,:,:,s)))    
    end do

    call StoreMixRtAdv( xyza_AdvScalar )   

  end function xyza_AdvScalar
!!!------------------------------------------------------------------------!!!
  function pyz_AdvVelX(pyz_VelX, xqz_VelY, xyr_VelZ)
    !
    ! z ȾʻҤ줿ˤή׻
    !
    
    !⥸塼ɤ߹
    use xyz_deriv_c4_module, only: xyz_dx_pyz, pqz_dy_pyz, pyr_dz_pyz

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: pyz_VelX &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿ®
    real(DP), intent(in) :: xqz_VelY &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿ®
    real(DP), intent(in) :: xyr_VelZ &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ľ®
    real(DP)             :: pyz_AdvVelX(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿΰή
    
!    pz_AdvVelX = 0.0d0  !

    pyz_AdvVelX =                                                 &
      & - pyz_VelX * pyz_avr_xyz( xyz_dx_pyz( pyz_VelX ) )        &
      & - pyz_avr_pqz( pqz_avr_xqz( xqz_VelY ) * pqz_dy_pyz( pyz_VelX ) ) &
      & - pyz_avr_pyr( pyr_avr_xyr( xyr_VelZ ) * pyr_dz_pyz( pyz_VelX ) )

    
  end function pyz_AdvVelX


!!!------------------------------------------------------------------------!!!
  function xyr_AdvVelZ(pyz_VelX, xqz_VelY, xyr_VelZ)
    !
    ! x ȾʻҤ줿ˤή׻
    !
    
    !⥸塼ɤ߹
    use xyz_deriv_c4_module, only: pyr_dx_xyr, xqr_dy_xyr, xyz_dz_xyr
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: pyz_VelX &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿ®
    real(DP), intent(in) :: xqz_VelY &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿ®
    real(DP), intent(in) :: xyr_VelZ &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ľ®
    real(DP)             :: xyr_AdvVelZ &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ľΰή
  
!    xr_AdvVelZ = 0.0d0  !
    xyr_AdvVelZ =                                                 &
      & - xyr_avr_pyr( pyr_avr_pyz( pyz_VelX ) * pyr_dx_xyr( xyr_VelZ ) ) &
      & - xyr_avr_xqr( xqr_avr_xqz( xqz_VelY ) * xqr_dy_xyr( xyr_VelZ ) ) &
      & - xyr_VelZ * xyr_avr_xyz( xyz_dz_xyr( xyr_VelZ ) )
    
  end function xyr_AdvVelZ

!!!------------------------------------------------------------------------!!!
  function xqz_AdvVelY(pyz_VelX, xqz_VelY, xyr_VelZ)
    !
    ! x ȾʻҤ줿ˤή׻
    !
    
    !⥸塼ɤ߹
    use xyz_deriv_c4_module, only: pqz_dx_xqz, xyz_dy_xqz, xqr_dz_xqz
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: pyz_VelX &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿ®
    real(DP), intent(in) :: xqz_VelY &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿ®
    real(DP), intent(in) :: xyr_VelZ &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ľ®
    real(DP)             :: xqz_AdvVelY &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ľΰή
  
!    xr_AdvVelZ = 0.0d0  !
    xqz_AdvVelY =                                                 &
      & - xqz_avr_pqz( pqz_avr_pyz( pyz_VelX ) * pqz_dx_xqz( xqz_VelY ) ) &
      & - xqz_VelY * xqz_avr_xyz( xyz_dy_xqz( xqz_VelY ) ) &
      & - xqz_avr_xqr( xqr_avr_xyr( xyr_VelZ ) * xqr_dz_xqz( xqz_VelY ) )
    
  end function xqz_AdvVelY

 
!!!------------------------------------------------------------------------!!!
  function xyr_Buoy(xyz_PotTemp)
    !
    ! ľαư˸Ϲ׻

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in)  :: xyz_PotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !̾
    real(DP)              :: xyr_Buoy &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !Ϲ

!    !
!    xr_Buoy = 0.0d0

    !Ϲη׻
    xyr_Buoy = Grav * xyr_avr_xyz(xyz_PotTemp / xyz_PotTempBasicZ)

  end function xyr_Buoy


!!!------------------------------------------------------------------------!!!
  function pyz_GradPi(xyz_Exner, pyz_VelX, xqz_VelY, xyr_VelZ)
    !
    ! z ȾʻҤ줿ǤΰϷϹη׻. 
    ! ȸޤ᤿꼰Ƥ뤳Ȥ.
    !
    
    !⥸塼ɤ߹

    use xyz_deriv_module, only: xyz_dx_pyz, xyz_dy_xqz, xyz_dz_xyr, pyz_dx_xyz
        
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: xyz_Exner &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ʡؿξ
    real(DP), intent(in) :: pyz_VelX &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ʿ®
    real(DP), intent(in) :: xqz_VelY &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ʿ®
    real(DP), intent(in) :: xyr_VelZ &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ľ®
    real(DP)             :: pyz_GradPi &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !Ϸ
    real(DP)             :: xyz_DivVel &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !®٤μ«

    !®٤μ«
    xyz_DivVel = xyz_dx_pyz( pyz_VelX ) + xyz_dy_xqz( xqz_VelY ) &
      &          + xyz_dz_xyr( xyr_VelZ )
    
    !Ϸ
!    pyz_GradPi = 0.0d0
    pyz_GradPi =  &
      & pyz_avr_xyz( CpDry * xyz_PotTempBasicZ )    &
      &   * ( pyz_dx_xyz( xyz_Exner ) &
      &       - pyz_dx_xyz( DampSound * xyz_DivVel ) )  
    
  end function pyz_GradPi
!!!------------------------------------------------------------------------!!!
  function xqz_GradPi(xyz_Exner, pyz_VelX, xqz_VelY, xyr_VelZ)
    !
    ! y ȾʻҤ줿ǤΰϷϹη׻. 
    ! ȸޤ᤿꼰Ƥ뤳Ȥ.
    !
    
    !⥸塼ɤ߹

    use xyz_deriv_module, only: xyz_dx_pyz, xyz_dy_xqz, xyz_dz_xyr, xqz_dy_xyz
        
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in)  :: xyz_Exner &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ʡؿξ
    real(DP), intent(in)  :: pyz_VelX &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ʿ®
    real(DP), intent(in)  :: xqz_VelY &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ʿ®
    real(DP), intent(in)  :: xyr_VelZ &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ľ®
    real(DP)              :: xqz_GradPi &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !Ϸ
    real(DP)              :: xyz_DivVel &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !®٤μ«

    !®٤μ«
    xyz_DivVel = xyz_dx_pyz( pyz_VelX ) + xyz_dy_xqz( xqz_VelY ) &
      &          + xyz_dz_xyr( xyr_VelZ )
    
    !Ϸ
!    xqz_GradPi = 0.0d0
    xqz_GradPi =  &
      & xqz_avr_xyz( CpDry * xyz_PotTempBasicZ )    &
      &   * ( xqz_dy_xyz( xyz_Exner )               &
      &       - xqz_dy_xyz( DampSound * xyz_DivVel ) )  
    
  end function xqz_GradPi
  
end module DynFunc_3d
