!= Module Damping
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: damping.f90,v 1.1 2009-03-05 05:39:43 yamasita Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ΨȤη׻ԤΥѥå⥸塼
!  * ȸη
!  * ݥؤ(նȤȿͤޤۼ뤿)
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!  * δؿ, ܾ줬ѿ(®, ʡؿξ)
!    ŬѤ뤳ȤꤷƤ. 
!  * ƳʻФؿɬפ
!
!== Future Plans
!
!

module Damping
  !
  !ΨȤη׻ԤΥѥå⥸塼
  !  * ȸη
  !  * ݥؤ(նȤȿͤޤۼ뤿)
  ! 

  !⥸塼ɤ߹
  use dc_message, only: MessageNotify

  use gridset, only: DimXMin,       &! x β
    &                DimXMax,       &! x ξ
    &                DimZMin,       &! z β
    &                DimZMax,       &! z ξ
    &                DelX,          &! x γʻֳ
    &                DelZ,          &! z γʻֳ
    &                s_X,           &!X ɸ(顼ʻ)
    &                s_Z,           &!Z ɸ(顼ʻ)
    &                f_X,           &!X ɸ(եåʻ)
    &                f_Z,           &!Z ɸ(եåʻ)
    &                XMax,          &!X ɸκ
    &                ZMax            !Z ɸκ
  use timeset,   only: DelTimeShort  !û֥ƥå
  
  !ۤηػ
  implicit none

  !private °
  private 
  
  !ؿˤ public °
  public Damping_Init
  public DampSound_Init
  public DampSponge_Init
  public DampSponge_xz
  public DampSponge_xr
  public DampSponge_pz
  public DampSound

  !ѿ
  real(8)  :: DampSound  = 0.0d0   !ȸθ그

  real(8)  :: EFTime     = 100.0d0 !ݥؤ e-folding time
  real(8)  :: DampDepthH = 0.0d0   !ݥؤθ(ʿ)
  real(8)  :: DampDepthV = 0.0d0   !ݥؤθ(ľ)
  real(8), allocatable    :: xz_DampRateH(:,:) !ss ʻ그(ʿ)
  real(8), allocatable    :: xz_DampRateV(:,:) !ss ʻ그(ľ)
  real(8), allocatable    :: pz_DampRateH(:,:) !fs ʻ그(ʿ)
  real(8), allocatable    :: pz_DampRateV(:,:) !fs ʻ그(ľ)
  real(8), allocatable    :: xr_DampRateH(:,:) !sf ʻ그(ʿ)
  real(8), allocatable    :: xr_DampRateV(:,:) !sf ʻ그(ľ)
  
  !ͤ save 
  save DampSound, EFTime, DampDepthH, DampDepthV
  save xz_DampRateH, xz_DampRateV
  save xr_DampRateH, xr_DampRateV
  save pz_DampRateH, pz_DampRateV
  
contains 
  
!!!------------------------------------------------------------------------!!!
  subroutine Damping_Init( cfgfile ) 
    !
    ! ȸȥݥؤθ그ν
    ! 

    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(in) :: cfgfile
    real(8)                  :: Alpha    !ȸη
    real(8)                  :: Time     !
    real(8)                  :: DepthH   !ݥؤθ(ʿ)
    real(8)                  :: DepthV   !ݥؤθ(ľ)

    !NAMELIST 
    NAMELIST /damping/ Alpha, Time, DepthH, DepthV
    open (10, FILE=cfgfile)
    read(10, NML=damping)
    close(10)

    !
    call DampSound_Init( Alpha ) 
    call DampSponge_Init( Time, DepthH, DepthV )


  end subroutine Damping_Init


!!!------------------------------------------------------------------------!!!
  subroutine DampSound_Init( damp ) 
    !
    ! ȸθ그ν
    ! 

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)  :: damp

    !-------------------------------------------------------------------
    ! ȸθΨ   Min(DelX, DelZ) ** 2.0 
    !-------------------------------------------------------------------
    DampSound = Damp * ( Min(DelX, DelZ) ** 2.0d0 ) / DelTimeShort
    
    !-----------------------------------------------------------------    
    ! ͤγǧ
    !-----------------------------------------------------------------
    call MessageNotify( "M", &
      & "DampSound_init", "DampSound = %f", d=(/DampSound/) )

  end subroutine DampSound_Init


!!!------------------------------------------------------------------------!!!
  subroutine DampSponge_Init( Time, DepthH, DepthV )
    !
    ! ݥؤθ그
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: Time     !ݥؤ e-folding time
    real(8), intent(in)   :: DepthH   !ݥؤθ(ʿ)
    real(8), intent(in)   :: DepthV   !ݥؤθ(ľ)
    real(8), parameter    :: Pi =3.1415926535897932385d0   !߼Ψ
    integer               :: i, k

    !
    allocate( &
      & xz_DampRateH(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_DampRateV(DimXMin:DimXMax, DimZMin:DimZMax), &
      & pz_DampRateH(DimXMin:DimXMax, DimZMin:DimZMax), &
      & pz_DampRateV(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xr_DampRateH(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xr_DampRateV(DimXMin:DimXMax, DimZMin:DimZMax)    )
    xz_DampRateH = 0.0d0
    xz_DampRateV = 0.0d0
    pz_DampRateH = 0.0d0
    pz_DampRateV = 0.0d0
    xr_DampRateH = 0.0d0
    xr_DampRateV = 0.0d0

    !ͤ
    EFTime     = Time
    DampDepthH = DepthH
    DampDepthV = DepthV
    
    !-----------------------------------------------------------------    
    ! ݥؤθΨ
    !-----------------------------------------------------------------
    !ʿ¦¦
    if ( DampDepthH < DelX ) then 
      call MessageNotify( "W", &
        & "DampSponge_Init", "DampDepthH is too thin. DelX is %f", d=(/DelX/))

    else
      do i = DimXMin, DimXMax
        !顼ʻ¦
        if ( s_X(i) < DampDepthH) then 
          xz_DampRateH(i,:) = ((1.0d0 - s_X(i) / DampDepthH) ** 3.0d0) / EFTime
        end if
        
        !եåʻ¦
        if ( f_X(i) < DampDepthH) then 
          pz_DampRateH(i,:) = ((1.0d0 - f_X(i) / DampDepthH) ** 3.0d0) / EFTime
         end if
        
        !顼ʻ¦    
        if ( s_X(i) > ( XMax - DampDepthH ) ) then 
          xz_DampRateH(i,:) = &
            & ((1.0d0 - (XMax - s_X(i)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
        
        !եåʻ¦    
        if ( f_X(i) > ( XMax - DampDepthH ) ) then 
          pz_DampRateH(i,:) = &
            & ((1.0d0 - (XMax - f_X(i)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
      end do
    end if
    !sf  ss  X ˴ؤƤƱ
    xr_DampRateH  = xz_DampRateH
    
    !ľξ    
    if ( DampDepthV < DelZ ) then 
      call MessageNotify( "W", &
        & "DampSponge_Init", "DampDepthV is too thin. DelZ is %f", d=(/DelZ/) )
      
    else
      do k = DimZMin, DimZMax
        !顼ʻ
        if ( s_Z(k) >= ( ZMax - DampDepthV ) ) then 
          xz_DampRateV(:,k) =  &
            & (1.0d0 - dcos(Pi * (s_Z(k) - ZMax + DampDepthV) / DampDepthV)) &
            &  / EFTime 
        end if
        
        !եåʻ
        if ( f_Z(k) >= ( ZMax - DampDepthV ) ) then 
          xr_DampRateV(:,k) =  &
            & (1.0d0 - dcos(Pi * (f_Z(k) - ZMax + DampDepthV)/ DampDepthV)) &
            &  / EFTime 
        end if
      end do
    end if
    !fs  ss  Z ˴ؤƤƱ
    pz_DampRateV  = xz_DampRateV
    
    !-----------------------------------------------------------------    
    ! ͤγǧ
    !-----------------------------------------------------------------

    call MessageNotify( "M", "DampSponge_Init", "EFTime = %f", d=(/EFTime/) )
    call MessageNotify( "M", "DampSponge_Init", "DampDepthH = %f", d=(/DampDepthH/) )
    call MessageNotify( "M", "DampSponge_Init", "DampDepthV = %f", d=(/DampDepthV/) )  

  end subroutine DampSponge_Init
  

!!!------------------------------------------------------------------------!!!
  subroutine DampSponge_xz(xz_VarA, xz_VarB, DelTime)
    !
    ! ss ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(inout):: xz_VarA(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: xz_VarB(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: DelTime
    real(8)               :: xz_Var(DimXMin:DimXMax, DimZMin:DimZMax)
    
    !ݥؤˤԥ󥰤׻
    xz_Var  =  xz_VarA - ( xz_DampRateH + xz_DampRateV ) * xz_VarB * DelTime
    xz_VarA = xz_Var
    
  end subroutine DampSponge_xz


!!!------------------------------------------------------------------------!!!
  subroutine DampSponge_xr(xr_VarA, xr_VarB, DelTime)
    !
    ! sf ʻФ륹ݥ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(inout):: xr_VarA(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: xr_VarB(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: DelTime
    real(8)               :: xr_Var(DimXMin:DimXMax, DimZMin:DimZMax)

    !ݥؤˤԥ󥰤׻  
    xr_Var  = xr_VarA - ( xr_DampRateH + xr_DampRateV )* xr_VarB * DelTime
    xr_VarA = xr_Var
    
  end subroutine DampSponge_xr
  

!!!------------------------------------------------------------------------!!!
  subroutine DampSponge_pz(pz_VarA, pz_VarB, DelTime)
    !
    ! fs ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(inout):: pz_VarA(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: pz_VarB(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: DelTime
    real(8)               :: pz_Var(DimXMin:DimXMax, DimZMin:DimZMax)
    
    !ݥؤˤԥ󥰤׻  
    pz_Var  = pz_VarA - ( pz_DampRateH + pz_DampRateV ) * pz_VarB * DelTime
    pz_VarA = pz_Var
    
  end subroutine DampSponge_pz
  
end module Damping
