!= Module Boundary
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: boundary.f90,v 1.1 2009-03-05 05:39:43 yamasita Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϳ뤿Υ⥸塼. 
! type ˻ꤵ줿狼, ֤Τפʬͤꤹ
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module boundary

  !⥸塼ɤ߹
  use gridset, only: MarginX,       &! x ζΥåɿ
    &                MarginZ,       &! z ζΥåɿ
    &                DimXMin,       &! x β
    &                DimXMax,       &! x ξ
    &                DimZMin,       &! z β
    &                DimZMax,       &! z ξ
    &                RegXMin,       &! x ʪΰβ
    &                RegXMax,       &! x ʪΰξ
    &                RegZMin,       &! z ʪΰβ
    &                RegZMax,       &! z ʪΰξ
    &                SpcNum          ! ؼο
     
  !ۤηػ
  implicit none

  !private °ˤ
  private
	
  !ؿ public ˤ
  public BoundaryXCyc_xza
  public BoundaryXCyc_xz
  public BoundaryXCyc_pz
  public BoundaryXCyc_xr

  public BoundaryZSym_xza
  public BoundaryZSym_xz
  public BoundaryZSym_pz
  public BoundaryZSym_xr

  public BoundaryZAntiSym_xza
  public BoundaryZAntiSym_xz
  public BoundaryZAntiSym_pz
  public BoundaryZAntiSym_xr

  !ؿ. 2  3 Ʊ褦ʴؿΤ򤱤뤿.
  interface BoundaryXCyc_xza
    module procedure BoundaryXCyc_aaa
  end interface
  interface BoundaryXCyc_xz
    module procedure BoundaryXCyc_aa
  end interface
  interface BoundaryXCyc_pz
    module procedure BoundaryXCyc_aa
  end interface 
  interface BoundaryXCyc_xr
    module procedure BoundaryXCyc_aa
  end interface 

  interface BoundaryZSym_xza
    module procedure BoundaryZSym_aza
  end interface 
  interface BoundaryZSym_xz
    module procedure BoundaryZSym_az
  end interface 
  interface BoundaryZSym_pz
    module procedure BoundaryZSym_az
  end interface
  interface BoundaryZSym_xr
    module procedure BoundaryZSym_ar
  end interface 
  
  interface BoundaryZAntiSym_xza
    module procedure BoundaryZAntiSym_aza
  end interface 
  interface BoundaryZAntiSym_xz
    module procedure BoundaryZAntiSym_az
  end interface 
  interface BoundaryZAntiSym_pz
    module procedure BoundaryZAntiSym_az
  end interface
  interface BoundaryZAntiSym_xr
    module procedure BoundaryZAntiSym_ar
  end interface

contains

!!!---------------------------------------------------------------------!!!
  subroutine BoundaryXCyc_aa( aa_Var )
    !
    ! x ˡּפŬѤ. 
    ! ʻ, ȾʻˤƤ, ؿηƱ
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(inout)  :: aa_Var(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)                 :: aa_Work(DimXMin:DimXMax, DimZMin:DimZMax)
    integer                 :: i
    
    aa_Work = aa_Var

    !ɤͤ
    aa_Var(RegXMin, :) = aa_Work(RegXMax, :)    

    !ɤγ¦ͤ
    do i = 1, MarginX
      aa_Var(RegXMin - i, :) = aa_Work(RegXMax - i, :)    
      aa_Var(RegXMax + i, :) = aa_Work(RegXMin + i, :) 
    end do
    
  end subroutine BoundaryXCyc_aa


!!!---------------------------------------------------------------------!!!
  subroutine BoundaryXCyc_aaa( aaa_Var )
    !
    ! x ˡּפŬѤ. 
    ! ʻ, ȾʻˤƤ, ؿηƱ
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(inout)  :: aaa_Var(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)                 :: aaa_Work(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    integer                 :: i
    
    aaa_Work = aaa_Var

    !ɤͤ
    aaa_Var(RegXMin, :, :) = aaa_Work(RegXMax, :, :)

    !ɤγ¦ͤ
    do i = 1, MarginX
      aaa_Var(RegXMin - i, :, :) = aaa_Work(RegXMax - i, :, :)
      aaa_Var(RegXMax + i, :, :) = aaa_Work(RegXMin + i, :, :) 
    end do
    
  end subroutine BoundaryXCyc_aaa


!!!---------------------------------------------------------------------!!!
  subroutine BoundaryZSym_az( az_Var )
    !
    ! z ȾʻҤ줿¸ߤѿФ, 
    ! z ˡоζפŬѤ. 
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(inout)  :: az_Var(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)                 :: az_Work(DimXMin:DimXMax, DimZMin:DimZMax)
    integer                 :: k
  
    az_Work = az_Var

    do k = 0, MarginZ
      az_Var( :, RegZMin - k ) = az_Work( :, RegZMin + 1 + k )
    end do
    do k = 1, MarginZ
      az_Var( :, RegZMax + k ) = az_Work( :, RegZMax + 1 - k )
    end do
    
  end subroutine BoundaryZSym_az


!!!---------------------------------------------------------------------!!!
  subroutine BoundaryZSym_aza( aza_Var )
    !
    ! z ȾʻҤ줿¸ߤѿФ, 
    ! z ˡоζפŬѤ. 
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(inout)  :: aza_Var(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)                 :: aza_Work(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    integer                 :: k
  
    aza_Work = aza_Var

    do k = 0, MarginZ
      aza_Var( :, RegZMin - k, : ) = aza_Work( :, RegZMin + 1 + k, : )
    end do
    do k = 1, MarginZ
      aza_Var( :, RegZMax + k, : ) = aza_Work( :, RegZMax + 1 - k, : )
    end do
    
  end subroutine BoundaryZSym_aza


!!!---------------------------------------------------------------------!!!
  subroutine BoundaryZAntiSym_az( az_Var )
    !
    ! z ȾʻҤ줿¸ߤѿФ, 
    ! z ˡȿоζפŬѤ. 
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(inout)  :: az_Var(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)                 :: az_Work(DimXMin:DimXMax, DimZMin:DimZMax)
    integer                 :: k
    
    az_Work = az_Var
    
    do k = 0, MarginZ
      az_Var( :, RegZMin - k ) = - az_Work( :, RegZMin + 1 + k )
    end do
    do k = 1, MarginZ
      az_Var( :, RegZMax + k ) = - az_Work( :, RegZMax + 1 - k )
    end do
    
  end subroutine BoundaryZAntiSym_az
  

!!!---------------------------------------------------------------------!!!
  subroutine BoundaryZAntiSym_aza( aza_Var )
    !
    ! z ȾʻҤ줿¸ߤѿФ, 
    ! z ˡȿоζפŬѤ. 
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(inout)  :: aza_Var(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)                 :: aza_Work(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    integer                 :: k
    
    aza_Work = aza_Var
    
    do k = 0, MarginZ
      aza_Var( :, RegZMin - k, : ) = - aza_Work( :, RegZMin + 1 + k, : )
    end do
    do k = 1, MarginZ
      aza_Var( :, RegZMax + k, : ) = - aza_Work( :, RegZMax + 1 - k, : )
    end do
    
  end subroutine BoundaryZAntiSym_aza
  

!!!---------------------------------------------------------------------!!!
  subroutine BoundaryZSym_ar( ar_Var )
    !
    ! z γʻ¸ߤѿФ, 
    ! z ˡоζפŬѤ. 
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(inout)  :: ar_Var(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)                 :: ar_Work(DimXMin:DimXMax, DimZMin:DimZMax)
    integer                 :: k
  
    ar_Work = ar_Var

    !Ǥ®٤ϥ
    ar_Var( :, RegZMin ) = 0.0d0
    ar_Var( :, RegZMax ) = 0.0d0
    
    do k = 1, MarginZ
      ar_Var( :, RegZMin - k ) = ar_Work( :, RegZMin + k )
      ar_Var( :, RegZMax + k ) = ar_Work( :, RegZMax - k )
    end do
    
  end subroutine BoundaryZSym_ar


!!!---------------------------------------------------------------------!!!
  subroutine BoundaryZAntiSym_ar( ar_Var )
    !
    ! z γʻ¸ߤѿФ, 
    ! z ˡȿоζפŬѤ. 
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(inout)  :: ar_Var(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)                 :: ar_Work(DimXMin:DimXMax, DimZMin:DimZMax)
    integer                 :: k
  
    ar_Work = ar_Var

    !Ǥ®٤ϥ
    ar_Var( :, RegZMin ) = 0.0d0
    ar_Var( :, RegZMax ) = 0.0d0

    do k = 1, MarginZ
      ar_Var( :, RegZMin - k ) = - ar_Work( :, RegZMin + k )
      ar_Var( :, RegZMax + k ) = - ar_Work( :, RegZMax - k )
    end do
    
  end subroutine BoundaryZAntiSym_ar


end module boundary
