!= Module Turbulence
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: turbulence.f90,v 1.1 2009-03-05 05:39:43 yamasita Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ή׻. 
!ǥʪ׻뤿ɬפȤʤؿ«ͤ⥸塼
!Ūˤϰʲι׻뤿δؿǼ.  
!  * ήȻ
!  * ήͥ륮λȯŸ˴ޤޤƹ
!  * Ǯ
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!  * 1.5 Υ㡼Ѥ
!  * 꼰 CReSS Υޥ˥奢򻲾Ȥ
!
!== Future Plans
!
!

module Turbulence
  !
  !ǥʪ׻뤿ɬפȤʤؿ«ͤ⥸塼
  !Ūˤϰʲι׻뤿δؿǼ.  
  !  * ήȻ
  !  * ήͥ륮λȯŸ˴ޤޤƹ
  !  * Ǯ
  !

  !⥸塼ɤ߹ 
  use gridset, only:  DimXMin,           &! x β
    &                 DimXMax,           &! x ξ
    &                 DimZMin,           &! z β
    &                 DimZMax,           &! z ξ
    &                 SpcNum,            &! z ξ
    &                 DelX,              &! x γʻֳ
    &                 DelZ                ! z γʻֳ
  use basicset, only: CpDry,             &!ʬǮ
    &                 Grav,              &!ϲ®
    &                 xz_PotTempBasicZ,  &!ܾβ
    &                 xz_EffMolWtBasicZ, &!ܾʬ̤θ
    &                 xz_ExnerBasicZ      !ʡؿδܾ
  use average,  only: xz_avr_pz, xz_avr_xr, xz_avr_pr, &
    &                 pz_avr_xz, &
    &                 pr_avr_xz, &
    &                 xr_avr_xz
!  use differentiate_center2, only: xz_dx_pz, xz_dz_xr, &
!    &                              xr_dx_pr, xr_dz_xz, &
!    &                              pz_dx_xz, pz_dz_pr, &
!    &                              pr_dx_xr, pr_dz_pz
  use differentiate_center4, only: xz_dx_pz, xz_dz_xr, &
    &                              xr_dx_pr, xr_dz_xz, &
    &                              pz_dx_xz, pz_dz_pr, &
    &                              pr_dx_xr, pr_dz_pz
  use StorePotTemp, only: StorePotTempDisp, StorePotTempTurb
  use StoreMixRt,   only: StoreMixRtTurb


  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public 
  public Turbulence_Init
  public xz_TurbScalar
  public xza_TurbScalar
  public pz_TurbVelX
  public xr_TurbVelZ
  public xz_ShearKm
  public xz_DispKm
  public xz_DispHeat
  public xz_BuoyKm
  public EddyViscosity


  !ѿ
  real(8)  :: Cm     = 2.0d-1    !ήͥ륮Ǽη 
  real(8)  :: MixLen = 0.0d0     !ʿѺΥ

  !ͤ¸
  save Cm, MixLen

contains

!!!------------------------------------------------------------------------!!!
  subroutine turbulence_init()
    !
    ! Turbulence ⥸塼ν롼
    ! 
    
    !ۤηػ
    implicit none

    !Υ
!    MixLen = sqrt(DelX * DelZ) 
    MixLen = min(DelX,  DelZ) 

  end subroutine turbulence_init
  
!!!------------------------------------------------------------------------!!!
  function xz_TurbScalar(xz_Var, xz_Kh)
    !
    ! x, z ȾʻҤ줿ǤήȻ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xz_Var(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !顼
    real(8), intent(in) :: xz_Kh(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ήȻ
    real(8)             :: xz_TurbScalar(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !顼̤οʿήȻ
  
!    xz_TurbScalar = 0.0d0  !
    xz_TurbScalar =                                          &
      &   xz_dx_pz(pz_avr_xz(xz_Kh) * pz_dx_xz(xz_Var))  &
      & + xz_dz_xr(xr_avr_xz(xz_Kh) * xr_dz_xz(xz_Var))

    call StorePotTempTurb( xz_TurbScalar )    
    
  end function xz_TurbScalar


!!!------------------------------------------------------------------------!!!
  function xza_TurbScalar(xza_Var, xz_Kh)
    !
    ! x, z ȾʻҤ줿ǤήȻ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xza_Var(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                                    !顼
    real(8), intent(in) :: xz_Kh(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ήȻ
    real(8)             :: xza_TurbScalar(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                                    !顼̤οʿήȻ
    integer             :: s
  
    do s = 1, SpcNum
      xza_TurbScalar(:,:,s) =                                      &
        &   xz_dx_pz(pz_avr_xz(xz_Kh) * pz_dx_xz(xza_Var(:,:,s)))  &
        & + xz_dz_xr(xr_avr_xz(xz_Kh) * xr_dz_xz(xza_Var(:,:,s)))
    end do

    call StoreMixRtTurb( xza_TurbScalar )    
    
  end function xza_TurbScalar


!!!------------------------------------------------------------------------!!!
  function pz_TurbVelX(xz_Km, pz_VelX, xr_VelZ)
    !
    ! ʿ®٤ФήȻ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ʿ®
    real(8), intent(in) :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ľ®
    real(8), intent(in) :: xz_Km(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ήȻ
    real(8)             :: pz_TurbVelX(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !顼̤οʿήȻ
  
!    pz_TurbVelX = 0.0d0  !  
    pz_TurbVelX = &
      &   2.0d0 * pz_dx_xz( xz_Km * xz_dx_pz( pz_VelX ) )     &
      & + pz_dz_pr(                                           &
      &       pr_avr_xz( xz_Km ) * pr_dx_xr( xr_VelZ )        &
      &     + pr_avr_xz( xz_Km ) * pr_dz_pz( pz_VelX )        &
      &   )                                                   &
      & - 2.0d0 * pz_dx_xz( ( xz_Km ** 2.0d0 ) )              &
      &   / ( 3.0d0 * ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 ) )
    
  end function pz_TurbVelX


!!!------------------------------------------------------------------------!!!
  function xr_TurbVelZ(xz_Km, pz_VelX, xr_VelZ)
    !
    !ľ®٤ФήȻ
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ʿ®
    real(8), intent(in) :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ľ®
    real(8), intent(in) :: xz_Km(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ήȻ
    real(8)             :: xr_TurbVelZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !顼̤οʿήȻ
  
!    xr_TurbVelZ = 0.0d0  !
    xr_TurbVelZ = &
      & + 2.0d0 * xr_dz_xz( xz_Km * xz_dz_xr( xr_VelZ ) )        &
      & + xr_dx_pr(                                              &
      &      pr_avr_xz( xz_Km ) * pr_dz_pz( pz_VelX )            &
      &    + pr_avr_xz( xz_Km ) * pr_dx_xr( xr_VelZ )            &
      &   )                                                      &
      & - 2.0d0 * xr_dz_xz( ( xz_Km ** 2.0d0 ) )                 &
      &   / ( 3.0d0 * ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 ) )
    
  end function xr_TurbVelZ


!!!------------------------------------------------------------------------!!!
  function xz_ShearKm(xz_Km, pz_VelX, xr_VelZ)
    !
    !®٥ˤήͥ륮
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8)             :: xz_ShearKm(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !Ǵΰή
    real(8), intent(in) :: xz_Km(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !Ǵ
    real(8), intent(in) :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !ʿ®
    real(8), intent(in) :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !ľ®
  
!    xz_ShearKm = 0.0d0
    xz_ShearKm = &
      &   ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 )                    &
      & * (                                                        &
      &      (xz_dx_pz(pz_VelX)) ** 2.0d0                          &
      &    + (xz_dz_xr(xr_VelZ)) ** 2.0d0                          &
      &    + 5.0d-1                                                &
      &      * (                                                   &
      &          (                                                 &
      &              xz_avr_pr(pr_dz_pz(pz_VelX))                  &
      &            + xz_avr_pr(pr_dx_xr(xr_VelZ))                  &
      &           ) ** 2.0d0                                       &
      &        )                                                   &
      &   )                                                        &
      & - xz_Km * (xz_dx_pz(pz_VelX) + xz_dz_xr(xr_VelZ)) / 3.0d0
    
  end function xz_ShearKm


!!!------------------------------------------------------------------------!!!
  function xz_TurbKm(xz_Km)
    !
    ! ήͥ륮γȻ
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8)             :: xz_TurbKm(DimXMin:DimXMax, DimZMin:DimZMax)
                                               ! ήͥ륮γȻ
    real(8), intent(in) :: xz_Km(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !Ǵ

!    xz_TurbKm = 0.0d0
    xz_TurbKm =                                      &
!      &     xz_dx_pz(pz_dx_xz(xz_Km)) * 5.0d-1       &
!      &   + xz_dz_xr(xr_dz_xz(xz_Km)) * 5.0d-1       &
      &     xz_dx_pz(pz_dx_xz(xz_Km ** 2.0d0)) * 5.0d-1  &
      &   + xz_dz_xr(xr_dz_xz(xz_Km ** 2.0d0)) * 5.0d-1  &
      &   + (xz_avr_pz(pz_dx_xz(xz_Km))) ** 2.0d0        & 
      &   + (xz_avr_xr(xr_dz_xz(xz_Km))) ** 2.0d0
    
  end function xz_TurbKm


!!!------------------------------------------------------------------------!!!
  function xz_DispKm(xz_Km)
    !
    !ήͥ륮ξû
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8)             :: xz_DispKm(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ήͥ륮ξû
    real(8), intent(in) :: xz_Km(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !Ǵ

!    xz_DispKm = 0.0d0
    xz_DispKm = - (xz_Km ** 2.0d0) * 5.0d-1 / (MixLen ** 2.0d0)
    
  end function xz_DispKm


!!!------------------------------------------------------------------------!!!
  function xz_DispHeat(xz_Km)
    !
    !̤λǮ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8)             :: xz_DispHeat(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ήͥ륮ξû
    real(8), intent(in) :: xz_Km(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !Ǵ

!    xz_DispHeat = 0.0d0
    xz_DispHeat = (xz_Km ** 3.0d0) * xz_EffMolWtBasicZ &
      &        / (xz_ExnerBasicZ * CpDry * (Cm ** 2.0d0) * (MixLen ** 4.0d0))

    !ͤݴ
    call StorePotTempDisp( xz_DispHeat )
    
  end function xz_DispHeat


!!!------------------------------------------------------------------------!!!
  function xz_BuoyKm(xz_PotTemp)
    !
    !ήͥ륮Ϲ׻. 絤. 
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !̾
    real(8)              :: xz_BuoyKm(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !Ϲ

    !Ϲη׻
!    xz_BuoyKm = 0.0d0
    xz_BuoyKm = &
      &  - 3.0d0 * Grav * ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 ) &
      &       * xz_avr_xr( xr_dz_xz( xz_PotTemp + xz_PotTempBasicZ ) ) &
      &       / ( 2.0d0 * xz_PotTempBasicZ )
    
  end function xz_BuoyKm

!!!------------------------------------------------------------------------!!!
  subroutine EddyViscosity(pz_VelX, xr_VelZ, xz_PotTemp, xz_Km, xz_KmA)
    !
    ! ήͥ륮ȤαȻ, Ǵ. 
    ! ήѥ᥿ꥼ, Mellor and Yamada (1974) 
    ! Level 1 Closure б뤬, Level1 Closure ¸ߤ 
    ! \bar{\theta^2} ̵뤵Ƥ. 

    !--- ۤηػ
    implicit none

    real(8), intent(in)  :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8), intent(in)  :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8), intent(in)  :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)  :: xz_Km(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8), intent(out) :: xz_KmA(DimXMin:DimXMax, DimZMin:DimZMax) 

    xz_KmA = &
      & sqrt ( &
      &   max( 0.0d0, &
      &        ( xz_ShearKm(xz_Km, pz_VelX, xr_VelZ) + &
      &          xz_BuoyKm(xz_PotTemp) ) * MixLen ** 2.0d0 ) )

  end subroutine EddyViscosity

end module Turbulence
