!= Program Arare
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: arare_081115.f90,v 1.1 2009-03-05 05:39:41 yamasita Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
! ϳإǥ deepconv/arare. 
! ή. 
! 
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!  * ϤϽవ̷.
!  * ή׻. 
!  * ̩٤η׻ήǴγθ̤ϹθƤʤ. 
!  * ưͥ륮̡̤. 
!
!== Future Plans
!
!

program arare
  !
  !ϳإǥ deepconv/arare. 
  !

  !----- ⥸塼ɤ߹ ------

  !-----   , ʸ   ----
  use dc_types,       only : STRING
  use dc_string,      only : StoA

  !-----   å   -----
  use dc_message,     only: MessageNotify

  !  ޥɥ饤
  use argset,        only : argset_init  

  !-----    ⥸塼   -----
  !  ̷׻⥸塼
  use ChemCalc, only: ChemCalc_init
  use chemdata, only: chemdata_init

  !  ϥե̾⥸塼
  use fileset,       only : fileset_init, &
    &                       InitFile

  !  ǥХåϴ⥸塼
  use debugset,      only : debugset_init

  !  ִ⥸塼
  use timeset,       only : timeset_init, &
    &                       NstepLong, NstepShort, DelTimeLong, DelTimeShort, &
    &                       NstepDisp

!  !  ʻ⥸塼 
!  use gridset,       only : gridset_init, &
!    &                       DimXMin, DimXMax, DimZMin, DimZMax, SpcNum

  !  ʻ⥸塼 
  use gridset,       only : gridset_init, &
    &                       DimXMin, DimXMax, DimZMin, DimZMax, SpcNum, &
    &                       RegXMin, RegXMax, RegZMin, RegZMax, &
    &                       DelX, DelZ, Xmin, Xmax

!  !  ܾ⥸塼
!  use basicset,      only : basicset_init, &
!    &                       xz_DensBasicZ, xza_MixRtBasicZ, xz_PotTempBasicZ, &
!    &                       xz_VelSoundBasicZ, xz_ExnerBasicZ

  !  ܾ⥸塼
  use basicset,      only : basicset_init, &
    &                       xz_DensBasicZ, xza_MixRtBasicZ, xz_PotTempBasicZ, &
    &                       xz_VelSoundBasicZ, xz_ExnerBasicZ, &
    &                       CpDry, GasRDry, Grav, PressSfc
 
  ! ʿ⥸塼(顼ʻ, եåʻ֤Ѵ)
  use average,       only : xz_avr_pz, xz_avr_xr

  !  ѻʹ⥸塼
  use StorePotTemp,      only : StorePotTemp_init, StorePotTempClean, &
    &                           StorePotTempCond
  use StoreMixRt,        only : StoreMixRt_init, StoreMixRtClean, &
    &                           StoreMixRtCond, StoreMixRtFill1, StoreMixRtFill2
  use StoreBuoy,         only : StoreBuoy_init, StoreBuoyClean
  use StoreStab,         only : StoreStab_init, StoreStabClean

  !  롼⥸塼
  use moistset,      only: moistset_init

  !-----    ⥸塼   -----
  !  ໤׻⥸塼 
  use damping,       only : damping_init, & 
    &                        DampSponge_xz, DampSponge_pz, DampSponge_xr

  !  ʬե륿⥸塼
  use timefilter,    only : AsselinFilter_xz, AsselinFilter_xr, &
    &                        AsselinFilter_pz, AsselinFilter_xza

  !  Ŭѥ⥸塼
  use boundary,    only : BoundaryXCyc_xz, BoundaryZSym_xz,     &
    &                      BoundaryXCyc_xza, BoundaryZSym_xza,   &
    &                      BoundaryXCyc_pz, BoundaryZSym_pz,     &
    &                      BoundaryXCyc_xr, BoundaryZAntiSym_xr

  !  CFL ǧ⥸塼
  use cflcheck,      only : CFLCheckTimeShort, &
    &                       CFLCheckTimeLongVelX, CFLCheckTimeLongVelZ

  !  μ̤Ŷ׻⥸塼
  use fillnegative,  only : FillNegative_init, xza_FillNegative_xza

  !-----    ϥ⥸塼   -----
  !  ꥹȥեϥ⥸塼
  use RestartFileIO, only : ReStartFile_Open, ReStartFile_OutPut, &
    &                       ReStartFile_Close, ReStartFile_Get

  !  ҥȥեϥ⥸塼
  use HistoryFileIO, only : HistoryFile_Open, HistoryFile_OutPut, &
    &                       HistoryFile_Close

  !-----       ϳز        -----
  !  ϳز׻Ѵؿ⥸塼
  use DynFunc,       only : xz_AdvScalar, xz_AdvKm, xza_AdvScalar, pz_AdvVelX, &
    &                       xr_Buoy, xr_AdvVelZ, pz_GradPi
  
  !  ϳزˡ׻Ѵؿ⥸塼
  !use DynImpFunc,    only : xz_Exner_init, xz_Exner, xr_GradPi 
                                               ! ʬŷ
  use DynImpFuncMarscond,    only : xz_Exner_init, xz_Exner, xr_GradPi
                                               ! ʬŷ
  
  !-----       ʪ        -----
  !  ͳȻ׻ѥ⥸塼
  use NumDiffusion,  only : NumDiffusion_Init, xz_NumDiffScalar, xz_NumDiffKm, &
    &                       xza_NumDiffScalar, pz_NumDiffVelX, xr_NumDiffVelZ

  !  ήȻ׻ѥ⥸塼
  use Turbulence,   only : Turbulence_Init, &
    &                      xz_TurbScalar, xza_TurbScalar, pz_TurbVelX, &
    &                      xr_TurbVelZ  , xz_ShearKm    , xz_DispKm,   &
    &                      xz_DispHeat
  
  !  Ͷ׻ѥ⥸塼
  use Radiation,    only : Radiation_init,  &
    &                      xz_RadHeatConst  
  
  !  ɽեå׻ѥ⥸塼
!  use HeatFlux,     only : xz_HeatFluxBulk, xz_MixRtFluxBulk
!  use HeatFlux,     only : xz_HeatFluxDiff, xza_MixRtFluxDiff
  use HeatFlux_N1994,   only : xz_HeatFluxBulk, xz_MixRtFluxBulk

  !  ˰Ĵˡ׻ѥ⥸塼
  use MoistAdjust,  only : MoistAdjustSvapPress, MoistAdjustNH4SH

  !  ʪѥ᥿ꥼ
  use WarmRainPrm,  only : WarmRainPrm_Init, xz_Rain2GasHeat, xza_Rain2Gas, &
    &                      xza_Rain2GasNH4SH, xz_Rain2GasHeatNH4SH,         &
    &                      xza_Cloud2Rain, xza_FallRain

  ! (2008/06/27 ãɲ)
  ! ʪѥ᡼ν֥롼
  use cloudset, only : cloudset_init 


  !  ᵤϷ׻ѥ⥸塼
  use MoistBuoyancy,only : MoistBuoy_Init, xz_BuoyMoistKm, xr_BuoyMolWt, &
    &                      xr_BuoyDrag

  !  ٤η׻
  use ECCM, only: ECCM_Stab


  !ۤηػ
  implicit none

  !ѿ
  character(80) :: cfgfile
  real(8), allocatable :: pz_VelXBl(:,:)
  real(8), allocatable :: pz_VelXNl(:,:)
  real(8), allocatable :: pz_VelXAl(:,:)
  real(8), allocatable :: pz_VelXNs(:,:)
  real(8), allocatable :: pz_VelXAs(:,:)
  real(8), allocatable :: xr_VelZBl(:,:)
  real(8), allocatable :: xr_VelZNl(:,:)
  real(8), allocatable :: xr_VelZAl(:,:)
  real(8), allocatable :: xr_VelZNs(:,:)
  real(8), allocatable :: xr_VelZAs(:,:)
  real(8), allocatable :: xz_ExnerBl(:,:)
  real(8), allocatable :: xz_ExnerNl(:,:)
  real(8), allocatable :: xz_ExnerAl(:,:)
  real(8), allocatable :: xz_ExnerNs(:,:)
  real(8), allocatable :: xz_ExnerAs(:,:)
  real(8), allocatable :: xz_ExnerSum(:,:)
  real(8), allocatable :: xz_PotTempWork(:,:)
  real(8), allocatable :: xz_PotTempBl(:,:)
  real(8), allocatable :: xz_PotTempNl(:,:)
  real(8), allocatable :: xz_PotTempAl(:,:)
  real(8), allocatable :: xz_PotTempNs(:,:)
  real(8), allocatable :: xz_PotTempAs(:,:)
  real(8), allocatable :: xz_PotTempSum(:,:)
  real(8), allocatable :: xz_TempSum(:,:)
  real(8), allocatable :: xz_KmBl(:,:)
  real(8), allocatable :: xz_KmNl(:,:)
  real(8), allocatable :: xz_KmAl(:,:)
  real(8), allocatable :: xz_KhBl(:,:)
  real(8), allocatable :: xz_KhNl(:,:)
  real(8), allocatable :: xz_KhAl(:,:)
  real(8), allocatable :: xza_MixRtWork(:,:,:)
  real(8), allocatable :: xza_MixRtBl(:,:,:)
  real(8), allocatable :: xza_MixRtNl(:,:,:)
  real(8), allocatable :: xza_MixRtAl(:,:,:)

  real(8), allocatable :: pz_AccelVelXNl(:,:)
  real(8), allocatable :: xr_AccelVelZNl(:,:)
  real(8), allocatable :: xza_DelMixRt(:,:,:)

! Ĺ֥ƥåפɾ٤̤ιǼ
! 2008/06/20 ã ɲ
  real(8), allocatable :: xz_TendPotTempNl(:,:)
                         

  real(8)              :: Time
  real(8)              :: ReStartTime(2)
  real(8), allocatable :: DelTimeLFrog(:)
  real(8)              :: DelTimeEular
  integer, allocatable :: NStepEular(:)
  integer              :: NStepLFrog

  integer              :: t, tau, t1, t2, k

! ʲѿϻɲ(2008/05/07)

! ñ̼̤Ǯ
  real(8), allocatable :: xz_LatHeatPerMassNl(:,:)  
! ˰
  real(8), allocatable :: xz_SatRatioBl(:,:)
  real(8), allocatable :: xz_SatRatioNl(:,:)
  real(8), allocatable :: xz_SatRatioAl(:,:)
  real(8), allocatable :: xz_SatRatioNs(:,:)
  real(8), allocatable :: xz_SatRatioAs(:,:)
! ̩
  real(8), allocatable :: xz_DensCloudBl(:,:)
  real(8), allocatable :: xz_DensCloudNl(:,:)
  real(8), allocatable :: xz_DensCloudAl(:,:)
  real(8), allocatable :: xz_DensCloudNs(:,:)
  real(8), allocatable :: xz_DensCloudAs(:,:)

! ŷ
  real(8), allocatable :: xz_MassCondNs(:,:)
  real(8), allocatable :: xz_MassCondNl(:,:)
! ŷǮˤ벹ѲΨ
  real(8), allocatable :: xz_QCond(:,:)
! ѿ
  real(8), allocatable :: worknum(:,:)
! Ƴʻμ̩(ʬδͿ)
  real(8), allocatable :: xz_MassDens(:,:)
! ΰΤεμ
  real(8)              :: MassTotal
! ΰΤαưͥ륮
  real(8)              :: KineticEnergyTotal
! Ƴʻαưͥ륮
  real(8), allocatable :: xz_KineticEnergy(:,:)
! ΰΤαμ
  real(8)              :: CloudMassTotal

  !ޥɥ饤β
  !  NAMELIST ե̾ɤ߹
  call argset_init(cfgfile)

  !ǥХå
  call debugset_init(cfgfile)

  !ʪν
  call chemdata_init()

  !˴ؤν
  !  NAMELIST ɬפʾɤ߼, ִϢѿԤ. 
  call timeset_init(cfgfile)

  !ʻν
  !  NAMELIST , ʻ׻
  call gridset_init(cfgfile)

  !ط׻롼ν
  call chemcalc_init()
  
  !ܾξν
  !  NAMELIST , ܾꤹ.
  call basicset_init(cfgfile)
  
  !I/O ե̾ν
  !  NAMELIST ե̾ꤷ, deepconv/arare 
  !  ϥե̾ NAMELIST 
  call fileset_init(cfgfile)

  !ʪѥ᡼ν֥롼
  call cloudset_init(cfgfile)

  !롼ζͭѿν
  call moistset_init()

  !write(*,*) "OK"

  !ѻͤݴɤ뤿Υ⥸塼ν
  !  NAMELIST , ܾꤹ.
  call StorePotTemp_init( )
  call StoreMixRt_init( )
  call StoreBuoy_init( )  
  call StoreStab_init( )  

  write(*,*) "OK"
  
  !ѿν. ȤꤢͤꤵƤ. 
  call ArareAlloc

  write(*,*) "OK"
  
  !ͽѿν
  !  ReStartFile ꤵƤˤϥեɤ߹, 
  !  ꤵƤʤˤ, ǥեȤδܾȾ. 

  write(*,*) InitFile

  if (trim(InitFile) /= '') then    

    !ܾ, νͤ netCDF ե뤫.
    call ReStartFile_Get(            &
      & ReStartTime,                 &
      & xz_PotTempBl, xz_ExnerBl, pz_VelXBl, xr_VelZBl, &
      & xza_MixRtBl,  xz_KmBl,    xz_KhBl,              &
      & xz_DensCloudBl, xz_SatRatioBl,                  &
      & xz_PotTempNl, xz_ExnerNl, pz_VelXNl, xr_VelZNl, &
      & xza_MixRtNl,  xz_KmNl,    xz_KhNl,              &
      & xz_DensCloudNl, xz_SatRatioNl                    )

    write(*,*) "OK"

  else
    !ǥեδܾ, . 
    call BasicEnv()
    call DisturbEnv(cfgfile,                            &
      & xz_PotTempBl, xz_ExnerBl, pz_VelXBl, xr_VelZBl, &
      & xza_MixRtBl,  xz_KmBl,    xz_KhBl,              &
      & xz_DensCloudBl, xz_SatRatioBl                     )
    
    ! 1 롼ܤ, bl  nl ͤƱˤƤ. 
    ! 1 ƥåܤϥ顼ˡǲɬפ뤬, 
    ! 1 ƥåܤȤʳΥƥåפ̡˥ǥ󥰤ʤ
    xz_PotTempNl = xz_PotTempBl
    xz_ExnerNl   = xz_ExnerBl
    pz_VelXNl    = pz_VelXBl
    xr_VelZNl    = xr_VelZBl
    xza_MixRtNl  = xza_MixRtBl
    xz_KmNl      = xz_KmBl
    xz_KhNl      = xz_KhBl
    xz_DensCloudNl = xz_DensCloudBl
    xz_SatRatioNl = xz_SatRatioBl
    xz_PotTempSum = xz_PotTempBl + xz_PotTempBasicZ
    xz_ExnerSum = xz_ExnerBl + xz_ExnerBasicZ
    xz_TempSum = xz_PotTempSum * xz_ExnerSum
    xz_MassDens =                                                    &
     & (xz_ExnerBasicZ + xz_ExnerNl)**( (CpDry - GasRDry)/GasRDry )  &
     & / (xz_PotTempBasicZ + xz_PotTempNl)                           &
     & - (xz_ExnerBasicZ )**( (CpDry - GasRDry)/GasRDry )            &
     & / xz_PotTempBasicZ
     MassTotal = (Xmax - Xmin) * PressSfc /Grav                 &
      & * ( xz_ExnerBasicZ(RegXMin,RegZMin)**(CpDry/GasRDry)          &
      &     - xz_ExnerBasicZ(RegXMin,RegZMax)**(CpDry/GasRDry) )      &
      & + PressSfc * DelX * DelZ / GasRDry                            &
      & * sum( xz_MassDens(RegXMin:RegXMax,RegZMin:RegZMax))

    write(*,*) "OK"
  end if

  write(*,*) "OK"
  
  !----------------------------------------------------------------------
  ! ѥå⥸塼ν
  !   ǥեȤͤѹɬפΤ롼Τ߽
  !----------------------------------------------------------------------
  call Damping_Init( cfgfile )      !Ȥθ그ν
  call NumDiffusion_Init()          !ͳȻν
  call Turbulence_Init()            !ή׻ν
  call WarmRainPrm_Init( cfgfile )  !ȤΥѥ᥿ꥼν
  call FillNegative_Init( xza_MixRtBasicZ, xz_DensBasicZ) 
                                    !ήˤ̤ν
  call Radiation_Init( cfgfile )    !Ͷν
  call MoistBuoy_Init()             !ʬ̤ФϷ׻롼ν
  call xz_Exner_Init()              !ˡν  
       

  !----------------------------------------------------------------------
  ! ȥ롼ײν 
  !----------------------------------------------------------------------
  NstepLFrog   = NstepLong 
  NstepEular   = NstepShort 
  DelTimeLFrog = DelTimeLong * 2.0d0 
  DelTimeEular = DelTimeShort
  if ( trim(InitFile) /= '') then    
    Time = ReStartTime(2)               !ꥹȳϻ
  else
    Time = 0.0d0                          !׻ϻ
    NstepEular(1)   = NstepShort /2 ! 1 롼ܤ
    DelTimeLFrog(1) = DelTimeLong         ! 1 롼ܤ
  end if

 
  !----------------------------------------------------------------
  ! ե
  !----------------------------------------------------------------
  !ե륪ץ
  call HistoryFile_Open( )

  if ( trim(InitFile) /= '') then    
    call HistoryFile_Output(  &
      &  ReStartTime(2),      &
      &  xz_PotTempNl,        &
      &  xz_PotTempSum,       &
      &  xz_TempSum,          &
      &  xz_ExnerNl,          &
      &  pz_VelXNl,           &
      &  xr_VelZNl,           &
      &  xza_MixRtNl,         &
      &  xz_KmNl,             &
      &  xz_KhNl,             &
      &  xz_DensCloudNl,      &
      &  xz_SatRatioNl,       &
      &  MassTotal,           &
      &  KineticEnergyTotal,  &
      &  CloudMassTotal         )
  end if

  ! 0 ξˤϽ
  if ( Time == 0 ) then
    call HistoryFile_Output(  &
      &  Time,                &
      &  xz_PotTempNl,        &
      &  xz_PotTempSum,       &
      &  xz_TempSum,          &
      &  xz_ExnerNl,          &
      &  pz_VelXNl,           &
      &  xr_VelZNl,           &
      &  xza_MixRtNl,         &
      &  xz_KmNl,             &
      &  xz_KhNl,             &
      &  xz_DensCloudNl,      &
      &  xz_SatRatioNl,       &
      &  MassTotal,           &
      &  KineticEnergyTotal,  &
      &  CloudMassTotal         )
  end if
  
  !----------------------------------------------------------------------
  ! Υå
  !----------------------------------------------------------------------
  !CFL Υå
  call CFLCheckTimeShort( xz_VelSoundBasicZ )

!  write(*,*) "OK"

  !----------------------------------------------------------------------
  ! ʬ
  !----------------------------------------------------------------------
  call MessageNotify( "M", "main", "Time integration" ) 
 
  do t1 = 1, NstepLFrog / NstepDisp
    do t2 = 1, NstepDisp

      t = (t1 - 1) * NstepDisp + t2
      
      !
      Time = Time + DelTimeLong

!  write(*,*) "OK"

      !----------------------------------------------------------------
      ! Ǵ, Ȼ.
      !----------------------------------------------------------------
      xz_KmAl =                                                       &
        & xz_KmBl                                                     &
        & + DelTimeLFrog(t)                                           &
        &   * (                                                       &
        &     + xz_AdvKm(xz_KmNl, pz_VelXNl, xr_VelZNl)               &
        &     + xz_BuoyMoistKm(xz_PotTempBl, xz_ExnerBl, xza_MixRtBl) &
        &     + xz_ShearKm(xz_KmBl, pz_VelXBl, xr_VelZBl)             &   
        &     + xz_NumDiffKm(xz_KmBl)                                 &
        &     + xz_DispKm(xz_KmBl)                                    &
        &    )

!  write(*,*) "OK"
      
      !ͤξ²¤
      !  * ͤˤʤ뤳Ȥݾڤ
      !  * ͤξ¤ 800 Ȥ. (1994, ذʸ)
      xz_KmAl = max( 0.0d0, min( xz_KmAl, 800.0d0 ) )
!     xz_KmAl = max( 0.0d0, min( xz_KmAl, 300.0d0 ) )

      !
      call BoundaryXCyc_xz( xz_KmAl )
      call BoundaryZSym_xz( xz_KmAl )
      
      !Ȼ
      xz_KhAl = 3.0d0 * xz_KmAl


!  write(*,*) "OK"
      
!      !----------------------------------------------------------------
!      ! ̤ΰή׻.
!      !----------------------------------------------------------------    
!      !ʬ
!      xz_PotTempAl =                                                  &
!        &   xz_PotTempBl                                              &
!        & + DelTimeLFrog(t)                                           &
!        &   * (                                                       &
!        &     + xz_AdvScalar( xz_PotTempNl,     pz_VelXNl, xr_VelZNl) &
!        &     + xz_AdvScalar( xz_PotTempBasicZ, pz_VelXNl, xr_VelZNl) &
!        &     + xz_TurbScalar(xz_PotTempBl,     xz_KhBl)              &
!        &     + xz_TurbScalar(xz_PotTempBasicZ, xz_KhBl)              &
!        &     + xz_NumDiffScalar(xz_PotTempBl)                        &
!        &     + xz_DispHeat( xz_KmBl )                                &
!        &     + xz_RadHeatConst( xz_ExnerBl )                         &
!        &     + xz_HeatFluxDiff( xz_PotTempNl )                       &
!!!      &     + xz_HeatFluxBulk( xz_PotTempNl )                     &
!!!      &     + xz_NewtonCool( xz_PotTempBl )                       &
!        &      )
!
!      !
!      call BoundaryXCyc_xz( xz_PotTempAl )
!      call BoundaryZSym_xz( xz_PotTempAl )
      
!      !----------------------------------------------------------------
!      ! Žʬκΰή׻.
!      !----------------------------------------------------------------
!      xza_MixRtAl =                                                & 
!        &   xza_MixRtBl                                            &
!        & + DelTimeLFrog(t)                                        &
!        &   * (                                                    &
!        &    + xza_AdvScalar(xza_MixRtNl,     pz_VelXNl, xr_VelZNl)&
!        &    + xza_AdvScalar(xza_MixRtBasicZ, pz_VelXNl, xr_VelZNl)& 
!        &    + xza_TurbScalar(xza_MixRtBl,    xz_KhBl)             &
!        &    + xza_TurbScalar(xza_MixRtBasicZ,xz_KhBl)             &
!        &    + xza_NumDiffScalar(xza_MixRtBl)                      &
!        &    + xza_FallRain(xza_MixRtBl)                           &
!        &    + xza_MixRtFluxDiff(xza_MixRtNl)                      &
!!!      &    + xza_MixRtFluxBulk(xza_MixRtNl)                      &
!        &   )
!
!      !ήˤäˤʤäʬ
!      xza_MixRtWork = xza_MixRtAl
!      xza_MixRtAl = xza_FillNegative_xza( xza_MixRtWork ) 
!      
!      !᤿/ä̤ݴ
!      call StoreMixRtFill1( (xza_MixRtAl - xza_MixRtWork) / DelTimeLFrog(t) )    
!      
!      !
!      call BoundaryXCyc_xza( xza_MixRtAl )
!      call BoundaryZSym_xza( xza_MixRtAl )
!      
!      
!      !-------------------------------------------------------------
!      ! ȤΥѥ᥿ꥼ.
!      !   <--> ѴԤ
!      !-------------------------------------------------------------
!      !鱫ؤѴʬɲä. 
!      !  xza_Cloud2Rain ؿ, Ȥƻֹߤ뤳Ȥ, 
!      !  ʬͤϤ. 
!
!      !ޤǤͤݴ
!      xza_MixRtWork = xza_MixRtAl
!      
!      !ؤѲ̤׻
!      xza_MixRtAl   = xza_MixRtWork &
!        &             + xza_Cloud2Rain( xza_MixRtAl, DelTimeLFrog(t) )
!      
!      !鱫ؤѴ̤ݴ
!      call StoreMixRtCond( (xza_MixRtAl - xza_MixRtWork) / DelTimeLFrog(t) ) 
!      
!      !
!      call BoundaryXCyc_xza( xza_MixRtAl )
!      call BoundaryZSym_xza( xza_MixRtAl )
!      
!
!      !-------------------------------------------------------------
!      ! ˰Ĵˡ
!      !   <-->ѴԤ.
!      !-------------------------------------------------------------
!      !ޤǤͤݴ
!      xz_PotTempWork = xz_PotTempAl
!      xza_MixRtWork  = xza_MixRtAl
!      
!      !ĴˡŬ
!      call MoistAdjustSvapPress(  xz_ExnerNl, xz_PotTempAl, xza_MixRtAl )
!      call MoistAdjustNH4SH( xz_ExnerNl, xz_PotTempAl, xza_MixRtAl )
!      
!      !Ĵˡˤ벹̤ȺѲ̤ݴ
!      call StorePotTempCond( (xz_PotTempAl - xz_PotTempWork) / DelTimeLFrog(t) ) 
!      call StoreMixRtCond( (xza_MixRtAl - xza_MixRtWork) / DelTimeLFrog(t) ) 
!      
!      !
!      call BoundaryXCyc_xza( xza_MixRtAl )
!      call BoundaryZSym_xza( xza_MixRtAl )
!
!
!      !-------------------------------------------------------------
!      ! ȤΥѥ᥿ꥼ.
!      !   <--> ѴԤ
!      !-------------------------------------------------------------
!      !ؤѴȼѲ׻
!      !  xza_Rain2Gas ؿ, Ȥƻֹߤ뤳Ȥ, 
!      !  ʬͤϤ. 
!      
!      !ޤǤͤݴ
!      xz_PotTempWork = xz_PotTempAl
!      xza_MixRtWork = xza_MixRtAl
!      
!      !ؤκѲ
!      !  ̤η׻ˤ, ѲɬפȤʤ뤿, 
!      !  Ѳ 1 ĤȤѰդ.
!      xza_DelMixRt = 0.0d0
!      xza_DelMixRt =                                                    &
!        & (                                                             &
!        &   + xza_Rain2Gas(                                             &
!        &        xz_ExnerNl, xz_PotTempAl, xza_MixRtAl, DelTimeLFrog(t) &
!        &       )                                                       &
!        &   + xza_Rain2GasNH4SH(                                        &
!        &        xz_ExnerNl, xz_PotTempAl, xza_MixRtAl, DelTimeLFrog(t) &
!        &       )                                                       &
!        &  )    
!      
!      !̤η׻. ؤѴȼǮȿǮɲ.
!      xz_PotTempAl =                                                       &   
!        & xz_PotTempWork                                                   &
!        & + (                                                              &
!        &      + xz_Rain2GasHeat( xz_PotTempAl, xz_ExnerNl, xza_DelMixRt ) & 
!        &      + xz_Rain2GasHeatNH4SH( xz_ExnerNl, xza_DelMixRt )          &
!        &    )
!      
!      !η׻. ؤѴʬɲ
!      xza_MixRtAl   = xza_MixRtWork + xza_DelMixRt
!      
!      !ͤݴ
!      call StorePotTempCond( (xz_PotTempAl - xz_PotTempWork) / DelTimeLFrog(t) ) 
!      call StoreMixRtCond( xza_DelMixRt / DelTimeLFrog(t) ) 
!      
!      !
!      call BoundaryXCyc_xz( xz_PotTempAl )
!      call BoundaryZSym_xz( xz_PotTempAl )
!      call BoundaryXCyc_xza( xza_MixRtAl )
!      call BoundaryZSym_xza( xza_MixRtAl )
!      
      
      !-------------------------------------------------------------
      ! Ĺ֥ƥåפǤ, ®٤ΰή, Ȼ, Ǵ, 
      ! (2008/06/20, ã : ̤ΰή, ή, Ȼ, Ǵι
      !   Ǽɲ)
      !-------------------------------------------------------------

      xz_TendPotTempNl =                                              &
        &     + xz_AdvScalar( xz_PotTempNl,     pz_VelXNl, xr_VelZNl) &
        &     + xz_AdvScalar( xz_PotTempBasicZ, pz_VelXNl, xr_VelZNl) &
        &     + xz_TurbScalar(xz_PotTempBl,     xz_KhBl)              &
        &     + xz_TurbScalar(xz_PotTempBasicZ, xz_KhBl)              &
        &     + xz_NumDiffScalar(xz_PotTempBl)                        


!  do k = DimZMin, DimZMax
!  write(*,*) "TendPotTempNl",xz_TendPotTempNl(1,k)
!  end do

!  write(*,*) "PotTempBl(50,1)",xz_PotTempBl(50,1)
!  write(*,*) "TendPotTempNl(50,1)",xz_TendPotTempNl(50,1)

!      worknum = xz_NumDiffScalar(xz_PotTempBl)                        

!  write(*,*) "xz_NumDiffScalar(50,1)",worknum(50,1)

!      worknum = - xz_AdvScalar( xz_PotTempNl,     pz_VelXNl, xr_VelZNl) &
!        &     - xz_AdvScalar( xz_PotTempBasicZ, pz_VelXNl, xr_VelZNl)

!  write(*,*) "xz_AdvScalar(50,1)",worknum(50,1)

!      worknum = xz_TurbScalar(xz_PotTempBl,     xz_KhBl)              &
!        &     + xz_TurbScalar(xz_PotTempBasicZ, xz_KhBl)

!  write(*,*) "xz_TurbScalar(50,1)",worknum(50,1)

!  write(*,*) "PotTempBl(50,2)",xz_PotTempBl(50,2)
!  write(*,*) "xz_NumDiffScalar(50,2)",worknum(50,2)

!  write(*,*) "PotTempBl(50,3)",xz_PotTempBl(50,3)
!  write(*,*) "xz_NumDiffScalar(50,3)",worknum(50,3)

      pz_AccelVelXNl =                                    &
        & + pz_AdvVelX(pz_VelXNl, xr_VelZNl)              &
        & + pz_TurbVelX(xz_KmBl,   pz_VelXBl, xr_VelZBl)  &
        & + pz_NumDiffVelX(pz_VelXBl)

  write(*,*) "OK"
      
      xr_AccelVelZNl =                                    &
        & + xr_AdvVelZ(xr_VelZNl, pz_VelXNl)              &
        & + xr_Buoy(xz_PotTempNl)                         &    
!        & + xr_BuoyMolWt(xza_MixRtNl)                     &
!        & + xr_BuoyDrag(xza_MixRtNl)                      &
        & + xr_TurbVelZ(xz_KmBl,   pz_VelXBl, xr_VelZBl)  &
        & + xr_NumDiffVelZ(xr_VelZBl)                        

!  write(*,*) "OK"

!      xz_TendPotTempNl =                                              &
!        &     + xz_AdvScalar( xz_PotTempNl,     pz_VelXNl, xr_VelZNl) &
!        &     + xz_AdvScalar( xz_PotTempBasicZ, pz_VelXNl, xr_VelZNl) &
!        &     + xz_TurbScalar(xz_PotTempBl,     xz_KhBl)              &
!        &     + xz_TurbScalar(xz_PotTempBasicZ, xz_KhBl)              &
!        &     + xz_NumDiffScalar(xz_PotTempBl)                        

!  write(*,*) "OK"

      !-------------------------------------------------------------
      ! û֥ƥåפνͺ
      !-------------------------------------------------------------
      pz_VelXNs  = pz_VelXBl
      xr_VelZNs  = xr_VelZBl
      xz_ExnerNs = xz_ExnerBl
      xz_PotTempNs = xz_PotTempBl
      xz_DensCloudNs = xz_DensCloudBl
      xz_SatRatioNs = xz_SatRatioBl      


      !-------------------------------------------------------------
      ! û֥ƥåפʬ. 顼ˡ
      !-------------------------------------------------------------
      Eular: do tau = 1, NstepEular(t)

      !-------------------------------------------------------------
      ! 2008/04/14 ɲ
      ! ŷ̤η׻, ŷʪǻ٤η׻, ŷǮη׻
      !-------------------------------------------------------------

      !=== ñ̶ŷ̤Ǯη׻
      call LatentHeatPerMass( xz_LatHeatPerMassNl )
                                    !(out) ñ̼̤Ǯ

!  write(*,*) "OK"

      !=== ŷ̤η׻
      call MassCondense(  &
        & xz_LatHeatPerMassNl, &    !(in) ñ̼̤Ǯ
        & xz_SatRatioNs, &          !(in) ˰
        & xz_PotTempNs, &           !(in) 
        & xz_ExnerNs, &             !(in) ̵
        & xz_DensCloudNs, &         !(in) ̩
        & xz_MassCondNs)            !(out)ŷ

!  write(*,*) "OK"

      !=== ŷʪǻ٤η׻
      call DensityCloud(  &
        & xz_DensCloudNs,                          & !(in) ߤλ֤α̩
        & DelTimeShort,                             & !(in) ֳִ
        & pz_VelXNl, xr_VelZNl, xz_DensCloudNl,  & !(in) եåη׻Ѥ
        & xz_MassCondNs,                         &   !(in) ŷ
        & xz_DensCloudAs)                            !(out)λ֤α̩

      ! 
      call BoundaryXCyc_xz( xz_DensCloudAs )
      call BoundaryZSym_xz( xz_DensCloudAs )

!  write(*,*) "OK!"
     
      ! (2005/12/07 ̼)
      !   * ŷˤȯǮ׻
      !=== ŷǮη׻
      call LatentHeat(  & 
        & xz_MassCondNs,       & !(in) ŷ
        & xz_LatHeatPerMassNl, & !(in) ñ̼̤Ǯ
        & xz_QCond)               !(out)ŷǮˤ벹ѲΨ

!  write(*,*) "OKOK"

!      ! (2008/06/16 ã)
!      !=== ˰٤η׻
!      call SaturationRatio( &
!        & xz_ExnerAs,       & !(in)
!        & xz_PotTempAs,     & !(in)
!        & xz_SatRatioAs)     !(out)
!
!  do k = DimZMin, DimZMax
!  write(*,*) "satratio",xz_SatRatioAs(1,k)
!  end do

      !
      ! ̤ΰή׻. 
      !(2008/06/20, ã : 
      ! ʬŷ뤿, û֥ƥåפΥ롼
      ! Ƿ׻褦񤭴. )
      !
 

      xz_PotTempAs =                                                  &
        &   xz_PotTempNs                                              &
        & + DelTimeEular                                              &
        &   * (                                                       &
!        &     + xz_AdvScalar( xz_PotTempNl,     pz_VelXNl, xr_VelZNl) &
!        &     + xz_AdvScalar( xz_PotTempBasicZ, pz_VelXNl, xr_VelZNl) &
!        &     + xz_TurbScalar(xz_PotTempBl,     xz_KhBl)              &
!        &     + xz_TurbScalar(xz_PotTempBasicZ, xz_KhBl)              &
!        &     + xz_NumDiffScalar(xz_PotTempBl)                        &
        &     + xz_TendPotTempNl                                      &
        &     + xz_DispHeat( xz_KmBl )                                &
        &     + xz_RadHeatConst( xz_ExnerBl )                         &
!        &     + xz_HeatFluxDiff( xz_PotTempNl )                       &
        &     + xz_Qcond                                              &
!      &     + xz_HeatFluxBulk( xz_PotTempNl, pz_VelXNl )             &
!      &     + xz_HeatFluxBulk( xz_PotTempNl  )                      &
!!      &     + xz_NewtonCool( xz_PotTempBl )                       &
        &      )

      !
      call BoundaryXCyc_xz( xz_PotTempAs )
      call BoundaryZSym_xz( xz_PotTempAs )



!  write(*,*) "OK"
        
        !-------------------------------------------------------------
        ! ® u η׻
        !-------------------------------------------------------------
        pz_VelXAs = &
          & pz_VelXNs                                          &
          &  + DelTimeEular                                    &
          &    * (                                             &
          &     - pz_GradPi(xz_ExnerNs, pz_VelXNs, xr_VelZNs)  &
          &     + pz_AccelVelXNl                               &
          &     )
        
        !
        call BoundaryXCyc_pz( pz_VelXAs )
        call BoundaryZSym_pz( pz_VelXAs )
        
        !-------------------------------------------------------------
        ! ʡؿη׻
        !-------------------------------------------------------------
!        xz_ExnerAs = xz_Exner( &
!          & xr_AccelVelZNl,    &
!          & pz_VelXNs,         &
!          & pz_VelXAs,         &
!          & xr_VelZNs,         &
!          & xz_ExnerNs)

        xz_ExnerAs = xz_Exner( &
          & xr_AccelVelZNl,    &
          & pz_VelXNs,         &
          & pz_VelXAs,         &
          & xr_VelZNs,         &
          & xz_ExnerNs,        &
!          & xz_ExnerBasicZ,    &
!          & xz_MassCondNl,     &
          & xz_MassCondNs,     &
          & xz_LatHeatPerMassNl)
        
        !
        call BoundaryXCyc_xz( xz_ExnerAs )
        call BoundaryZSym_xz( xz_ExnerAs )

! write(*,*) "pz_VelXAs", pz_VelXAs(50,1)
! write(*,*) "xz_ExnerAs", xz_ExnerAs(50,1)

!  write(*,*) "OK"
        
        !-------------------------------------------------------------
        ! ® w η׻
        !-------------------------------------------------------------
        xr_VelZAs =                                                    &
          & xr_VelZNs                                                  &
          &  + DelTimeEular                                            &
          &    * (                                                     &
          &     - xr_GradPi(xz_ExnerAs,xz_ExnerNs,pz_VelXNs,xr_VelZNs) &
          &     + xr_AccelVelZNl                                       &
          &     )
        
        !
        call BoundaryXCyc_xr( xr_VelZAs )
        call BoundaryZAntiSym_xr( xr_VelZAs )

! worknum = - xr_GradPi(xz_ExnerAs,xz_ExnerNs,pz_VelXNs,xr_VelZNs)
! write(*,*) "- xr_GradPi", worknum(50,1)

! worknum = xr_AccelVelZNl
! write(*,*) "xr_AccelVelZNl", worknum(50,1)

! write(*,*) "xr_VelZAs", xr_VelZAs(50,1)

!  write(*,*) "OK"

      ! (2008/06/16 ã)
      !=== ˰٤η׻
      call SaturationRatio( &
        & xz_ExnerAs,       & !(in)
        & xz_PotTempAs,     & !(in)
        & xz_SatRatioAs)     !(out)

!  do k = DimZMin, DimZMax
!  write(*,*) "satratio",xz_SatRatioAs(1,k)
!  end do
        
        !-------------------------------------------------------------
        ! û֥ƥåפΥ롼פ󤹤ν
        !-------------------------------------------------------------
        xz_ExnerNs  = xz_ExnerAs
        xz_PotTempNs = xz_PotTempAs
        pz_VelXNs   = pz_VelXAs
        xr_VelZNs   = xr_VelZAs
        xz_DensCloudNs = xz_DensCloudAs
        xz_SatRatioNs = xz_SatRatioAs

      end do Eular


      
      !----------------------------------------------------------------
      ! ǽŪû֥ƥåפǤͤĹ֥ƥåפǤͤȤߤʤ
      !----------------------------------------------------------------
      xz_ExnerAl  = xz_ExnerAs
      xz_PotTempAl = xz_PotTempAs
      pz_VelXAl   = pz_VelXAs
      xr_VelZAl   = xr_VelZAs
      xz_DensCloudAl = xz_DensCloudAs
      xz_SatRatioAl = xz_SatRatioAs


      !-------------------------------------------------------------
      ! åλ֥ե륿.  Nl ͤե륿
      ! 1 ƥåܤ Euler ˡǷ׻뤿, ե륿򤫤ʤ. 
      ! (2008/08/25 ã)
      !-------------------------------------------------------------

  if ( t /= 1 ) then
      call AsselinFilter_xz(xz_ExnerAl, xz_ExnerNl, xz_ExnerBl)
      call AsselinFilter_pz(pz_VelXAl, pz_VelXNl, pz_VelXBl )
      call AsselinFilter_xr(xr_VelZAl, xr_VelZNl, xr_VelZBl )
      call AsselinFilter_xz(xz_PotTempAl, xz_PotTempNl, xz_PotTempBl)
      call AsselinFilter_xz(xz_KmAl, xz_KmNl, xz_KmBl)
!      call AsselinFilter_xza(xza_MixRtAl, xza_MixRtNl, xza_MixRtBl)
!      call AsselinFilter_xz(xz_DensCloudAl, xz_DensCloudNl, xz_DensCloudBl)
  else
      write(*,*) "OK"
  end if

!      call AsselinFilter_xz(xz_ExnerAl, xz_ExnerNl, xz_ExnerBl)
!      call AsselinFilter_pz(pz_VelXAl, pz_VelXNl, pz_VelXBl )
!      call AsselinFilter_xr(xr_VelZAl, xr_VelZNl, xr_VelZBl )
!      call AsselinFilter_xz(xz_PotTempAl, xz_PotTempNl, xz_PotTempBl)
!      call AsselinFilter_xz(xz_KmAl, xz_KmNl, xz_KmBl)
!!      call AsselinFilter_xza(xza_MixRtAl, xza_MixRtNl, xza_MixRtBl)
!!      call AsselinFilter_xz(xz_DensCloudAl, xz_DensCloudNl, xz_DensCloudBl)
    
      !-------------------------------------------------------------
      ! ݥ
      !-------------------------------------------------------------
      call DampSponge_pz( pz_VelXAl, pz_VelXBl, DelTimeLFrog(t) )
      call DampSponge_xr( xr_VelZAl, xr_VelZBl, DelTimeLFrog(t) )
!     xz_ExnerAl   = xz_DampSponge( xz_ExnerAl,    xz_ExnerBl,   DelTimeLFrog(t) )
!     pz_VelXAl    = pz_DampSponge( pz_VelXAl,     pz_VelXBl,    DelTimeLFrog(t) )
!     xr_VelZAl    = xr_DampSponge( xr_VelZAl,     xr_VelZBl,    DelTimeLFrog(t) )
!     xz_PotTempAl = xz_DampSponge( xz_PotTempAl,  xz_PotTempBl, DelTimeLFrog(t) )
!     xz_KmAl      = xz_DampSponge( xz_KmAl,       xz_KmBl,      DelTimeLFrog(t) )


      !--------------------------------------------------------------
      ! 椬ʲˤʤʤν
      !---------------------------------------------------------------
!      xza_MixRtWork = xza_MixRtAl 
!      xza_MixRtAl = max( - xza_MixRtBasicZ, xza_MixRtWork )
!      call StoreMixRtFill2( (xza_MixRtAl - xza_MixRtWork) / DelTimeLFrog(t) )     


      !--------------------------------------------------------------
      ! 
      !---------------------------------------------------------------
      call ECCM_Stab( xz_PotTempAl, xz_ExnerAl, xza_MixRtAl )
      
      !----------------------------------------------------------------
      ! Ĺ֥ƥåפΥ롼פ󤹤ν
      !----------------------------------------------------------------

      xz_PotTempBl = xz_PotTempNl
      xza_MixRtBl  = xza_MixRtNl
      xz_ExnerBl   = xz_ExnerNl
      pz_VelXBl    = pz_VelXNl
      xr_VelZBl    = xr_VelZNl
      xz_KmBl      = xz_KmNl
      xz_KhBl      = xz_KhNl
      xz_DensCloudBl = xz_DensCloudNl
      xz_SatRatioBl = xz_SatRatioNl

      
      xz_PotTempNl = xz_PotTempAl
      xza_MixRtNl  = xza_MixRtAl
      xz_ExnerNl   = xz_ExnerAl
      pz_VelXNl    = pz_VelXAl
      xr_VelZNl    = xr_VelZAl
      xz_KmNl      = xz_KmAl
      xz_KhNl      = xz_KhAl
      xz_DensCloudNl = xz_DensCloudAl
      xz_SatRatioNl = xz_SatRatioAl

      xz_PotTempSum = xz_PotTempNl + xz_PotTempBasicZ    
      xz_ExnerSum = xz_ExnerNl + xz_ExnerBasicZ
      xz_TempSum = xz_PotTempSum * xz_ExnerSum
        ! 2008/08/16( ã)
        ! ܾȾ¤Ϥ٤ɲ

   ! ʬ̤η׻

    ! Ƴʻμ̩(ʬδͿ)
     xz_MassDens =                                                    &
      & (xz_ExnerBasicZ + xz_ExnerNl)**( (CpDry - GasRDry)/GasRDry )  &
      & / (xz_PotTempBasicZ + xz_PotTempNl)                           &
      & - (xz_ExnerBasicZ )**( (CpDry - GasRDry)/GasRDry )            &
      & / xz_PotTempBasicZ

    ! ΰΤεμ
     MassTotal = (Xmax - Xmin) * PressSfc /Grav                 &
      & * ( xz_ExnerBasicZ(RegXMin,RegZMin)**(CpDry/GasRDry)          &
      &     - xz_ExnerBasicZ(RegXMin,RegZMax)**(CpDry/GasRDry) )      &
      & + PressSfc * DelX * DelZ / GasRDry                            &
      & * sum( xz_MassDens(RegXMin:RegXMax,RegZMin:RegZMax))

    ! Ƴʻαưͥ륮
     xz_KineticEnergy = PressSfc * DelX * DelZ / GasRDry              &
      & * (xz_ExnerBasicZ + xz_ExnerNl )**((CpDry - GasRDry)/GasRDry) &
      & / (xz_PotTempBasicZ + xz_PotTempNl)                           &
      & * ( xz_avr_pz(pz_VelXNl)**2.0d0 + xz_avr_xr(xr_VelZNl)**2.0d0 &
      &     )

    ! ΰΤαưͥ륮
     KineticEnergyTotal =                                             &
      & sum( xz_KineticEnergy(RegXMin:RegXMax,RegZMin:RegZMax) )

    ! ΰΤαμ
     CloudMassTotal = DelX * DelZ                                     &
      & * sum( xz_DensCloudNl(RegXMin:RegXMax,RegZMin:RegZMax) )

    end do

   !----------------------------------------------------------------
    ! ե
    !----------------------------------------------------------------
    ! CFL Υå
    call MessageNotify( "M", "main", "Time = %f", d=(/Time/) )
    
    call CFLCheckTimeLongVelX( pz_VelXNl )
    call CFLCheckTimeLongVelZ( xr_VelZNl )
    
    !ҥȥե
    call HistoryFile_Output(  &
      &  Time,                &
      &  xz_PotTempNl,        &
      &  xz_PotTempSum,       &
      &  xz_TempSum,          &
      &  xz_ExnerNl,          &
      &  pz_VelXNl,           &
      &  xr_VelZNl,           &
      &  xza_MixRtNl,         &
      &  xz_KmNl,             &
      &  xz_KhNl,             &
      &  xz_DensCloudNl,      &
      &  xz_SatRatioNl,       &
      &  MassTotal,           &
      &  KineticEnergyTotal,  &
      &  CloudMassTotal       &
      & )
    
    !ѻͤΥꥢ
    call StorePotTempClean
    call StoreMixRtClean
    call StoreBuoyClean
    call StoreStabClean
    
  end do

  write(*,*) "OK"  
  
  !----------------------------------------------------------------
  ! ϥեΥ
  !----------------------------------------------------------------
  call HistoryFile_Close


  !----------------------------------------------------------------
  ! ꥹȥեκ
  !----------------------------------------------------------------
  call ReStartFile_Open( )
  call ReStartFile_OutPut(                            &
    & Time - DelTimeLong,                             &
    & xz_PotTempBl, xz_ExnerBl, pz_VelXBl, xr_VelZBl, &
    & xza_MixRtBl,  xz_KmBl,    xz_KhBl,              &
    & xz_DensCloudBl, xz_SatRatioBl                   )
  call ReStartFile_OutPut(                            &
    & Time,                                           &
    & xz_PotTempNl, xz_ExnerNl, pz_VelXNl, xr_VelZNl, &
    & xza_MixRtNl,  xz_KmNl,    xz_KhNl,              &
    & xz_DensCloudNl, xz_SatRatioNl                   )
  call ReStartFile_Close
  
contains

  subroutine ArareAlloc
    !
    !Ȥ, , ͤȤƥ.
    !

    !ۤηػ
    implicit none

    !
    allocate(                                                   &
      & pz_VelXBl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & pz_VelXNl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & pz_VelXAl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & pz_VelXNs(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & pz_VelXAs(DimXMin:DimXMax, DimZMin:DimZMax),           &
!
      & xr_VelZBl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xr_VelZNl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xr_VelZAl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xr_VelZNs(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xr_VelZAs(DimXMin:DimXMax, DimZMin:DimZMax),           &
!
      & xz_ExnerBl(DimXMin:DimXMax, DimZMin:DimZMax),          &
      & xz_ExnerNl(DimXMin:DimXMax, DimZMin:DimZMax),          &
      & xz_ExnerNs(DimXMin:DimXMax, DimZMin:DimZMax),          &
      & xz_ExnerAl(DimXMin:DimXMax, DimZMin:DimZMax),          &
      & xz_ExnerAs(DimXMin:DimXMax, DimZMin:DimZMax),          &
      & xz_ExnerSum(DimXMin:DimXMax, DimZMin:DimZMax),         &
!
      & xz_PotTempWork(DimXMin:DimXMax, DimZMin:DimZMax),      &
      & xz_PotTempSum(DimXMin:DimXMax, DimZMin:DimZMax),       &
      & xz_PotTempBl(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_PotTempNl(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_PotTempAl(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_PotTempNs(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_PotTempAs(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_TempSum(DimXMin:DimXMax, DimZMin:DimZMax),          &
!
      & xz_KmBl(DimXMin:DimXMax, DimZMin:DimZMax),             &
      & xz_KmNl(DimXMin:DimXMax, DimZMin:DimZMax),             &
      & xz_KmAl(DimXMin:DimXMax, DimZMin:DimZMax),             &
!
      & xz_KhBl(DimXMin:DimXMax, DimZMin:DimZMax),             &
      & xz_KhNl(DimXMin:DimXMax, DimZMin:DimZMax),             &
      & xz_KhAl(DimXMin:DimXMax, DimZMin:DimZMax),             &
!
      & xza_MixRtWork(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum), &
      & xza_MixRtBl(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),   &
      & xza_MixRtNl(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),   &
      & xza_MixRtAl(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),   &
!
      & pz_AccelVelXNl(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xr_AccelVelZNl(DimXMin:DimXMax, DimZMin:DimZMax),        & 
      & xz_TendPotTempNl(DimXMin:DimXMax, DimZMin:DimZMax),      &
!
      & xza_DelMixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),  &
!
      & DelTimeLFrog(NstepLong), NStepEular(NStepLong),          &
!
      & xz_LatHeatPerMassNl(DimXMin:DimXMax, DimZMin:DimZMax),   &
      & xz_MassCondNs(DimXMin:DimXMax, DimZMin:DimZMax),         &
      & xz_MassCondNl(DimXMin:DimXMax, DimZMin:DimZMax),         &
      & xz_DensCloudBl(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_DensCloudNl(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_DensCloudAl(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_DensCloudNs(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_DensCloudAs(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_SatRatioBl(DimXMin:DimXMax, DimZMin:DimZMax),         &
      & xz_SatRatioNl(DimXMin:DimXMax, DimZMin:DimZMax),         &
      & xz_SatRatioAl(DimXMin:DimXMax, DimZMin:DimZMax),         &
      & xz_SatRatioNs(DimXMin:DimXMax, DimZMin:DimZMax),         &
      & xz_SatRatioAs(DimXMin:DimXMax, DimZMin:DimZMax),         &
      & xz_QCond(DimXMin:DimXMax, DimZMin:DimZMax),              &
      & worknum(DimXMin:DimXMax, DimZMin:DimZMax),               &
      & xz_MassDens(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xz_KineticEnergy(DimXMin:DimXMax, DimZMin:DimZMax)         )


    pz_VelXNs = 0.0d0;     pz_VelXAs = 0.0d0    
    xr_VelZNs = 0.0d0;     xr_VelZAs = 0.0d0
    xz_ExnerNs = 0.0d0;    xz_ExnerAs = 0.0d0
    xz_PotTempNs = 0.0d0;     xz_PotTempAs = 0.0d0

    pz_VelXBl = 0.0d0;     pz_VelXNl = 0.0d0;     pz_VelXAl = 0.0d0
    xr_VelZBl = 0.0d0;     xr_VelZNl = 0.0d0;     xr_VelZAl = 0.0d0
    xz_ExnerBl = 0.0d0;    xz_ExnerNl = 0.0d0;    xz_ExnerAl = 0.0d0
    xz_KmBl = 0.0d0;       xz_KmNl = 0.0d0;       xz_KmAl = 0.0d0
    xz_KhBl = 0.0d0;       xz_KhNl = 0.0d0;       xz_KhAl = 0.0d0
    xz_PotTempBl = 0.0d0;  xz_PotTempNl = 0.0d0;  xz_PotTempAl = 0.0d0
    xza_MixRtBl = 0.0d0;    xza_MixRtNl = 0.0d0;    xza_MixRtAl = 0.0d0

    pz_AccelVelXNl = 0.0d0
    xr_AccelVelZNl = 0.0d0

    xza_DelMixRt = 0.0d0

    xz_LatHeatPerMassNl = 0.0d0
    xz_MassCondNs = 0.0d0;       xz_MassCondNl = 0.0d0
    xz_DensCloudBl = 0.0d0;      xz_DensCloudNl = 0.0d0
    xz_DensCloudAl = 0.0d0
    xz_DensCloudNs = 0.0d0;      xz_DensCloudAs = 0.0d0
    xz_SatRatioBl = 0.0d0;       xz_SatRatioNl = 0.0d0
    xz_SatRatioAl = 0.0d0
    xz_SatRatioNs = 0.0d0;       xz_SatRatioAs = 0.0d0
    xz_QCond = 0.0d0            

    DelTimeEular = 0.0d0
    DelTimeLFrog = 0.0d0
    NStepEular = 0.0d0
    NstepLFrog = 0.0d0
    
    worknum = 0.0d0
    xz_MassDens = 0.0d0
    xz_KineticEnergy = 0.0d0

  end subroutine ArareAlloc
  
  
end program arare
