!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004, 2005. All rights reserved.
!---------------------------------------------------------------------
!= Subroutine DisturbEnv
!
!   * Developer: SUGIYAMA Ko-ichiro, ODAKA Masatsugu
!   * Version: $Id: disturbenv.f90,v 1.1 2009-03-05 05:39:40 yamasita Exp $ 
!   * Tag Name: $Name: arare4-20100306 $
!   * Change History: 
!
!== Overview 
!
!ΥǥեͤͿ뤿Υ롼. 
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
! * ή׻
!
!== Future Plans
!
!  * ǽʾΥפ䤹
!  * 顼 gf4f90io 
!

subroutine DisturbEnv(                                            &
  &    cfgfile, xz_PotTemp, xz_Exner, pz_VelX, xr_VelZ, xza_MixRt,&
  &    xz_Km, xz_Kh, xz_DensCloud, xz_SatRatio                 &
  &  )
  !
  !ΥǥեͤͿ뤿Υ롼. 
  !
  
  !⥸塼ɤ߹
  use dc_message, only: MessageNotify

  use gridset,    only:DimXMin,         &!  X β
    &                  DimXMax,         &!  X ξ
    &                  RegXMin,         &!  X β
    &                  RegXMax,         &!  X ξ
    &                  DimZMin,         &!  Z β
    &                  DimZMax,         &!  Z ξ
    &                  RegZMin,         &!  Z β
    &                  RegZMax,         &!  Z ξ
    &                  MarginZ,         &! ׻ΰΥޡ
    &                  DelZ,            &! Z ι
    &                  SpcNum,          &! Žؼο
    &                  XMin, XMax,      &! 
    &                  ZMin, ZMax,      &! 
    &                  s_X,             &! X ɸ(顼ʻ)
    &                  s_Z               ! Z ɸ(顼ʻ)
  use fileset,    only:RandomFile        ! ե
  use basicset,   only:                 &
    &                  SpcWetMolFr,     &!Žʬν
    &                  MolWtWet,        &!Žʬʬ
    &                  MolWtDry,        &!ʬʬ
    &                  xz_PotTempBasicZ, &! ܾβ
    &                  xz_TempBasicZ,   &! ܾβ
    &                  xz_PressBasicZ,  &! ܾΰ
    &                  xz_ExnerBasicZ,  &! ̵
    &                  xza_MixRtBasicZ, &! ܾκ
    &                  TempSfc,         &! ɽ̲
    &                  PressSfc,        &! ɽ̰
    &                  GasRDry,         &! ʬε
    &                  CpDry,           &! ʬ갵Ǯ
    &                  Grav              ! ϲ®
  use ChemData, only:  ChemData_SVapPress_AntoineA, &!Antoine μη
    &                  ChemData_SVapPress_AntoineB   !Antoine μη
  use Boundary, only:  BoundaryXCyc_xza , &!
    &                  BoundaryZSym_xza 
  use ECCM,     only:  ECCM_MolFr


  !ۤηػ
  implicit none
  
  !ѿ
  character(*), intent(in) :: cfgfile
  real(8), intent(out)  :: pz_VelX(DimXMin:DimXMax,DimZMin:DimZMax)  
                                    !ʿ®ξʬ
  real(8), intent(out)  :: xr_VelZ(DimXMin:DimXMax,DimZMin:DimZMax) 
                                    !ľ®ξʬ 
  real(8), intent(out)  :: xz_Exner(DimXMin:DimXMax,DimZMin:DimZMax)  
                                    !ʡؿξʬ 
  real(8), intent(out)  :: xz_PotTemp(DimXMin:DimXMax,DimZMin:DimZMax)  
                                    !̤ξʬ 
  real(8), intent(out)  :: xza_MixRt(DimXMin:DimXMax,DimZMin:DimZMax, SpcNum)  
                                    !Žʬκ(ʬ)
  real(8), intent(out)  :: xz_Km(DimXMin:DimXMax,DimZMin:DimZMax)
                                    !ư̤ФȻ
  real(8), intent(out)  :: xz_Kh(DimXMin:DimXMax,DimZMin:DimZMax)
                                    !ǮФȻ
  real(8), intent(out)  :: xz_DensCloud(DimXMin:DimXMax,DimZMin:DimZMax)
                                    !̩
  real(8), intent(out)  :: xz_SatRatio(DimXMin:DimXMax,DimZMin:DimZMax)
                                    !˰
  real(8), parameter         :: Pi = 3.1415926535897932385d0 
                                    !߼Ψ
  real(8)       :: Humidity         !м
  real(8)       :: XcRate           !濴(ʿ)ΰФ
  real(8)       :: XrRate           !Ⱦ(ʿ)ΰФ
  real(8)       :: ZcRate           !濴(ľ)ΰФ
  real(8)       :: ZrRate           !Ⱦ(ľ)ΰФ
  real(8)       :: Xc               !濴(ʿ)
  real(8)       :: Xr               !Ⱦ(ʿ)
  real(8)       :: Zc               !濴(ľ)
  real(8)       :: Zr               !Ⱦ(ľ)
  real(8)       :: Xpos             ! X ɸ [m] (Therma-Random )
  real(8)       :: Zpos             ! Z ɸ [m] (Therma-Random )
  real(8)       :: beta(DimXMin:DimXMax, DimZMin:DimZMax)
                                    !κͤФ
  real(8)       :: DelMax           !̾κ
  real(8)       :: HalfWidth        !̾Ⱦ
  real(8)       :: ShearWidth       !ؤ
  real(8)       :: Random           !ե뤫
  real(8)       :: RandomNum(DimXMin:DimXMax)
  real(8)       :: RandomNum2(DimXMin:DimXMax)
  character(20) :: Type             !̾Υ
  real(8)       :: xz_MolFr(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                    !

  integer       :: i, k, s, n       ! DO 롼ѿ



  !-------------------------------------------------------------
  ! 
  !-------------------------------------------------------------
  !NAMELIST եɤ߹
  NAMELIST /disturbset/ &
    & Type, DelMax, XrRate, XcRate, ZrRate, ZcRate, &
    & Humidity, Xpos, Zpos, HalfWidth, ShearWidth

  open (10, FILE=cfgfile)
  read(10, NML=disturbset)
  close(10)
  
  !
  pz_VelX    = 0.0d0
!  pz_VelX    = 20.0d0
!  xr_VelZ    = 0.0d0
  xr_VelZ    = 0.0d0
  xz_Exner   = 0.0d0
  xz_PotTemp = 0.0d0
  xza_MixRt  = 0.0d0
  xz_Km      = 0.0d0
  xz_Kh      = 0.0d0
  xz_DensCloud = 0.0d0
  xz_SatRatio = 0.0d0

!  Xr = minval( s_X, 1, s_X > (XMax - XMin) * XrRate )
  Xr = (XMax - XMin) * XrRate
!  Xc = minval( s_X, 1, s_X > (XMax - XMin) * XcRate )
  Xc = (XMax - XMin) * XcRate
!  Zr = minval( s_Z, 1, s_Z > (ZMax - ZMin) * ZrRate )
  Zr = (ZMax - ZMin) * ZrRate
!  Zc = minval( s_Z, 1, s_Z > (ZMax - ZMin) * ZcRate )
  Zc = (ZMax - ZMin) * ZcRate

  !-------------------------------------------------------------
  ! ̤ξ
  !-------------------------------------------------------------
  select case(Type)

  case ("Thermal-KW1978")
    ! ꤵ줿ΰ˲̾Ϳ (Klemp and Wilhelmson, 1978) 
    
    do k = DimZMin, DimZMax
      do i = DimXMin, DimXMax
        beta(i,k) =                                 &
          & (                                       &
          &      ( ( s_X(i) - Xc ) / Xr ) ** 2.0d0  &
          &    + ( ( s_Z(k) - Zc ) / Zr ) ** 2.0d0  &
          &  ) ** 5.0d-1
      end do
    end do
    
    where ( beta < 1.0d0 )
      xz_PotTemp = DelMax * ( dcos( Pi * 5.0d-1 * beta ) ** 2.0d0 ) &
        &          / xz_ExnerBasicZ
    end where
    

  case ("Thermal-Gauss")
    ! ꤵ줿ɸ濴Ȥʬۤβ̾Ϳ. 

    do k = DimZMin, DimZMax
      do i = DimXMin, DimXMax
        xz_PotTemp(i,k) = &
          & DelMax * dexp( - ( (s_X(i) - Xc) / Xr )**2.0d0 * 5.0d-1   &
          &                - ( (s_Z(k) - Zc) / Zr )**2.0d0 * 5.0d-1 ) &
          & / xz_ExnerBasicZ(i,k)
      end do
    end do

    where ( sign(1.0d0, DelMax) * xz_PotTemp < DelMax * 1.0d-4 )
      xz_PotTemp = 0.0d0 
    end where

  case ("Kitamori-Gauss")
    ! ̼(2006) η׻. 
    ! ꤵ줿ɸ濴Ȥʬۤβ̾Ϳ. 
    ! ܾ찵ʬۤ˰¾˰Ϳ. 

    do k = DimZMin, DimZMax
      do i = DimXMin, DimXMax

!    do k = RegZMin, RegZMax
!      do i = RegXMin, RegXMax

!        xz_PotTemp(i,k) = &
!          & DelMax * dexp( - ( (s_X(i) - Xc) / Xr )**2.0d0 * 5.0d-1   &
!          &                - ( (s_Z(k) - Zc) / Zr )**2.0d0 * 5.0d-1 ) &
!          & / xz_ExnerBasicZ(i,k)

        xz_PotTemp(i,k) = &
          & DelMax * dexp( - ( (s_X(i) - Xc) / Xr )**2.0d0 * 5.0d-1   &
          &                - ( (s_Z(k) - Zc) / Zr )**2.0d0 * 5.0d-1 ) 
   
!        xz_SatRatio(i,k) = &
!!          & PressSfc * (TempSfc / xz_TempBasicZ(i,k) )**(Grav / CpDry )    &
!          &   xz_PressBasicZ(i,k)                                          &
!          & / exp( ChemData_SVapPress_AntoineA(12) -                       &
!          &        ChemData_SVapPress_AntoineB(12) / ( xz_TempBasicZ(i,k)  &
!          &        * (1.0d0 + xz_PotTemp(i,k) / TempSfc) ) )

         xz_SatRatio(i,k) = &
           & PressSfc * (xz_ExnerBasicZ(i,k) + xz_Exner(i,k))**(CpDry / GasRDry) &
           & * ( exp(  &
           &         - ChemData_SVapPress_AntoineA(12) &
           &         + ChemData_SVapPress_AntoineB(12) &
           &           / ( (xz_ExnerBasicZ(i,k) + xz_Exner(i,k)) &
           &              * (xz_PotTempBasicZ(i,k) + xz_PotTemp(i,k)) ) &
           &         ) &
           &   )

      end do
    end do

    
  case ("Thermal-MixRt-Gauss")
    ! ꤵ줿ɸ濴Ȥʬۤβ̾ȺͿ. 
    ! , κͤ, ܾκ 0.01 ܤȤ.
    
    do k = DimZMin, DimZMax
      do i = DimXMin, DimXMax
        xz_PotTemp(i,k) =                                             &
          & DelMax * dexp( - ( (s_X(i) - Xc) / Xr )**2.0d0 * 5.0d-1   &
          &                - ( (s_Z(k) - Zc) / Zr )**2.0d0 * 5.0d-1 ) & 
          & / xz_ExnerBasicZ(i,k)

        do s = 1, SpcNum
          xza_MixRt(i,:,s) =                                     &
            & maxval( xza_MixRtBasicZ(:,:,s) ) * 1.0d-1          &
            & * dexp( - ( (s_X(i) - Xc) / Xr )**2.0d0 * 5.0d-1   &
            &         - ( (s_Z(k) - Zc) / Zr )**2.0d0 * 5.0d-1 ) &
            & / xz_ExnerBasicZ(i,:)
        end do
      end do
    end do
    
!    where ( sign(1.0d0, DelMax) * xz_PotTemp < DelMax * 1.0d-4 )
!      xz_PotTemp = 0.0d0 
!    end where
    
  case ("Exner-Gauss")
    ! ꤵ줿, ʲ̤ξͿ. 

    do k = DimZMin, DimZMax
      do i = DimXMin, DimXMax
        xz_Exner(i,k) = &
          & DelMax * dexp( - ( (s_X(i) - Xc) / Xr )**2.0d0 * 5.0d-1 &
          &                - ( (s_Z(k) - Zc) / Zr )**2.0d0 * 5.0d-1 ) 
      end do
    end do

!    where ( xz_Exner < DelMax * 1.0d-4)
!      xz_Exner = 0.0d0 
!    end where
    
  case ("Thermal-Random")
    ! ؤ˥ʾͿ

    open(20,file=RandomFile)
    do i = DimXMin, DimXMax
      read(20,*) random
      RandomNum(i) = random
!      write(*,*) RandomNum(i)
    end do
    close(20)

    do i = DimXMin, DimXMax

      !ΤȤƤϥȤʤ褦Ĵ
      RandomNum2(i) = RandomNum(i)  &
        & - sum( RandomNum(RegXMin+1:RegXMax) ) / real(RegXMax - RegXMin, 8) 

!  write(*,*) "RandomNum2", RandomNum2(i)

!      xz_PotTemp(i, maxloc(s_Z, s_Z <= 90.0d3) - MarginZ) = &
!        & DelMax * RandomNum2(i) / xz_ExnerBasicZ(i, maxloc(s_Z, s_Z <= 100.0d3) - MarginZ)

      xz_PotTemp(i, maxloc(s_Z, s_Z <= Zpos) - MarginZ - 1) = &
         & DelMax * RandomNum2(i) / xz_ExnerBasicZ(i, maxloc(s_Z, s_Z <= Zpos) - MarginZ - 1)

 write(*,*) "xz_PotTemp()", xz_PotTemp(i, - MarginZ -1)

    end do
 

  case ("HS2001")
    ! Hueso and Sanchez-Lavega Ϥ

    i = ( DimXMax - DimXMin - 10) / 2 
    k = minloc( s_Z, 1, s_Z > 2.5d4 ) - MarginZ
    n = int( 5.0d3 / DelZ )

    xz_PotTemp(i-n:i,k-n:k) = DelMax


!  case ("SK1989")
!    ! Skamarock and Klemp (1989)  Cold-bubble ¸
!    
!    xz_PotTemp = 0.0d0
!
!    do k = DimZMin, DimZMax
!      do i = DimXMin, DimXMax
!
!        beta(i,k) =                                 &
!          & sqrt(                                   &
!          &      ( ( s_X(i) - Xc ) / Xr ) ** 2.0d0  &
!          &    + ( ( s_Z(k) - Zc ) / Zr ) ** 2.0d0  &
!          &  )
!      end do
!    end do
!
!    where ( beta < 1.0d0 )
!      xz_PotTemp = 0.5d0*DelMax*(cos(pi*beta) + 1.0d0)
!    end where

  case ("SK1994")
    ! Skamarock and Klemp (1994) ȼ¸
    
    do k = DimZMin, DimZMax
     do i = DimXMin, DimXMax
        xz_PotTemp(i,k) =                             &
          & DelMax * HalfWidth ** 2.0d0               &
          & * sin(pi * s_Z(k) / ZMax)                 &
          & / (HalfWidth ** 2.0d0 +                   &
          & (s_X(i) - XcRate * (XMax - XMin)) ** 2.0d0 )
      end do
    end do
    do k = DimZMin, DimZMax
     do i = DimXMin, DimXMax
         pz_VelX(i,k)    =   20.0d0
      end do
    end do

  case ("KH")
    ! KH ԰¸(̾Ϳ륿)
    
    do k = DimZMin, DimZMax
     do i = DimXMin, DimXMax
         pz_VelX(i,k)    =  4.0d0 *                           &
          & (1.0d0 + tanh((s_Z(k) - ZcRate * (ZMax - ZMin)) / ShearWidth))
      end do
    end do
    do k = DimZMin, DimZMax
     do i = DimXMin, DimXMax
         xz_PotTemp(i,k)  =  1.0d0 *                           &
!          & (1.0d0 + tanh((s_Z(k) - ZcRate * (ZMax - ZMin)) / ShearWidth))
          & sin(s_X(i)*2.0d0*pi/XMax)*sin(s_Z(k)*2.0d0*pi/ZMax)
      end do
    end do

  case ("KH-2")
    ! KH ԰¸(̾Ϳʤ)
    
    do k = DimZMin, DimZMax
     do i = DimXMin, DimXMax
         pz_VelX(i,k)    =  3.0d0 *                             &
          & (1.0d0 + tanh((s_Z(k) - ZcRate * (ZMax - ZMin)) / ShearWidth)) &
          & + 0.2d0 * (1.0d0 +                                  &
          & sin(s_X(i)*2.0d0*pi/XMax)*sin(s_Z(k)*2.0d0*pi/ZMax))
      end do
    end do


  end select

  !-------------------------------------------------------------
  ! . 
  !-------------------------------------------------------------
  if (Humidity /= 0.0d0) then 
    do i = DimXMin, DimXMax      
      call ECCM_MolFr( SpcWetMolFr(1:SpcNum), Humidity, xz_TempBasicZ(i,:), &
        &              xz_PressBasicZ(i,:), xz_MolFr(i,:,:) )
    end do
    
    !Υ򺮹Ѵ
    do s = 1, SpcNum
      xza_MixRt(:,:,s) =                                                    &
        & xz_MolFr(:,:,s) * MolWtWet(s) / MolWtDry - xza_MixRtBasicZ(:,:,s)
    end do
  end if
  
  
  !ͤʤꤹʤ褦˺ͤͿ
!  where (xza_MixRt <= 1.0d-20 )
!    xza_MixRt = 1.0d-20
!  end where
  
  !
  call BoundaryXCyc_xza( xza_MixRt )
  call BoundaryZSym_xza( xza_MixRt )
!  xza_MixRt = xza_BoundaryXCyc_xza( xza_MixRt )
!  xza_MixRt = xza_BoundaryZSym_xza( xza_MixRt )
  

end subroutine DisturbEnv
