!-------------------------------------------------
!  UEpack Module
!-------------------------------------------------
module uepack
  use dcl_common

  interface DclSetShadeLevel
     module procedure DclSetShadeA, DclSetShadeB, DclSetShadeV, DclSetShadeN
  end interface

  private :: DclSetShadeA, DclSetShadeB, DclSetShadeV, DclSetShadeN

  contains
!------------------------------2ޤΤ̤櫓򤪤ʤ
    subroutine DclShadeContour(z)
      real,      intent(in), dimension(:,:) :: z

      call sgoopn('DclShadeContour', ' ')
      nx = size(z,1)
      ny = size(z,2)
      call uetone(z,nx,nx,ny)   
      call sgocls('DclShadeContour')
    end subroutine
!------------------------------2ޤΤ̤櫓򤪤ʤ
    subroutine DclShadeContourEx(z)
      real,      intent(in), dimension(:,:) :: z

      call sgoopn('DclShadeContourEX', ' ')
      nx = size(z,1)
      ny = size(z,2)
      call uetonf(z,nx,nx,ny)  
      call sgocls('DclShadeContourEX')
    end subroutine
!------------------------------ȡ٥ͤǾ͡,ͤꤹ롥
    subroutine   DclSetShadeA(xmin,xmax,dx)
      real,      intent(in) :: xmin,xmax    !ȡ٥κǾ
      real,      intent(in) :: dx           !dx > 0 ΤȤdx򤭤

      call prcopn('DclSetShadeLevel')
      call uegtla(xmin,xmax,dx) 
      call prccls('DclSetShadeLevel')
    end subroutine
!------------------------------ȡ٥ͤ,ͤꤹ롥
    subroutine DclSetShadeB(z,dx)
      real,      intent(in), dimension(:,:) :: z
      real,      intent(in) :: dx            !dx > 0 ΤȤdx򤭤

      call prcopn('DclSetShadeLevel')
      nx = size(z,1)
      ny = size(z,2)
      call uegtlb(z,nx,nx,ny,dx) 
      call prccls('DclSetShadeLevel')
     end subroutine
!------------------------------ ̤櫓٥ȥѥ1٥뤴Ȼꤹ롥
    subroutine DclSetShadeV(level1,level2,pattern)
      real,      intent(in) :: level1,level2  !̤櫓٥β¾
      integer,   intent(in) :: pattern        !ȡѥֹ

      call prcopn('DclSetShadeLevel')
      call uestlv(level1,level2,pattern)
      call prccls('DclSetShadeLevel')
    end subroutine
!----------------------------- ̤櫓٥ȥѥʣ٥ꤹ롥
    subroutine DclSetShadeN(level,pattern)
      integer, intent(in), dimension(:) :: pattern 
      real,    intent(in), dimension(size(pattern)) :: level 

      call prcopn('DclSetShadeLevel')
      call uestln(level,pattern,size(pattern)) 
      call prccls('DclSetShadeLevel')
    end subroutine
!-------------------------------itonܤΥȡ٥°
    subroutine DclGetShadeLevel(number, level1, level2, pattern) 
      integer,   intent(in) :: number
      real,      intent(out) :: level1, level2
      integer,   intent(out) :: pattern

      call prcopn('DclGetShadeLevel')
      call ueqtlv(level1,level2,pattern,number) 
      call prccls('DclGetShadeLevel')
    end subroutine
!------------------------------ꤵƤȡ٥ο
    function DclGetShadeLevelNumber()
      integer :: DclGetShadeLevelNumber

      call prcopn('DclGetShadeLevelNumber')
      call ueqntl(DclGetShadeLevelNumber)  
      call prccls('DclGetShadeLevelNumber')
    end function
!-----------------------------ȡ٥̵ˤ롥
    subroutine DclClearShadeLevel()

      call prcopn('DclClearShadeLevel')
      call ueitlv() 
      call prccls('DclClearShadeLevel')
    end subroutine
      
end module
