/* pktype.c by tomas rokicki */
#include <stdio.h>
#define namelength 80 
#define terminallinelength 132 
#define incr(a) a++
#define decr(a) a--
#define true (1)
#define false (0)
#define round(a) ((int)(a+.5))
#define sendout(a,b) zsendout((boolean)(a),(integer)(b))

  typedef int integer ;
  typedef unsigned char quarterword ;
  typedef char boolean ;
  typedef float real ;
  typedef quarterword ASCIIcode ; 
  typedef FILE *textfile ; 
  typedef quarterword eightbits ; 
  typedef FILE *bytefile ; 
  ASCIIcode xord[128] ; 
  char xchr[256] ; 
  textfile typfile ; 
  bytefile pkfile ; 
  char pkname[81] ; 
  integer pkloc ; 
  integer termpos ; 
  integer magnification ; 
  integer designsize ; 
  integer checksum ; 
  integer hppp, vppp ; 
  integer i, j ; 
  integer flagbyte ; 
  integer endofpacket ; 
  integer width, height ; 
  integer xoff, yoff ; 
  integer tfmwidth ; 
  integer tfms[256] ; 
  integer dx, dy ; 
  integer dxs[256], dys[256] ; 
  boolean status[256] ; 
  integer dynf ; 
  integer car ; 
  integer packetlength ; 
  eightbits inputbyte ; 
  eightbits bitweight ; 
  eightbits nybble ; 
  integer repeatcount ; 
  integer rowsleft ; 
  boolean turnon ; 
  integer hbit ; 
  integer count ; 
  integer gargc ;
  char **gargv ;
  initialize () { integer i ; 
    for ( i = 0 ; i <= 31 ; i ++ ) xchr [ i ] = '?' ; 
      xchr [ 32 ] = ' ' ; 
    xchr [ 33 ] = '!' ; 
    xchr [ 34 ] = '"' ; 
    xchr [ 35 ] = '#' ; 
    xchr [ 36 ] = '$' ; 
    xchr [ 37 ] = '%' ; 
    xchr [ 38 ] = '&' ; 
    xchr [ 39 ] = '\'' ; 
    xchr [ 40 ] = '(' ; 
    xchr [ 41 ] = ')' ; 
    xchr [ 42 ] = '*' ; 
    xchr [ 43 ] = '+' ; 
    xchr [ 44 ] = ',' ; 
    xchr [ 45 ] = '-' ; 
    xchr [ 46 ] = '.' ; 
    xchr [ 47 ] = '/' ; 
    xchr [ 48 ] = '0' ; 
    xchr [ 49 ] = '1' ; 
    xchr [ 50 ] = '2' ; 
    xchr [ 51 ] = '3' ; 
    xchr [ 52 ] = '4' ; 
    xchr [ 53 ] = '5' ; 
    xchr [ 54 ] = '6' ; 
    xchr [ 55 ] = '7' ; 
    xchr [ 56 ] = '8' ; 
    xchr [ 57 ] = '9' ; 
    xchr [ 58 ] = ':' ; 
    xchr [ 59 ] = ';' ; 
    xchr [ 60 ] = '<' ; 
    xchr [ 61 ] = '=' ; 
    xchr [ 62 ] = '>' ; 
    xchr [ 63 ] = '?' ; 
    xchr [ 64 ] = '@' ; 
    xchr [ 65 ] = 'A' ; 
    xchr [ 66 ] = 'B' ; 
    xchr [ 67 ] = 'C' ; 
    xchr [ 68 ] = 'D' ; 
    xchr [ 69 ] = 'E' ; 
    xchr [ 70 ] = 'F' ; 
    xchr [ 71 ] = 'G' ; 
    xchr [ 72 ] = 'H' ; 
    xchr [ 73 ] = 'I' ; 
    xchr [ 74 ] = 'J' ; 
    xchr [ 75 ] = 'K' ; 
    xchr [ 76 ] = 'L' ; 
    xchr [ 77 ] = 'M' ; 
    xchr [ 78 ] = 'N' ; 
    xchr [ 79 ] = 'O' ; 
    xchr [ 80 ] = 'P' ; 
    xchr [ 81 ] = 'Q' ; 
    xchr [ 82 ] = 'R' ; 
    xchr [ 83 ] = 'S' ; 
    xchr [ 84 ] = 'T' ; 
    xchr [ 85 ] = 'U' ; 
    xchr [ 86 ] = 'V' ; 
    xchr [ 87 ] = 'W' ; 
    xchr [ 88 ] = 'X' ; 
    xchr [ 89 ] = 'Y' ; 
    xchr [ 90 ] = 'Z' ; 
    xchr [ 91 ] = '[' ; 
    xchr [ 92 ] = '\\' ; 
    xchr [ 93 ] = ']' ; 
    xchr [ 94 ] = '^' ; 
    xchr [ 95 ] = '_' ; 
    xchr [ 96 ] = '`' ; 
    xchr [ 97 ] = 'a' ; 
    xchr [ 98 ] = 'b' ; 
    xchr [ 99 ] = 'c' ; 
    xchr [ 100 ] = 'd' ; 
    xchr [ 101 ] = 'e' ; 
    xchr [ 102 ] = 'f' ; 
    xchr [ 103 ] = 'g' ; 
    xchr [ 104 ] = 'h' ; 
    xchr [ 105 ] = 'i' ; 
    xchr [ 106 ] = 'j' ; 
    xchr [ 107 ] = 'k' ; 
    xchr [ 108 ] = 'l' ; 
    xchr [ 109 ] = 'm' ; 
    xchr [ 110 ] = 'n' ; 
    xchr [ 111 ] = 'o' ; 
    xchr [ 112 ] = 'p' ; 
    xchr [ 113 ] = 'q' ; 
    xchr [ 114 ] = 'r' ; 
    xchr [ 115 ] = 's' ; 
    xchr [ 116 ] = 't' ; 
    xchr [ 117 ] = 'u' ; 
    xchr [ 118 ] = 'v' ; 
    xchr [ 119 ] = 'w' ; 
    xchr [ 120 ] = 'x' ; 
    xchr [ 121 ] = 'y' ; 
    xchr [ 122 ] = 'z' ; 
    xchr [ 123 ] = '{' ; 
    xchr [ 124 ] = '|' ; 
    xchr [ 125 ] = '}' ; 
    xchr [ 126 ] = '~' ; 
    for ( i = 127 ; i <= 255 ; i ++ ) xchr [ i ] = '?' ; 
      for ( i = 0 ; i <= 127 ; i ++ ) xord [ ( i ) ] = 32 ; 
      for ( i = 32 ; i <= 126 ; i ++ ) xord [ xchr [ i ] ] = i ; 
      } 
  jumpout () { exit ( 1 ) ; 
    } 
  opentypfile () { ; 
    } 
  openpkfile () { pkfile = fopen ( pkname , "r" ) ; 
    if (pkfile==NULL) {
      printf("%s does not exist\n", pkname) ;
      jumpout() ;
    }
    pkloc = 0 ; 
    } 
  eightbits pkbyte () { eightbits temp ; 
    incr ( pkloc ) ; 
    return ( getc ( pkfile ) ) ; 
    } 
  integer get16 () { integer a ; 
    a = pkbyte () ; 
    return ( a * 256 + pkbyte () ) ; 
    } 
  integer get32 () { integer a ; 
    a = get16 () ; 
    if ( a > 32767 ) a = a - 65536 ; 
    return ( a * 65536 + get16 () ) ; 
    } 
  integer getnyb () { eightbits temp ; 
    if ( bitweight == 0 ) 
    { inputbyte = pkbyte () ; 
      bitweight = 16 ; 
      } 
    temp = inputbyte / bitweight ; 
    inputbyte = inputbyte - temp * bitweight ; 
    bitweight = bitweight / 16 ; 
    return ( temp ) ; 
    } 
  boolean getbit () { boolean temp ; 
    bitweight = bitweight / 2 ; 
    if ( bitweight == 0 ) 
    { inputbyte = pkbyte () ; 
      bitweight = 128 ; 
      } 
    temp = inputbyte >= bitweight ; 
    if ( temp ) inputbyte = inputbyte - bitweight ; 
    return ( temp ) ; 
    } 
  zsendout ( repeatcount , value ) 
  boolean repeatcount ; 
  integer value ; 
  { integer i, len ; 
    i = 10 ; 
    len = 1 ; 
    while ( value >= i ) 
      { incr ( len ) ; 
        i = i * 10 ; 
        } 
      if ( repeatcount || ! turnon ) len = len + 2 ; 
    if ( termpos + len > 78 ) 
    { termpos = len + 2 ; 
      printf ( "\n" ) ; 
      printf ( "  " ) ; 
      } 
    else termpos = termpos + len ; 
    if ( repeatcount ) printf ( "[%d]" , value ) ; 
    else if ( turnon ) printf ( "%d", value ) ; 
    else printf ( "(%d)" , value ) ; 
    } 
  integer pkpackednum () { integer i, j, k ; 
    i = getnyb () ; 
    if ( i == 0 ) 
    { do { j = getnyb () ; 
        incr ( i ) ; 
        } while ( ! ( j != 0 ) ) ; 
      while ( i > 0 ) 
        { j = j * 16 + getnyb () ; 
          decr ( i ) ; 
          } 
        return ( j - 15 + ( 13 - dynf ) * 16 + dynf ) ; 
      } 
    else if ( i <= dynf ) return ( i ) ; 
    else if ( i < 14 ) return ( ( i - dynf - 1 ) * 16 + getnyb () + dynf + 1 
    ) ; 
    else 
    { if ( repeatcount != 0 ) 
      { ; 
        printf ( " Second repeat count for this row!\n" ) ; 
        jumpout () ; 
        } 
      if ( i == 14 ) repeatcount = pkpackednum () ; 
      else repeatcount = 1 ; 
      sendout ( true , repeatcount ) ; 
      return ( pkpackednum () ) ; 
      } 
    } 
  skipspecials () { integer i, j, k ; 
    do { flagbyte = pkbyte () ; 
      if ( flagbyte >= 240 ) switch ( flagbyte ) 
      { case 240 : 
        case 241 : 
        case 242 : 
        case 243 : 
        
        { printf ( "%d:  Special: '" , pkloc - 1 ) ; 
          i = 0 ; 
          for ( j = 240 ; j <= flagbyte ; j ++ ) i = 256 * i + pkbyte () ; 
            for ( j = 1 ; j <= i ; j ++ ) putchar ( xchr [ pkbyte () ] ) ; 
            printf ( "'\n" ) ; 
          } 
        break ; 
        case 244 : 
        printf ( "%d:  Num special: %d\n" , pkloc - 1 , get32 () ) ; 
        break ; 
        case 245 : 
        printf ( "%d:  Postamble\n" , pkloc - 1 ) ; 
        break ; 
        case 246 : 
        printf ( "%d:  No op\n" , pkloc - 1 ) ; 
        break ; 
        case 247 : 
        case 248 : 
        case 249 : 
        case 250 : 
        case 251 : 
        case 252 : 
        case 253 : 
        case 254 : 
        case 255 : 
        
        { ; 
          printf ( " Unexpected %d!\n" , flagbyte ) ; 
          jumpout () ; 
          } 
        break ; 
        } } while ( ! ( ( flagbyte < 240 ) || ( flagbyte == 245 ) ) ) ; 
    } 
  dialog () { if ( gargc != 2 ) 
    { ; 
      printf ( " Usage: pktype pkfile\n" ) ; 
      jumpout () ; 
      } 
    strcpy ( pkname , gargv [ 1 ] ) ; 
    } 
  main (argc, argv) 
int argc ;
char *argv[] ;
{ gargc = argc ;
  gargv = argv ;
  initialize () ; 
  dialog () ; 
  openpkfile () ; 
  opentypfile () ; 
  printf ( "This is PKtype, C Version 2.3\n" ) ; 
  printf ( "Input file: %s\n" , pkname ) ; 
  if ( pkbyte () != 247 ) 
  { ; 
    printf ( " Bad pk file!  pre command missing.\n" ) ; 
    jumpout () ; 
    } 
  if ( pkbyte () != 89 ) 
  { ; 
    printf ( " Wrong version of packed file!.\n" ) ; 
    jumpout () ; 
    } 
  j = pkbyte () ; 
  printf ( "'" ) ; 
  for ( i = 1 ; i <= j ; i ++ ) putchar ( xchr [ pkbyte () ] ) ; 
    printf ( "'\n" ) ; 
  designsize = get32 () ; 
  printf ( "Design size = %d\n" , designsize ) ; 
  checksum = get32 () ; 
  printf ( "Checksum = %d\n" , checksum ) ; 
  hppp = get32 () ; 
  vppp = get32 () ; 
  printf ( "Resolution: horizontal = %d  vertical = %d" , hppp , vppp ) ; 
  magnification = round ( hppp * 72.27 / 65536 ) ; 
  printf ( "  (%d dpi)\n" , magnification ) ; 
  if ( hppp != vppp ) ; 
  skipspecials () ; 
  while ( flagbyte != 245 ) 
    { printf ( "%d:  Flag byte = %d" , pkloc - 1 , flagbyte ) ; 
      dynf = flagbyte / 16 ; 
      flagbyte = flagbyte % 16 ; 
      turnon = flagbyte >= 8 ; 
      if ( turnon ) flagbyte = flagbyte - 8 ; 
      if ( flagbyte == 7 ) 
      { packetlength = get32 () ; 
        car = get32 () ; 
        endofpacket = packetlength + pkloc ; 
        packetlength = packetlength + 9 ; 
        tfmwidth = get32 () ; 
        dx = get32 () ; 
        dy = get32 () ; 
        width = get32 () ; 
        height = get32 () ; 
        xoff = get32 () ; 
        yoff = get32 () ; 
        } 
      else if ( flagbyte > 3 ) 
      { packetlength = ( flagbyte - 4 ) * 65536 + get16 () ; 
        car = pkbyte () ; 
        endofpacket = packetlength + pkloc ; 
        packetlength = packetlength + 4 ; 
        i = pkbyte () ; 
        tfmwidth = i * 65536 + get16 () ; 
        dx = get16 () * 65536 ; 
        dy = 0 ; 
        width = get16 () ; 
        height = get16 () ; 
        xoff = get16 () ; 
        yoff = get16 () ; 
        if ( xoff > 32767 ) xoff = xoff - 65536 ; 
        if ( yoff > 32767 ) yoff = yoff - 65536 ; 
        } 
      else 
      { packetlength = flagbyte * 256 + pkbyte () ; 
        car = pkbyte () ; 
        endofpacket = packetlength + pkloc ; 
        packetlength = packetlength + 3 ; 
        i = pkbyte () ; 
        tfmwidth = i * 65536 + get16 () ; 
        dx = pkbyte () * 65536 ; 
        dy = 0 ; 
        width = pkbyte () ; 
        height = pkbyte () ; 
        xoff = pkbyte () ; 
        yoff = pkbyte () ; 
        if ( xoff > 127 ) xoff = xoff - 256 ; 
        if ( yoff > 127 ) yoff = yoff - 256 ; 
        } 
      printf ( "  Character = %d  Packet length = %d\n" , car , packetlength 
      ) ; 
      printf ( "  Dynamic packing variable = %d\n" , dynf ) ; 
      printf ( "  TFM width = %d  dx = %d" , tfmwidth , dx ) ; 
      if ( dy != 0 ) printf ( "  dy = %d\n" , dy ) ; 
      else printf ( "\n" ) ; 
      printf ( "  Height = %d  Width = %d  X-offset = %d  Y-offset = %d\n" ,
      height , width , xoff , yoff ) ;
      bitweight = 0 ; 
      if ( dynf == 14 ) 
      { for ( i = 1 ; i <= height ; i ++ ) 
          { printf ( "  " ) ; 
            for ( j = 1 ; j <= width ; j ++ ) if ( getbit () ) printf ( "*" ) 
              ; 
              else printf ( "." ) ; 
              printf ( "\n" ) ; 
            } 
          } 
      else 
      { termpos = 2 ; 
        printf ( "  " ) ; 
        rowsleft = height ; 
        hbit = width ; 
        repeatcount = 0 ; 
        while ( rowsleft > 0 ) 
          { count = pkpackednum () ; 
            sendout ( false , count ) ; 
            if ( count >= hbit ) 
            { rowsleft = rowsleft - repeatcount - 1 ; 
              repeatcount = 0 ; 
              count = count - hbit ; 
              hbit = width ; 
              rowsleft = rowsleft - count / width ; 
              count = count % width ; 
              } 
            hbit = hbit - count ; 
            turnon = ! turnon ; 
            } 
          printf ( "\n" ) ; 
        if ( ( rowsleft != 0 ) || ( hbit != width ) ) 
        { ; 
          printf ( " Bad pk file---more bits than required!\n" ) ; 
          jumpout () ; 
          } 
        } 
      if ( endofpacket != pkloc ) 
      { ; 
        printf ( " Bad pk file!  Bad packet length.\n" ) ; 
        jumpout () ; 
        } 
      skipspecials () ; 
      } 
    j = 0 ; 
    i = pkbyte () ;
  while ( ! feof ( pkfile ) ) 
    { if ( i != 246 ) 
      { ; 
        printf ( " Bad byte at end of file: %d\n" , i ) ; 
        jumpout () ; 
        } 
      incr(j) ;
      printf ( "%d:  No op\n" , pkloc - 1 ) ; 
      i = pkbyte () ;
      } 
  pkloc -- ;
  printf ( "%d bytes read from packed file.\n" , pkloc ) ; 
  lab9999 : ; 
  } 
