/*
 * main() plus other necessary routines for mf
 *
 * Tim Morgan 12/19/85
 */

#include <stdio.h>
#include "mf.h"
#include "mf_vars.h"

extern char *strcat();
static char *gfname;

main(argc, argv)
int argc;
char *argv[];
{
    if (argc != 2) {
	fprintf(stderr, "Usage: gftype gffile\n");
	exit(1);
    }
    gfname = argv[1];

    mf();
    exit(0);
}

/* Simulate eoln function */
boolean eoln(f)
FILE *f;
{
    register int c;

    if (feof(f)) return(true);	/* Fulfill "weaker" requirement */
    c = getc(f);
    (void) ungetc(c, f);
    return(c == '\n');
}

/* Exit */
cexit(h)
int h;
{
    putchar('\n');
    exit(h);
}

/* Hand-coded to avoid compiler deficiency */
integer firstpar(o)
eightbits o;
{
    if (o <= 63)
	return(o);
    if (o == 64 || o == 71 || o == 245 || o == 246 || o == 239)
	return(getbyte());
    if (o == 65 || o == 72 || o == 240)
	return(gettwobytes());
    if (o == 66 || o == 73 || o == 241)
	return(getthreebytes());
    if (o == 242 || o == 243)
	return(signedquad());
    if (o == 70 || o == 244 || o == 67 || o == 68 || o == 69 ||
	(o >= 248 && o <= 255)) return(0);
    return(o - 74);
}

opengffile()
{
    gffile = fopen(gfname, "r");
    if (!gffile) {
	fprintf(stderr, "GF file does not exist!\n");
	exit(1);
    }
    curloc = 0;
}

input_ln()
{
    if (gets(buffer) == NULL) {
	fprintf(stderr, "Unexpected EOF!\n");
	exit(1);
    }
    (void) strcat(buffer, " ");
}
