/*
 * Metafont in C, system-dependent code
 *
 */

#define	EXTERN			/* Instantiate data in this module */
#ifndef	INIMF			/* Keep lint happy */
#define	INIMF			/* Instantiate INIMF-specific data */
#endif
#include "mfd.h"		/* Includes "site.h" via "mf.h" */

#ifdef	SYSV
#define	index	strchr
extern int sprintf();
#else
extern char *sprintf();		/* From C library */
#endif	/* SYSV */

int argc;
static char **gargv;



main(iargc, iargv)
int iargc;
char *iargv[];
{
    argc=iargc;
    gargv=iargv;
    main_body();
} 

/* Return the integer absolute value */
integer zabs(x)
integer x;
{
    if (x >= 0) return(x);
    return(-x);
}

/* Return the nth program argument into the string pointed at by s */
argv(n,s)
integer n; char *s;
{
    (void) sprintf(s+1, "%s ", gargv[n-1]);
}

/* Return true on end of line or eof of file, else false */
eoln(f)
FILE *f;
{
    register int c;

    if (feof(f)) return(1);
    c = getc(f);
    if (c != EOF)
	(void) ungetc(c, f);
    return (c == '\n' || c == EOF);
}

/* Open a file.  Don't return unless successful */
FILE *Fopen(name, mode)
char *name, *mode;
{
    FILE *result;
    char *index(), *cp, my_name[filenamesize];
    register int i = 0;

    for (cp=name; *cp && *cp != ' ';)
	my_name[i++] = *cp++;
    my_name[i] = '\0';
    result = fopen(my_name, mode);
    if (!result) {
	perror(my_name);
	exit(1);
    }
    return(result);
}

#ifdef	sequent
/*
 * On a Sequent Balance system under Dynix 2.1.1, if u and v are unsigned
 * shorts or chars, then "(int) u - (int) v" does not perform a signed
 * subtraction.  Hence we have to call this routine to force the compiler
 * to treat u and v as ints instead of unsigned ints.  Sequent knows about
 * the problem, but they don't seem to be in a hurry to fix it.
 */
integer ztoint(x)
{
    return(x);
}
#endif


/*
 * Read a line of input as efficiently as possible while still
 * looking like Pascal.
 * Sets last==first and returns FALSE if eof is hit.
 * Otherwise, TRUE is returned and either last==first or buffer[last-1]!=' ';
 * that is, last == first + length(line except trailing whitespace).
 */
zinputln(f)
FILE *f;
{
    register int i;

    last = first;
    while ( last < bufsize && ((i = getc(f)) != EOF) && i != '\n') {
#ifdef	NONASCII
	buffer[last++] = i;
#else
	buffer[last++] = (i > 127 || i < 0)?' ':i;
#endif
    }
    if (i == EOF && last == first)
	return(false);
    if (i != EOF && i != '\n') {
	/* We didn't get whole line because of lack of buffer space */
	(void) fprintf(stderr, "\nUnable to read an entire line---bufsize=%d\n",
	    bufsize);
	exit(1);
    }
    buffer[last] = ' ';
    if (last >= maxbufstack)
	maxbufstack = last;	/* Record keeping */
    /* Trim trailing whitespace by decrementing "last" */
    while (last > first && (buffer[last-1] == ' ' || buffer[last-1] == '\t'))
	--last;
    /* Now, either last==first or buffer[last-1] != ' ' (or tab) */
/*
 * If we're running on a system with ASCII characters like TeX's
 * internal character set, we can save some time by not executing
 * this loop.
 */
#ifdef	NOTASCII
    for (i = first; i <= last; i++)
	buffer[i] = xord[buffer[i]];
#endif
    return(true);
}
