#ifndef lint
static	char RCSid[] = "$Header: mf_windows.c,v 1.0 86/01/31 14:59:56 richards Released $";
#endif

#include <stdio.h>
#define	EXTERN	extern
#include "../mfd.h"

/*
 * Generic Window interface to Unix version of MetaFont
 *
 *	This module contains a dispatch table indexed by the
 *	TERM environment variable to select the graphics routines
 *	appropriate to the user's terminal.  Note that all graphics
 *	output comes out on "stdio", which must be a legitimate 
 *	terminal device (ala isatty()).
 */

#ifdef	SUNWIN
extern	mf_sun_initscreen(),		mf_sun_updatescreen();
extern	mf_sun_blankrectangle(),	mf_sun_paintrow();
#endif

#ifdef	HP2627WIN
extern	mf_hp2627_initscreen(),		mf_hp2627_updatescreen();
extern	mf_hp2627_blankrectangle(),	mf_hp2627_paintrow();
#endif

#ifdef	X10WIN
extern	mf_x10_initscreen(), mf_x10_updatescreen();
extern	mf_x10_blankrectangle(), mf_x10_paintrow();
#endif

#ifdef	X11WIN
extern	mf_x11_initscreen(), mf_x11_updatescreen();
extern	mf_x11_blankrectangle(), mf_x11_paintrow();
#endif

#ifdef	TEKTRONIXWIN
extern	mf_tektronix_initscreen(), mf_tektronix_updatescreen();
extern	mf_tektronix_blankrectangle(), mf_tektronix_paintrow();
#endif

/*
 * Array "mfwsw" contains the dispatch tables for each terminal.
 *	we map the pascal calls to the routines:
 *		init_screen;
 *		update_screen;
 *		blank_rectangle;
 *	   and  paint_row;
 *	into the appropriate entry point for the specific terminal
 *	that MF is being run from.
 *	I was too lazy to make multiple aliases for the same terminal,
 *	but didn't feel it was needed...
 */
struct mfwin_sw {
	char	*mfwsw_type;		/* name of terminal ala TERMCAP	*/
	int	(*mfwsw_initscreen)();	/* initscreen() entry		*/
	int	(*mfwsw_updatescrn)();	/* updatescreen() entry		*/
	int	(*mfwsw_blankrect)();	/* blankrectangle() entry	*/
	int	(*mfwsw_paintrow)();	/* paintrow() entry		*/
} mfwsw[] = {

#ifdef	SUNWIN
{	"sun",
		mf_sun_initscreen,		mf_sun_updatescreen,
		mf_sun_blankrectangle,		mf_sun_paintrow		},
#endif

#ifdef	HP2627WIN
{	"hp2627",
		mf_hp2627_initscreen,		mf_hp2627_updatescreen,
		mf_hp2627_blankrectangle,	mf_hp2627_paintrow	},
#endif

#ifdef	X10WIN
{	"xterm",
		mf_x10_initscreen,		mf_x10_updatescreen,
		mf_x10_blankrectangle,		mf_x10_paintrow		},
#endif

#ifdef	X11WIN
{	"xterm",
		mf_x11_initscreen,		mf_x11_updatescreen,
		mf_x11_blankrectangle,		mf_x11_paintrow		},
#endif

#ifdef	TEKTRONIXWIN
{	"tek",
		mf_tektronix_initscreen,	mf_tektronix_updatescreen,
		mf_tektronix_blankrectangle,	mf_tektronix_paintrow	},
#endif

{	"Test",
		NULL,				NULL,
		NULL,				NULL			},

/*=========== End of mfsw[] must have mfwsw_type==NULL =================*/
{	NULL,
		NULL,				NULL,
		NULL,				NULL			}
};
/*======================================================================*/

static	struct mfwin_sw	*mfwp;	/* pointer to current mfwsw[] entry	*/

/*
 * The following are dummy routines that just jump to the correct 
 *	terminal-specific graphics code:
 *
 * init_screen: boolean;  return true if window operations legal
 */

extern	char	*getenv();

initscreen()
{
	register char *ttytype;

	if ((ttytype = getenv("TERM")) == NULL || !(isatty(fileno(stdout))))
		return(0);
	for (mfwp = mfwsw; mfwp->mfwsw_type != NULL; mfwp++) 
		if (!strncmp(mfwp->mfwsw_type,ttytype,strlen(mfwp->mfwsw_type))) 
		    if (mfwp->mfwsw_initscreen) 
			return((*mfwp->mfwsw_initscreen)());
		    else {	/* Test terminal type */
			printf("Initscreen called\n");
			return 1;
		    }
	return(0);
}

/*
 * updatescreen; -- just make sure screen is ready to view
 */

updatescreen()
{
    if (mfwp->mfwsw_updatescrn) 
	((*mfwp->mfwsw_updatescrn)());
    else {
	printf("Updatescreen called\n");
    }
}

/*
 * blankrectangle: reset rectangle bounded by ([left,right],[top,bottom])
 *			to background color
 */

blankrectangle(left, right, top, bottom)
	screencol left, right;
	screenrow top, bottom;
{
    if (mfwp->mfwsw_blankrect) 
	((*mfwp->mfwsw_blankrect)(left, right, top, bottom));
    else {
	printf("Blankrectangle l=%d  r=%d  t=%d  b=%d\n", 
	    left, right, top, bottom);
    }
}

/*
 * paintrow -- paint "row" starting with color "init_color",  up to next
 *		transition specified by "transition_vector", switch colors,
 *		and continue for "vector_size" transitions.
 */

zpaintrow(row, init_color, transition_vector, vector_size)
	screenrow	row;
	pixelcolor	init_color;
	transspec	transition_vector;
	screencol	vector_size;
{
    if (mfwp->mfwsw_paintrow) 
	((*mfwp->mfwsw_paintrow)(row, init_color,
				transition_vector, vector_size));
    else {
	printf("Paintrow r=%d  c=%d  v=");
	while (vector_size-- > 0) printf("%d  ", transition_vector++);
	printf("\n");
    }
}
