/* 
 *	FIG : Facility for Interactive Generation of figures
 *
 *	Copyright (c) 1985 by Supoj Sutanthavibul (supoj@sally.UTEXAS.EDU)
 *      November 1985.
 *
 *	%W%	%G%
*/
#include <suntool/tool_hs.h>
#include <stdio.h>
#include "const.h"

static u_int	addpt_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00038000, 0x00044000, 0x00054000, 
		0x0006C000, 0x0007C000, 0x00082000, 0x00101000, 
		0x00200800, 0x00410400, 0x00838200, 0x01054100, 
		0x02010080, 0x04010040, 0x08010020, 0x10010010, 
		0x20010008, 0x00010000, 0x00000000, 0x00000000, 
		0x3FFFFFF8, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(addpt_ic, 32, 32, 1, addpt_image);

static u_int	arc_image[32] = {
		0x00000000, 0x04380000, 0x0C240000, 0x043B0000, 
		0x0400C000, 0x04002000, 0x04001000, 0x0E000800, 
		0x00000400, 0x00000400, 0x00000200, 0x00000200, 
		0x0000C100, 0x00012100, 0x00002280, 0x00004280, 
		0x00008280, 0x00010100, 0x0001E100, 0x00000200, 
		0x00000200, 0x00000400, 0x00000400, 0x06000800, 
		0x09001000, 0x01002000, 0x0600C000, 0x013B0000, 
		0x09240000, 0x06380000, 0x00000000, 0x00000000, };
mpr_static(arc_ic, 32, 32, 1, arc_image);

static u_int	autoarrow_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00010000, 
		0x00010000, 0x00010000, 0x00038000, 0x00038000, 
		0x00038000, 0x00054000, 0x00054000, 0x00054000, 
		0x00092000, 0x00092000, 0x00092000, 0x00111000, 
		0x00111000, 0x00111000, 0x00210800, 0x00210800, 
		0x00210800, 0x00010000, 0x00010000, 0x00010000, 
		0x00010000, 0x00010000, 0x00010000, 0x00010000, 
		0x00010000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(autoarrow_ic, 32, 32, 1, autoarrow_image);

static u_int	backarrow_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x0001E000, 
		0x001E0000, 0x01E00000, 0x1FFFFFF8, 0x1FFFFFF8, 
		0x01E00000, 0x001E0000, 0x0001E000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000,  };
mpr_static(backarrow_ic, 32, 32, 1, backarrow_image);

static u_int	latexline_image[32] = {
		0x00000000,0x00000000,0x00007000,0x001F8000,
		0x00F00000,0x01EFC000,0x01903F00,0x028C00F0,
		0x04830000,0x08808000,0x08806000,0x10801000,
		0x00000000,0x00000000,0x00000000,0x00000000,
		0x00000000,0x180FC186,0x18CFC0CC,0x192300CC,
		0x19230078,0x19E37C30,0x19236030,0x19236078,
		0x180360CC,0x1F8378CC,0x1F836186,0x00006000,
		0x00006000,0x00007C00,0x00000000,0x00000000,  };
mpr_static(latexline_ic, 32, 32, 1, latexline_image);

static u_int	latexarrow_image[32] = {
		0x00000000,0x00003C00,0x0000F800,0x001F3000,
		0x00F00000,0x01EFC000,0x01903F60,0x028C00F0,
		0x048340F8,0x19C0C000,0x1DC0E000,0x1880F000,
		0x10800000,0x00000000,0x00000000,0x00000000,
		0x00000000,0x180FC186,0x18CFC0CC,0x192300CC,
		0x19230078,0x19E37C30,0x19236030,0x19236078,
		0x180360CC,0x1F8378CC,0x1F836186,0x00006000,
		0x00006000,0x00007C00,0x00000000,0x00000000,  };
mpr_static(latexarrow_ic, 32, 32, 1, latexarrow_image);

static u_int	box_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x07FFFFE0,
		0x04000020, 0x04000020, 0x04000020, 0x04000020,
		0x04000020, 0x04000020, 0x04000020, 0x04000020,
		0x04000020, 0x04000020, 0x04000020, 0x04000020,
		0x04000020, 0x04000020, 0x04000020, 0x07FFFFE0,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,  };
mpr_static(box_ic, 32, 32, 1, box_image);

static u_int	break_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x2AAAAAA8, 
		0x00000000, 0x20000008, 0x00001C00, 0x20006308, 
		0x00F08080, 0x210C8088, 0x02008080, 0x22006308, 
		0x01001C00, 0x20F00008, 0x000C0200, 0x20020108, 
		0x00020080, 0x24020048, 0x0204FE40, 0x21F81048, 
		0x00001040, 0x20001048, 0x03FC1080, 0x22041108, 
		0x02041200, 0x22041008, 0x03FC0000, 0x20000008, 
		0x00000000, 0x2AAAAAA8, 0x00000000, 0x00000000, };
mpr_static(break_ic, 32, 32, 1, break_image);

static u_int	cirrad_image[32] = {
		0x00000000, 0x00000000, 0x0007F000, 0x00180C00, 
		0x00600300, 0x00800080, 0x01000040, 0x02000020, 
		0x04000010, 0x04000010, 0x08000008, 0x08000008,
		0x10000004, 0x10000004, 0x10008004, 0x1001FFFC, 
		0x10008004, 0x10000004, 0x10000004, 0x08000008,
		0x08000008, 0x04000010, 0x04000010, 0x02000020,
		0x01000040, 0x00800080, 0x00600300, 0x00180C00,
		0x0007F000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(cirrad_ic, 32, 32, 1, cirrad_image);

static u_int	cirdia_image[32] = {
		0x00000000, 0x00000000, 0x0007F000, 0x00180C00, 
		0x00600300, 0x00800080, 0x01000040, 0x02000020, 
		0x04000010, 0x04000010, 0x08000008, 0x08000008,
		0x10000004, 0x10000004, 0x10008004, 0x1FFFFFFC, 
		0x10008004, 0x10000004, 0x10000004, 0x08000008,
		0x08000008, 0x04000010, 0x04000010, 0x02000020,
		0x01000040, 0x00800080, 0x00600300, 0x00180C00,
		0x0007F000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(cirdia_ic, 32, 32, 1, cirdia_image);

static u_int	c_spl_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x003FC000,
		0x01C03000, 0x02000800, 0x04000400, 0x04000400,
		0x04000800, 0x04001000, 0x02006000, 0x01E18000,
		0x001FF000, 0x00600F00, 0x01800080, 0x06000040,
		0x08000020, 0x10000020, 0x10000020, 0x20000020,
		0x20000020, 0x20000040, 0x10000080, 0x10000100,
		0x08000600, 0x07007800, 0x00FF8000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(c_spl_ic, 32, 32, 1, c_spl_image);

static u_int	compbegin_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x0000C000, 
		0x00010000, 0x00030000, 0x00030000, 0x00030000, 
		0x00030000, 0x00030000, 0x00030000, 0x00030000, 
		0x00030000, 0x00020000, 0x00040000, 0x00180000, 
		0x00040000, 0x00020000, 0x00030000, 0x00030000, 
		0x00030000, 0x00030000, 0x00030000, 0x00030000, 
		0x00030000, 0x00030000, 0x00010000, 0x0000C000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(compbegin_ic, 32, 32, 1, compbegin_image);

static u_int	compend_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x000C0000, 
		0x00020000, 0x00030000, 0x00030000, 0x00030000, 
		0x00030000, 0x00030000, 0x00030000, 0x00030000, 
		0x00030000, 0x00010000, 0x00008000, 0x00006000, 
		0x00008000, 0x00010000, 0x00030000, 0x00030000, 
		0x00030000, 0x00030000, 0x00030000, 0x00030000, 
		0x00030000, 0x00030000, 0x00020000, 0x000C0000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(compend_ic, 32, 32, 1, compend_image);

static u_int	copy_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x0E0001C0, 0x1F0003E0, 0x31800630,
		0x61800C30, 0x61800C30, 0x61800C30, 0x60C08C18,
		0x60C0CC18, 0x60DFEC18, 0x60C0CC18, 0x60C08C18,
		0x61800C30, 0x61800C30, 0x31800630, 0x19800330,
		0x0F0001E0, 0x060000C0, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(copy_ic, 32, 32, 1, copy_image);

static u_int	glue_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x3FFFFFF8, 
		0x3FFFFFF8, 0x30000018, 0x30001C18, 0x30006318, 
		0x30F08098, 0x310C8098, 0x32008098, 0x32006318, 
		0x31001C18, 0x30F00018, 0x300C0218, 0x30020118, 
		0x30020098, 0x34020058, 0x3204FE58, 0x31F81058, 
		0x30001058, 0x30001058, 0x33FC1098, 0x32041118, 
		0x32041218, 0x32041018, 0x33FC0018, 0x30000018, 
		0x3FFFFFF8, 0x3FFFFFF8, 0x00000000, 0x00000000, };
mpr_static(glue_ic, 32, 32, 1, glue_image);

static u_int	dashline_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x3E3E3E3E,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(dashline_ic, 32, 32, 1, dashline_image);

static u_int	dottedline_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x10842108,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(dottedline_ic, 32, 32, 1, dottedline_image);

static u_int	deletept_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x07800000, 
		0x02500000, 0x01300000, 0x00B00000, 0x00780000, 
		0x60740000, 0x58520000, 0x46990000, 0x31948000, 
		0x0C724000, 0x03192000, 0x02C69000, 0x0231C800, 
		0x041C6800, 0x04131C78, 0x0811FEFC, 0x08100FC6, 
		0x101006F2, 0x10100F3E, 0x20100D8C, 0x20100CC0, 
		0x40100640, 0x40100340, 0x001001C0, 0x00100000, 
		0x00100000, 0x00000000, 0x00000000, 0x00000000, 
		};
mpr_static(deletept_ic, 32, 32, 1, deletept_image);

static u_int	ellrad_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x0007F000, 0x00388E00,
		0x00C08180, 0x01008040, 0x02008020, 0x04008010,
		0x08008008, 0x08008008, 0x10008004, 0x1001FFFC,
		0x10008004, 0x08000008, 0x08000008, 0x04000010,
		0x02000020, 0x01000040, 0x00C00180, 0x00380E00,
		0x0007F000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(ellrad_ic, 32, 32, 1, ellrad_image);

static u_int	elldia_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x0007F000, 0x00388E00,
		0x00C08180, 0x01008040, 0x02008020, 0x04008010,
		0x08008008, 0x08008008, 0x10008004, 0x1FFFFFFC,
		0x10008004, 0x08008008, 0x08008008, 0x04008010,
		0x02008020, 0x01008040, 0x00C08180, 0x00388E00,
		0x0007F000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(elldia_ic, 32, 32, 1, elldia_image);

static u_int	flip_x_image[32] = {
		0x00000000, 0x00010000, 0x00028000, 0x00028000, 
		0x00044000, 0x00044000, 0x00082000, 0x00082000, 
		0x00101000, 0x00101000, 0x00200800, 0x003EF800, 
		0x00038000, 0x0006C000, 0x000AA000, 0x34ABAD24, 
		0x000AA000, 0x0006C000, 0x00038000, 0x003EF800, 
		0x00200800, 0x00101000, 0x00101000, 0x00082000, 
		0x00082000, 0x00044000, 0x00044000, 0x00028000, 
		0x00028000, 0x00010000, 0x00000000, 0x00000000, };
mpr_static(flip_x_ic, 32, 32, 1, flip_x_image);

static u_int	flip_y_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x01C00700, 
		0x02200880, 0x04101040, 0x04101040, 0x04101040, 
		0x02200880, 0x01438500, 0x01444500, 0x0E3FF8E0, 
		0x10092010, 0x261FF048, 0x4A2448A4, 0x52238894, 
		0x6410104C, 0x04101040, 0x08082020, 0x08082020, 
		0x10044010, 0x1EBC7AF0, 0x02A00A80, 0x02A00A80, 
		0x02A00A80, 0x02A00A80, 0x02A00A80, 0x02A00A80, 
		0x03E00F80, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(flip_y_ic, 32, 32, 1, flip_y_image);

static u_int	forarrow_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00078000, 
		0x00007800, 0x00000780, 0x1FFFFFF8, 0x1FFFFFF8, 
		0x00000780, 0x00007800, 0x00078000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000,  };
mpr_static(forarrow_ic, 32, 32, 1, forarrow_image);

static u_int	grid1_image[32] = {
		0x10410410, 0x10410410, 0x10410410, 0x10410410,
		0xFFFFFFFF, 0x10410410, 0x10410410, 0x10410410,
		0x10410410, 0x10410410, 0xFFFFFFFF, 0x10410410,
		0x10410410, 0x10410410, 0x10410410, 0x10410410,
		0xFFFFFFFF, 0x10410410, 0x10410410, 0x10410410,
		0x10410410, 0x10410410, 0xFFFFFFFF, 0x10410410,
		0x10410410, 0x10410410, 0x10410410, 0x10410410,
		0xFFFFFFFF, 0x10410410, 0x10410410, 0x10410410, };
mpr_static(grid1_ic, 32, 32, 1, grid1_image);

static u_int	grid2_image[32] = {
		0x10010010, 0x10010010, 0x10010010, 0x10010010,
		0xFFFFFFFF, 0x10010010, 0x10010010, 0x10010010,
		0x10010010, 0x10010010, 0x10010010, 0x10010010,
		0x10010010, 0x10010010, 0x10010010, 0x10010010,
		0xFFFFFFFF, 0x10010010, 0x10010010, 0x10010010,
		0x10010010, 0x10010010, 0x10010010, 0x10010010,
		0x10010010, 0x10010010, 0x10010010, 0x10010010,
		0xFFFFFFFF, 0x10010010, 0x10010010, 0x10010010, };
mpr_static(grid2_ic, 32, 32, 1, grid2_image);

static short	intspl_image[64] = {
		0x0000,0x0000,0x0000,0x0000, 0x0007,0x0000,0x003F,0xC000,
		0x01C7,0x3E00,0x0200,0x0E00, 0x0400,0x0E00,0x0E00,0x0000,
		0x0E00,0x0000,0x0E00,0x0000, 0x0200,0x0000,0x01E3,0x8000,
		0x001F,0xF000,0x0003,0x8F00, 0x0000,0x0080,0x0000,0x0040,
		0x0000,0x0020,0x0000,0x0070, 0x0000,0x0070,0x7000,0x0070,
		0x7000,0x0020,0x7000,0x0040, 0x1000,0x0080,0x1000,0x0100,
		0x0800,0x0600,0x071C,0x7800, 0x00FF,0x8000,0x001C,0x0000,
		0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
		};
mpr_static(intspl_ic, 32, 32, 1, intspl_image);

static short	c_intspl_image[64] = {
		0x0000,0x0000,0x0000,0x0000, 0x000E,0x0000,0x003F,0xC000,
		0x01CE,0x3000,0x0200,0x1C00, 0x0E00,0x1C00,0x0E00,0x1C00,
		0x0E00,0x0800,0x0400,0x1000, 0x0200,0x6000,0x01E1,0xC000,
		0x001F,0xF000,0x0061,0xCF00, 0x0180,0x0080,0x0600,0x0040,
		0x0800,0x0020,0x1000,0x0070, 0x1000,0x0070,0x3800,0x0070,
		0x3800,0x0020,0x3800,0x0040, 0x1000,0x0080,0x1000,0x0100,
		0x0800,0x0600,0x071C,0x7800, 0x00FF,0x8000,0x001C,0x0000,
		0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
		};
mpr_static(c_intspl_ic, 32, 32, 1, c_intspl_image);

static u_int	line_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00200080, 0x003000C0, 0x004800C0, 0x004800A0,
		0x008400A0, 0x008400A0, 0x01020090, 0x01020110,
		0x02010110, 0x02010108, 0x04008108, 0x04008108,
		0x08010100, 0x08020200, 0x10040200, 0x10080200,
		0x00100200, 0x00200200, 0x00400200, 0x00C00400,
		0x00300800, 0x000C1000, 0x00032000, 0x0000C000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,  };
mpr_static(line_ic, 32, 32, 1, line_image);

static u_int	magnet_image[32] = {
		0x00000000, 0x00000000, 0x000FF000, 0x00700E00, 
		0x01800180, 0x02000040, 0x04000020, 0x0803C010, 
		0x08042010, 0x10081008, 0x10100808, 0x10100808, 
		0x10100808, 0x20200404, 0x20200404, 0x20200404, 
		0x20200404, 0x20200404, 0x20200404, 0x10100808, 
		0x10100808, 0x12300B88, 0x13300C48, 0x0AA81390, 
		0x0A681050, 0x0A281450, 0x062423A0, 0x04042020, 
		0x07FC3FE0, 0x00000000, 0x00000000, 0x00000000, 
		};
mpr_static(magnet_ic, 32, 32, 1, magnet_image);

static u_int	unconstraint_image[32] = {
		0x00000000,0x00000000,0x00000000,0x00055F80,
		0x00102F80,0x00400780,0x00002340,0x01000060,
		0x00004010,0x04000030,0x00004068,0x080001C8,
		0x00004708,0x10000E04,0x0000981F,0x1000700E,
		0x0000C00E,0x1000280E,0x00004204,0x10000084,
		0x00001020,0x08000008,0x00000800,0x04000010,
		0x00000400,0x01000040,0x00000200,0x00400100,
		0x00100400,0x00055000,0x00000000,0x00000000, };
mpr_static(unconstraint_ic, 32, 32, 1, unconstraint_image);

static u_int	mounthattan_image[32] = {
		0x00000000,0x00000000,0x00000000,0x00000000,
		0x00000000,0x001F8000,0x001F8000,0x00198000,
		0x00198040,0x001980A0,0x0039C110,0x0039C208,
		0x0130C404,0x02B0C802,0x0470D001,0x0830E000,
		0x1030C000,0x2030C000,0x4030F000,0x8030F000,
		0x00300000,0x00300000,0x00000000,0x00000000,
		0x00000000,0x00000000,0x00000000,0x00000000,
		0xFFFFFFFF,0x00000000,0x00000000,0x00000000, };
mpr_static(mounthattan_ic, 32, 32, 1, mounthattan_image);

static u_int	manhattan_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x001F8000, 0x001F8000, 0x00198000,
		0x00198000, 0x0019800F, 0x0039C00F, 0x0039C00C,
		0x0030C00C, 0x0030C00C, 0x0030C00C, 0x3E30CF8C,
		0x3E30CF8C, 0x3630CD8C, 0x3630FD8C, 0x3630FD8C,
		0x37F0018C, 0x37F0018C, 0x300001FC, 0x300001FC,
		0xF0000000, 0xF0000000, 0x00000000, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0x00000000, };
mpr_static(manhattan_ic, 32, 32, 1, manhattan_image);

static u_int	mountain_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x0C000000, 0x1E000000, 0x33000000,
		0x61800000, 0xC0C00000, 0x80600000, 0x00300000,
		0x00180018, 0x000C003C, 0x00060066, 0x000300C3,
		0x00018180, 0x0000C300, 0x00006600, 0x00003C00,
		0x00001800, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0x00000000, };
mpr_static(mountain_ic, 32, 32, 1, mountain_image);

static u_int	move_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x000001C0, 0x0A0003E0, 0x10000630, 
		0x21000C30, 0x00000C30, 0x21000C30, 0x00808C18, 
		0x2000CC18, 0x009FEC18, 0x2000CC18, 0x00808C18, 
		0x20000C30, 0x01000C30, 0x10000630, 0x09000330, 
		0x020001E0, 0x000000C0, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(move_ic, 32, 32, 1, move_image);

static u_int	movept_image[32] = {
		0x00000000, 0x00000000, 0x00020000, 0x000103F0,
		0x000083F0, 0x03FFC330, 0x200083F0, 0x000103F0,
		0x080206C0, 0x20000CC0, 0x020018C0, 0x000030C0,
		0x208060C0, 0x0000C0C0, 0x002180C0, 0x200300C0,
		0x000E00C0, 0x000C00C0, 0x201A00C0, 0x003000C0,
		0x006080C0, 0x20C000C0, 0x018020C0, 0x030000C0,
		0x260008C0, 0x0C0000C0, 0x180002C0, 0x300000C0,
		0x000000C0, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(movept_ic, 32, 32, 1, movept_image);

static u_int	polygon_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x03FFF800, 
		0x02000400, 0x02000200, 0x02000100, 0x02000080, 
		0x02000040, 0x02000040, 0x02000040, 0x02000040, 
		0x02000040, 0x02000080, 0x02000100, 0x02000200, 
		0x02000400, 0x0203F800, 0x02020000, 0x02020000, 
		0x02020000, 0x02020000, 0x02020000, 0x02020000, 
		0x02020000, 0x02020000, 0x02020000, 0x02020000, 
		0x03FE0000, 0x00000000, 0x00000000, 0x00000000,  };
mpr_static(polygon_ic, 32, 32, 1, polygon_image);

static u_int	remove_image[32] = {
		0x00000000, 0x00000200, 0x00084400, 0x00000800, 
		0x00211004, 0x00002008, 0x00844010, 0x00008021, 
		0x02110040, 0x00008084, 0x10844100, 0x10002210, 
		0x10211400, 0x10000840, 0x10000000, 0x10000000, 
		0x10000400, 0x10000300, 0x08000080, 0x08000080, 
		0x08000040, 0x04000040, 0x02000040, 0x018000C0,
		0x00400080, 0x00200300, 0x001E1C00, 0x0003E000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(remove_ic, 32, 32, 1, remove_image);

static u_int	rot270_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00030000, 0x0000C000, 0x003FF000, 0x0020C000, 
		0x00230000, 0x00200000, 0x00200000, 0x00200000, 
		0x00200000, 0x00200000, 0x00200000, 0x00200000, 
		0x00200000, 0x00200000, 0x00700000, 0x00A80000, 
		0x01240000, 0x013FFFF0, 0x01040010, 0x00880010, 
		0x00700010, 0x00000054, 0x00000054, 0x00000038, 
		0x00000038, 0x00000010, 0x00000010, 0x00000000, };
mpr_static(rot270_ic, 32, 32, 1, rot270_image);

static u_int	rot90_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x06000000, 0x18000000, 0x7FE00000, 0x18200000, 
		0x06200000, 0x00200000, 0x00200000, 0x00200000, 
		0x00200010, 0x00200010, 0x00200038, 0x00200038, 
		0x00200054, 0x00200054, 0x00700010, 0x00A80010, 
		0x01240010, 0x013FFFF0, 0x01040000, 0x00880000, 
		0x00700000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(rot90_ic, 32, 32, 1, rot90_image);

static u_int	scale_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x2AFFFFF8,
		0x15FFFFF8, 0x20C00018, 0x10C01E18, 0x20C06198, 
		0x10F08058, 0x21CC8058, 0x12C08058, 0x22C06198, 
		0x11C01E18, 0x20F80018, 0x10C40218, 0x20C20118,
		0x10C20098, 0x24C20058, 0x12C4FE58, 0x21F81058, 
		0x10C01058, 0x20C01058, 0x13FFFFF8, 0x22FFFFF8, 
		0x12041210, 0x22041008, 0x13FC0010, 0x20000008, 
		0x15555550, 0x2AAAAAA8, 0x00000000, 0x00000000, };
mpr_static(scale_ic, 32, 32, 1, scale_image);

static u_int	turn_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x01000004, 0x02000008, 0x04000010, 0x08000020, 
		0x10000040, 0x10000080, 0x20000100, 0x20000200, 
		0x20000400, 0x20000800, 0x10000400, 0x10000200, 
		0x08000100, 0x08000080, 0x04000040, 0x04081020, 
		0x02100810, 0x023FFC08, 0x02100810, 0x04081020, 
		0x04000040, 0x08000080, 0x10000100, 0x20000200, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(turn_ic, 32, 32, 1, turn_image);

static u_int	solidline_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x3FFFFFF8, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(solidline_ic, 32, 32, 1, solidline_image);

static u_int	spl_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x003FC000,
		0x01C03800, 0x02000400, 0x04000000, 0x04000000,
		0x04000000, 0x04000000, 0x02000000, 0x01E00000,
		0x001FF000, 0x00000F00, 0x00000080, 0x00000040,
		0x00000020, 0x00000020, 0x00000020, 0x00000020,
		0x20000020, 0x20000040, 0x10000080, 0x10000100,
		0x08000600, 0x07007800, 0x00FF8000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, };
mpr_static(spl_ic, 32, 32, 1, spl_image);

static u_int	text_image[32] = {
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x07FFFFE0, 0x0707E0E0, 0x0603C060, 0x0403C020,
		0x0003C000, 0x0003C000, 0x0003C000, 0x0003C000,
		0x0003C000, 0x0003C000, 0x0003C000, 0x0003C000,
		0x0003C000, 0x0003C000, 0x0003C000, 0x0003C000,
		0x0003C000, 0x0003C000, 0x0003C000, 0x0003C000,
		0x0003C000, 0x0007E000, 0x001FF800, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,  };
mpr_static(text_ic, 32, 32, 1, text_image);

typedef struct		switch_struct {
				int		on;
				int		group;
				int		x;	/* Row 0 / 1 */
				int		y;	/* Column 0 -> ? */
				struct pixrect	*icon;
				int		value;
				int		(*on_func)();
				int		(*off_func)();
				int		type;
#define						S_TOG		1
#define						S_ON		2
				}
			F_switch;
/*
Switches in the same "group" > -1 are mutually exclusive;
i.e., only one of the switches of the same group can be on at any time.
If a switch in a group n>-1 is on and another one in the same group is
depressed, the former will be turned off and the latter on.
A S_ON switch can not be turned off by clicking at it; it can be turned
off only by clicking another switch in the same group.
A S_TOG switch can be turned off both ways.
No two S_ON or S_ON switches of the same group can be on (hilighted)
at anytime.
Switches with group = -1 are toggle type switches.
*/
