.\"   Manual documentation for Tib reference formatting programs
.TH TIB 1 "2/14/86" 
.fi
.SH NAME
tib, tibdex, tiblook, tiblist \- process reference and citation entries
for TeX documents
.SH SYNOPSIS
.sp1
.in -5
.pp
\fBtib\fR  [-d <\fIdirectory\fR>] [-i <\fIinclude file\fR>] 
[-n <\fIinitial citation number\fR>]
[-p <\fIprivate index file(s)\fR>] [-s <\fIstyle file\fR>] 
[-x] [-z] [-|] [<\fIinput file(s)\fR>]
.sp1
.pp
\fBtibdex\fR  [-c <\fIcommon-word file\fR>] [-k <\fIkey number\fR>] 
[-l <\fIlength of keys\fR>] [-p <\fIprivate output file\fR>] [-z] 
[-% <\fIstring\fR>] <\fIreference file(s)\fR>
.sp1
.pp
\fBtiblist\fR [-d <\fIdirectory\fR ][-i <\fIinclude file\fR>] 
[-s <\fIstyle file\fR>] [-x] [-z] [-|] [<\fIreference file(s)\fR>]
.sp1
.pp
\fBtiblook\fR [-c <\fIcommon-words file\fR>] [-l <\fIlength of keys\fR>] 
[-p <\fIprivate indices\fR>] [<\fIkeyword1 keyword2 ...\fR>]
.sp1
.SH DESCRIPTION
.pp
There are four programs in the Tib package:
.sp 1
.in +.5
.ta 1in
Tib      	bibliographic preprocessor for TeX documents,
.br
Tibdex   	makes inverted index from database(s),
.br
Tiblist		lists all members of the database(s),
.br
Tiblook  	locates listings in the database(s).
.in -.5
.sp 1
.in +3
\fITib\fR is a program to construct a bibliography for a TeX file
and to include calls to macros files so that TeX formats the citations
and bibliography in any of a number of styles.
The \fIinput file\fR is a TeX file augmented with incomplete or keyed
citations surrounded by Tib escape characters.
Multiple input files are separated by spaces on the call and amalgamated
into one output file.  If <\fIinput file\fR> is omitted, one prompt is given.
If the input file is named \fIfile\fR or \fIfile.tex\fR,
the output file is named \fIfile-t.tex\fR, unless the input file is
\fIstdin\fR, in which case the output file is \fIstdout\fR.
The following are the options:
.sp 1
.in +3
\fB-d\fR <\fIdirectory\fR>  Private directory of tib files.

\fB-i\fR <\fIfiles\fR>    Include files of macros and tib commands.  
This option is used if there are private macro/command files.

\fB-n\fR <\fInumber\fR>   Nonnegative integer to initialize citations.

\fB-p\fR <\fIfiles\fR>    Private index files, separated by commas.  
The default is the file \fIINDEX\fR in the working directory.

\fB-s\fR <\fIfile\fR>     Style file, which contains formatting 
instructions and also may call other files.

\fB-x\fR            Output to \fIstdout\fR.

\fB-z\fR            Silent run. Informational 
(but not warning or error) messages are suppressed.

\fB-|\fR            Pipe. Input is \fIstdin\fR; output is \fIstdout\fR. Silent.
.in -3
.sp 1
\fITibdex\fR makes an inverted index from reference file(s). 
Multiple reference files are separated by spaces.  
The output is an inverted index for use by Tib and Tiblist.  The output 
index must not be moved or the links to the reference files will be broken.
The following are the options:
.in+3
.sp1
\fB-c\fR <\fIfile\fR>   	Common-word list, one word per line.  
Common words are not used as keys (default CCCCC).

\fB-k\fR <\fInumber\fR>   	Maximum number of keys kept per record 
(default 100).

\fB-l\fR <\fInumber\fR>   	Maximum length of keys (default 6)

\fB-p\fR <\fIfile\fR>    	Private output file (default \fIINDEX\fR in the current directory).

\fB-z\fR	Silent run.  Informational (but not warning and error) messages are suppressed.

\fB-%\fR <\fIstring\fR>  	Ignore lines in the reference file that 
begin with %x where x is in the string (default CNOPVcnopv\\ ).
.in -3
.sp 1
\fITiblist\fR makes a formatted TeX file of all entries in the
input reference file(s).  Multiple files are separated by spaces.
If <input file> is omitted, one prompt is given.  Unlike Tib, Tib list
does not use inverted indices, but operates directly on the reference files.
The following are the options:
.sp 1
.in +3
\fB-d <\fIdirectory\fR>  	Private directory of tib files.

\fB-i <\fIfiles\fR>      	Include files of macros and tib commands.  This option is used if there are private macro/command files.

\fB-s\fR <\fIfile\fR>    	Style file, which contains formatting instructions and also may call other files.

\fB-x\fR	Output to \fIstdout\fR.

\fB-z\fR	Silent run. Informational (but not warning and error) 
messages are suppressed.

\fB-|\fR	Pipe. Input is \fIstdin\fR; output is \fIstdout\fR.  Silent.
.in -3
.sp 1
Note: the \fB-p\fR option does not cause an error, but is ignored.
.br
.sp 1
\fITiblook\fR locates entries in reference files from
keywords entered at the terminal.  If keywords are entered on the command
line, it operates noninteractively, otherwise it gives instructions for
interactive use.  Tiblook, like Tib, works through inverted indices 
to get to the reference files.  
.sp 1
The following are the options:
.sp 1
.in +3
\fB-c\fR <\fIfile\fR>  	Common-word list, one word per line.  
Common words are not used as keys (default CCCCC/common).

\fB-l\fR <\fInumber\fR>   	Maximum length of keys (default 6).

\fB-p\fR <\fIfiles\fR>   	Private index files, separated by commas.  
The default is the file \fIINDEX\fR in the working directory.
.in -6
.SH STYLES
.sp 1
.in +3
There are a number of styles (called with the -s option) available.  See the
full documentation or the file AAAAA/Styles.
.in -3
.SH FILES AND DIRECTORIES
.sp 1
.ta 2in
.in +3
AAAAA     	directory for Tib documentation
.br
BBBBB     	directory for Tib macros
.br
CCCCC     	Tib file of common words
.br
FFFFF     	Tib system index
.br
EEEEE     	source directory
.in -3
.SH AUTHOR
.sp 1
.in +3
.nf
James C. Alexander
.in -3
.fi
.SH ACKNOWLEDGEMENTS
.sp 1
.in +2
Tib is based on the \fInroff/troff\fR bibliography system \fIbib\fR
by T. A. Budd of the University of Arizona, which in turn was inspired
by the system \fIrefer\fR.   Certain files used by Tib are supplied
by \fIMathematical Reviews\fR.  The material in these files is 
copyright by \fIMathematical Reviews\fR.
.in -2
.SH SEE ALSO
.sp 1
.in +1
AAAAA/intro.tib  \- a brief introduction
.br
AAAAA/tibdoc.tex. \- full documentation: a plain TeX file
.br
AAAAA/Styles \- available styles
.br
.sp 1
tex(1), latex(1), bib(1), refer(1)
