/*
This file contains the list for non-math macros and plain troff macros.
Do NOT forget to put the dot for the troff macros, and the backslash
for TeX macros (two backslashes, one for escape).
The third column in the list is 0 for macros that have no arguments
and either 1 or 2 for those that do. If it is 1, then only one line
will be read as an argument. If it is 2, then lines will be read until
properly terminated. Arguments for MS macros are terminated by an MS macro
(e.g. .PP). Plain troff macros are terminated after reading the desired number
of lines specified by the macro (e.g. .ce 5   will centerline 5 lines).
*/
struct macro_table {
	char *troff_mac, *tex_mac;
	int arg;
} macro[] = {

/*  troff macro		TeX macro		   argument	*/
	".1C",		 "\\onecolumn",			0,
	".2C",		 "\\twocolumn",			0,
	".AE",		 "\\end{abstract}",		0,
	".AI",		 "\\authoraff",			2,
	".AU",		 "\\author",			2,
	".Ac",		 "\\ACK",		  	0,
	".B1",		 "\\boxit{",			0,
	".B2",		 "}",				0,
	".DE",		 "\\displayend",		0,
	".DS",		 "\\displaybegin",		0,
	".FE",		 "}",				0,
	".FS",		 "\\footnote{",			0,
	".IP",		 "\\par\\noindent",		0,
	".Ie",		 "}\\end{figure}",		0,
	".Is",		 "\\begin{figure}",		0,
	".KS",		 "{\\nobreak",			0,
	".LP",		 "\\par\\noindent",		0,
	".MH",		 "\\mhead",			2,
	".NH",		 "\\section",			1,
	".PP",		 "\\par",			0,
	".QE",		 "\\end{quotation}",		0,
	".QS",		 "\\begin{quotation}",		0,
	".SH",		 "\\shead",			1,
	".TH",		 "\\phead",			1,
	".TL",		 "\\title",			2,
	".UC",		 "",				0,
	".UL",		 "\\undertext",			1,
	".bp",		 "\\newpage",			0,
	".br",		 "\\nwl",			0,
	".ce",		 "\\cntr",			2,
	".cu",		 "\\undertext",			2,
	".fi",		 "\\fill",			0,
	".na",		 "\\raggedright",		0,
	".nf",		 "\\nofill",			0,
	".ns",		 "",				0,
	".ul",		 "\\undertext",			2
};
