set terminal latex
set output "eg4.tex"
set size 3.5,3
set format x "$%5.1f\mu$"
set noclip
set title "This is a very long title\\because it has\\three lines"
set xlabel "This is the $x$ axis\\with more than two\\lines in the label"
set ylabel "This is a longer\\version of\\the $y$ axis"
set style new1 "$\otimes$" 3 "\circle*{100}" "\circle*{200}" "\circle*{300}"
plot [-10:10] [-10:10] "eg3.dat" with new1, 3*exp(-x*x)+1 with lines
label -5,-5 "Data" rb 1.7
key -7,5 "Data file" with new1, "$3e^{-x^{2}}+1$" with lines
