/*
 * File:
 *
 *	pxl.h
 *
 * Author:
 *
 *	Brad Rullman
 *	Department of Computer Science  FR-35
 *	University of Washington
 *	Seattle, Washington  98155
 *	email: ecola@cs.washington.edu
 *
 *	Copyright @ March, 1987 - This program, or any subset of the functions
 *	herein, is not to be redistributed, or used for personal or commercial
 *	gain in the form of fame, fortune, or shorter working hours, without
 *	the consent of the author.
 *
 * Function:
 *
 *	Include file for pxl.c.
 */

#define MAXBSIZE	8192
#define PXLID		1001 /* should be first word in every pxl file */
#define FONTDIRPTR 	8    /* points to font directory table in pxl file */
#define MINVIEWSWMARGIN	4    /* min pixel width to leave as ViewSW margin  */ 


/*
 * PXLData, PXLDataPtr.
 *
 * Contains the pixel width, height, reference point x-offset and y-offset,
 * and the byte offset to the start of a raster image for a character. This
 * is taken from the directory entry for a TeX character in a pxl file.
 * (Note: the width and height are the bounding box for the pixel image
 * and not the tfm widths.)
 */
typedef struct {
    short	width;
    short	height;
    short	xOffset;
    short	yOffset;
    int		rasterPtr;
} PXLData, *PXLDataPtr;
