/*
 * File:
 *
 *	paint.c
 *
 * Author:
 *
 *	Brad Rullman
 *	Department of Computer Science  FR-35
 *	University of Washington
 *	Seattle, Washington  98155
 *	email: ecola@cs.washington.edu
 *
 *	Copyright @ March, 1987 - This program, or any subset of the functions
 *	herein, is not to be redistributed, or used for personal or commercial
 *	gain in the form of fame, fortune, or shorter working hours, without
 *	the consent of the author.
 *
 * Function:
 *
 *	A file of functions which implement the Paint subwindow.
 *
 * Contents:
 *
 *   Public:
 *
 *	InitPaintSW		Creates the PaintSW and associated pixwin.
 *	FixPaintSW		Resets size and position of PaintSW.
 *
 *   Private:
 *
 *	paintSWInputHandler	Handles mouse input in the PaintSW.
 */

#include "global.h"
#include <suntool/scrollbar.h>

static Scrollbar   ScrollbarVert;	/* vertical scrollbar */
static Scrollbar   ScrollbarHori;	/* horizontal scrollbar */
static int         ScrollbarBreadth;	/* default thickness of scrollbar */



/*
 * InitPaintSW
 *
 * Input:
 *	none.
 * Output:
 *	none.
 * Action:
 *	Create the paint subwindow, which is a canvas subwindow.
 *	The paint subwindow will catch mouse input (position and button)
 *	and take appropriate action.
 */
void
InitPaintSW()
{
    static void paintSWInputHandler();

    ScrollbarBreadth = (int) scrollbar_get(SCROLLBAR, SCROLL_THICKNESS);
    ScrollbarVert = scrollbar_create(0);
    ScrollbarHori = scrollbar_create(0);

    PaintSW = window_create(FontToolFrame, CANVAS,
	CANVAS_AUTO_SHRINK,		FALSE,
	CANVAS_AUTO_EXPAND,		FALSE,
  	CANVAS_WIDTH,			SCALEUP(MINVIEWSWWIDTH),
  	CANVAS_HEIGHT,			SCALEUP(MINVIEWSWHEIGHT),
	WIN_WIDTH,		SCALEUP(MINVIEWSWWIDTH) + ScrollbarBreadth,
	WIN_HEIGHT,		SCALEUP(MINVIEWSWHEIGHT) + ScrollbarBreadth,
	WIN_CURSOR,			PaintCursor,
	WIN_VERTICAL_SCROLLBAR,		ScrollbarVert,
	WIN_HORIZONTAL_SCROLLBAR,	ScrollbarHori,
	WIN_CONSUME_PICK_EVENTS,	WIN_NO_EVENTS, WIN_MOUSE_BUTTONS,
					LOC_DRAG, LOC_STILL, 0,
	WIN_EVENT_PROC,			paintSWInputHandler,
	CANVAS_FAST_MONO,		TRUE,
	0);
    PaintPW = canvas_pixwin(PaintSW);
}



/*
 * FixPaintSW
 *
 * Input:
 *	none.
 * Output:
 *	none.
 * Action:
 *	Makes sure the PaintSW is positioned and sized correctly, in case
 *	the user has resized the main tool window, the ViewSW has changed
 *	in size, or a new magnification has been selected.  Note that the
 *	contents of the PaintSW must first be "homed" to scrolling position
 *	(0, 0), otherwise resizing it makes no sense.
 */
void
FixPaintSW()
{
    Rect r;

    r = *((Rect *) window_get(FontToolFrame, WIN_RECT));
    PaintRect.r_top = MAX(
	ViewRect.r_top + ViewRect.r_height + SWSPACING,
	OptionRect.r_top + OptionRect.r_height + SWSPACING);
    PaintRect.r_width = MIN(
	SCALEUP(ViewRect.r_width) + ScrollbarBreadth,
	r.r_width - 2*FRAMEMARGIN);
    PaintRect.r_height = MIN(
	SCALEUP(ViewRect.r_height) + ScrollbarBreadth,
	r.r_height 
	    - (int) window_get(FontToolFrame, WIN_TOP_MARGIN)
	    - MessageRect.r_height
	    - MAX(ViewRect.r_height, OptionRect.r_height)
	    - 2*SWSPACING
	    - FRAMEMARGIN);
    scrollbar_scroll_to(ScrollbarVert, 0);
    scrollbar_scroll_to(ScrollbarHori, 0);
    r = PaintRect;
    window_set(PaintSW, WIN_RECT, &r, 0);
    window_set(PaintSW,
	CANVAS_WIDTH,	SCALEUP(ViewPR->pr_size.x),
	CANVAS_HEIGHT,	SCALEUP(ViewPR->pr_size.y),
	0);
}



/*
 * paintSWInputHandler
 *
 * Input:
 *	window: A subwindow handle.
 *	event : A pointer to an event.
 *	arg   : "An optional argument containing data pertinent to the event."
 * Output:
 *	none.
 * Action:
 *	paintSWInputHandler is called when one of the events specified
 *	in the input mask for the paint subwindow has occurred.
 */
static void
paintSWInputHandler(window, event, arg)
Window window;
Event *event;
caddr_t arg;
{
    int xView, yView;
    enum mouseButs {none, left, middle, right};
    static enum mouseButs currentMousePressed;

    /*
     * Convert to the unmagnified coordinates used in the ViewSW.
     */
    xView = SCALEDOWN(event_x(event));
    yView = SCALEDOWN(event_y(event));

    switch(event_id(event)) {
	case MS_LEFT: 
       	    if (event_is_down(event)) {
	       	currentMousePressed = left;
		PaintColor = BLACK;
		RasterChanged = 1;
		switch(MouseMode) {
		    case MODEPOINTS:
			ResetRect(&UndoRect, xView, yView, 1, 1);
			COPYPR(ViewPR, UndoPR);
			DrawDot(xView, yView);
			CLEARUNDOREFPT;
			break;
		    case MODELINES:
			StartLine(xView, yView);
			CLEARUNDOREFPT;
			break;
		    case MODEFILL:
			FillRegion(xView, yView);
			CLEARUNDOREFPT;
			break;
		    case MODEMOVE:	/* move the reference point */
			SETUNDOREFPT;
			MoveRefPoint(SCALEUP(xView), SCALEUP(yView));
			ClearMsg();
			break;
		}
	    }
	    else {
		currentMousePressed = none;
	    }
	    break;
		    
	case MS_MIDDLE:
       	    if (event_is_down(event)) {
	       	currentMousePressed = middle;
		PaintColor = WHITE;
		RasterChanged = 1;
		switch(MouseMode) {
		    case MODEPOINTS:
			ResetRect(&UndoRect, xView, yView, 1, 1);
			COPYPR(ViewPR, UndoPR);
			DrawDot(xView, yView);
			CLEARUNDOREFPT;
			break;
		    case MODELINES:
			StartLine(xView, yView);
			CLEARUNDOREFPT;
			break;
		    case MODEFILL:
			FillRegion(xView, yView);
			CLEARUNDOREFPT;
			break;
		    case MODEMOVE:	/* move the reference point */
			SETUNDOREFPT;
			MoveRefPoint(SCALEUP(xView), SCALEUP(yView));
			ClearMsg();
			break;
		}
	    }
	    else {
		currentMousePressed = none;
	    }
	    break;

	case MS_RIGHT:	/* Undo */
       	    if (event_is_down(event)) {
		SETCURSORWATCH;
		Undo();
		SETCURSORNORMAL;
	    }
	    break;

	case LOC_DRAG:
	    if ( (currentMousePressed == left) || 
		 (currentMousePressed == middle) ) {
		switch (MouseMode) {
		    case MODEPOINTS:
			ExpandRect(&UndoRect, xView, yView);
			DrawDot(xView, yView);
			break;
		    case MODELINES:
			DrawLine(xView, yView);		    
			break;
		    case MODEFILL:
			break;
		    case MODEMOVE:
			/*
			 * If the new mouse position is not in the same
			 * PaintSW cell as in the last event, go ahead and
			 * move the reference point.
			 */
			if ( (SCALEUP(xView) != ReferenceXY.x) || 
			     (SCALEUP(yView) != ReferenceXY.y) ) {
			    MoveRefPoint(SCALEUP(xView), SCALEUP(yView));
			}
			break;
		}
	    }
	    break;

	case LOC_STILL:
	    if ( (MouseMode == MODELINES) && (currentMousePressed != none) ) {
		DrawLine(xView, yView);
	    }
	    break;

	default:
	    break;
    }
}
