% UNIX.CH. UNIX Change file for Crudetype
% UNIX changes by Peter King for Berkeley Pascal
% modified by RMD for Crudetype version 2
%

% COPYRIGHT ( C ) P.King,  Heriot-Watt University, 1988.
%
% Permission is given to any person to make and distribute copies of this
% software, subject to the following conditions:
%
% 1. All copies of the software must carry an exact copy of this notice.
%
% 2. This software is distributed free of charge, "AS IS" with absolutely no
% guarantee of performance. Any persons receiving or using this software must do
% so entirely at their own risk. Neither the authors nor their institutions
% accept any liability for any defects of this software, or for any consequential
% loss or damage however caused.
%
% 3. Any person who changes this software must clearly mark it as modified and
% add a note describing the changes made.


% [0] WEAVE: print changes only
@x
\pageno=\contentspagenumber \advance\pageno by 1
@y
\pageno=\contentspagenumber \advance\pageno by 1
\def\title{Crudetype for {\mc UNIX }  }
@z

% 4
@x
@d banner=='This is Crudetype, Version 2, copyright, experimental'
@y
@d banner=='This is Crudetype, Version 2, copyright, experimental UNIX'
@z

%6
@x
  @<Set initial values@>
@y
  @<Set initial values@>
  setpaths; { set up the correct search path for fonts }
@z

%7
% add variables for runtime arguments, and to suppress all the non-error
% information messages
% stdin is not yet used, but is a handle for an extension to read from
% input ( a UNIX pipe )
@x
  in_i, in_j :integer; {loop index for initializations}
@y
  in_i, in_j :integer; {loop index for initializations}
  stdin : boolean; { read from standard input }
@z

% 11
% Change the types
@x
@<Types...@>=
  byte = 0..255 ;
  i_word = -max_half-1 .. max_half ;
@y
@<Types...@>=
  byte = 0..255 ;
  bite = -128..127 ; { signed ! }
  i_word = -max_half-1..max_half ;
@z

% 13
% UNIX writeln moves you down a line
@x
  w_l_feed_dist = 0 ;
@y
  w_l_feed_dist = 1 ;
@z

% 14
%
@x
@<Lowest...@>=
  {Declare |parse_file|}
@y
@<Lowest...@>=
  procedure  parse_file( name: var_string; var dir, nam, ex: var_string) ;
  var p,r,s: s_ptr ;
  begin
    dir := blank; nam := blank; ex := blank;
    s := name.len ;
    if ( s>0) then begin
      p := s_search( name, '/', -s);
      if ( p>0) then substring( dir, name, 1, p) ;
      r := s_search( name, '.', -s);
      if ( r>p) then substring( ex, name, r, s-r+1)
      else r := s +1 ;
      substring( nam, name, p+1, r-p-1) ;
    end;
  end;
@z

% 18
% Changes to incorporate UNIX conventions
% lower case file names, default to putting the .lpr file in the
% same directory as the .dvi file
@x
@d block_length = 512
@d same_dir == false

@<Set init...@>=
  set_string( dvi_def, '.DVI' , ' ', 0) ;
  set_string( tfm_def, 'TEX$FONTS:.TFM', ' ', 0) ;
  set_string( raster_def, 'TEX$GF:.&DGF', ' ', 0) ;
  set_string( print_ex, '.PRI', ' ', 0);
@y

The Unix version of \.{Crudetype} uses ``paths''.

@d block_length = 1
@d same_dir == true

@<Set init...@>=
  set_string( dvi_def, '.dvi' , ' ', 0) ;
  set_string( tfm_def, '/tex/fonts/.tfm', ' ', 0) ;
  set_string( raster_def, '/tex/gfdir/.&Dgf', ' ', 0) ;
  set_string( print_ex, '.lpr', ' ', 0);
@z

% 19
% More of the UNIX simple minded view of files.
% but including the (optional) directory search for .tfm files
@x
@<Lowest...@>=
  {Declare |open_binary|}
@y
@d read_access_mode=4  {``read'' mode for |test_access|}
@d write_access_mode=2 {``write'' mode for |test_access|}

@d close_binary(#)== do_nothing ;

@<Lowest...@>=
  procedure setpaths;
    external;
  function test_access(accessmode:integer; filepath:integer): boolean;
    external;

@#
  function open_binary (var f_f: byte_file; name: var_string;
    search_path: integer ): boolean;
  begin
    cur_name := name.data ;
    if test_access(read_access_mode,search_path) then
    begin
      reset(f_f, real_name_of_file);
      set_string( name, real_name_of_file, ' ' , 0) ;
      open_binary := true
    end
    else
    open_binary := false
  end;
@z

% 20
@x
@ @<Open |printfile|@>=
  rewrite(printfile) ;
@y
@ @<Open |printfile|@>=
  rewrite(printfile, print_name.data ) ;
@z

@x 21
@d get_val( #) == # := s_to_i( #, true)
@d prefix == "/"
@d got_cl == ( command.len > 0)
@d read_command_line( #) == do_nothing

@<Lowest...@>=
  {Declare |read_command_line| }
@#
  procedure get_command ;
  var ss: s_dat ;
  begin
    ss := blank.data ;
    read_command_line( ss) ;
    set_string( command, ss, ' ', 0) ;
  end;
@y

Unix \P\ does not supply a command line; instead it chops it up and supplies
the pieces using two predeclared procedures |argc| and |argv|. It seemed to me
that the least messy way to fit this onto the rest of the program is to
re-assemble the command line.

@d get_val( #) == # := s_to_i( #, true)
@d prefix == "-"
@d got_cl == ( argc > 1)
@d read_command_line( #) == do_nothing

@<Lowest...@>=
  procedure get_command ;
  var ss: s_dat ; nn: integer ; tt: var_string ;
  begin
    command := blank ;
    for nn := 1 to argc-1 do begin
      ss := blank.data ;
      argv( nn, ss) ;
      set_string( tt, ss, ' ', 0) ;
      append( command, tt) ;
      incr( command.len) ;
    end;
  end;
@z

@x 27
@ If there was no command line, try to send messages to the user at a
terminal. This requires nonstandard \PASCAL\ constructions to handle the
online interaction. So it may be necessary on some systems to omit the dialog.
First, the (\.{DVI}) file name.

@<Get \.{DVI} file name and open it@>=
  if can_interact and ( dvi_name.len = 0) then repeat
    ask_prompt('DVI file name? ') ;
    get_name( dvi_name) ;
  until ( dvi_name.len > 0) ;
  if not open_and_ask(dvi_file, dvi_indx, dvi_name, dvi_def, true)
  then abort('couldnt open DVI file')
    @.Fatal: couldnt open@>
@y
@ If there was no command line, try to send messages to the user at a
terminal. This requires nonstandard \PASCAL\ constructions to handle the
online interaction. So it may be necessary on some systems to omit the dialog.
First, the (\.{DVI}) file name. This part is altered to use Unix style path
searching.

@d no_file_path=0    {no path searching should be done}
@d font_file_path=3  {path specifier for \.{TFM} files}

@<Get \.{DVI} file name and open it@>=
  if can_interact and ( dvi_name.len = 0) then repeat
    ask_prompt('DVI file name? ') ;
    get_name( dvi_name) ;
  until ( dvi_name.len > 0) ;
  dvi_indx := no_file_path ;
  if not open_and_ask(dvi_file, dvi_indx, dvi_name, dvi_def, true)
  then abort('couldnt open DVI file')
    @.Fatal: couldnt open@> @.Opening DVI file@>
@z

% 28
@x
@ But when we come to open a font file, we merely report a failure:

@<Open font file@>=
  font_ok := open_and_ask (tfm_file, tfm_indx, tfm_name, tfm_def, true) ;
@y
@ When we try to open a font file, we search the path specified by the user's
environment variable before we report a failure:

@<Open font file@>=
  tfm_indx := font_file_path ;
  font_ok := open_and_ask (tfm_file, tfm_indx, tfm_name, tfm_def, true) ;
@z

@x 34
@ @<Glob...@>=
  next_pause: integer;
  pause_after: var_string ;
@y
@ The filenames used by |test_access| are added here.

@<Glob...@>=
  next_pause: integer;
  pause_after: var_string ;
  @!cur_name,@!real_name_of_file:s_dat ;
   {external name}
@z

% 35 binary file handling
@x
The main input file is the \.{DVI} file. Logically, this is just a stream of
8-bit bytes, with no record or block structure. However VMS \PASCAL\
apparently cannot handle files of this type; so I have adopted the blocking
scheme (due to D.R.Fuchs) from the VMS \.{DVItype} change file. But a lot of
the code has been rewritten. Some other operating systems use similar
blocking schemes; so this code may possibly work without much change. The
program deals with two binary file variables: |@!dvi_file| is the main input
file that we are printing, and |@!tfm_file| the current font metric file from
which character-width information is being read. Each of these has a name and
a counter, declared here; also a default name (system dependent, and so
declared previously). 
@y
The main input file is the \.{DVI} file. Logically, this is just a stream of
8-bit bytes, with no record or block structure. UNIX \PASCAL\ can happily
handle these, except that it treats each byte as a signed quantity, so we do
some fudging to make them unsigned. The program deals with two binary file
variables: |@!dvi_file| is the main input file that we are printing, and
|@!tfm_file| the current font metric file from which character-width
information is being read. Each of these has a name declared here. 
@z

%35 Binary file types
@x
  @!byte_block=packed array [0..block_length-1] of byte ;
  @!byte_file= packed file of byte_block;
@y
  @!byte_file= file of bite;
@z

%37 open_and_ask must pass the search path into open_binary
@x
      success := open_binary(f_f, name ) ;
@y
      success := open_binary(f_f, name, f_c ) ;
@z

%40
% P. King deleted all the VMS indx stuff, since all the files are (logically)
% read one character at a time. I have re-instated it because it is very
% useful when debugging.
%
@x
@d get_real(#) == read_real(# @& file, # @& indx)

@<Lowest...@>=
  function read_byte(var f_file: byte_file; var f_indx: integer) : byte;
  begin
    if eof(f_file) then
    warn('fallen off end of file' )
    else begin
      read_byte := f_file^[f_indx] ;
      incr(f_indx);
      if f_indx =block_length then begin
        get(f_file );
        f_indx:=0;
      end;
    end;
  end ;

@#
  procedure skip_bytes(var f_file: byte_file; var f_indx: integer; n:integer);
  {discard n bytes from |f_file|}
  begin
    if n < 0 then abort('skip_bytes called with negative number');
    f_indx := f_indx + n;
    while f_indx >= block_length do
    begin
      if eof(f_file) then
      warn('fallen off end of file' )
      else get(f_file );
      f_indx := f_indx - block_length ;
    end ;
  end;
    @.error: fallen off end of file@> @.Fatal: skip_bytes called...@>
@y
@d read_real == rr_read_real    {|read_real| is  Unix \Pascal\ procedure}
@d get_real(#) == read_real(# @& file, # @& indx)

@<Lowest...@>=
  function read_byte(var f_file: byte_file; var f_indx: integer) : byte;
  var x:bite;
  begin
    if eof(f_file) then begin
      warn('fallen off end of file' ) ;
      read_byte := 0 ;     { return some value }
    end
    else begin
      read(f_file,x);
      if x < 0 then read_byte := x + 256
      else read_byte := x ;
      incr(f_indx);
    end;
  end;

@#
  procedure skip_bytes(var f_file: byte_file; var f_indx: integer; n:integer);
  {discard n bytes from |f_file|}
  var k:integer;
      x:bite;
  begin
    if n < 0 then abort('skip_bytes called with negative number');
    f_indx := f_indx + n;
    for k:=1 to n do
    begin
      if eof(f_file) then
      warn('fallen off end of file' )
      else read(f_file, x );
    end ;
  end;
    @.error: fallen off end of file@> @.Fatal: skip_bytes called...@>
@z

