% PHILIPS. Change file for Philips printer
% NOTE the system change file must normally be inserted above this point.
% This file became obsolete when its printer was removed.
%


@x
*** Attach printer change file here ***
@y

This is a change file for a particular model of Philips, with a particular set
of resident fonts. It cannot be assumed that this file will work on other
Philipses, or on the same model with a different operating system. I have
tried to adapt this to \.{Crudetype} version 2, but I have no way to test it.

@<Const...@>= device_ID = 'Philips';

@ Where will the printed file go to?

@<Set init...@>=
  set_string( print_ex, '.PHI', ' ', 0);

@ The first batch of constants describes the printer's style of carriage
control. |fortran| means that the carriage control character gets put at the
start of the line, and it is here assumed that it must be inserted explicitly.
Note also that the program makes no attempt to check all these values for
consistency.

@<Carriage control constants@>=
  fortran = false ;
  list = false ;
  b_feed_absolute = false ;
  b_feed_by_string = false ;
  feed_absolute = true ;
  b_feed_scream = true ;
  b_space_absolute = true ;
  b_space_by_string =false ;
  space_absolute = true ;
  abs_is_incr = false ;
  w_l_does_c_r = false ;
  want_split = true ;
  is_header = false ; {each page needs a header}
  param_type = 'D' ;

@ This batch is concerned with distances and resolutions.

@<Const...@>=
  l_margin = 10 ;
  top_margin = 24 ;
  h_resolution = 72 ;         {h_steps per inch}
  v_resolution = 48 ;         {v_steps per inch}
  fixed_width = true ;        {printer's characters are fixed width}
  h_fudge = 1.4 ;
    {Trial and error. May need to be adjusted}
  v_fudge = 1 ;
  char_width = 6 ;
      {all printer characters are this width, in units of |h_step|. Normally,
          space_dist will be equal to this, but some printers are not normal!}
  gap_width = 2 ; {Intended minimum space between words}
  char_ht = 8 ;

@ Next, some constants for rule-setting.

@<Rule setting const...@>=
  rail_width = 6 ;  {Height and width of rule chars, in steps}
  rail_height  = 1 ;
  post_width = 1 ;
  post_height = 6 ;
  rail_types = 1 ;

@ @<Set rule characters@>=
  rail_chars[1] := codes[ 1, 95 ] ;
  post_char := codes[ 1, 124] ;

@ @<Pause constants...@>=
  do_pause = false ;
  pause_steps = 20 ;
  pause_ask = 'PAUSED. Type <return> to continue' ;

@ The next batch are concerned with the printers fonts.

@<Const...@>=
  min_font = 1 ;
  {smallest & largest number of printers resident fonts}
  max_font = 5 ;
  only_one_font = false ;
  can_dl_font = false ;
  min_dl_font = 0 ;
  max_dl_font = 0 ; {printers down-loadable fonts}
  max_codes = 8 ; {no. of known \TeX\ coding schemes}
  max_char = 127 ;  {max. no. of chars per \TeX\ font}
  max_plain = 4 ;  {Max number of a plain text font}

@ Finally, consider command strings. These are intended to set various
options. In the |start_stuff| below, each `#' will be translated into ASCII
escape. Taking these escape sequences in order, they: select portrait paper,
clear all tabs and margin, select initial font and pitch, set step size |1/6|
character pitch  (that was why we had to select a font), and set line spacing
at 48 per inch .

@<Set init...@>=
  set_string ( start_stuff,
    '#[22h#[3g#[2;2x#;#[4y#[48{                                           ', '#', 27 );
  set_string ( font_prefix,
    '#[                                                                   ',  '#', 27 );
  set_string ( font_suffix ,
    ';2x                                                                  ',  '#', 27 );
  {this sets the pitch to 12/inch}
  v_abs_prefix := font_prefix ;
  set_string ( v_abs_suffix,
    'd                                                                    ', '#', 27 );
  h_abs_prefix := font_prefix ;
  set_string ( h_abs_suffix,
    '`                                                                    ', '#', 27 );
  stop_stuff := blank ;
  page_top  := blank ;
  pause_after := blank ;

@* Character code data for the printer.

Here we actually put data into the |codes| array. In general, I have merely
replaced each character in the PLAIN.TEX coding schemes by the nearest equiv-
alent in ASCII, when any reasonable equivalent exists ; I have not tried to
tackle either AMSY or AMATHEX ; clearly there will be some scope for doing so.
First we give the scheme names, ( padded to |code_len|) then do stuff for each
name in turn. On the Philips ( as set up here) there are essentially 2 useful
fonts ; 2 is a Roman font, 5 is a simple math symbol font.

@<Assign char...@>=
  set_string( known_schemes[ 0 ] ,
    '                                                                     ' , ' ', 32 ) ;
  set_string( known_schemes[ 1 ] ,
    'TEX EXTENDED ASCII                                                   ' , ' ', 32 ) ;
  set_string( known_schemes[ 2 ] ,
    'TEX TYPEWRITER TEXT                                                  ' , ' ', 32 ) ;
  set_string( known_schemes[ 3 ] ,
    'TEX TEXT                                                             ' , ' ', 32 ) ;
  set_string( known_schemes[ 4 ] ,
    'TEX TEXT WITHOUT F-LIGATURES                                         ' , ' ', 32 ) ;
  set_string( known_schemes[ 5 ] ,
    'AEFMNOT ONLY                                                         ' , ' ', 32 ) ;
  set_string( known_schemes[ 6 ] ,
    'TEX MATH ITALIC                                                      ' , ' ', 32 ) ;
  set_string( known_schemes[ 7 ] ,
    'TEX MATH SYMBOLS                                                     ' , ' ', 32 ) ;
  set_string( known_schemes[ 8 ] ,
    'TEX MATH EXTENSION                                                   ' , ' ', 32 ) ;

@ Now do scheme 1 = EXTENDED ASCII

@<Assign char...@>=
  alphabet( 32, 95, 1, 2, 32) ;
  row(  ' o       &       a       b       LL      ~       e       p           ' ,1,0,5) ;
  row(  ' l       g       d       ^       #       {LQ|}   LT      LB          ' ,1,1,5) ;
  row(  ' Z       Z       Z       Z       Z       Z       `       \           ' ,1,2,5) ;
  row(  ' :       ;       ?       Z       LM      LN      LI      [F2or]      ' ,1,3,5) ;
  codes[1,127].IM_font :=  2 ;
  codes[1,127].IM_char :=  "Z" ;

@ Now do scheme 2 = TYPEWRITER. Unfortunately, \.TANGLE imposes a limit of 69
on the length of quoted strings. This causes difficulty because several multi-
character commands are too long for 8 of them to fit neatly into a string of
that length. So I use the Z command to ( effectively) split any complicated
|row_spec| into two.

@<Assign char...@>=
  alphabet( 32, 95, 2, 2, 32) ;
  codes[2, 127].IM_char := 34 ;
  row(  ' LG      LD      LQ      LL      LI      LP      LS      LU          ' ,2,0,5) ;
  row(  ' LF      LY      LW      ^       &       F2Q     !       ?           ' ,1,1,5) ;
  row(  ' i       j       `       Q       Z       Z       <U_>    <U.>        ' ,2,2,2) ;
  row(  ' ,       {LB_}   [aK3e]  [oK3e] {o/}    [LAK3LE] [LOK3LE] {LO/}      ' ,2,3,2) ;


@ The TEX TEXT scheme is nearly the same, so we start by copying it.

@<Assign char...@>=
  for in_i := 0 to 127 do codes [3, in_i] := codes [2, in_i] ;
  row(  ' Z       Z       Z       [ff]    [fi]    [fl]    [ffi]   [ffl]       ' ,3,1,2) ;
  row(  ' Z       Z       Z       Z       !       Z       ?       Z           ' ,3,7,2) ;
  row(  ' Z       Z       Z       Z       W       Z       Z       <U.>        ' ,3,11,2) ;
  row(  ' Z       Z       Z       -       [--]    W       ~       W           ' ,3,15,2) ;

@ Recently there has appeared a scheme, called TEX TEXT WITHOUT F-LIGATURES.

@<Assign char...@>=
  for in_i := 0 to 127 do codes [4, in_i] := codes [3, in_i] ;
  row(  ' {oI}    {u|}    Z       {^|}    {v|}    Q       !       ?           ' ,4,1,2) ;

@ and AEFMNOT ONLY  (for the Metafont logo).

@<Assign char...@>=
  row(  ' Z      LA       Z       Z       Z      LE      LF       Z           ' ,5,8,2) ;
  row(  ' Z       Z       Z       Z       Z      LM      LN      LO           ' ,5,9,2) ;
  row(  ' Z       Z       Z       Z      LT       Z       Z       Z           ' ,5,10,2) ;

@ Now the MATH ITALIC scheme. The Philips can try to do quite a lot of this.
As before, a lot of this is indistinguishable from the TEXT scheme, so we copy

@<Assign char...@>=
  for in_i := 0 to 10 do codes [6, in_i] := codes [2, in_i] ;
  for in_i := 48 to 122 do codes [6, in_i] := codes [2, in_i] ;
  {Next the lower-case Greek letters in rows 1..4}
  row(  ' Z       Z       Z       a       b       g       d       e           ' ,6,1,5) ;
  row(  ' z       h       q       j       k       l       m       n           ' ,6,2,5) ;
  row(  ' c       p       r       s       t       n       f       x           ' ,6,3,5) ;
  row(  ' y       w       e       q       w       r       z       f           ' ,6,4,5) ;
  row(  ' [:-]    [:-]    [-;]    [-;]    Z       Z       Z       Z           ' ,6,5,5) ;
  row(  ' Z       Z       .       ,       Z       /       Z       *           ' ,6,7,2) ;
  row(  ' Z       Z       Z       i       j       p       <UF5;>  Z           ' ,6,15,2) ;

@ MATH SYMBOLS are messy, and no doubt the results will look unpleasant.

@<Assign char...@>=
  alphabet( 65, 26, 7, 1, 65) ;
  row(  ' -       .       {\/}    *       {-:}    Z       {+_}    <U_+>       ' ,7,0,2) ;
  row(  ' {LO+}   {LO-}   {LOx}   {LO/}   LO      LO       o       o          ' ,7,1,2) ;
  row(  ' Z       {=_}    Z       Z       {L<_}   {L>_}   {L<_}   {L>_}       ' ,7,2,2) ;
  row(  ' ~       <U~~>   Z       Z       [L<L<]  [L>L>]  L<      L>          ' ,7,3,2) ;
  row(  ' [{L<-}-]        [{L>-}-]        {|^}            {|v}    Z Z Z Z     ' ,7,4,2) ;
  row(  ' Z Z Z Z         [{L<-}{-L>}]    /               \       {~_}        ' ,7,4,2) ;
  row(  ' [{L<=}=]        [{L>=}=]        Z               Z       Z Z Z Z     ' ,7,5,2) ;
  row(  ' Z Z Z Z         [{L<=}{=L>}]    Z               Z       Z           ' ,7,5,2) ;
  row(  ' Q               [oo]            {L(-}           {-L)}   Z Z Z Z     ' ,7,6,2) ;
  row(  ' Z Z Z Z         [{/_}{_\}]      <U[__][\/]>     /       Q           ' ,7,6,2) ;
  row(  ' [{\-}{-/}]      <U_[{-_}|]>     ~       {0/}    LR LT   <U_|>   {|_}' ,7,7,2) ;
  row(  ' Z       Z       Z       LU      Z       {LU+}   &       [or]        ' ,7,11,2) ;
  row(  ' [{|-}-]         [-{-|}]         Z Z Z   Z       L{      L}          ' ,7,12,2) ;
  row(  ' L<      L>      |       [||]    {^|v}   {^|v}   \       Z           ' ,7,13,2) ;
  row(  ' <Z{-v/}>        [{I_}{_I}]      <U[__][\/]>     Z       Z Z Z Z     ' ,7,14,2) ;

@<Set rule characters@>

@z
