% NOSVE.CH . LINEPRINTER Change file for Crudetype
% NOS/VE Version 1.0 changed by Matthias Rawohl Sept./Okt. 1987
% Altered by RMD to fit Crudetype version 1 , May 1988.
% Altered by RMD to fit Crudetype version 2, Oct 1988.
%
%
%  COPYRIGHT ( C ) G-H Knauf, 1988.
%
%  Permission is given to any person to make and distribute copies of this
%  software, subject to the following conditions:
%
%  1. All copies of the software must carry an exact copy of this notice.
%
%  2. This software is distributed free of charge, "AS IS" with absolutely no
%  guarantee of performance. Any persons receiving or using this software must
%  do so entirely at their own risk. Neither the authors nor their institutions
%  accept any liability for defects of this software, or for any consequential
%  loss or damage however caused.
%
%  3. Any person who changes this software must clearly mark it as modified and
%  add a note describing the changes made.
%
%

% [0]: WEAVE: New title
@x
\pageno=\contentspagenumber \advance\pageno by 1
@y
\pageno=\contentspagenumber \advance\pageno by 1
\def\title{Crudetype for {\mc NOS-VE}}
@z

% [4]: 
@x
@d banner=='This is Crudetype, Version 2, copyright, experimental'
{printed when the program starts}

@p program crudetype
@y
The identifier |value| is a reserved word in NOS/VE Pascal, so we have to
change this into the word |values|.
@d value ==values
@d banner=='This is Crudetype, NOS/VE Version 2.1, modified by MR'
{printed when the program starts}

@p program crudetype@&_@&module
@z

% [6]: 
@x
  @<Read \.{DVI} preamble @>
@y
  @<Read \.{DVI} preamble @>
  page( printfile) ;
@z

% [13 ]
@x
  fortran = false ;
@y
  fortran = true ;
@z

% [14]
@x
@<Lowest...@>=
  {Declare |parse_file|}
@y
@<Lowest...@>=
  procedure  parse_file( name: var_string; var dir, nam, ex: var_string) ;
  var p,q,r,s: s_ptr ;
  begin
    dir := blank; nam := blank; ex := blank;
    s := name.len ;
    if ( s>0) then begin
      p := s_search( name, '.', -s);
      if ( p>0) then substring( dir, name, 1, p) ;
      r := s_search( name, '_', -s);
      if ( r>p) then substring( ex, name, r, s-r+1)
      else r := s +1 ;
      substring( nam, name, p+1, r-p-1) ;
    end;
  end;
@z

% [17]
@x
@ As an initial attempt at downloading, we declare a |@!raster_file|.

@<Files @>= term_in, term_out, printfile, dvi_file, tfm_file, raster_file
@y
@ Instead of reading a command line, NOS-VE Pascal declares its parameters in
the program header. This is an excellent system, except there is apparently no
way to specify defaults. As an initial attempt at downloading, we declare a
|@!raster_file|.

@<Files @>= term_in, term_out, printfile, dvi_file, tfm_file, raster_file,
  quiet, run_on, squash, first_page, count_pages, magnify
@z

% [18]
@x
@d block_length = 512
@d same_dir == false

@<Set init...@>=
  set_string( dvi_def, '.DVI' , ' ', 0) ;
  set_string( tfm_def, 'TEX$FONTS:.TFM', ' ', 0) ;
  set_string( raster_def, 'TEX$GF:.&DGF', ' ', 0) ;
  set_string( print_ex, '.PRI', ' ', 0);
@y
@d block_length = 16
@d same_dir == false

@<Set init...@>=
  set_string( dvi_def, '_DVI' , ' ', 0) ;
  set_string( tfm_def, ':$LIB.PUBLIC.TEX.TFM._TFM', ' ', 0) ;
  set_string( raster_def, '$LIB.PUBLIC.TEX.GFDIR._&DGF', ' ', 0) ;
  set_string( print_ex, '_LST', ' ', 0);
@z

% [19]
@x
@<Lowest...@>=
  {Declare |open_binary|}
@y

In NOS/VE you have two choices: you may use the NOS/VE Pascal extension
|bindingtype| or the Cybil routines developed by Norbert Schwarz for his \TeX\
implementation for NOS/VE. Norbert's routines are smarter if a TFM file is
missing.

RMD:  I hope to distribute N.Schwarz's routines in the file NOSVEBIND.CYB.
Dont ask me how these work, I have no idea. The next lot of macro definitions
is rather messy; I have tried to clean them up. To switch from Cybil binding
to (NOS) Pascal binding, swop the curly brackets in the next two definitions.

@d PASCL ==@{
@d CYBIL ==@}

@d close_binary(#)==
    close_read (#)

@<Lowest...@>=
  @{ CYBIL

@#
  procedure close_read(var f_f:byte_file); external;

@#
  function open_binary (
    var f_f: byte_file; name: var_string ): boolean;
  type string_type=string(64);
  var s: integer;
  long_name_of_file, effectiv_file_name : string_type;
  procedure open_read(
    var f_f:byte_file; given_name:string_type;
    is_text_file:boolean;
    var effectiv_file_name: string_type;
    var open_error:integer);
  external;
  begin
    close_binary(f_f );
      {in case the file was left open}
    long_name_of_file := substr( name.data,1,string_length);
    open_read(f_f,long_name_of_file, false,effectiv_file_name,s);
    if s <> 0 then open_binary := false
    else begin
      reset(f_f );
      open_binary := true ;
    end;
  end;

@#
  PASCL PASCL

@#
  procedure close_read(var f_f:byte_file); begin  unbind(f_f) end;

@#
  function open_binary (
    var f_f: byte_file; name: var_string; ): boolean;
  var file_bind : @=bindingtype@> ;   { a predefined type in NOS/VE-Pascal}
  begin
    file_bind:=binding(f_f);
    if file_bind.bound then unbind(f_f);
      {in case the file was left open}
    file_bind.name := substr( name.data,1,string_length);
    bind(f_f,file_bind);
    file_bind:= binding(f_f);
    open_binary := file_bind.bound;
    if file_bind.bound  then reset(f_f);
  end;

@#
  CYBIL @}
@z

% [23]
@x
@<Determine operating parameters@>=
  command := blank ; get_command ;
  dvi_name := blank ;
  if got_cl then parse_command
  else display_ln(banner, ' --- ', device_ID) ;
  @<Get \.{DVI} file name and open it@> ;
  @<Open |printfile|@>;
  if not got_cl then @<Ask the user@> ;
@y
NOS/VE uses a quite different mechanism; the parameters are passed in as
arguments to the |PROGRAM| statement.

@<Determine operating parameters@>=
  reset( dvi_file) ; dvi_indx := 0 ;
  rewrite(printfile) ;
@z
