/*
 *	This program is Copyright (C) 1987 by the Board of Trustees of the
 *	University of Illinois, and by the author Dirk Grunwald.
 *
 *	This program may be freely copied, as long as this copyright
 *	message remaines affixed. It may not be sold, altough it may
 *	be distributed with other software which is sold. If the
 *	software is distributed, the source code must be made available.
 *
 *	No warrenty, expressed or implied, is given with this software.
 *	It is presented in the hope that it will prove useful.
 */

/*
 *	Include the following from the CTex distribution
 */

#include <stdio.h>

#include "types.h"
#include "font.h"

/*
 *	We use the following flags to keep track of shrunk fonts
 */

#define	GF_SHRUNK	GF_USR0

#define	GLYPH_SHRUNK(g) ((g) -> g_flags & GF_SHRUNK)

#define SHRUNK_GLYPH_BYTES_WIDE(g) ((((g) -> g_width + 15) >> 4) * 2)

typedef struct font DviFont;
typedef struct glyph DviGlyph;

#define MAX_GLYPH	128
#define MAX_FONTFAMILY	128

#define DEFAULT_DPI	300
#define DEFAULT_HHMARGIN	DEFAULT_DPI
#define DEFAULT_VVMARGIN	DEFAULT_DPI

#define DEFAULT_BLACKNESS 3


struct fontinfo {
	struct font *f;		/* the font */
	i32 pspace;		/* boundary between `small & `large spaces
				   (for positive horizontal motion) */
	i32 nspace;		/* -4 * pspace, for negative motion */
	i32 vspace;		/* 5 * pspace, for vertical motion */
	int family;		/* Imagen family number (we pick one) */
};

typedef struct fontinfo DviFontInfo;

extern int	dviHH;		/* current horizontal position, in DEVs */
extern int	dviVV;		/* current vertical position, in DEVs */
extern int	dviHHMargin;
extern int	dviVVMargin;
extern int	dviDPI;
extern int	dviTallestPage;
extern int	dviWidestPage;
extern int	dviTotalPages;
extern int	dviCurrentPage;
extern int	dviMaxDrift;
extern char 	*dviPrintEngine;
extern int      dviBlackness;

extern DviFontInfo *dviCurrentFont;
extern FILE	*dviFile;				/* user's file */
extern char	*ProgName;

extern void dviInit();
extern void dviPreparePage( /* int */ );
extern struct glyph *dviShrinkGlyph();

void applicationLoadGlyph( /* charCode, glyph */ );
void applicationPutChar( /* hh, vv, charCode */ );
DviFont *applicationNewFont( /* font structure */);
void applicationResetFont(/* font info, key */);
void applicationSetRule( /* hh, vv, height, width  : long*/ );
void applicationDoSpecial();
