#ifndef lint
static char rcsid[] = "$Header$";
#endif

/*
 * Show font things.
 */

#include <stdio.h>
#include "../h/types.h"
#include "../h/conv.h"
#include "../h/font.h"

char *ProgName;
extern int errno;
extern char *optarg;
extern int optind;

#define	PTTOSP(x) ((x) << 16)	/* points to scaled points */

int	dvimag;
int	dvidsz;
char	*devspec;
int	rotation;

main(argc, argv)
	register int argc;
	register char **argv;
{
	register int c;
	int dpi, globalmag;

	ProgName = *argv;
	dvimag = PTTOSP(10);
	dvidsz = PTTOSP(10);
	globalmag = 1000;
	dpi = 200;
	rotation = ROT_NORM;
	while ((c = getopt(argc, argv, "D:d:m:g:r:s:")) != EOF) {
		switch (c) {

		case 'D':
			dpi = atoi(optarg);
			break;

		case 'd':
			dvidsz = atoi(optarg);
			break;

		case 'm':
			dvimag = atoi(optarg);
			break;

		case 'g':
			globalmag = atoi(optarg);
			break;

		case 'r':
			rotation = makerot(optarg);
			break;

		case 's':
			devspec = optarg;
			break;

		case '?':
usage:
			error(1, 0, "\
usage: %s [-Ddpi] [-mdvimag] [-ddesignsz] [-ggloblmag] [-sdevspec] font ...",
				ProgName);
			/* NOTREACHED */

		default:
			panic("case %d", c);
			/* NOTREACHED */
		}
	}
	if (optind >= argc)
		goto usage;
	SetConversion(dpi, 1000, 25400000, 473628672, globalmag);
	for (c = optind; c < argc; c++)
		show(argv[c]);
	exit(0);
}

makerot(s)
	char *s;
{

	switch (*s) {

	case 'n':
		return (ROT_NORM);

	case 'l':
		return (ROT_LEFT);

	case 'd':
		return (ROT_DOWN);

	case 'r':
		return (ROT_RIGHT);

	case '0': case '1': case '2': case '3':
		return (*s - '0');

	default:
		error(1, 0, "\
valid rotations are `n'ormal, `l'eft, `right', and `d'own");
		/* NOTREACHED */
	}
}

show(s)
	char *s;
{
	register struct font *f;
	register struct glyph *g;
	register int i;
	char *fname;

	f = GetFont(s, dvimag, dvidsz, devspec, &fname);
	if (f == NULL) {
		GripeCannotGetFont(s, dvimag, dvidsz, devspec, fname);
		exit(1);
	}
	printf("[%s]\n", fname);
	for (i = f->f_lowch; i < f->f_highch; i++) {
		g = GLYPH(f, i);
		if (!GVALID(g))
			continue;
		printf("glyph ");
		if (i >= ' ' && i < 127)
			printf("'%c'", i);
		else
			printf("%3d", i);
		printf(":\n\
\theight = %5d width = %5d yorigin = %5d xorigin = %5d\n\
\tTFM width = %6.2fpt (%d pixels)\n",
			g->g_height, g->g_width, g->g_yorigin, g->g_xorigin,
			g->g_tfmwidth / 65536.0, fromSP(g->g_tfmwidth));
		if (!HASRASTER(g))
			continue;
		showraster(g, RASTER(g, f, rotation));
	}
}

showraster(g, p)
	struct glyph *g;
	register char *p;
{
	register int c, t, i, j, k, w;

	w = g->g_width;
	for (i = g->g_height; --i >= 0;) {
		k = 7;
		t = 0;
		for (j = w; --j >= 0;) {
			if (++k == 8)
				k = 0, c = *p++;
			if (c & 0x80) {
				while (--t >= 0)
					(void) putchar(' ');
				t = 0;
				(void) putchar('*');
			} else
				t++;
			c <<= 1;
		}
		(void) putchar('\n');
	}
	(void) putchar('\n');
}
