#! /bin/sh
#
# makesubdir - make the TeX fonts reside in a subdirectory style system
#
# usage:
#	cd /usr/lib/tex/fonts
#	sh makesubdir.sh

if [ -f SUBDIR ]; then
	echo "$0: SUBDIR file already exists.
Are you sure you need to do this?
(If so, remove the SUBDIR file and try again.)" 1>&2
	exit 1
fi

>SUBDIR

for font in *.*pxl; do
	dir=`echo $font | sed -e 's/\..*//'`
	if [ ! -d $dir ]; then
		if [ -f $dir ]; then
echo "$0: \`$dir' exists as a file (renamed to $dir.old)" 1>&2
			if mv -i $dir $dir.old; then
				echo "$0: aborting" 1>&2
			fi
		fi
		mkdir $dir
	fi
	mv -i $font $dir/$font
done
