#! /bin/sh
#
# print a dvi file on the imagen

flags=
cflag=-c
# put default offset here: -X3 -Y-4 moves output .3in left, .4in up
# from the usual 1" margin in both directions.
offset=

# eat arguments

while [ $# -gt 0 ]
do
	case "$1" in
	-c)
		cflag=;;
	-d|-m|-r|-X|-Y)
		flags="$flags $1 $2"; shift;;
	-)
		break;;
	-*)
		flags="$flags $1";;
	*)
		break;;
	esac
	shift
done

if [ $# != 1 ]; then
	echo "Usage: $0 [-c] [-l] [-s] [-m mag] [-d drift] [-r resol] filename" 2>&1
	exit 1
fi

dvifile=$1
if [ x$dvifile = x- ]; then
	dvifile=
else
	# people insist that iptex should look for file.dvi first:
	if [ -r $dvifile.dvi ]; then
		dvifile=$dvifile.dvi
	else
		if [ ! -r $dvifile ]; then
			echo "$0: cannot find $1 or $1.dvi" 1>&2
			exit 1
		fi
	fi
fi

tmpfile=${TMPDIR-/tmp}/iptex$$
if [ "$cflag" = -c ]; then
	trap 'rm -f $tmpfile' 0 1 2 3 15
	if imagen1 $offset $flags $dvifile > $tmpfile; then
		ipr $tmpfile
	else
		echo "$0: output not spooled (use -c to force)" 1>&2
		exit 1
	fi
else
	imagen1 $offset $flags $dvifile | ipr
fi
