#! /bin/sh
#
# print a dvi file on the versatec
#
# NOTE: sense of -h is inverted (-h => no horizontal printing)

flags=
hflag=-h
q=
v=
title=

# eat arguments

while [ $# -gt 0 ]
do
	case "$1" in
	-m)
		shift
		flags="$flags -m $1";;
	-h)
		hflag=;;
	-q)
		q=q;;
	-v)
		v=v;;
	-t)
		echo tape interface not yet implemented 2>&1;;
	-T)
		shift
		title="$1";;
	-T*)
		title="$1";;
	-*)
		flags="$flags $1";;
	*)
		break
	esac
	shift
done

if [ $# != 1 ]; then
	echo "Usage: $0 [-q] [-v] [-h] [-s] [-m mag] [-d drift] [-T title] filename" 2>&1
	exit 1
fi

if [ x"$title" = x ]; then
	title="$*"
fi

# pass 2 only?
if [ x$v = xv ]; then
	exec spool -d versatec -verser2 -t "$title" $*
fi

dvifile=$1

if [ ! -r $dvifile ]; then
	dvifile=$1.dvi
	if [ ! -r $dvifile ]; then
		echo "$0: cannot find $1 or $1.dvi" 2>&1
		exit 1
	fi
fi

# pass 1 only?
if [ x$q = xq ]; then
	exec verser1 $hflag $flags $dvifile
fi

verser1 $hflag $flags $dvifile | spool -d versatec -verser2 -t "$title"
