
#include <stdio.h>
#ifdef	sys5
#include <sys/termio.h>
#else
#include <sgtty.h>
#endif
#include <signal.h>
#include <sys/jioctl.h>
#include <setjmp.h>
#include "dmdcodes.h"

static jmp_buf jenv;
int jerq;
static char prooftty[] = "/dev/tty";
#ifdef	sys5
static struct termio sttybuf, sttysave;
#else
static struct sgttyb modes, savetty;
#endif
static int termraw;

void
sighup()
{
	putchar(DMD_EXIT);
	exit(1);
}

dmdstart()
{
	char command[256];
	int ismpx;

	signal(SIGHUP, sighup);

	if ((jerq = open(prooftty, 2)) < 0) {
		error(1, 0, prooftty);
		exit(1);
	}
	if (ioctl(jerq, JMPX, 0) == -1)
		ismpx = 0;
	else
		ismpx = 1;

#ifdef sys5
	ioctl(jerq, TCGETA, &sttysave);
	sttybuf.c_iflag = IGNBRK;
	sttybuf.c_cflag = (sttysave.c_cflag & (CBAUD | CLOCAL)) | CS8 | CREAD;
	sttybuf.c_cc[VMIN] = 1;
	(void)ioctl(jerq, TCSETAW, &sttybuf);
#else
	ioctl(jerq, TIOCGETP, &modes);
	savetty = modes;
	modes.sg_flags |= RAW;
	modes.sg_flags &= ~ECHO;
	ioctl(jerq, TIOCSETP, &modes);
#endif
	termraw++;
#define	Proofm	"/usr/local/lib/dvidmd.m"
#define	Proofj	"/usr/local/lib/dvidmd.j"
#define	X32ld	"32ld"
	if (!isatty(1) || !verify()) {
		sprintf(command, "%s %s < %s > %s", X32ld,
			ismpx ? Proofm : Proofj, prooftty, prooftty);
		if (system(command) != 0)
			error(1, 0, "%s failed", X32ld);
		if (!verify())
			error(1, 0, "could not sync display");
	}
}

void
alarmcatch(sig)
{
	longjmp(jenv, 1);
}

verify()
{
	char c;

	signal(SIGALRM, alarmcatch);
	c = DMD_TYPESET;
	write(jerq, &c, 1);
	if (setjmp(jenv))
		return(0);
	alarm(2);
	read(jerq, &c, 1);
	alarm(0);
	return (c == DMD_ACK);
}

pagecmd()
{
	int i, c;

	switch (c = inkbd()) {
	case DMD_EXIT:
		exit(0);
	case DMD_PAGE:
		i = inkbd();
		if (i > 127)
			i -= 256;
		return(i);
	default:
		error(1, 0, "bad pagecmd response 0%o", c);
	}
	/*NOTREACHED*/
}

inkbd()
{
	char c;
	register i;

	fflush(stdout);
	if (read(jerq, &c, 1) != 1)
		c = 4;		/* ^D, looks like EOF */
	i = c & 0377;
	return(i);
}

exit(n)
{
	fflush(stdout);
	fflush(stderr);
	if (termraw) {
#ifdef	sys5
		(void)ioctl(jerq, TCSETAW, &sttysave);
#else
		ioctl(jerq, TIOCSETP, &savetty);
#endif
	}
	_exit(n);
}

#ifndef lint
static char rcsid[] = "$Header: error.c,v 2.5 86/11/08 17:09:39 chris Exp $";
#endif

/*
 * Print an error message with an optional system error number, and
 * optionally quit.
 *
 * THIS CODE IS SYSTEM DEPENDENT UNLESS varargs WORKS WITH vprintf
 * OR _doprnt.  It should work properly under System V using vprintf.
 * (If you have vprintf, define HAVE_VPRINTF.)
 */

#include <varargs.h>

#ifdef lint

/* VARARGS3 ARGSUSED */
error(quit, e, fmt) int quit, e; char *fmt; {;}

/* VARARGS1 ARGSUSED */
panic(fmt) char *fmt; { exit(1); /* NOTREACHED */ }

#else lint

extern char *ProgName;
extern int errno;
extern char *sys_errlist[];
extern int sys_nerr;

/*
 * We can be civlised by calling legitimate routines.
 */
error(va_alist)
	va_dcl
{
	va_list l;
	int quit, e;
	char *fmt;

	if (termraw)
		putchar(DMD_ASCII);
	(void) fflush(stdout);	/* sync error messages */
	(void) fprintf(stderr, "%s: ", ProgName);
	va_start(l);
	/* pick up the constant arguments: quit, errno, printf format */
	quit = va_arg(l, int);
	e = va_arg(l, int);
	if (e < 0)
		e = errno;
	fmt = va_arg(l, char *);
#if defined(sys5) || defined(HAVE_VPRINTF)
	(void) vfprintf(stderr, fmt, l);
#else
	_doprnt(fmt, l, stderr);
#endif
	va_end(l);
	if (e) {
		if (e < sys_nerr)
			(void) fprintf(stderr, ": %s", sys_errlist[e]);
		else
			(void) fprintf(stderr, ": Unknown error code %d", e);
	}
	(void) putc('\n', stderr);
	(void) fflush(stderr);	/* just in case */
	if (termraw)
		putchar(0);
	if (quit) {
		if (termraw)
			putchar(DMD_TERM);
		exit(quit);
	}
}

panic(va_alist)
	va_dcl
{
	va_list l;
	char *fmt;

	if (termraw)
		putchar(DMD_TERM);
	(void) fflush(stdout);
	(void) fprintf(stderr, "%s: panic: ", ProgName);
	va_start(l);
	/* pick up the constant argument: printf format */
	fmt = va_arg(l, char *);
#if defined(sys5) || defined(HAVE_VPRINTF)
	(void) vfprintf(stderr, fmt, l);
#else
	_doprnt(fmt, l, stderr);
#endif
	va_end(l);
	(void) putc('\n', stderr);
	(void) fflush(stderr);
	abort();
}

#endif /* lint */
