/* Fortran filter */
#ifndef lint
static char *rcs = "$Header: rf.c,v 1.1 88/01/15 13:05:24 simpson Rel $";
#endif
/*
$Log:	rf.c,v $
 * Revision 1.1  88/01/15  13:05:24  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  18:31:19  simpson
 * beta test
 * 
*/
#include <stdio.h>
#include <signal.h>
#include <local/qms.h>
#include <local/standard.h>
#include <local/profile.h>
#include "fontnode.h"

char	*Whoami;	/* argv[0] */
char	Buffer[5001];
int	LineNum = 1;
int	Length, Width;
int	Indent = 0;
int	PortraitFont = 1204;
int	LandscapeFont = 1217;
struct sigvec	SigStruct;
extern char	*User;
extern char	*Host;
extern Boolean	Accounting;
extern int	NumPages;
extern FILE	*Accting;

main(argc, argv)
int	argc;
char	*argv[];
{
    extern int	    optind;
    extern char	    *optarg;
    PROFILE_VALUE   *v, *getbindingvalue();
    char	    *gets();
    int		    c, i, callcleanup();
    void	    sanestate(), cleanup();

    Whoami = argv[0];
    while ((c = getopt(argc, argv, "x:y:n:h:w:l:i:")) != EOF)
	switch (c) {
	case 'x':
	case 'y':
	    break;
	case 'i':
	    Indent = atoi(optarg);
	    break;
	case 'l':
	    Length = atoi(optarg);
	    break;
	case 'w':
	    Width = atoi(optarg);
	    break;
	case 'n':
	    User = optarg;
	    break;
	case 'h':
	    Host = optarg;
	    break;
	case '?':		    /* This should not happen */
	    exit(2);		    /* Page intentionally left blank */
	}			    /* Void where prohibited */
    if (optind < argc) {
	Accounting = TRUE;
	if (!(Accting = fopen(argv[optind], "a"))) {
	    fprintf(stderr, "%s: cannot open accounting file %s\r\n", Whoami,
	    argv[optind]);
	    Accounting = FALSE;
	}
    }
    if (Width > 80) {
	if ((v = getbindingvalue("landscapefont")) && v->class ==
	PROFILE_INTEGER)
	    LandscapeFont = v->value.i;
    } else if ((v = getbindingvalue("portraitfont")) && v->class ==
    PROFILE_INTEGER)
	PortraitFont = v->value.i;
    SigStruct.sv_handler = callcleanup;
    SigStruct.sv_mask = 0;
    SigStruct.sv_onstack = 0;
    (void)sigvec(SIGINT, &SigStruct, (struct sigvec *)NULL);
    fputs(QUICON, stdout);
    fputs(Width > 80 ? LANDSCAPE : PORTRAIT, stdout);
    printf("%s00000", SYNTAX);
    printf("%s%05d%05d", INITMARGVERT, (int)(.22 * 1000), Width > 80 ?
    (int)(8.5 * 1000) : 11 * 1000);
    printf("%s%05d%05d", INITMARGHORZ, (int)(.325 * 1000), Width > 80 ? 11 *
    1000 : (int)(8.5 * 1000));
    printf("%s%04d", LINESPACING, Width > 80 ? 8 * 100 : (int)(6.02 * 100));
    printf("%s%d%s", DEFFONT, Width > 80 ? LandscapeFont : PortraitFont,
    ENDCMD);
    if (Width > 80) {
	if ((v = getbindingvalue("landscapepitch")) && (v->class ==
	PROFILE_INTEGER || v->class == PROFILE_FLOAT))
	    if (v->class == PROFILE_INTEGER)
	        printf("%s%04d", CHARSPACING, v->value.i * 100);
	    else
		printf("%s%04d", CHARSPACING, (int)(v->value.f * 100));
    } else
	if ((v = getbindingvalue("portraitpitch")) && (v->class ==
	PROFILE_INTEGER || v->class == PROFILE_FLOAT))
	    if (v->class == PROFILE_INTEGER)
		printf("%s%04d", CHARSPACING, v->value.i * 100);
	    else
		printf("%s%04d", CHARSPACING, (int)(v->value.f * 100));
    fputs(FREEOFF, stdout);
    fputs(QUICOFF, stdout);
    while (gets(Buffer))
	if (strlen(Buffer) > 0) {
	    switch (Buffer[0]) {
	    case '+':
		(void)putchar('\r');
		break;
	    case '1':
		(void)putchar('\f');
		NumPages++, LineNum = 1;
		break;
	    case '0':
		fputs("\r\n", stdout);
		if (++LineNum > Length) {
		    LineNum -= Length;
		    NumPages++;
		}
	    default:
		fputs("\r\n", stdout);
		if (++LineNum > Length) {
		    LineNum -= Length;
		    NumPages++;
		}
		break;
	    }
	    if (Indent > 0)
		for (i = 0; i < Indent; i++)
		    putchar(' ');
	    fputs(&Buffer[1], stdout);
	} else {
	    fputs("\r\n", stdout);
	    if (++LineNum > Length) {
		LineNum -= Length;
		NumPages++;
	    }
	}
    (void)sigblock(SIGINT);
    fputs(QUICON, stdout);
    fputs(FORMFEED, stdout), NumPages++;
    cleanup((struct FontNode *)NULL, SUCCEED);
}

callcleanup()
{
    void	cleanup();

    fputs(QUICON, stdout);
    fputs(FORMFEED, stdout), NumPages++;
    cleanup((struct FontNode *)NULL, SUCCEED);
}
