#ifndef lint
static char *rcs = "$Header: qms.c,v 1.1 88/01/15 13:05:14 simpson Rel $";
#endif
/*
$Log:	qms.c,v $
 * Revision 1.1  88/01/15  13:05:14  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  18:31:16  simpson
 * beta test
 * 
*/

/* QMS printer routines */

#include <stdio.h>
#include <local/qms.h>
#include "fontnode.h"


/* Sets up the printer to portrait mode in a sane state.  After the
 * completion of a job, the banner page of the next job may be printed
 * without running the "of" filter so we must setup the printer as the "of"
 * filter does.  Also, switch the tray offset in this routine.  This
 * routine is called before every filter exits.
 */
void sanestate(portfont)
int	portfont;
{
    fputs(QUICON, stdout);
    fputs(PORTRAIT, stdout);
    printf("%s00000", SYNTAX);
    printf("%sXTX1", INITIALIZE);
    printf("%s0000011000", INITMARGVERT);
    printf("%s0025008500", INITMARGHORZ);
    printf("%s%04d", LINESPACING, (int)(6.02 * 100));
    printf("%s%d%s", DEFFONT, portfont, ENDCMD);
    fputs(FREEOFF, stdout);
}

/* Trys to make room for numblocks.  Return boolean if successful. */
Boolean makeroom(head, maxblocks, curramblocks, curromblocks, numblocks)
struct FontNode	*head;
int		maxblocks;
int		*curramblocks;	/* This one changes so pass by reference */
int		curromblocks;
int		numblocks;
{
    /* This is the number of blocks we need to free */
    int			freeblocks = numblocks - (maxblocks - *curramblocks
			- curromblocks);
    struct FontNode	*p;

    for (p = head; p && freeblocks > 0; p = p->next)
    	if (p->flags & RAM && p->flags & LOADED) { /* do ! delete rom fonts */
	    printf("%s%d%c%s", DOWNLOAD, p->qmsnumber, p->flags & PORT ? 'P'
	    : 'L', ENDCMD);
	    p->flags &= ~LOADED;
	    freeblocks -= p->blocksize;
	    *curramblocks -= p->blocksize;
	}
    if (freeblocks > 0)
    	return FALSE;
    else
    	return TRUE;
}
