#ifndef lint
static char *rcs = "$Header: list.c,v 1.1 88/01/15 13:04:23 simpson Rel $";
#endif
/*
$Log:	list.c,v $
 * Revision 1.1  88/01/15  13:04:23  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  18:31:00  simpson
 * beta test
 * 
*/

/* Routines for processing and returning information on font lists */

#include <stdio.h>
#include <local/qms.h>
#include "fontnode.h"


/* Returns a pointer to a font on the font list; NULL if not found */
struct FontNode *getfontnode(head, fontnumber, orientation)
struct FontNode	*head;
int 		fontnumber;
int 		orientation;
{
    struct FontNode	*p;

    for (p = head; p; p = p->next)
    	if (p->qmsnumber == fontnumber && (p->flags & PORT ? 'P' : 'L') ==
	orientation)
	    return p;
    return NULL;
}

/* Puts the node passed as an argument on the end of the list.  Fonts are 
 * deleted from the beginning of the list when making room in font memory
 * so put the current font on the end of the list.
 */
void endoflist(head, thenode)
struct FontNode	**head;
struct FontNode *thenode;
{
    struct FontNode	*prev = NULL, *p;

    if (!head || !thenode)
    	return;
    /* First delete it from the FontList */
    for (p = *head; p; prev = p, p = p->next)
    	if (p == thenode)
	    if (p == *head)
	    	*head = (*head)->next;
    	    else
	        prev->next = p->next;
    thenode->next = NULL;
    /* Tack it on the end */
    if (!*head)
        *head = thenode;
    else {
	for (p = *head; p->next; p = p->next)
	    ;
	p->next = thenode;
    }
}

/* Takes a list of fonts that are already loaded in the printer (i.e., the
 * two lists returned by qmsfnt()) and returns a single list of FontNode's.
 * We manipulate singly linked lists of FontNode's in each driver, not the
 * lists returned by qmsfnt().
 */
struct FontNode *createfontlist(fntinfo)
struct qmsfnt	*fntinfo;
{
    struct fontnode	*p;
    struct FontNode	*list = NULL, *new;
    char		*malloc();

    if (!fntinfo)
    	return NULL;
    for (p = fntinfo->rom; p; p = p->next) {
	bzero((char *)(new = (struct FontNode *)malloc(
	(unsigned)sizeof(struct FontNode))), sizeof(struct FontNode));
	new->next = list, list = new;	/* Put on front of list */
	list->flags = LOADED | PRELOADED;
	if (p->orientation == 'P')
	    list->flags |= PORT;
	list->qmsnumber = p->number;
	list->blocksize = CEILING(p->bytes / 1024.0);
    }
    for (p = fntinfo->ram; p; p = p->next) {
	bzero((char *)(new = (struct FontNode *)malloc(
	(unsigned)sizeof(struct FontNode))), sizeof(struct FontNode));
	new->next = list, list = new;
	list->flags = RAM | LOADED | PRELOADED;
	if (p->orientation == 'P')
	    list->flags |= PORT;
	list->qmsnumber = p->number;
	list->blocksize = CEILING(p->bytes / 1024);
    }
    return list;
}
