#ifndef lint
static char	*rcs = "$Header: io.c,v 1.1 88/01/15 13:04:20 simpson Rel $";
#endif
/*
$Log:	io.c,v $
 * Revision 1.1  88/01/15  13:04:20  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  18:30:59  simpson
 * beta test
 * 
*/
/* General I/O routines */

#include <stdio.h>
#include <local/standard.h>
#include <ctype.h>

/* Reads n bytes from file f into an unsigned long. The cgetc() routine is used
 * so an appropriate error routine will need to be selected. */
unsigned long uinteger(f, bytes)
FILE	*f;
int	bytes;
{
    int     i;
    long    n = 0;

    for (i = 0; i < bytes; i++)
	n = n << 8 | cgetc(f);
    return n;
}

/* Reads n bytes from file f into a long. The cgetc() routine is used so
 * an appropriate error routine will need to be selected. */
long integer(f, bytes)
FILE		*f;
int		bytes;
{
    int   i;
    long  n = 0;

    for (i = 0; i < bytes; i++) {
	n = n << 8 | cgetc(f);
	if (i == 0 && n & 0x80)
	    n = n | ~0x7f;
    }
    return n;
}

/* Gets the next character from the input that is not a space character.
 * It calls cgetc() on EOF so the EOF function should be set appropriately.
 */
int getnonblank(f)
FILE	*f;
{
    int c;

    while (isspace(c = cgetc(f)))
    	;
    return c;
}

/* Gets the next integer from the input and returns its value.  It calls
 * cgetc() on EOF so the EOF function should be set appropriately.
 */
int getinteger(f)
FILE	*f;
{
    int 	c, i = 0;
    Boolean	negative = FALSE;

    while (isspace(c = cgetc(f)))
    	;
    if (c == '-') {
    	negative = TRUE;
    	c = cgetc(f);
    }
    while ('0' <= c && c <= '9') {
	i = i * 10 + c - '0';
	c = cgetc(f);
    }
    (void)ungetc(c, f);
    if (negative)
    	i = -i;
    return i;
}

/* Reads the next blank delineated string from the file.  It calls cgetc()
 * so an EOF function should be set appropriately.  The return value is static
 * and is overwritten with each call.
 */
char *getstring(f)
FILE	*f;
{
    static char		buf[81];
    int			c;

    c = getnonblank(f);
    buf[0] = c, buf[1] = '\0';
    while (!isspace(c = cgetc(f)))
    	buf[strlen(buf)+1] = '\0', buf[strlen(buf)] = c;
    (void)ungetc(c, f);
    return buf;
}
