/* $Header: fontinfo.h,v 1.1 88/01/15 13:03:58 simpson Rel $ */
/*
$Log:	fontinfo.h,v $
 * Revision 1.1  88/01/15  13:03:58  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  18:30:53  simpson
 * beta test
 * 
*/

/* Information on a whole font */
struct FontInfo {
    int	    blocksize;		/* Estimated blocks >= real blocks */
    int	    qmsheight;		/* Height to give QMS printer */
    int	    qmsbaseline;	/* Baseline height to give QMS printer */
    int	    numchars;		/* Number of characters in font */
    /* The following are just as in the PK documentation */
    char    comment[256];
    long    ds;			/* Design size in FIXes */
    long    cs;			/* Checksum */
    long    hppp, vppp;		/* Pixel sps per point */
    struct charinfo {
	long	tfm;		/* Width of character in FIXes/designsize */
	long	dx, dy;		/* Escapements in pixels sps */
	long	w, h;	        /* Width, height in pixels */
	long	hoff, voff;	/* horizontal, vertical offset in pixels */
    } chararray[256];
};

/* Information on a single character in a font */
struct CharInfo {
    long	cc;		/* Character found */
    long 	tfm;		/* Width of character in FIXes/designsize */
    enum {pshort, pexshort, plong} preambletype;
    long dxordm, dy;		/* Escapements */
    long	w, h;		/* Width and height of bitmap */
    long 	hoff, voff;	/* Offsets */
    char	*bitmap;	/* Raster bitmap.  If type 'X' orientation
				 * then it is (w+7)/8 bytes wide, h tall.
				 * If type 'Y' orientation then it is (h+7)/8
				 * bytes wide, w tall.
				 */
};
