#ifndef lint
static char *rcs = "$Header: cat.c,v 1.1 88/01/15 13:03:09 simpson Rel $";
#endif
/*
$Log:	cat.c,v $
 * Revision 1.1  88/01/15  13:03:09  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  18:30:40  simpson
 * beta test
 * 
*/

/* This file contains structure for mapping between ASCII and the weird
 * CAT otroff font positions.  The CAT only contains 102 characters per
 * font mapped into strange positions.
 */

/* This table maps from CAT otroff order of a non-special font to the position
 * of the character in the real font.
 */
char	RegularToAscii[128] = {
0,	/* Not used */
'h',	/* h */
't',	/* t */
'n',	/* n */
'm',	/* m */
'l',	/* l */
'i',	/* i */
'z',    /* z */
's',	/* s */
'd',	/* d */
'b',	/* b */
'x',	/* x */
'f',	/* f */
'j',	/* j */
'u',	/* u */
'k',    /* k */
0,	/* Not used */
'p',	/* p */
006,	/* \(em */
';',	/* ; */
0,	/* Not used */
'a',	/* a */
005,	/* \(ru */
'c',    /* c */
'`',	/* ` */
'e',	/* e */
'\'',	/* ' */
'o',	/* o */
021,	/* \(14 */
'r',	/* r */
022,	/* \(12 */
'v',    /* v */
'-',	/* - or \(hy */
'w',	/* w */
'q',	/* q */
'/',	/* / */
'.',	/* . */
'g',	/* g */
023,	/* \(34 */
',',    /* , */
'&',	/* & */
'y',	/* y */
0,	/* Not used */
'%',	/* % */
0,	/* Not used */
'Q',	/* Q */
'T',	/* T */
'O',    /* O */
'H',	/* H */
'N',	/* N */
'M',	/* M */
'L',	/* L */
'R',	/* R */
'G',	/* G */
'I',	/* I */
'P',    /* P */
'C',	/* C */
'V',	/* V */
'E',	/* E */
'Z',	/* Z */
'D',	/* D */
'B',	/* B */
'S',	/* S */
'Y',    /* Y */
0,	/* Not used */
'F',	/* F */
'X',	/* X */
'A',	/* A */
'W',	/* W */
'J',	/* J */
'U',	/* U */
'K',    /* K */
'0',	/* 0 */
'1',	/* 1 */
'2',	/* 2 */
'3',	/* 3 */
'4',	/* 4 */
'5',	/* 5 */
'6',	/* 6 */
'7',    /* 7 */
'8',	/* 8 */
'9',	/* 9 */
'*',	/* * */
004,	/* \- or \(-- */
001,	/* \(fi */
002,	/* \(fl */
003,	/* \(ff */
020,    /* \(ct */
012,	/* \(fL or \(Fl */
011,	/* \fI or \(Fi */
'(',	/* ( */
')',	/* ) */
'[',	/* [ */
']',	/* ] */
013,	/* \(de */
014,    /* \(dg */
'=',	/* = */
017,	/* \(rg */
':',	/* : */
'+',	/* + */
0,	/* Not used */
'!',	/* ! */
007,	/* \(bu */
'?',    /* ? */
015,	/* \(fm */
'|',	/* | */
0,	/* Not used */
016,	/* \(co */
010,	/* \(sq */
'$',	/* $ */
0,	/* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
};

/* This table maps from CAT otroff order in a special font to the position
 * of the character in the real font.
 */
char	SpecialToAscii[128] = {
0,	/* Not used */
'w',	/* \(*q */
'h',	/* \(*h */
'm',	/* \(*n */
'l',	/* \(*m */
'k',	/* \(*l */
'i',	/* \(*i */
'f',    /* \(*z */
'r',	/* \(*s */
'd',	/* \(*d */
'b',	/* \(*b */
'n',	/* \(*c */
'g',	/* \(*y */
'u',	/* \(*f */
't',	/* \(*u */
'j',    /* \(*k */
0,	/* Not used */
'p',	/* \(*p */
'@',	/* @ */
'7',	/* \(da */
0,	/* Not used */
'a',	/* \(*a */
'|',	/* \(or */
'v',    /* \(*x */
'"',	/* " */
'e',	/* \(*e */
'=',	/* = */
'o',	/* \(*o */
'4',	/* \(<- */
'q',	/* \(*r */
'6',	/* \(ua */
's',    /* \(*t */
'_',	/* _ */
'\\',	/* \e */
'W',	/* \(*Q */
007,	/* \(bs */
001,	/* \(if */
'c',	/* \(*g */
002,	/* \(fl */
003,	/* \(pt */
004,	/* \(rh */
'x',	/* \(*w */
0,	/* Not used */
'(',	/* \(gr */
0,	/* Not used */
'U',	/* \(*F */
'H',	/* \(*H */
'X',    /* \(*W */
005,	/* \(cu */
006,	/* \(rn */
014,	/* \(ts */
'K',	/* \(*L */
'-',	/* \(mi */
'C',	/* \(*G */
015,	/* \(is */
'P',    /* \(*P */
032,	/* \(sb */
033,	/* \(sp */
'2',	/* \(ap */
'y',	/* \(pd */
'D',	/* \(*D */
013,	/* \(sr */
'R',	/* \(*S */
'1',    /* \(~= */
0,	/* Not used */
'>',	/* > */
'N',	/* \(*C */
'<',	/* < */
016,	/* \(sl */
034,	/* \(ca */
'T',	/* \(*U */
035,    /* \(no */
023,	/* \(rc */
024,	/* \(lt */
017,	/* \(bv */
030,	/* \(lk */
025,	/* \(lb */
026,	/* \(rt */
031,	/* \(rk */
027,    /* \(rb */
021,	/* \(rf */
020,	/* \(lf */
022,	/* \(lc */
'*',	/* \(mu */
'/',	/* \(di */
010,	/* \(+- */
011,	/* \(<= */
012,    /* \(>= */
'0',	/* \(== */
'3',	/* \(!= */
'{',	/* { */
'}',	/* } */
'\'',	/* ' */
'`',	/* \` */
'^',	/* ^ */
'#',    /* # */
036,	/* \(lh */
037,	/* \(mo */
'~',	/* ~ */
'z',	/* \(es */
0,	/* Not used */
'Y',	/* \(dd */
'Z',	/* \(br */
'9',    /* \(** */
'[',	/* \(ib */
']',	/* \(ci */
0,	/* Not used */
'+',	/* \(pl */
'5',	/* \(-> */
'8',	/* \(sc */
0,	/* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0,      /* Not used */
0       /* Not used */
};

/* This tables maps from the order in the otroff width output table to
 * the font position of that character.  A zero value designates not used.
 */
char RegularOrder[256-32] = {
' ',
'!',
0,	/* " */
0,	/* # */
'$',
'%',
'&',
'\'',
'(',
')',
'*',
'+',
',',
'-',   /* hyphen */
'.',
'/',
'0',
'1',
'2',
'3',
'4',
'5',
'6',
'7',
'8',
'9',
':',
';',
0,	/* < */
'=',
0,	/* > */
'?',
0,	/* @ */
'A',
'B',
'C',
'D',
'E',
'F',
'G',
'H',
'I',
'J',
'K',
'L',
'M',
'N',
'O',
'P',
'Q',
'R',
'S',
'T',
'U',
'V',
'W',
'X',
'Y',
'Z',
'[',
0,	/* \ */
']',
0,	/* ^ */
0,	/* _ */
'`',
'a',
'b',
'c',
'd',
'e',
'f',
'g',
'h',
'i',
'j',
'k',
'l',
'm',
'n',
'o',
'p',
'q',
'r',
's',
't',
'u',
'v',
'w',
'x',
'y',
'z',
0,	/* { */
'|',
0,	/* } */
0,	/* ~ */
0,      /* narrow space */
055,    /* hyphen */
007,    /* bullet */
010,    /* square */
006,    /* 3/4 em */
005,    /* rule */
021,    /* 1/4 */
022,    /* 1/2 */
023,    /* 3/4 */
004,    /* minus */
001,    /* fi */
002,    /* fl */
003,    /* ff */
011,    /* ffi */
012,    /* ffl */
013,    /* degree */
014,    /* dagger */
0,      /* section */
015,    /* foot mark */
0,      /* ' */
0,      /* ` */
0,      /* _ */
0,
0,      /* half narrow space */
0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,
017,    /* registered */
016,    /* copyright */
0,
020     /* cent */
};

/* Just like RegularOrder, but for the special font */
char SpecialOrder[256-32] = {
0,0,
'"',
'#',
0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,
'<',
0,
'>',
0,
'@',
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,
'\\',
0,
'^',
'_',
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,
'{',
0,
'}',
'~',
0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
070,	/* section */
0,
'\'',
'`',
'_',
016,	/* slash (longer) */
0, 
0,
0141,   /* alpha */
0142,   /* beta */
0143,   /* gamma */
0144,   /* delta */
0145,   /* epsilon */
0146,   /* zeta */
0147,   /* eta */
0150,   /* theta */
0151,   /* iota */
0152,   /* kappa */
0153,   /* lambda */
0154,   /* mu */
0155,   /* nu */
0156,   /* xi */
0157,   /* omicron */
0160,   /* pi */
0161,   /* rho */
0162,   /* sigma */
0163,   /* tau */
0164,   /* upsilon */
0165,   /* phi */
0166,   /* chi */
0167,   /* psi */
0170,   /* omega */
0103,   /* Gamma */
0104,   /* Delta */
0110,   /* Theta */
0113,   /* Lambda */
0116,   /* Xi */
0120,   /* Pi */
0122,   /* Sigma */
0,
0124,   /* Upsilon */
0125,   /* Phi */
0127,   /* Psi */
0130,   /* Omega */
013,    /* square root */
014,    /* terminal sigma */
006,    /* root extender */
012,    /* >= */
011,    /* <= */
060,    /* identically equal */
055,    /* minus */
061,	/* approximately = */
062,    /* approximates */
063,    /* not equal */
065,    /* right arrow */
064,    /* left arrow */
066,    /* up arrow */
067,    /* down arrow */
'=',
052,    /* multiply */
057,    /* divide */
010,    /* plus minus */
005,    /* cup (union) */
034,    /* cap (intersection) */
032,    /* subset of */
033,    /* superset of */
0133,	/* improper subset */
002,    /* improper superset */
001,    /* infinity */
0171,   /* partial derivative */
050,    /* gradient */
035,    /* not */
015,    /* integral sign */
003,    /* proportional to */
0172,   /* empty set */
037,    /* member of */
'+',
0,
0,
0,	/* box vertical rule */
0,
0131,   /* double dagger */
004,    /* right hand */
036,    /* left hand */
071,    /* math * */
007,    /* bell system sign */
'|',	/* or */
0135,   /* circle */
024,    /* left top (of big curly) */
025,    /* left bottom */
026,    /* right top */
027,    /* right bottom */
022,    /* left center of big curly bracket */
023,    /* right center of big curly bracket */
017,    /* bold vertical */
020,    /* left floor */
021,    /* right floor */
022,    /* left ceiling */
023    /* right ceiling */
};


