.\" $Header: qmsquery.l,v 1.1 88/01/15 12:58:36 simpson Rel $
.\" $Log:	qmsquery.l,v $
.\" Revision 1.1  88/01/15  12:58:36  simpson
.\" initial release
.\" 
.\" Revision 0.1  87/12/11  17:56:58  simpson
.\" beta test
.\" 
.TH QMSQUERY 3 TRW
.UC
.SH NAME
qmsquery \- routines to query the status of a QMS printer
.SH SYNOPSIS
.nf
#include <local/qms.h>
.sp
qmsopen(writefd, readfd)
int writefd, readfd;
.sp
struct qmsmap *qmsmap(north, south, west, east)
double north, south, west, east;
.sp
struct qmspag *qmspag()
.sp
struct qmsovl *qmsovl()
.sp
struct qmspfp *qmspfp()
.sp
struct qmsopc *qmsopc()
.sp
struct qmsram *qmsram()
.sp
struct qmsfnt *qmsfnt()
.sp
struct qmsver *qmsver()
.sp
qmsclose()
.sp
void qmsmapfree(mapinfo)
struct qmsmap *mapinfo;
.sp
void qmsovlfree(ovlinfo)
struct qmsovl *ovlinfo;
.sp
void qmspfpfree(pfpinfo)
struct qmspfp *pfpinfo;
.sp
void qmsopcfree(opcinfo)
struct qmsopc *opcinfo;
.sp
void qmsfntfree(fntinfo)
struct qmsfnt *fntinfo;
.fi
.SH DESCRIPTION
These routines query the QMS printer for internal information.  The QMS
printer must be connected through two sets of serial lines.
The QMS laser printers read data through one serial line (the daughter
board port)
and send status
information through their debugger port on another serial line.
Qmsopen and qmsclose return 1 on success, 0 on error.  
The *free routines free the space containing the structures returned
by the rest of the routines.
NULL is used by qmsmap, qmspag, qmsovl, qmspfp, qmsopc, qmsram, qmsfnt and
qmsver to designate an empty list or an error.
All of the
routines except qmsopen, qmsclose and the *free routines
will displace the current position in the QMS printer
so you have to reposition the virtual QMS cursor with the tab and justify
commands after using these routines.
All of the coordinates are given in inches and
the routines will change the
QMS input syntax to inches if it is not already.
Since the routines are written in 
.IR lex (1)
and 
.IR yacc (1),
the 
.I -ll
library must be loaded when using the routines.
A variety of structures stored in the header file 
.I qms.h
are used to return information.
.nf
.sp
/* Structure returned when requesting MAP info */
struct qmsmap {
    int     count;      /* Byte count */
    int     checksum;
    char    *data;      /* "count" bytes of data terminated by NULL */
    struct qmsmap *next;
};

/* Structure returned when requesting PAG info */
struct qmspag {
    char    PO;     /* Orientation. 'P' or 'L' */
    float   TM;     /* Top margin */
    float   BM;     /* Bottom margin */
    float   LM;     /* Left margin */
    float   RM;     /* Right margin */
    float   LPI;    /* Lines per inch */
    float   CPI;    /* Characters per inch. 0 == Proportional */
    short   PT;     /* Paper Tray. 0 == Top tray. 1 == Bottom Tray */
    short   PS;     /* Page Size. 0 == Short. 1 == Long. 2 == European A-4 */
    char    SO;     /* Stacker Offset. 'Y' or 'N' */
    short   CC;     /* Copy Count */
};

/* Structure returned when requesting OVL info */
struct qmsovl {
    enum { regular, automatic } ovltype;
    /* The number and size are only valid for regular overlays */
    int ovlnumber;  /* Overlay number */
    int ovlsize;    /* Overlay size in bytes */
    struct qmsovl   *next;
};

/* Structure returned when requesting PFP info */
struct qmspfp {
    char    *module;    /* Name of installed module */
    struct qmspfp   *next;
};

/* Structure returned when requesting OPC info */
struct qmsopc {
    struct optnode  *OC1, *OC2, *OC3, *OC4, *OC5;
};

struct optnode {
    short   option;     /* Number of option */
    struct optnode  *next;
};

/* Structure returned when requesting RAM info */
struct qmsram {
    short   TR;         /* Total Ram memory in printer */
    short   AR;         /* Current Available Ram memory */
    short   FR;         /* Font Ram memory used */
    short   OR;         /* Overlay Ram memory used */
};

/* Structure returned when requesting FNTB info */
struct qmsfnt {
    struct fontnode *rom;   /* List of rom fonts */
    struct fontnode *ram;   /* List of ram fonts */
};

struct fontnode {
    char    orientation;    /* 'P' or 'L' */
    short   number;         /* Font number */
    long    bytes;          /* Number of bytes in printer */
    char    version;
    char    class;          /* '1' or '2' */
    struct fontnode *next;
};

/* Structure returned when requesting version information */
struct qmsver {
    float   version;	    /* Version of QUIC */
    float   firmware;	    /* Version of the firmware */
    struct date {	    /* Date of the firmware */
	short	month;
	short	day;
	short	year;	    /* Without the 1900 */
    } date;
};
.sp
.fi
Please refer to the above structures for the discussion of the following
routines.
.TP
qmsopen(writefd, readfd)
This routine does some internal housekeeping before you can use any of
the other routines.
It should be called exactly once before all the other 
routines.
Writefd is an open file descriptor on the line to the QMS printer
(the daughter board port).
Readfd is an open file descriptor on the line to the QMS printer debugger 
port.  It is used for reading status information from the QMS printer.
These routines do not fiddle with the tty bits.  Do this elsewhere.
.TP
qmsmap(north, south, west, east)
This function returns a hex dump of a portion of the QMS page memory.
The coordinates of the dump should be given in inches from the top and left
of the page.  The linked list returned is allocated by 
.IR malloc (3) 
and sorted in the order the data comes from the QMS printer.
That is, the first node of data is the first line of data returned by the
QMS printer.
.TP
qmspag()
This function returns information about page formatting specifications.
The value returned is static and overwritten by each call.
.TP
qmsovl()
This function returns information on currently defined overlays.
The linked list returned is allocated by 
.IR malloc (3).
If an automatic overlay is loaded then one and only one of the nodes in
the list will have ovltype automatic.
The variables ovlnumber and ovlsize are not used for an automatic overlay.
The return value ovlinfo is NULL if no overlays are loaded.
.TP
qmspfp()
This function returns a linked list of the currently installed PFP modules.
The linked list is allocated by
.IR malloc (3).
If no PFP modules are installed, pfpinfo is NULL.
.TP
qmsopc()
This function returns information on the currently set option classes.
The return structure contains a set of five linked lists allocated by 
.I malloc (3)
but the structure qmsopc is static and its values are overwritten after each
call.
If no options are set for one of the five option classes then the 
appropriate list is 
NULL.
.TP
qmsram()
This function returns information about ram usage in the printer.
The value returned is static and overwritten after each call.
The ram values are given in blocks. QMS ram memory consists of 16 bit words
in 1024 byte blocks.
.TP
qmsfnt()
This function returns two lists containing the rom and ram fonts loaded.
The qmsfnt structure is static but the two lists are allocated by
.IR malloc (3).
If no rom or ram fonts are loaded the appropriate list is NULL.
.TP
qmsver()
This function returns information about the firmware.
The version information returned is stored in a static area that is
overwritten with each call.
.TP
qmsclose()
This function closes the tty lines used by the above routines.  It should
be called when you are done using the routines.
.PP
The *free routines return the space allocated by 
.IR malloc (3)
for further use.
Free space routines only exist for the routines above which use 
.IR malloc (3)
to allocate space.  Static areas are not freed by the free routines.
.SH FILES
.nf
.ta \w'/dev/tty*  'u
/dev/tty*	Usually the two serial lines to the printer
.fi
.SH AUTHOR
Scott Simpson, TRW
.SH SEE ALSO
lex(1), yacc(1), malloc(3)
.br
QUIC Programming Manual
