%{
#ifndef lint
static char *rcs = "$Header: qmsver.y,v 1.1 88/01/15 12:19:41 simpson Rel $";
#endif
/*
$Log:	qmsver.y,v $
 * Revision 1.1  88/01/15  12:19:41  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  17:12:14  simpson
 * beta test
 * 
*/
#include <stdio.h>
#include <setjmp.h>
#include <local/standard.h>
#include "qms.h"

extern FILE *_Ifp, *_Ofp;
extern Boolean	_FirstChar;
static jmp_buf	Env;
static struct qmsver	Result;
%}
%token DATE FIRMWARE VERSION ENDLINE QUIC
%token <i> INTEGER
%token <r> REAL
%union {
    int	    i;
    float   r;
}
%%
version : VERSION '=' QUIC ':' REAL FIRMWARE ':' REAL DATE INTEGER '/'
    INTEGER '/' INTEGER ENDLINE 
	{
	    Result.version = $5;
	    Result.firmware = $8;
	    Result.date.month = $10;
	    Result.date.day = $12;
	    Result.date.year = $14;
	}
    ;
%%
#include "qmsverlex.c"

struct qmsver *qmsver()
{
    _FirstChar = TRUE;
    fputs(QUICON, _Ofp);
    fprintf(_Ofp, "%s00000", SYNTAX);
    fprintf(_Ofp, "%sVER%s", INFO, ENDCMD);
    fputs(QUICOFF, _Ofp);
    (void)fflush(_Ofp);
    if (setjmp(Env)) {
	while (timedgetc(_Ifp) != EOF)	/* Discard remaining input */
	    ;
	return NULL;
    }
    if (yyparse() != 0)
	return NULL;
    yysptr = yysbuf;	    /* Resets lex lookahead buffer */
    return &Result;
}

static yyerror(s)
char	*s;
{
    longjmp(Env, TRUE);
}
